/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Base;
import com.adobe.fontengine.font.opentype.Cff;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.Cvt;
import com.adobe.fontengine.font.opentype.Fond;
import com.adobe.fontengine.font.opentype.Fpgm;
import com.adobe.fontengine.font.opentype.Gasp;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.GlyfRaw;
import com.adobe.fontengine.font.opentype.Gpos;
import com.adobe.fontengine.font.opentype.Gsub;
import com.adobe.fontengine.font.opentype.Head;
import com.adobe.fontengine.font.opentype.Hhea;
import com.adobe.fontengine.font.opentype.HmtxRaw;
import com.adobe.fontengine.font.opentype.Kern;
import com.adobe.fontengine.font.opentype.LocaRaw;
import com.adobe.fontengine.font.opentype.Ltsh;
import com.adobe.fontengine.font.opentype.Maxp;
import com.adobe.fontengine.font.opentype.Name;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Os2;
import com.adobe.fontengine.font.opentype.Post;
import com.adobe.fontengine.font.opentype.Prep;
import com.adobe.fontengine.font.opentype.Vhea;
import com.adobe.fontengine.font.opentype.VmtxRaw;
import com.adobe.fontengine.font.opentype.Vorg;
import java.io.IOException;

public class Table {
    OTByteArray data;

    protected static Table factory(int tag, FontByteArray buffer) throws InvalidFontException, UnsupportedFontException, IOException {
        switch (tag) {
            case 1668112752: {
                return new Cmap(buffer);
            }
            case 1751672161: {
                return new Hhea(buffer);
            }
            case 1752003704: {
                return new HmtxRaw(buffer);
            }
            case 1835104368: {
                return new Maxp(buffer);
            }
            case 1851878757: {
                return new Name(buffer);
            }
            case 1330851634: {
                return new Os2(buffer);
            }
            case 1196445523: {
                return new Gpos(buffer);
            }
            case 1196643650: {
                return new Gsub(buffer);
            }
            case 1195656518: {
                return new Gdef(buffer);
            }
            case 1111577413: {
                return new Base(buffer);
            }
            case 1751474532: {
                return new Head(buffer);
            }
            case 1886352244: {
                try {
                    return new Post(buffer);
                }
                catch (UnsupportedFontException unsupported) {
                    return null;
                }
            }
            case 1735162214: {
                return new GlyfRaw(buffer);
            }
            case 1819239265: {
                return new LocaRaw(buffer);
            }
            case 1128678944: {
                return new Cff(buffer);
            }
            case 1986553185: {
                return new Vhea(buffer);
            }
            case 1986884728: {
                return new VmtxRaw(buffer);
            }
            case 1668707360: {
                return new Cvt(buffer);
            }
            case 1718642541: {
                return new Fpgm(buffer);
            }
            case 1886545264: {
                return new Prep(buffer);
            }
            case 1801810542: {
                return new Kern(buffer);
            }
            case 1734439792: {
                return new Gasp(buffer);
            }
            case 1280594760: {
                return new Ltsh(buffer);
            }
            case 1448038983: {
                return new Vorg(buffer);
            }
            case 1718578788: {
                return new Fond(buffer);
            }
        }
        return new Table(buffer);
    }

    protected static boolean knownTable(int tag) {
        switch (tag) {
            case 1111577413: 
            case 1128678944: 
            case 1195656518: 
            case 1196445523: 
            case 1196643650: 
            case 1280594760: 
            case 1330851634: 
            case 1448038983: 
            case 1668112752: 
            case 1668707360: 
            case 1718578788: 
            case 1718642541: 
            case 1734439792: 
            case 1735162214: 
            case 1751474532: 
            case 1751672161: 
            case 1752003704: 
            case 1801810542: 
            case 1819239265: 
            case 1835104368: 
            case 1851878757: 
            case 1886352244: 
            case 1886545264: 
            case 1986553185: 
            case 1986884728: {
                return true;
            }
        }
        return false;
    }

    protected Table(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        this.data = new OTByteArray(buffer);
    }

    public Table() {
    }

    protected OTByteArray.OTByteArrayBuilder getDataAsByteArray() {
        return OTByteArray.getOTByteArrayBuilderInstance(this.data);
    }

    long checksum(int from, int to, long checksum) throws InvalidFontException {
        return this.data.checksum(from, to, checksum);
    }
}

