/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.ChainingFormat1Harvester;
import com.adobe.fontengine.font.opentype.ChainingFormat2Harvester;
import com.adobe.fontengine.font.opentype.ContextFormat1Harvester;
import com.adobe.fontengine.font.opentype.ContextFormat2Harvester;
import com.adobe.fontengine.font.opentype.Gsub;
import com.adobe.fontengine.font.opentype.IntGrowableArray;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableHarvester;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GsubHarvester
extends LookupTableHarvester {
    private AltSubstHarvester altSubstHarvester = new AltSubstHarvester();
    private LigaSubstHarvester ligaSubstHarvester = new LigaSubstHarvester();
    private MultSubstHarvester multSubstHarvester = new MultSubstHarvester();
    private SingleSubstFormat1Harvester singleSubstFormat1Harvester = new SingleSubstFormat1Harvester();
    private SingleSubstFormat2Harvester singleSubstFormat2Harvester = new SingleSubstFormat2Harvester();

    GsubHarvester(Gsub gsub, int numGlyphs) {
        super(gsub, numGlyphs);
    }

    TreeMap<Integer, List> gatherPossibleLookups(Subset gids) throws InvalidFontException, UnsupportedFontException {
        int initialGIDListSize;
        TreeMap<Integer, List> applicableLookups = new TreeMap<Integer, List>();
        IntGrowableArray featuresInFeatureList = this.getAllFeatureListFeatures();
        do {
            initialGIDListSize = gids.getNumGlyphs();
            this.harvestAllFeatures(featuresInFeatureList, applicableLookups, gids);
        } while (gids.getNumGlyphs() != initialGIDListSize);
        return applicableLookups;
    }

    private List gatherContextualGlyphs(int stOffset, Subset gids, Map lookups, List subtables, int subtableIndex) throws InvalidFontException, UnsupportedFontException {
        int stFormat = this.lookupTable.data.getuint16(stOffset);
        switch (stFormat) {
            case 1: {
                subtables = this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, new ContextFormat1Harvester(this, lookups, true), subtableIndex);
                break;
            }
            case 2: {
                subtables = this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, new ContextFormat2Harvester(this, lookups), subtableIndex);
                break;
            }
            case 3: {
                int numGlyphs = this.lookupTable.data.getuint16(stOffset + 2);
                if (numGlyphs <= 0) break;
                subtables = this.gatherLookupsForCoverage(stOffset, 6, gids, subtables, new ContextFormat3SubstHarvester(lookups), subtableIndex);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid contextual lookup format (" + stFormat + ")");
            }
        }
        return subtables;
    }

    private List gatherContextualGlyphsForAllSubtables(Subset gids, int offset, Map lookups) throws InvalidFontException, UnsupportedFontException {
        List subtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        for (int i = 0; i < subtableCount; ++i) {
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            subtables = this.gatherContextualGlyphs(stOffset, gids, lookups, subtables, i);
        }
        return subtables;
    }

    private List gatherSingleSubstGlyphsForAllSubtables(Subset gids, int offset, Map lookups) throws InvalidFontException, UnsupportedFontException {
        List subtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        block4: for (int i = 0; i < subtableCount; ++i) {
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            int stFormat = this.lookupTable.data.getuint16(stOffset);
            switch (stFormat) {
                case 1: {
                    subtables = this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, this.singleSubstFormat1Harvester, i);
                    continue block4;
                }
                case 2: {
                    subtables = this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, this.singleSubstFormat2Harvester, i);
                }
            }
        }
        return subtables;
    }

    private List gatherChainingGlyphs(int stOffset, Subset gids, Map lookups, List subtables, int subtableIndex) throws InvalidFontException, UnsupportedFontException {
        int stFormat = this.lookupTable.data.getuint16(stOffset);
        switch (stFormat) {
            case 1: {
                subtables = this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, new ChainingFormat1Harvester(this, lookups, true), subtableIndex);
                break;
            }
            case 2: {
                subtables = this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, new ChainingFormat2Harvester(this, lookups), subtableIndex);
                break;
            }
            case 3: {
                int backtrackCount = this.lookupTable.data.getuint16(stOffset + 2);
                int inputCount = this.lookupTable.data.getuint16(stOffset + 4 + 2 * backtrackCount);
                if (inputCount <= 0) break;
                subtables = this.gatherLookupsForCoverage(stOffset, 4 + 2 * backtrackCount + 2, gids, subtables, new ChainingFormat3SubstHarvester(lookups), subtableIndex);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid contextual lookup format (" + stFormat + ")");
            }
        }
        return subtables;
    }

    private List gatherChainingGlyphsForAllSubtables(Subset gids, int offset, Map lookups) throws InvalidFontException, UnsupportedFontException {
        List subtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        for (int i = 0; i < subtableCount; ++i) {
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            subtables = this.gatherChainingGlyphs(stOffset, gids, lookups, subtables, i);
        }
        return subtables;
    }

    private List gatherExtensionGlyphsForAllSubtables(Subset gids, int offset, Map lookups, int lookupFlag) throws InvalidFontException, UnsupportedFontException {
        ArrayList<Integer> subtables = null;
        List dummySubtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        for (int i = 0; i < subtableCount; ++i) {
            Integer j;
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            int format = this.lookupTable.data.getuint16(stOffset);
            if (format != 1) {
                throw new InvalidFontException("Invalid extension format (" + format + ")");
            }
            int lookupType = this.lookupTable.data.getuint16(stOffset + 2);
            int extOffset = this.lookupTable.data.getuint32asint(stOffset + 4, "Only signed extension values supported");
            switch (lookupType) {
                case 1: {
                    int subFormat = this.lookupTable.data.getuint16(stOffset + extOffset);
                    if (subFormat == 1) {
                        dummySubtables = this.gatherLookupsForCoverage(stOffset + extOffset, 2, gids, dummySubtables, this.singleSubstFormat1Harvester, 0);
                        break;
                    }
                    dummySubtables = this.gatherLookupsForCoverage(stOffset + extOffset, 2, gids, dummySubtables, this.singleSubstFormat2Harvester, 0);
                    break;
                }
                case 2: {
                    dummySubtables = this.gatherLookupsForCoverage(stOffset + extOffset, 2, gids, dummySubtables, this.multSubstHarvester, 0);
                    break;
                }
                case 3: {
                    dummySubtables = this.gatherLookupsForCoverage(stOffset + extOffset, 2, gids, dummySubtables, this.altSubstHarvester, 0);
                    break;
                }
                case 4: {
                    dummySubtables = this.gatherLookupsForCoverage(stOffset + extOffset, 2, gids, dummySubtables, this.ligaSubstHarvester, 0);
                    break;
                }
                case 5: {
                    dummySubtables = this.gatherContextualGlyphs(stOffset + extOffset, gids, lookups, dummySubtables, 0);
                    break;
                }
                case 6: {
                    dummySubtables = this.gatherChainingGlyphs(stOffset + extOffset, gids, lookups, dummySubtables, 0);
                    break;
                }
                default: {
                    throw new InvalidFontException("Invalid GSUB lookup type (" + lookupType + ")");
                }
            }
            if (dummySubtables == null) continue;
            if (subtables == null) {
                subtables = new ArrayList<Integer>();
            }
            if (subtables.contains(j = new Integer(i))) continue;
            subtables.add(j);
        }
        return subtables;
    }

    @Override
    protected List harvestSubtables(Subset gids, int lookupOffset, int lookupType, int lookupFlag, Map lookups) throws InvalidFontException, UnsupportedFontException {
        List subtables = null;
        switch (lookupType) {
            case 1: {
                subtables = this.gatherSingleSubstGlyphsForAllSubtables(gids, lookupOffset, lookups);
                break;
            }
            case 2: {
                subtables = this.gatherLookupsForCoverageAllSubtables(gids, lookupOffset, this.multSubstHarvester);
                break;
            }
            case 3: {
                subtables = this.gatherLookupsForCoverageAllSubtables(gids, lookupOffset, this.altSubstHarvester);
                break;
            }
            case 4: {
                subtables = this.gatherLookupsForCoverageAllSubtables(gids, lookupOffset, this.ligaSubstHarvester);
                break;
            }
            case 5: {
                subtables = this.gatherContextualGlyphsForAllSubtables(gids, lookupOffset, lookups);
                break;
            }
            case 6: {
                subtables = this.gatherChainingGlyphsForAllSubtables(gids, lookupOffset, lookups);
                break;
            }
            case 7: {
                subtables = this.gatherExtensionGlyphsForAllSubtables(gids, lookupOffset, lookups, lookupFlag);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid GSUB lookup type (" + lookupType + ")");
            }
        }
        return subtables;
    }

    private class ContextFormat3SubstHarvester
    extends GSubLookupHarvester
    implements LayoutTable.CoverageConsumer {
        private Map lookups;
        private boolean coverageContainsGid;

        ContextFormat3SubstHarvester(Map lookups) {
            this.lookups = lookups;
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            int i;
            int glyphCount = GsubHarvester.this.lookupTable.data.getuint16(stOffset + 2);
            if (glyphCount == 1) {
                this.coverageContainsGid = true;
            }
            for (i = 1; i < glyphCount; ++i) {
                this.coverageContainsGid = false;
                GsubHarvester.this.lookupTable.iterateCoverage(GsubHarvester.this.lookupTable.data.getOffset(stOffset, 6 + i * 2), gids, this);
                if (!this.coverageContainsGid) break;
            }
            if (i == glyphCount) {
                int lookupCount = GsubHarvester.this.lookupTable.data.getuint16(stOffset + 4);
                for (int j = 0; j < lookupCount; ++j) {
                    int lookupIndex = GsubHarvester.this.lookupTable.data.getuint16(stOffset + 6 + 2 * glyphCount + 4 * j + 2);
                    GsubHarvester.this.harvest(gids, lookupIndex, this.lookups);
                }
            }
            return this.coverageContainsGid;
        }

        public boolean glyphInfo(int gid, int coverageIndex) {
            this.coverageContainsGid = true;
            return false;
        }
    }

    private class ChainingFormat3SubstHarvester
    extends GSubLookupHarvester
    implements LayoutTable.CoverageConsumer {
        private Map lookups;
        private boolean coverageContainsGid;

        ChainingFormat3SubstHarvester(Map lookups) {
            this.lookups = lookups;
        }

        private boolean checkCoverages(int stOffset, int coverageStartOffset, int numCoverages, Subset gids) throws InvalidFontException, UnsupportedFontException {
            for (int i = 0; i < numCoverages; ++i) {
                this.coverageContainsGid = false;
                GsubHarvester.this.lookupTable.iterateCoverage(GsubHarvester.this.lookupTable.data.getOffset(stOffset, coverageStartOffset + 2 * i), gids, this);
                if (this.coverageContainsGid) continue;
                return false;
            }
            return true;
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            int lookaheadCount;
            int inputCount;
            int delta = 4;
            int backtrackCount = GsubHarvester.this.lookupTable.data.getuint16(stOffset + 2);
            boolean ok = this.checkCoverages(stOffset, delta, backtrackCount, gids);
            if (!ok) {
                return false;
            }
            delta += 2 * backtrackCount;
            if (!(ok = this.checkCoverages(stOffset, (delta += 2) + 2, (inputCount = GsubHarvester.this.lookupTable.data.getuint16(stOffset + delta)) - 1, gids))) {
                return false;
            }
            delta += 2 * inputCount;
            if (!(ok = this.checkCoverages(stOffset, delta += 2, lookaheadCount = GsubHarvester.this.lookupTable.data.getuint16(stOffset + delta), gids))) {
                return false;
            }
            int lookupCount = GsubHarvester.this.lookupTable.data.getuint16(stOffset + (delta += 2 * lookaheadCount));
            delta += 2;
            for (int j = 0; j < lookupCount; ++j) {
                int lookupIndex = GsubHarvester.this.lookupTable.data.getuint16(stOffset + delta + 4 * j + 2);
                GsubHarvester.this.harvest(gids, lookupIndex, this.lookups);
            }
            return true;
        }

        public boolean glyphInfo(int gid, int coverageIndex) {
            this.coverageContainsGid = true;
            return false;
        }
    }

    private class LigaSubstHarvester
    extends GSubLookupHarvester {
        private LigaSubstHarvester() {
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            int ligaSetOffset = GsubHarvester.this.lookupTable.data.getOffset(stOffset, 6 + coverageIndex * 2);
            int ligaCount = GsubHarvester.this.lookupTable.data.getuint16(ligaSetOffset);
            boolean foundRelevantLiga = false;
            for (int i = 0; i < ligaCount; ++i) {
                int gid;
                int j;
                int ligaOffset = GsubHarvester.this.lookupTable.data.getOffset(ligaSetOffset, 2 + i * 2);
                int componentCount = GsubHarvester.this.lookupTable.data.getuint16(ligaOffset + 2);
                for (j = 0; j < componentCount - 1 && gids.getExistingSubsetGid(gid = GsubHarvester.this.lookupTable.data.getuint16(ligaOffset + 4 + 2 * j)) != -1; ++j) {
                }
                if (j != componentCount - 1) continue;
                foundRelevantLiga = true;
                gid = GsubHarvester.this.lookupTable.data.getuint16(ligaOffset);
                try {
                    gids.getSubsetGid(gid);
                    continue;
                }
                catch (InvalidFontException e) {
                    foundRelevantLiga = false;
                }
            }
            return foundRelevantLiga;
        }
    }

    private class AltSubstHarvester
    extends GSubLookupHarvester {
        private AltSubstHarvester() {
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            int alternateOffset = GsubHarvester.this.lookupTable.data.getOffset(stOffset, 6 + coverageIndex * 2);
            int glyphCount = GsubHarvester.this.lookupTable.data.getuint16(alternateOffset);
            for (int i = 0; i < glyphCount; ++i) {
                int glyphID = GsubHarvester.this.lookupTable.data.getuint16(alternateOffset + 2 + 2 * i);
                try {
                    gids.getSubsetGid(glyphID);
                    continue;
                }
                catch (InvalidFontException e) {
                    return false;
                }
            }
            return true;
        }
    }

    private class MultSubstHarvester
    extends GSubLookupHarvester {
        MultSubstHarvester() {
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            int sequenceOffset = GsubHarvester.this.lookupTable.data.getOffset(stOffset, 6 + 2 * coverageIndex);
            int glyphCount = GsubHarvester.this.lookupTable.data.getuint16(sequenceOffset);
            for (int g = 0; g < glyphCount; ++g) {
                try {
                    gids.getSubsetGid(GsubHarvester.this.lookupTable.data.getuint16(sequenceOffset + 2 + 2 * g));
                    continue;
                }
                catch (InvalidFontException e) {
                    return false;
                }
            }
            return true;
        }
    }

    private class SingleSubstFormat2Harvester
    extends GSubLookupHarvester {
        SingleSubstFormat2Harvester() {
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            int substitute = GsubHarvester.this.lookupTable.data.getuint16(stOffset + 6 + 2 * coverageIndex);
            try {
                gids.getSubsetGid(substitute);
            }
            catch (InvalidFontException e) {
                return false;
            }
            return true;
        }
    }

    private class SingleSubstFormat1Harvester
    extends GSubLookupHarvester {
        SingleSubstFormat1Harvester() {
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            int delta = GsubHarvester.this.lookupTable.data.getint16(stOffset + 4);
            try {
                gids.getSubsetGid(coverageGlyph + delta);
            }
            catch (InvalidFontException e) {
                return false;
            }
            return true;
        }
    }

    private abstract class GSubLookupHarvester
    implements LookupTableHarvester.CoverageLookupHarvester {
        private GSubLookupHarvester() {
        }

        public boolean keepGoing() {
            return true;
        }
    }
}

