/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.ChainingFormat1Harvester;
import com.adobe.fontengine.font.opentype.ChainingFormat2Harvester;
import com.adobe.fontengine.font.opentype.ContextFormat1Harvester;
import com.adobe.fontengine.font.opentype.ContextFormat2Harvester;
import com.adobe.fontengine.font.opentype.Gpos;
import com.adobe.fontengine.font.opentype.IntGrowableArray;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableHarvester;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class GposHarvester
extends LookupTableHarvester {
    private static final NoopHarvester noopHarvester = new NoopHarvester();
    private final NCoveragesHarvester twoCoveragesHarvester = new NCoveragesHarvester(2, 2, 1);
    private final PairPosFormat1Harvester pairPosHarvester = new PairPosFormat1Harvester();

    GposHarvester(Gpos gpos, int numGlyphs) {
        super(gpos, numGlyphs);
    }

    TreeMap gatherPossibleLookups(Subset gids) throws InvalidFontException, UnsupportedFontException {
        TreeMap applicableLookups = new TreeMap();
        IntGrowableArray featuresInFeatureList = this.getAllFeatureListFeatures();
        this.harvestAllFeatures(featuresInFeatureList, applicableLookups, gids);
        return applicableLookups;
    }

    private List gatherPairPosLookups(int stOffset, Subset gids, List subtables, int subtableIndex) throws InvalidFontException, UnsupportedFontException {
        int stFormat = this.lookupTable.data.getuint16(stOffset);
        switch (stFormat) {
            case 1: {
                return this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, this.pairPosHarvester, subtableIndex);
            }
            case 2: {
                return this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, noopHarvester, subtableIndex);
            }
        }
        throw new InvalidFontException("Invalid pair pos lookup format (" + stFormat + ")");
    }

    private List gatherPairPosLookupsForAllSubtables(Subset gids, int offset) throws InvalidFontException, UnsupportedFontException {
        List subtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        for (int i = 0; i < subtableCount; ++i) {
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            subtables = this.gatherPairPosLookups(stOffset, gids, subtables, i);
        }
        return subtables;
    }

    private List gatherContextualLookup(int stOffset, Subset gids, Map lookups, List subtables, int subtableIndex) throws InvalidFontException, UnsupportedFontException {
        int stFormat = this.lookupTable.data.getuint16(stOffset);
        switch (stFormat) {
            case 1: {
                return this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, new ContextFormat1Harvester(this, lookups, false), subtableIndex);
            }
            case 2: {
                return this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, new ContextFormat2Harvester(this, lookups), subtableIndex);
            }
            case 3: {
                int numGlyphs = this.lookupTable.data.getuint16(stOffset + 2);
                if (numGlyphs > 0) {
                    return this.gatherLookupsForCoverage(stOffset, 6, gids, subtables, new ContextFormat3Harvester(lookups, stOffset), subtableIndex);
                }
                return subtables;
            }
        }
        throw new InvalidFontException("Invalid contextual lookup format (" + stFormat + ")");
    }

    private List gatherContextualLookupsForAllSubtables(Subset gids, int offset, Map lookups) throws InvalidFontException, UnsupportedFontException {
        List subtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        for (int i = 0; i < subtableCount; ++i) {
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            subtables = this.gatherContextualLookup(stOffset, gids, lookups, subtables, i);
        }
        return subtables;
    }

    private List gatherChainingLookup(int stOffset, Subset gids, Map lookups, List subtables, int subtableIndex) throws InvalidFontException, UnsupportedFontException {
        int stFormat = this.lookupTable.data.getuint16(stOffset);
        switch (stFormat) {
            case 1: {
                return this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, new ChainingFormat1Harvester(this, lookups, false), subtableIndex);
            }
            case 2: {
                return this.gatherLookupsForCoverage(stOffset, 2, gids, subtables, new ChainingFormat2Harvester(this, lookups), subtableIndex);
            }
            case 3: {
                int backtrackCount = this.lookupTable.data.getuint16(stOffset + 2);
                int inputCount = this.lookupTable.data.getuint16(stOffset + 4 + 2 * backtrackCount);
                if (inputCount > 0) {
                    return this.gatherLookupsForCoverage(stOffset, 4 + 2 * backtrackCount + 2, gids, subtables, new ChainingFormat3Harvester(lookups, stOffset), subtableIndex);
                }
                return subtables;
            }
        }
        throw new InvalidFontException("Invalid contextual lookup format (" + stFormat + ")");
    }

    private List gatherChainingLookupsForAllSubtables(Subset gids, int offset, Map lookups) throws InvalidFontException, UnsupportedFontException {
        List subtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        for (int i = 0; i < subtableCount; ++i) {
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            subtables = this.gatherChainingLookup(stOffset, gids, lookups, subtables, i);
        }
        return subtables;
    }

    private List gatherExtensionGlyphsForAllSubtables(Subset gids, int offset, Map lookups) throws InvalidFontException, UnsupportedFontException {
        ArrayList<Integer> subtables = null;
        List dummySubtables = null;
        int subtableCount = this.lookupTable.data.getuint16(offset + 4);
        for (int i = 0; i < subtableCount; ++i) {
            Integer j;
            int stOffset = this.lookupTable.data.getOffset(offset, 6 + 2 * i);
            int format = this.lookupTable.data.getuint16(stOffset);
            if (format != 1) {
                throw new InvalidFontException("Invalid extension format (" + format + ")");
            }
            int lookupType = this.lookupTable.data.getuint16(stOffset + 2);
            int extOffset = this.lookupTable.data.getuint32asint(stOffset + 4, "Only signed extension values supported");
            switch (lookupType) {
                case 1: 
                case 3: {
                    dummySubtables = this.gatherLookupsForCoverage(stOffset + extOffset, 2, gids, dummySubtables, noopHarvester, 0);
                    break;
                }
                case 2: {
                    dummySubtables = this.gatherPairPosLookups(stOffset + extOffset, gids, dummySubtables, 0);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.twoCoveragesHarvester.resetCoverageInfo(2, 2, 1);
                    dummySubtables = this.gatherLookupsForCoverage(stOffset + extOffset, 2, gids, dummySubtables, this.twoCoveragesHarvester, 0);
                    break;
                }
                case 7: {
                    dummySubtables = this.gatherContextualLookup(stOffset + extOffset, gids, lookups, dummySubtables, 0);
                    break;
                }
                case 8: {
                    dummySubtables = this.gatherChainingLookup(stOffset + extOffset, gids, lookups, dummySubtables, 0);
                    break;
                }
                default: {
                    throw new InvalidFontException("Invalid GPOS lookup type (" + lookupType + ")");
                }
            }
            if (dummySubtables == null) continue;
            if (subtables == null) {
                subtables = new ArrayList<Integer>();
            }
            if (subtables.contains(j = new Integer(i))) continue;
            subtables.add(j);
        }
        return subtables;
    }

    List harvestSubtables(Subset gids, int lookupOffset, int lookupType, int lookupFlag, Map lookups) throws InvalidFontException, UnsupportedFontException {
        switch (lookupType) {
            case 1: 
            case 3: {
                return this.gatherLookupsForCoverageAllSubtables(gids, lookupOffset, noopHarvester);
            }
            case 2: {
                return this.gatherPairPosLookupsForAllSubtables(gids, lookupOffset);
            }
            case 4: 
            case 5: 
            case 6: {
                this.twoCoveragesHarvester.resetCoverageInfo(2, 2, 1);
                return this.gatherLookupsForCoverageAllSubtables(gids, lookupOffset, this.twoCoveragesHarvester);
            }
            case 7: {
                return this.gatherContextualLookupsForAllSubtables(gids, lookupOffset, lookups);
            }
            case 8: {
                return this.gatherChainingLookupsForAllSubtables(gids, lookupOffset, lookups);
            }
            case 9: {
                return this.gatherExtensionGlyphsForAllSubtables(gids, lookupOffset, lookups);
            }
        }
        throw new InvalidFontException("Invalid GPOS lookup type (" + lookupType + ")");
    }

    private class ChainingFormat3Harvester
    extends NCoveragesHarvester {
        private final Map lookups;
        private int backtrackCount;
        private boolean subsequentCoveragesTested;
        private boolean subsequentCoveragesApply;

        ChainingFormat3Harvester(Map lookups, int stOffset) throws InvalidFontException {
            super(4, GposHarvester.this.lookupTable.data.getuint16(stOffset + 2), 1);
            this.subsequentCoveragesTested = false;
            this.backtrackCount = GposHarvester.this.lookupTable.data.getuint16(stOffset + 2);
            this.lookups = lookups;
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            if (this.subsequentCoveragesTested) {
                return this.subsequentCoveragesApply;
            }
            this.subsequentCoveragesTested = true;
            boolean applies = super.lookupApplies(coverageGlyph, stOffset, coverageIndex, gids);
            if (!applies) {
                this.subsequentCoveragesApply = false;
                return false;
            }
            int inputCount = GposHarvester.this.lookupTable.data.getuint16(stOffset + 4 + 2 * this.backtrackCount);
            this.resetCoverageInfo(4 + 2 * this.backtrackCount + 2, inputCount, 0);
            applies = super.lookupApplies(coverageGlyph, stOffset, coverageIndex, gids);
            if (!applies) {
                this.subsequentCoveragesApply = false;
                return false;
            }
            int lookaheadCount = GposHarvester.this.lookupTable.data.getuint16(stOffset + 6 + 2 * this.backtrackCount + 2 * inputCount);
            this.resetCoverageInfo(8 + 2 * this.backtrackCount + 2 * inputCount, lookaheadCount, 0);
            applies = super.lookupApplies(coverageGlyph, stOffset, coverageIndex, gids);
            if (!applies) {
                this.subsequentCoveragesApply = false;
                return false;
            }
            int lookupCount = GposHarvester.this.lookupTable.data.getuint16(stOffset + 8 + 2 * this.backtrackCount + 2 * inputCount + 2 * lookaheadCount);
            for (int j = 0; j < lookupCount; ++j) {
                int lookupIndex = GposHarvester.this.lookupTable.data.getuint16(stOffset + 10 + 2 * this.backtrackCount + 2 * inputCount + 2 * lookaheadCount + 4 * j + 2);
                GposHarvester.this.harvest(gids, lookupIndex, this.lookups);
            }
            this.subsequentCoveragesApply = true;
            return true;
        }
    }

    private class ContextFormat3Harvester
    extends NCoveragesHarvester {
        private final Map lookups;

        ContextFormat3Harvester(Map lookups, int stOffset) throws InvalidFontException {
            super(6, GposHarvester.this.lookupTable.data.getuint16(stOffset + 2), 1);
            this.lookups = lookups;
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            boolean applies = super.lookupApplies(coverageGlyph, stOffset, coverageIndex, gids);
            if (applies) {
                int lookupCount = GposHarvester.this.lookupTable.data.getuint16(stOffset + 4);
                for (int j = 0; j < lookupCount; ++j) {
                    int lookupIndex = GposHarvester.this.lookupTable.data.getuint16(stOffset + 6 + 2 * this.numCoverages + 4 * j + 2);
                    GposHarvester.this.harvest(gids, lookupIndex, this.lookups);
                }
            }
            return applies;
        }
    }

    private class NCoveragesHarvester
    extends GposLookupHarvester
    implements LayoutTable.CoverageConsumer {
        private boolean covered;
        private boolean subsequentCoveragesIterated;
        private boolean subsequentCoveragesCovered;
        private int offsetDeltaToCoverages;
        protected int numCoverages;
        private int coverageStartIndex;

        NCoveragesHarvester(int offsetDeltaToCoverages, int numCoverages, int coverageStartIndex) {
            this.subsequentCoveragesIterated = false;
            this.offsetDeltaToCoverages = offsetDeltaToCoverages;
            this.numCoverages = numCoverages;
            this.coverageStartIndex = coverageStartIndex;
        }

        protected void resetCoverageInfo(int offsetDeltaToCoverages, int numCoverages, int coverageStartIndex) {
            this.subsequentCoveragesIterated = false;
            this.offsetDeltaToCoverages = offsetDeltaToCoverages;
            this.numCoverages = numCoverages;
            this.coverageStartIndex = coverageStartIndex;
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            if (this.subsequentCoveragesIterated) {
                return this.subsequentCoveragesCovered;
            }
            this.subsequentCoveragesIterated = true;
            for (int i = this.coverageStartIndex; i < this.numCoverages; ++i) {
                this.covered = false;
                GposHarvester.this.lookupTable.iterateCoverage(GposHarvester.this.lookupTable.data.getOffset(stOffset, this.offsetDeltaToCoverages + 2 * i), gids, this);
                if (this.covered) continue;
                this.subsequentCoveragesCovered = false;
                return false;
            }
            this.subsequentCoveragesCovered = true;
            return true;
        }

        public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
            this.covered = true;
            return false;
        }
    }

    private class PairPosFormat1Harvester
    extends GposLookupHarvester {
        private PairPosFormat1Harvester() {
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
            int pairSetOffset = GposHarvester.this.lookupTable.data.getOffset(stOffset, 10 + 2 * coverageIndex);
            int firstValueSize = ((Gpos)GposHarvester.this.lookupTable).getValueRecordSize(GposHarvester.this.lookupTable.data.getuint16(stOffset + 4));
            int secondValueSize = ((Gpos)GposHarvester.this.lookupTable).getValueRecordSize(GposHarvester.this.lookupTable.data.getuint16(stOffset + 6));
            int pairValueCount = GposHarvester.this.lookupTable.data.getuint16(pairSetOffset);
            for (int i = 0; i < pairValueCount; ++i) {
                int secondGlyph = GposHarvester.this.lookupTable.data.getuint16(pairSetOffset + 2 + (2 + firstValueSize + secondValueSize) * i);
                if (gids.getExistingSubsetGid(secondGlyph) == -1) continue;
                return true;
            }
            return false;
        }
    }

    private static class NoopHarvester
    extends GposLookupHarvester {
        private NoopHarvester() {
        }

        public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) {
            return true;
        }
    }

    private static abstract class GposLookupHarvester
    implements LookupTableHarvester.CoverageLookupHarvester {
        private GposLookupHarvester() {
        }

        public boolean keepGoing() {
            return false;
        }
    }
}

