/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LookupTableHarvester;
import java.util.Map;

class ContextFormat1Harvester
implements LookupTableHarvester.CoverageLookupHarvester {
    private Map lookups;
    private final LookupTableHarvester harvester;
    private final boolean continueIterating;

    ContextFormat1Harvester(LookupTableHarvester harvester, Map lookups, boolean continueIteratingWhenLookupApplies) {
        this.lookups = lookups;
        this.harvester = harvester;
        this.continueIterating = continueIteratingWhenLookupApplies;
    }

    public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
        int subruleSetOffset = this.harvester.lookupTable.data.getOffset(stOffset, 6 + 2 * coverageIndex);
        int subruleCount = this.harvester.lookupTable.data.getuint16(subruleSetOffset);
        boolean applies = false;
        for (int i = 0; i < subruleCount; ++i) {
            int gid;
            int j;
            int subruleOffset = this.harvester.lookupTable.data.getOffset(subruleSetOffset, 2 + 2 * i);
            int glyphCount = this.harvester.lookupTable.data.getuint16(subruleOffset);
            for (j = 0; j < glyphCount - 1 && gids.getExistingSubsetGid(gid = this.harvester.lookupTable.data.getuint16(subruleOffset + 4 + 2 * j)) != -1; ++j) {
            }
            if (j != glyphCount - 1) continue;
            int lookupCount = this.harvester.lookupTable.data.getuint16(subruleOffset + 2);
            for (j = 0; j < lookupCount; ++j) {
                int lookupIndex = this.harvester.lookupTable.data.getuint16(subruleOffset + 4 + 2 * (glyphCount - 1) + 4 * j + 2);
                this.harvester.harvest(gids, lookupIndex, this.lookups);
            }
            applies = true;
        }
        return applies;
    }

    public boolean keepGoing() {
        return this.continueIterating;
    }
}

