/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.mac;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.WrapperFontData;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;

public class ResourceFontData
extends WrapperFontData {
    private String rsrcFontName;
    private String sfntName;
    private ULocale locale;
    private boolean isBold;
    private boolean isItalic;

    public ResourceFontData(FontData fontData, ULocale locale, String fontName, String sfntName, boolean isBold, boolean isItalic) {
        super(fontData);
        this.locale = locale;
        this.rsrcFontName = fontName;
        this.sfntName = sfntName;
        this.isBold = isBold;
        this.isItalic = isItalic;
    }

    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        if ((platform == Platform.MAC_OSX || platform == null) && this.locale != null && this.rsrcFontName != null && ResourceFontData.isContainedWithin(this.locale, locale)) {
            FXGFontDescription[] fxgDesc = new FXGFontDescription[]{new FXGFontDescription(Platform.MAC_OSX, this.locale, this.rsrcFontName, this.isBold, this.isItalic)};
            return fxgDesc;
        }
        return new FXGFontDescription[0];
    }

    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        PlatformFontDescription[] platformDesc = this.getFontData().getPlatformFontDescription(platform, locale);
        if (platformDesc != null) {
            return platformDesc;
        }
        if ((platform == Platform.MAC_OSX || platform == null) && this.locale != null && this.sfntName != null && ResourceFontData.isContainedWithin(this.locale, locale)) {
            platformDesc = new PlatformFontDescription[]{new PlatformFontDescription(Platform.MAC_OSX, this.locale, this.sfntName)};
            return platformDesc;
        }
        return new PlatformFontDescription[0];
    }

    private static boolean isContainedWithin(ULocale baseLocale, ULocale locale) {
        if (locale == null) {
            return true;
        }
        String baseLanguage = baseLocale.getLanguage();
        if (baseLanguage != null && !baseLanguage.equals("") && !baseLanguage.equals(locale.getLanguage())) {
            return false;
        }
        String baseCountry = baseLocale.getCountry();
        if (baseCountry != null && !baseCountry.equals("") && !baseCountry.equals(locale.getCountry())) {
            return false;
        }
        String baseScript = baseLocale.getScript();
        return baseScript == null || !baseScript.equals("") || baseScript.equals(locale.getScript());
    }
}

