/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.postscript.SubArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class Type2CStringGenerator
implements HintedOutlineConsumer {
    private static final int MAX_STACK = 48;
    private static final int MAX_STEMS = 96;
    private static final int STANDARD_FLEX_DEPTH = 50;
    public static final double DEFAULT_NOMINAL_WIDTH = 0.0;
    public static final double DEFAULT_DEFAULT_WIDTH = 0.0;
    private static final double BOTTOM_EDGE = -21.0;
    private static final double TOP_EDGE = -20.0;
    private static final boolean debug = false;
    private int currCStringIndex = 0;
    GlyphInfo[] glyphs;
    private boolean[] widthsAnalyzed;
    private double[] nominalWidth;
    private double[] defaultWidth;
    private double currentX;
    private double currentY;
    private int startOfSeqOp;
    private boolean moveToSeen;
    private int lastOpCode;
    private int stackCount;
    private double[] stack = new double[48];
    private int hintMaskIndex;
    private boolean hintMaskSeen;
    private boolean cntrMaskSeen;
    private byte[] hintmask = new byte[12];
    private byte[] cntrmask = new byte[12];
    private boolean subrize;

    public Type2CStringGenerator(int numGlyphs, int numFDs) {
        this.init(numGlyphs, numFDs, false);
    }

    public Type2CStringGenerator(int numGlyphs, int numFDs, boolean willSubrize) {
        this.init(numGlyphs, numFDs, willSubrize);
    }

    private void init(int numGlyphs, int numFDs, boolean willSubrize) {
        this.glyphs = new GlyphInfo[numGlyphs];
        this.widthsAnalyzed = new boolean[numFDs];
        this.nominalWidth = new double[numFDs];
        this.defaultWidth = new double[numFDs];
        this.subrize = willSubrize;
        for (int i = 0; i < numFDs; ++i) {
            this.nominalWidth[i] = 0.0;
            this.defaultWidth[i] = 0.0;
        }
        this.resetState();
    }

    private void resetState() {
        this.moveToSeen = false;
        this.lastOpCode = 0;
        this.stackCount = 0;
        this.currentX = 0.0;
        this.currentY = 0.0;
        this.startOfSeqOp = 0;
        this.hintMaskSeen = false;
        this.cntrMaskSeen = false;
        this.hintMaskIndex = -1;
        Arrays.fill(this.hintmask, (byte)0);
        Arrays.fill(this.cntrmask, (byte)0);
    }

    private void stackToCString() {
        if (this.stackCount != 0) {
            for (int i = 0; i < this.stackCount; ++i) {
                this.glyphs[this.currCStringIndex].tmpcstr.numToCString(this.stack[i]);
            }
            this.stackCount = 0;
        }
        switch (this.lastOpCode) {
            case 6: 
            case 7: 
            case 30: 
            case 31: {
                this.glyphs[this.currCStringIndex].tmpcstr.addByte(this.startOfSeqOp);
                break;
            }
            default: {
                this.glyphs[this.currCStringIndex].tmpcstr.addByte(this.lastOpCode);
            }
        }
        this.lastOpCode = 0;
    }

    private void ensureStackSpace(int numArgs) {
        if (this.stackCount + numArgs + (this.subrize ? 1 : 0) > 48) {
            this.stackToCString();
        }
    }

    public void newGlyph(int glyphID, int fontDictionary, double defaultWidth, double nominalWidth) {
        this.resetState();
        this.currCStringIndex = glyphID;
        this.glyphs[glyphID] = new GlyphInfo(fontDictionary, defaultWidth);
        this.defaultWidth[fontDictionary] = defaultWidth;
        this.nominalWidth[fontDictionary] = nominalWidth;
    }

    private void newHintMask() {
        if (this.lastOpCode == 0 && this.hintMaskIndex == this.glyphs[this.currCStringIndex].tmpcstr.cstrLen) {
            Arrays.fill(this.hintmask, (byte)0);
        } else {
            if (this.lastOpCode != 0) {
                this.stackToCString();
            }
            if (this.hintMaskSeen) {
                HintMask mask = new HintMask(this.hintMaskIndex, this.hintmask);
                this.glyphs[this.currCStringIndex].hintMasks.add(this.glyphs[this.currCStringIndex].hintMasks.size(), mask);
                Arrays.fill(this.hintmask, (byte)0);
            } else {
                this.hintMaskSeen = true;
            }
            this.hintMaskIndex = this.glyphs[this.currCStringIndex].tmpcstr.cstrLen;
        }
    }

    private void newCntrMask() {
        if (this.lastOpCode != 0) {
            this.stackToCString();
        }
        if (this.cntrMaskSeen) {
            CntrMask mask = new CntrMask(this.cntrmask);
            this.glyphs[this.currCStringIndex].cntrMasks.add(this.glyphs[this.currCStringIndex].cntrMasks.size(), mask);
            Arrays.fill(this.cntrmask, (byte)0);
        } else {
            this.cntrMaskSeen = true;
        }
    }

    private void addIdToMask(int id, byte[] mask) {
        if (id < 96) {
            int n = id / 8;
            mask[n] = (byte)(mask[n] | 1 << id % 8);
        }
    }

    private void checkForNewHintMask(boolean doHintSubstitution) {
        if (this.moveToSeen && (doHintSubstitution || this.glyphs[this.currCStringIndex].hints.size() == 0) || !this.moveToSeen && doHintSubstitution && this.glyphs[this.currCStringIndex].hints.size() > 0) {
            this.newHintMask();
        }
    }

    private void checkForNewCntrMask(boolean newGroup) {
        if (!this.cntrMaskSeen || newGroup) {
            this.newCntrMask();
        }
    }

    private void cntrHint(double edge1, double edge2, boolean vertical) {
        int id = this.glyphs[this.currCStringIndex].findHint(edge1, edge2, vertical, true);
        this.addIdToMask(id, this.cntrmask);
        if (this.hintMaskSeen) {
            this.addIdToMask(id, this.hintmask);
        } else {
            this.addIdToMask(id, this.glyphs[this.currCStringIndex].initMask);
        }
    }

    public void setMatrix(Matrix m) {
    }

    public void stem(double edge1, double edge2, boolean doHintSubstitution, boolean vertical, boolean isCounter) {
        if (!isCounter) {
            this.checkForNewHintMask(doHintSubstitution);
        }
        int id = this.glyphs[this.currCStringIndex].findHint(edge1, edge2, vertical, isCounter);
        if (isCounter) {
            this.checkForNewCntrMask(doHintSubstitution);
            this.addIdToMask(id, this.cntrmask);
        } else if (this.hintMaskSeen) {
            this.addIdToMask(id, this.hintmask);
        } else {
            this.addIdToMask(id, this.glyphs[this.currCStringIndex].initMask);
        }
    }

    public void stem3(double edge1, double edge2, double edge3, double edge4, double edge5, double edge6, boolean doHintSubstitution, boolean isVertical) {
        this.checkForNewHintMask(doHintSubstitution);
        this.checkForNewCntrMask(false);
        this.cntrHint(edge1, edge2, isVertical);
        this.cntrHint(edge3, edge4, isVertical);
        this.cntrHint(edge5, edge6, isVertical);
    }

    public boolean width(double wx) {
        this.glyphs[this.currCStringIndex].setWidth(wx, this.nominalWidth);
        return true;
    }

    public void globalColorOn() {
        if (this.lastOpCode != 0) {
            this.stackToCString();
        }
        this.glyphs[this.currCStringIndex].tmpcstr.addByte(12);
        this.glyphs[this.currCStringIndex].tmpcstr.addByte(38);
    }

    public void noCounters() {
        this.newCntrMask();
    }

    public void noHints() {
        this.newHintMask();
    }

    public void lineto(double x, double y) {
        if (!this.moveToSeen) {
            this.moveto(0.0, 0.0);
        }
        double dx = x - this.currentX;
        double dy = y - this.currentY;
        this.currentX = x;
        this.currentY = y;
        if (dx == 0.0) {
            this.ensureStackSpace(1);
            switch (this.lastOpCode) {
                default: {
                    this.stackToCString();
                }
                case 0: {
                    this.startOfSeqOp = 7;
                }
                case 6: 
            }
            this.stack[this.stackCount++] = dy;
            this.lastOpCode = 7;
        } else if (dy == 0.0) {
            this.ensureStackSpace(1);
            switch (this.lastOpCode) {
                default: {
                    this.stackToCString();
                }
                case 0: {
                    this.startOfSeqOp = 6;
                }
                case 7: 
            }
            this.stack[this.stackCount++] = dx;
            this.lastOpCode = 6;
        } else {
            this.ensureStackSpace(2);
            switch (this.lastOpCode) {
                case 5: {
                    this.stack[this.stackCount++] = dx;
                    this.stack[this.stackCount++] = dy;
                    break;
                }
                case 8: {
                    this.stack[this.stackCount++] = dx;
                    this.stack[this.stackCount++] = dy;
                    this.lastOpCode = 24;
                    this.stackToCString();
                    break;
                }
                default: {
                    this.stackToCString();
                }
                case 0: {
                    this.stack[this.stackCount++] = dx;
                    this.stack[this.stackCount++] = dy;
                    this.lastOpCode = 5;
                }
            }
        }
    }

    private void addVHCurveTo(double dy1, double dx2, double dy2, double dx3) {
        this.ensureStackSpace(4);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: {
                this.startOfSeqOp = 30;
            }
            case 31: 
        }
        this.stack[this.stackCount++] = dy1;
        this.stack[this.stackCount++] = dx2;
        this.stack[this.stackCount++] = dy2;
        this.stack[this.stackCount++] = dx3;
        this.lastOpCode = 30;
    }

    private void addVHCurveTo(double dy1, double dx2, double dy2, double dx3, double dy3) {
        this.ensureStackSpace(5);
        this.addVHCurveTo(dy1, dx2, dy2, dx3);
        this.stack[this.stackCount++] = dy3;
        this.stackToCString();
    }

    private void addVVCurveTo(double dy1, double dx2, double dy2, double dy3) {
        this.ensureStackSpace(4);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: 
            case 26: 
        }
        this.stack[this.stackCount++] = dy1;
        this.stack[this.stackCount++] = dx2;
        this.stack[this.stackCount++] = dy2;
        this.stack[this.stackCount++] = dy3;
        this.lastOpCode = 26;
    }

    private void addVVCurveTo(double dx1, double dy1, double dx2, double dy2, double dy3) {
        this.ensureStackSpace(5);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: 
        }
        this.stack[this.stackCount++] = dx1;
        this.stack[this.stackCount++] = dy1;
        this.stack[this.stackCount++] = dx2;
        this.stack[this.stackCount++] = dy2;
        this.stack[this.stackCount++] = dy3;
        this.lastOpCode = 26;
    }

    private void addHVCurveTo(double dx1, double dx2, double dy2, double dy3) {
        this.ensureStackSpace(4);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: {
                this.startOfSeqOp = 31;
            }
            case 30: 
        }
        this.stack[this.stackCount++] = dx1;
        this.stack[this.stackCount++] = dx2;
        this.stack[this.stackCount++] = dy2;
        this.stack[this.stackCount++] = dy3;
        this.lastOpCode = 31;
    }

    private void addHVCurveTo(double dx1, double dx2, double dy2, double dx3, double dy3) {
        this.ensureStackSpace(5);
        this.addHVCurveTo(dx1, dx2, dy2, dy3);
        this.stack[this.stackCount++] = dx3;
        this.stackToCString();
    }

    private void addHHCurveTo(double dx1, double dx2, double dy2, double dx3) {
        this.ensureStackSpace(4);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: 
            case 27: 
        }
        this.stack[this.stackCount++] = dx1;
        this.stack[this.stackCount++] = dx2;
        this.stack[this.stackCount++] = dy2;
        this.stack[this.stackCount++] = dx3;
        this.lastOpCode = 27;
    }

    private void addHHCurveTo(double dx1, double dy1, double dx2, double dy2, double dx3) {
        this.ensureStackSpace(5);
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
            }
            case 0: 
        }
        this.stack[this.stackCount++] = dy1;
        this.stack[this.stackCount++] = dx1;
        this.stack[this.stackCount++] = dx2;
        this.stack[this.stackCount++] = dy2;
        this.stack[this.stackCount++] = dx3;
        this.lastOpCode = 27;
    }

    private void addRRCurveTo(double dx1, double dy1, double dx2, double dy2, double dx3, double dy3) {
        this.ensureStackSpace(6);
        switch (this.lastOpCode) {
            case 5: {
                this.stack[this.stackCount++] = dx1;
                this.stack[this.stackCount++] = dy1;
                this.stack[this.stackCount++] = dx2;
                this.stack[this.stackCount++] = dy2;
                this.stack[this.stackCount++] = dx3;
                this.stack[this.stackCount++] = dy3;
                this.lastOpCode = 25;
                this.stackToCString();
                break;
            }
            default: {
                this.stackToCString();
            }
            case 0: 
            case 8: {
                this.stack[this.stackCount++] = dx1;
                this.stack[this.stackCount++] = dy1;
                this.stack[this.stackCount++] = dx2;
                this.stack[this.stackCount++] = dy2;
                this.stack[this.stackCount++] = dx3;
                this.stack[this.stackCount++] = dy3;
                this.lastOpCode = 8;
            }
        }
    }

    public void curveto(double x1, double y1, double x2, double y2) {
        if (!this.moveToSeen) {
            this.moveto(0.0, 0.0);
        }
        this.curveto(Math.round((this.currentX + 2.0 * x1) / 3.0), Math.round((this.currentY + 2.0 * y1) / 3.0), Math.round((2.0 * x1 + x2) / 3.0), Math.round((2.0 * y1 + y2) / 3.0), x2, y2);
    }

    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (!this.moveToSeen) {
            this.moveto(0.0, 0.0);
        }
        double dx1 = x1 - this.currentX;
        double dx2 = x2 - x1;
        double dx3 = x3 - x2;
        double dy1 = y1 - this.currentY;
        double dy2 = y2 - y1;
        double dy3 = y3 - y2;
        this.currentX = x3;
        this.currentY = y3;
        if (dx1 == 0.0) {
            if (dy3 == 0.0) {
                this.addVHCurveTo(dy1, dx2, dy2, dx3);
            } else if (dx3 == 0.0) {
                this.addVVCurveTo(dy1, dx2, dy2, dy3);
            } else {
                this.addVHCurveTo(dy1, dx2, dy2, dx3, dy3);
            }
        } else if (dy1 == 0.0) {
            if (dx3 == 0.0) {
                this.addHVCurveTo(dx1, dx2, dy2, dy3);
            } else if (dy3 == 0.0) {
                this.addHHCurveTo(dx1, dx2, dy2, dx3);
            } else {
                this.addHVCurveTo(dx1, dx2, dy2, dx3, dy3);
            }
        } else if (dx3 == 0.0) {
            this.addVVCurveTo(dx1, dy1, dx2, dy2, dy3);
        } else if (dy3 == 0.0) {
            this.addHHCurveTo(dx1, dy1, dx2, dy2, dx3);
        } else {
            this.addRRCurveTo(dx1, dy1, dx2, dy2, dx3, dy3);
        }
    }

    private void clearMoveTo(double dx, double dy) {
        this.currentX -= dx;
        this.currentY -= dy;
        this.stackCount = 0;
        this.lastOpCode = 0;
    }

    public void moveto(double x, double y) {
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                this.clearMoveTo(0.0, this.stack[0]);
                break;
            }
            case 22: {
                this.clearMoveTo(this.stack[0], 0.0);
                break;
            }
            case 21: {
                this.clearMoveTo(this.stack[0], this.stack[1]);
            }
        }
        double dx = x - this.currentX;
        double dy = y - this.currentY;
        this.currentX = x;
        this.currentY = y;
        if (dx == 0.0) {
            this.stack[this.stackCount++] = dy;
            this.lastOpCode = 4;
        } else if (dy == 0.0) {
            this.stack[this.stackCount++] = dx;
            this.lastOpCode = 22;
        } else {
            this.stack[this.stackCount++] = dx;
            this.stack[this.stackCount++] = dy;
            this.lastOpCode = 21;
        }
        this.moveToSeen = true;
    }

    public void closepath() {
    }

    private void addGeneralFlex(double depth, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double x5, double y5, double x6, double y6) {
        this.stack[this.stackCount++] = x1 - this.currentX;
        this.stack[this.stackCount++] = y1 - this.currentY;
        this.stack[this.stackCount++] = x2 - x1;
        this.stack[this.stackCount++] = y2 - y1;
        this.stack[this.stackCount++] = x3 - x2;
        this.stack[this.stackCount++] = y3 - y2;
        this.stack[this.stackCount++] = x4 - x3;
        this.stack[this.stackCount++] = y4 - y3;
        this.stack[this.stackCount++] = x5 - x4;
        this.stack[this.stackCount++] = y5 - y4;
        this.stack[this.stackCount++] = x6 - x5;
        this.stack[this.stackCount++] = y6 - y5;
        this.stack[this.stackCount++] = depth;
        this.lastOpCode = 12;
        this.stackToCString();
        this.lastOpCode = 35;
        this.stackToCString();
        this.currentX = x6;
        this.currentY = y6;
    }

    public void flex(double depth, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, double x5, double y5, double x6, double y6) {
        boolean horizontalFlex = true;
        if (this.lastOpCode != 0) {
            this.stackToCString();
        }
        if (depth != 50.0) {
            this.addGeneralFlex(depth, x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, x6, y6);
            return;
        }
        if (this.currentY == y6) {
            if (y2 == y3 && y3 == y4) {
                if (this.currentY == y1 && y5 == y6) {
                    this.stack[this.stackCount++] = x1 - this.currentX;
                    this.stack[this.stackCount++] = x2 - x1;
                    this.stack[this.stackCount++] = y2 - y1;
                    this.stack[this.stackCount++] = x3 - x2;
                    this.stack[this.stackCount++] = x4 - x3;
                    this.stack[this.stackCount++] = x5 - x4;
                    this.stack[this.stackCount++] = x6 - x5;
                    this.lastOpCode = 12;
                    this.stackToCString();
                    this.lastOpCode = 34;
                    this.stackToCString();
                } else {
                    this.stack[this.stackCount++] = x1 - this.currentX;
                    this.stack[this.stackCount++] = y1 - this.currentY;
                    this.stack[this.stackCount++] = x2 - x1;
                    this.stack[this.stackCount++] = y2 - y1;
                    this.stack[this.stackCount++] = x3 - x2;
                    this.stack[this.stackCount++] = x4 - x3;
                    this.stack[this.stackCount++] = x5 - x4;
                    this.stack[this.stackCount++] = y5 - y4;
                    this.stack[this.stackCount++] = x6 - x5;
                    this.lastOpCode = 12;
                    this.stackToCString();
                    this.lastOpCode = 36;
                    this.stackToCString();
                }
                this.currentX = x6;
                this.currentY = y6;
                return;
            }
        } else if (this.currentX == x6) {
            horizontalFlex = false;
        } else {
            this.addGeneralFlex(depth, x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, x6, y6);
            return;
        }
        if (Math.abs(x5 - this.currentX) > Math.abs(y5 - this.currentY) != horizontalFlex) {
            this.addGeneralFlex(depth, x1, y1, x2, y2, x3, y3, x4, y4, x5, y5, x6, y6);
            return;
        }
        this.stack[this.stackCount++] = x1 - this.currentX;
        this.stack[this.stackCount++] = y1 - this.currentY;
        this.stack[this.stackCount++] = x2 - x1;
        this.stack[this.stackCount++] = y2 - y1;
        this.stack[this.stackCount++] = x3 - x2;
        this.stack[this.stackCount++] = y3 - y2;
        this.stack[this.stackCount++] = x4 - x3;
        this.stack[this.stackCount++] = y4 - y3;
        this.stack[this.stackCount++] = x5 - x4;
        this.stack[this.stackCount++] = y5 - y4;
        this.stack[this.stackCount++] = horizontalFlex ? x6 - x5 : y6 - y5;
        this.lastOpCode = 12;
        this.stackToCString();
        this.lastOpCode = 37;
        this.stackToCString();
        this.currentX = x6;
        this.currentY = y6;
    }

    public void endchar() {
        switch (this.lastOpCode) {
            default: {
                this.stackToCString();
                break;
            }
            case 0: 
            case 4: 
            case 21: 
            case 22: {
                this.stackCount = 0;
                this.lastOpCode = 0;
            }
        }
        this.lastOpCode = 14;
        this.stackToCString();
        this.newHintMask();
        this.newCntrMask();
    }

    private CharStrings createIndexFromCharstrings() throws InvalidFontException, UnsupportedFontException {
        int i;
        int totalSize = 1;
        CFFByteArray.CFFByteArrayBuilder builder = CFFByteArray.getCFFByteArrayBuilderInstance();
        builder.addCard16(this.glyphs.length);
        for (i = 0; i < this.glyphs.length; ++i) {
            totalSize += this.glyphs[i].finalcstr.cstrLen;
        }
        int offsetSize = totalSize > 0xFFFFFF ? 4 : (totalSize > 65535 ? 3 : (totalSize > 255 ? 2 : 1));
        builder.addCard8(offsetSize);
        totalSize = 1;
        for (i = 0; i < this.glyphs.length; ++i) {
            builder.addOffset(offsetSize, totalSize);
            totalSize += this.glyphs[i].finalcstr.cstrLen;
        }
        builder.addOffset(offsetSize, totalSize);
        for (i = 0; i < this.glyphs.length; ++i) {
            builder.addBytes(this.glyphs[i].finalcstr.cstr, 0, this.glyphs[i].finalcstr.cstrLen);
        }
        return new CharStrings(builder.toCFFByteArray(), 0);
    }

    public CharStrings getCharstringIndex() throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i].generateFullCharstring(this.defaultWidth, this.nominalWidth, this.subrize);
        }
        return this.createIndexFromCharstrings();
    }

    private int numsize(double r) {
        int i = (int)r;
        if ((double)i == r) {
            if (-107 <= i && i <= 107) {
                return 1;
            }
            if (-1131 <= i && i <= 1131) {
                return 2;
            }
            return 3;
        }
        return 5;
    }

    private void analyzeWidths(int fontDictionary) {
        ArrayList<WidthFrequency> frequencies = new ArrayList<WidthFrequency>();
        WidthFrequency thisWidth = new WidthFrequency();
        WidthComparator c = new WidthComparator();
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (this.glyphs[i].fd != fontDictionary) continue;
            thisWidth.width = this.glyphs[i].width;
            int index = Collections.binarySearch(frequencies, thisWidth, c);
            if (index >= 0) {
                ++((WidthFrequency)frequencies.get((int)index)).count;
                continue;
            }
            frequencies.add(-index - 1, new WidthFrequency(this.glyphs[i].width));
        }
        if (frequencies.size() > 0) {
            if (frequencies.size() == 1) {
                this.defaultWidth[fontDictionary] = ((WidthFrequency)frequencies.get((int)0)).width;
            } else {
                int j;
                int defaultSize = 0;
                int indexOfNW = 0;
                int indexOfDW = 0;
                for (j = 0; j < frequencies.size(); ++j) {
                    WidthFrequency width = (WidthFrequency)frequencies.get(j);
                    if (width.width == 0.0) continue;
                    defaultSize += this.numsize(width.width - 0.0) * width.count;
                }
                int minSize = defaultSize;
                for (j = 0; j < frequencies.size(); ++j) {
                    WidthFrequency rec;
                    int k;
                    double nomwidth = ((WidthFrequency)frequencies.get((int)j)).width + 107.0;
                    int nomsize = 0;
                    for (k = 0; k < frequencies.size(); ++k) {
                        rec = (WidthFrequency)frequencies.get(k);
                        nomsize += this.numsize(rec.width - nomwidth) * rec.count;
                    }
                    for (k = 0; k < frequencies.size(); ++k) {
                        rec = (WidthFrequency)frequencies.get(k);
                        int totsize = nomsize - this.numsize(rec.width - nomwidth) * rec.count;
                        if (totsize >= minSize) continue;
                        minSize = totsize;
                        indexOfNW = j;
                        indexOfDW = k;
                    }
                }
                double dflt = ((WidthFrequency)frequencies.get((int)indexOfDW)).width;
                double nominal = ((WidthFrequency)frequencies.get((int)indexOfNW)).width + 107.0;
                int dictSize = 0;
                if (dflt != 0.0) {
                    dictSize += this.numsize(dflt) + Dict.Key.defaultWidthX.opCodeLength();
                }
                if (nominal != 0.0) {
                    dictSize += this.numsize(nominal) + Dict.Key.nominalWidthX.opCodeLength();
                }
                if (minSize + dictSize < defaultSize) {
                    this.defaultWidth[fontDictionary] = dflt;
                    this.nominalWidth[fontDictionary] = nominal;
                }
            }
        }
        this.widthsAnalyzed[fontDictionary] = true;
    }

    public double calculateNominalWidth(int fontDictionary) {
        if (!this.widthsAnalyzed[fontDictionary]) {
            this.analyzeWidths(fontDictionary);
        }
        return this.nominalWidth[fontDictionary];
    }

    public double calculateDefaultWidth(int fontDictionary) {
        if (!this.widthsAnalyzed[fontDictionary]) {
            this.analyzeWidths(fontDictionary);
        }
        return this.defaultWidth[fontDictionary];
    }

    static final class GlyphInfo {
        double width;
        final int fd;
        List hints = new ArrayList();
        List hintMasks = new ArrayList();
        List cntrMasks = new ArrayList();
        byte[] initMask = new byte[12];
        GrowableBuffer tmpcstr = new GrowableBuffer();
        GrowableBuffer finalcstr = new GrowableBuffer();

        GlyphInfo(int fd, double defaultWidth) {
            this.fd = fd;
            this.width = defaultWidth;
        }

        private int findHint(double edge1, double edge2, boolean vertical, boolean counter) {
            double e2;
            double e1;
            HintComparator c = new HintComparator();
            double delta = edge2 - edge1;
            if (delta < 0.0 && Double.compare(delta, -21.0) != 0 && Double.compare(delta, -20.0) != 0) {
                e1 = edge2;
                e2 = edge1;
            } else {
                e1 = edge1;
                e2 = edge2;
            }
            HintInfo thisHint = new HintInfo(e2, e1, (vertical ? 1 : 0) | (counter ? 2 : 0));
            int index = Collections.binarySearch(this.hints, thisHint, c);
            if (index < 0) {
                if (this.cntrMasks.size() > 0 && !counter) {
                    if (-index - 1 < this.hints.size() && thisHint.fuzzyMatch((HintInfo)this.hints.get(-index - 1))) {
                        return ((HintInfo)this.hints.get((int)(-index - 1))).id;
                    }
                    if (-index - 1 > 0 && thisHint.fuzzyMatch((HintInfo)this.hints.get(-index - 2))) {
                        return ((HintInfo)this.hints.get((int)(-index - 2))).id;
                    }
                }
                thisHint.id = this.hints.size();
                if (thisHint.id < 96) {
                    this.hints.add(-index - 1, thisHint);
                }
                return thisHint.id;
            }
            return ((HintInfo)this.hints.get((int)index)).id;
        }

        private static boolean maskByteSet(int id, byte[] mask) {
            return (mask[id / 8] & 1 << id % 8) != 0;
        }

        private static void addHintToMask(int index, byte[] mask) {
            int n = index / 8;
            mask[n] = (byte)(mask[n] | 1 << 7 - index % 8);
        }

        private void writeStems(int start, int limit, int opCode, boolean writeOpCode) {
            int stems_per_op = 23;
            int ops = (limit - start + 23 - 1) / 23;
            int hintsForThisOp = limit - start - (ops - 1) * 23;
            ListIterator iter = this.hints.listIterator(start);
            while (ops-- > 0) {
                double last = 0.0;
                while (hintsForThisOp-- > 0) {
                    HintInfo hint = (HintInfo)iter.next();
                    this.finalcstr.numToCString(hint.bottom - last);
                    this.finalcstr.numToCString(hint.top - hint.bottom);
                    last = hint.top;
                }
                if (writeOpCode || ops > 0) {
                    this.finalcstr.addByte(opCode);
                }
                hintsForThisOp = 23;
            }
        }

        private void saveStartOfCString(byte[] hintMap, double[] defaultWidth, double[] nominalWidth, boolean willSubrize) {
            int i;
            int maskBytes = (this.hints.size() + 7) / 8;
            byte[] tmpMask = new byte[maskBytes];
            boolean haveMask = false;
            boolean initMask = false;
            int numHints = this.hints.size();
            if (this.width != defaultWidth[this.fd]) {
                this.finalcstr.numToCString(this.width - nominalWidth[this.fd]);
            }
            if (numHints == 0) {
                return;
            }
            Iterator iter = this.hints.iterator();
            int numHStems = 0;
            while (iter.hasNext()) {
                HintInfo hint = (HintInfo)iter.next();
                if ((hint.flags & 1) != 0) break;
                ++numHStems;
            }
            Arrays.fill(tmpMask, (byte)-1);
            if (numHints % 8 != 0) {
                tmpMask[tmpMask.length - 1] = (byte)(255 >> 8 - numHints % 8);
            }
            if (!SubArrays.arrayCompare(tmpMask, 0, this.initMask, 0, tmpMask.length)) {
                haveMask = true;
                initMask = true;
            } else if (!this.hintMasks.isEmpty()) {
                HintMask hintMask = (HintMask)this.hintMasks.get(0);
                if (hintMask.indexIntoCStr == 0) {
                    initMask = true;
                }
                haveMask = true;
            }
            byte[] curMaskBytes = initMask ? this.initMask : tmpMask;
            iter = this.hintMasks.iterator();
            while (iter.hasNext()) {
                HintMask hintMask = (HintMask)iter.next();
                if (hintMask.indexIntoCStr != 0 && SubArrays.arrayCompare(curMaskBytes, 0, hintMask.mask, 0, curMaskBytes.length)) {
                    iter.remove();
                    continue;
                }
                curMaskBytes = hintMask.mask;
            }
            if (this.hintMasks.isEmpty() && !initMask) {
                haveMask = false;
            }
            this.writeStems(0, numHStems, haveMask ? 18 : 1, true);
            this.writeStems(numHStems, numHints, haveMask ? 23 : 3, !initMask && this.cntrMasks.isEmpty());
            for (CntrMask mask : this.cntrMasks) {
                Arrays.fill(tmpMask, (byte)0);
                this.finalcstr.addByte(20);
                for (i = 0; i < numHints; ++i) {
                    if (!GlyphInfo.maskByteSet(i, mask.mask)) continue;
                    GlyphInfo.addHintToMask(hintMap[i], tmpMask);
                }
                if (willSubrize) {
                    this.finalcstr.addByte(tmpMask.length + 2);
                }
                for (i = 0; i < tmpMask.length; ++i) {
                    this.finalcstr.addByte(tmpMask[i]);
                }
            }
            if (initMask) {
                Arrays.fill(tmpMask, (byte)0);
                this.finalcstr.addByte(19);
                for (i = 0; i < numHints; ++i) {
                    if (!GlyphInfo.maskByteSet(i, this.initMask)) continue;
                    GlyphInfo.addHintToMask(hintMap[i], tmpMask);
                }
                if (willSubrize) {
                    this.finalcstr.addByte(tmpMask.length + 2);
                }
                for (i = 0; i < tmpMask.length; ++i) {
                    this.finalcstr.addByte(tmpMask[i]);
                }
            }
        }

        private void savePathsToCString(byte[] hintMap, boolean willSubrize) {
            int maskBytes = (this.hints.size() + 7) / 8;
            Iterator iter = this.hintMasks.iterator();
            int cstrIndex = 0;
            byte[] tmpMask = new byte[maskBytes];
            int numHints = this.hints.size();
            while (iter.hasNext()) {
                int i;
                HintMask mask = (HintMask)iter.next();
                int stopAt = mask.indexIntoCStr;
                while (cstrIndex < stopAt) {
                    this.finalcstr.addByte(this.tmpcstr.cstr[cstrIndex]);
                    ++cstrIndex;
                }
                Arrays.fill(tmpMask, (byte)0);
                this.finalcstr.addByte(19);
                for (i = 0; i < numHints; ++i) {
                    if (!GlyphInfo.maskByteSet(i, mask.mask)) continue;
                    GlyphInfo.addHintToMask(hintMap[i], tmpMask);
                }
                if (willSubrize) {
                    this.finalcstr.addByte(tmpMask.length + 2);
                }
                for (i = 0; i < tmpMask.length; ++i) {
                    this.finalcstr.addByte(tmpMask[i]);
                }
            }
            while (cstrIndex < this.tmpcstr.cstrLen) {
                this.finalcstr.addByte(this.tmpcstr.cstr[cstrIndex]);
                ++cstrIndex;
            }
        }

        void generateFullCharstring(double[] defaultWidth, double[] nominalWidth, boolean willSubrize) {
            byte[] hintMap = new byte[this.hints.size()];
            Iterator iter = this.hints.iterator();
            byte i = 0;
            while (iter.hasNext()) {
                HintInfo info = (HintInfo)iter.next();
                hintMap[info.id] = i;
                i = (byte)(i + 1);
            }
            this.saveStartOfCString(hintMap, defaultWidth, nominalWidth, willSubrize);
            this.savePathsToCString(hintMap, willSubrize);
        }

        void setWidth(double width, double[] nominalWidth) {
            this.width = width + nominalWidth[this.fd];
        }
    }

    static final class GrowableBuffer {
        byte[] cstr = new byte[200];
        int cstrLen = 0;

        GrowableBuffer() {
        }

        void ensureCStrIsBigEnough(int numBytesNeeded) {
            if (this.cstrLen + numBytesNeeded > this.cstr.length) {
                byte[] tmp = new byte[this.cstr.length + Math.max(numBytesNeeded, 50)];
                System.arraycopy(this.cstr, 0, tmp, 0, this.cstrLen);
                this.cstr = tmp;
            }
        }

        void addByte(int value) {
            this.ensureCStrIsBigEnough(1);
            this.cstr[this.cstrLen++] = (byte)(value & 0xFF);
        }

        private void intToCString(int iVal) {
            short value = (short)iVal;
            if (-107 <= value && value <= 107) {
                this.addByte(value + 139);
            } else if (108 <= value && value <= 1131) {
                value = (short)(value - 108);
                this.addByte((value >> 8) + 247);
                this.addByte(value);
            } else if (-1131 <= value && value <= -108) {
                value = (short)(value + 108);
                this.addByte((-value >> 8) + 251);
                this.addByte(-value);
            } else if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
                this.addByte(28);
                this.addByte(value >> 8);
                this.addByte(value);
            }
        }

        void numToCString(double value) {
            int intVal = (int)value;
            if ((double)intVal == value) {
                this.intToCString(intVal);
                return;
            }
            int i = (int)(value * 65536.0 + (value < 0.0 ? -0.5 : 0.5));
            this.addByte(255);
            this.addByte(i >> 24);
            this.addByte(i >> 16);
            this.addByte(i >> 8);
            this.addByte(i);
        }
    }

    private static class CntrMask {
        byte[] mask = new byte[12];

        CntrMask(byte[] mask) {
            System.arraycopy(mask, 0, this.mask, 0, mask.length);
        }
    }

    private static class HintMask {
        final int indexIntoCStr;
        final byte[] mask = new byte[12];

        HintMask(int indexIntoCStr, byte[] mask) {
            this.indexIntoCStr = indexIntoCStr;
            System.arraycopy(mask, 0, this.mask, 0, mask.length);
        }
    }

    private static class HintComparator
    implements Comparator {
        private HintComparator() {
        }

        public int compare(Object o1, Object o2) {
            HintInfo h1 = (HintInfo)o1;
            HintInfo h2 = (HintInfo)o2;
            int diff = (h1.flags & 1) - (h2.flags & 1);
            if (diff != 0) {
                return diff;
            }
            if (h1.bottom < h2.bottom) {
                return -1;
            }
            if (h1.bottom > h2.bottom) {
                return 1;
            }
            if (h1.top < h2.top) {
                return -1;
            }
            if (h1.top > h2.top) {
                return 1;
            }
            return 0;
        }
    }

    private static class HintInfo {
        final double top;
        final double bottom;
        final int flags;
        int id;
        static final int VERTICAL_STEM = 1;
        static final int CNTR_STEM = 2;

        HintInfo(double top, double bottom, int flags) {
            this.top = top;
            this.bottom = bottom;
            this.flags = flags;
        }

        boolean fuzzyMatch(HintInfo oldHint) {
            return (oldHint.flags & 2) != 0 && (this.flags & 1) == (oldHint.flags & 1) && Math.abs(this.bottom - oldHint.bottom) < 2.0 && Math.abs(this.top - oldHint.top) < 2.0;
        }
    }

    private static class WidthComparator
    implements Comparator {
        private WidthComparator() {
        }

        public int compare(Object o1, Object o2) {
            WidthFrequency f1 = (WidthFrequency)o1;
            WidthFrequency f2 = (WidthFrequency)o2;
            return (int)(f1.width - f2.width);
        }
    }

    private static class WidthFrequency {
        double width;
        int count;

        WidthFrequency(double width) {
            this.width = width;
            this.count = 1;
        }

        WidthFrequency() {
            this.count = 0;
        }
    }
}

