/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.Type2ConsumerDefaultImpl;
import com.adobe.fontengine.font.cff.Type2OutlineParser;
import com.adobe.fontengine.font.cff.Type2Parser;
import java.util.List;

final class CIDComponentFont {
    protected final Dict fontDict;
    protected final Dict privateDict;
    protected final CharStrings localSubrs;

    public CIDComponentFont(CFFByteArray data, int offset, int size, StringIndex stringIndex) throws InvalidFontException, UnsupportedFontException {
        this.fontDict = new Dict(data, offset, size, stringIndex);
        Dict.OffsetSizeValue v2 = this.fontDict.get(Dict.Key.Private, false);
        if (v2 == null) {
            throw new InvalidFontException("Missing privateDict in CID component font");
        }
        this.privateDict = new Dict(data, v2.offset, v2.size, stringIndex);
        Dict.OffsetValue o3 = this.privateDict.get(Dict.Key.Subrs, false);
        this.localSubrs = o3 != null ? new CharStrings(data, v2.offset + o3.offset) : null;
    }

    public CIDComponentFont(Dict fontDict, Dict privateDict, CharStrings localSubrs) {
        this.fontDict = fontDict;
        this.privateDict = privateDict;
        this.localSubrs = localSubrs;
    }

    public void getOutline(CharStrings charStrings, int gid, CharStrings globalSubrs, Type2OutlineParser parser, OutlineConsumer consumer, Dict.NumbersValue topMatrix) throws InvalidFontException, UnsupportedFontException {
        parser.parse(charStrings, gid, this.localSubrs, globalSubrs, consumer, this.getOutlineMatrix(topMatrix), null);
    }

    public double getStemV() {
        Dict.NumbersValue value = this.privateDict.get(Dict.NumbersKey.StdVW, false);
        if (value != null) {
            return value.getFirstValueAsDouble();
        }
        value = this.privateDict.get(Dict.NumbersKey.StemSnapV, false);
        if (value != null) {
            return value.getFirstValueAsDouble();
        }
        return 0.0;
    }

    Matrix getOutlineMatrix(Dict.NumbersValue topMatrix) {
        Dict.NumbersValue componentMatrix = this.fontDict.get(Dict.Key.FontMatrix, false);
        if (topMatrix == null && componentMatrix == null) {
            return new Matrix(this.fontDict.get(Dict.Key.FontMatrix, true).getValuesAsDouble());
        }
        if (topMatrix == null) {
            return new Matrix(componentMatrix.getValuesAsDouble());
        }
        if (componentMatrix == null) {
            return new Matrix(topMatrix.getValuesAsDouble());
        }
        Matrix m1 = new Matrix(componentMatrix.getValuesAsDouble());
        return m1.multiply(new Matrix(topMatrix.getValuesAsDouble()));
    }

    public double getHorizontalAdvance(CharStrings charStrings, int gid, CharStrings globalSubrs) throws InvalidFontException, UnsupportedFontException {
        Type2Parser parser = new Type2Parser();
        WidthConsumer consumer = new WidthConsumer();
        parser.parse(charStrings, gid, this.localSubrs, globalSubrs, consumer, null);
        if (consumer.widthSeen) {
            Dict.NumbersValue v = this.privateDict.get(Dict.Key.nominalWidthX, true);
            return v.getFirstValueAsDouble() + consumer.width;
        }
        Dict.NumbersValue v = this.privateDict.get(Dict.Key.defaultWidthX, true);
        return v.getFirstValueAsDouble();
    }

    public void collectStrings(List strings) {
        this.fontDict.collectStrings(strings);
        this.privateDict.collectStrings(strings);
    }

    static class WidthConsumer
    extends Type2ConsumerDefaultImpl {
        public double width;
        public boolean widthSeen = false;

        WidthConsumer() {
        }

        public boolean width(double w) {
            this.widthSeen = true;
            this.width = w;
            return false;
        }
    }
}

