/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CharStrings;
import java.util.ArrayList;
import java.util.Collections;

public class CFFSubrize {
    private static final int MAX_CALL_LIST_COUNT = 3;
    private static final int NODE_GLOBAL = Short.MAX_VALUE;
    private static final int EDGE_TABLE_SMALLEST_SPARSE_SIZE = 128;
    private static final int EDGE_TABLE_SIZE_USE_SIMPLE_HASH = 16;
    private static final int SUBR_TABLE_SIZE_USE_SIMPLE_HASH = 262144;
    private static final int SUBR_HASH_SAMPLE_COUNT = 8;
    private static final int SUBR_PREFIX_MAP_SIZE = 8192;
    private static final int CALL_OP_SIZE = 1;
    private static final int LISTSIZE = 4000;
    private static final int TX_MAX_CALL_STACK = 10;
    private static final int T2_SEPARATOR = 9;
    private static final int TX_CALLSUBR = 10;
    private static final int TX_RETURN = 11;
    private static final int TX_ESCAPE = 12;
    private static final int TX_ENDCHAR = 14;
    private static final int T2_HINTMASK = 19;
    private static final int T2_CNTRMASK = 20;
    private static final int T2_SHORTINT = 28;
    private static final int T2_CALLGSUBR = 29;
    private static final int CFF_LONGINT = 29;
    private static final int SORT_MODE_LOCAL = 0;
    private static final int SORT_MODE_GLOBAL = 1;
    private static final int SORT_MODE_FITNESS = 2;
    private byte[] mCharStr;
    private Node mRoot;
    private Node mBase;
    private ArrayList mSinks;
    private Edge mBaseEdge;
    private ArrayList mSubrs;
    private ArrayList mTmp;
    private Subr[] mReorder;
    private ArrayList mCalls;
    private ArrayList mMembers;
    private ArrayList mLeaders;
    private boolean mSingleton;
    private int mOffSize = 2;
    private boolean mSubrStackOvl;
    private SubrCSData mGSubrs;
    private int mNumFonts;
    private SubrFont[] mFonts;
    private byte[] mOpLenCache;
    private Subr[] mSubrHash;
    private byte[] mSubrPrefixMap = new byte[8192];
    private short[] mSubrLenMap;
    private short[] mPrefixLen;
    private int mMaxSubrLen;
    private int mMinSubrLen;
    private int mMaxNumSubrs;
    private int mSubrSortMode;

    public CharStrings subrize(CharStrings csi) {
        return this.subrize(csi, null);
    }

    public CharStrings subrize(CharStrings csi, byte[] fdIndex) {
        int nStrings = csi.getCount();
        int[] offsets = new int[nStrings];
        int cBase = csi.offsetOf(0);
        int cEnd = csi.size();
        int cLen = cEnd - cBase;
        for (int i = 0; i < nStrings; ++i) {
            offsets[i] = csi.offsetOf(i + 1) - cBase;
        }
        byte[] cstrs = csi.data.getBytes(cBase, cLen);
        byte[] newCstrs = new byte[cstrs.length + 4 * nStrings];
        int src = 0;
        int dst = 0;
        for (int i = 0; i < nStrings; ++i) {
            int length = offsets[i] - src;
            System.arraycopy(cstrs, src, newCstrs, dst, length);
            src += length;
            dst += length;
            newCstrs[dst++] = 9;
            newCstrs[dst++] = (byte)(i >> 16);
            newCstrs[dst++] = (byte)(i >> 8);
            newCstrs[dst++] = (byte)i;
            offsets[i] = dst;
        }
        cstrs = newCstrs;
        nStrings = this.subrizeRaw(nStrings, offsets, cstrs, fdIndex);
        offsets = this.getMainOffsets();
        cstrs = this.getMainData();
        return this.buildIndex(nStrings, offsets, cstrs);
    }

    public CharStrings getLSubrs() {
        int nStrings = this.getLSubrCount();
        if (nStrings == 0) {
            return null;
        }
        return this.buildIndex(nStrings, this.getLSubrOffsets(), this.getLSubrData());
    }

    public CharStrings getLSubrs(int fdIndex) {
        if (this.mFonts[0].fdInfo == null || fdIndex >= this.mFonts[0].fdInfo.length) {
            return null;
        }
        SubrCSData csData = this.mFonts[0].fdInfo[fdIndex].subrs;
        if (csData.nStrings == 0) {
            return null;
        }
        return this.buildIndex(csData.nStrings, csData.offset, csData.data);
    }

    public CharStrings getGSubrs() {
        int nStrings = this.getGSubrCount();
        if (nStrings == 0) {
            return null;
        }
        return this.buildIndex(nStrings, this.getGSubrOffsets(), this.getGSubrData());
    }

    public int subrizeRaw(int nStrings, int[] offsets, byte[] cstrs, byte[] fdIndex) {
        SubrFont[] fonts = new SubrFont[1];
        SubrFont font = new SubrFont();
        font.chars.nStrings = nStrings;
        font.chars.offset = offsets;
        font.chars.data = cstrs;
        if (fdIndex != null) {
            int i;
            font.subrFontCID = true;
            font.fdIndex = fdIndex;
            byte fdMax = 0;
            for (i = 0; i < fdIndex.length; ++i) {
                if (fdIndex[i] <= fdMax) continue;
                fdMax = fdIndex[i];
            }
            font.fdCount = fdMax + 1;
            font.fdInfo = new SubrFDInfo[fdMax + 1];
            for (i = 0; i <= fdMax; ++i) {
                font.fdInfo[i] = new SubrFDInfo();
            }
        }
        fonts[0] = font;
        this.cfwSubrSubrize(1, fonts);
        return font.chars.nStrings;
    }

    public int[] getMainOffsets() {
        return this.mFonts[0].chars.offset;
    }

    public byte[] getMainData() {
        return this.mFonts[0].chars.data;
    }

    public int getGSubrCount() {
        return this.mGSubrs == null ? 0 : this.mGSubrs.nStrings;
    }

    public int[] getGSubrOffsets() {
        return this.mGSubrs == null ? null : this.mGSubrs.offset;
    }

    public byte[] getGSubrData() {
        return this.mGSubrs == null ? null : this.mGSubrs.data;
    }

    public int getLSubrCount() {
        return this.mFonts[0].subrs.nStrings;
    }

    public int[] getLSubrOffsets() {
        return this.mFonts[0].subrs.offset;
    }

    public byte[] getLSubrData() {
        return this.mFonts[0].subrs.data;
    }

    private CharStrings buildIndex(int nStrings, int[] offsets, byte[] cstrs) {
        int totalSize = cstrs.length + 1;
        CFFByteArray.CFFByteArrayBuilder builder = CFFByteArray.getCFFByteArrayBuilderInstance();
        builder.addCard16(nStrings);
        int offsetSize = totalSize > 0xFFFFFF ? 4 : (totalSize > 65535 ? 3 : (totalSize > 255 ? 2 : 1));
        builder.addCard8(offsetSize);
        builder.addOffset(offsetSize, 1);
        for (int i = 0; i < offsets.length; ++i) {
            builder.addOffset(offsetSize, offsets[i] + 1);
        }
        builder.addBytes(cstrs, 0, totalSize - 1);
        try {
            return new CharStrings(builder.toCFFByteArray(), 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int t2oplen(byte[] cstr) {
        switch (cstr[0] & 0xFF) {
            default: {
                return 1;
            }
            case 12: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                return 2;
            }
            case 28: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 255: {
                return 5;
            }
            case 19: 
            case 20: 
        }
        return cstr[1] & 0xFF;
    }

    private int t2cstrcpy(byte[] dst, int dstX, int srcX, int length) {
        int srcEnd = srcX + length;
        block6: while (srcX < srcEnd) {
            switch (this.mCharStr[srcX] & 0xFF) {
                case 19: 
                case 20: {
                    dst[dstX++] = this.mCharStr[srcX++];
                    int left = this.mCharStr[srcX++] - 2;
                    while (left-- != 0) {
                        dst[dstX++] = this.mCharStr[srcX++];
                    }
                    --length;
                    continue block6;
                }
                case 255: {
                    dst[dstX++] = this.mCharStr[srcX++];
                    dst[dstX++] = this.mCharStr[srcX++];
                    dst[dstX++] = this.mCharStr[srcX++];
                    dst[dstX++] = this.mCharStr[srcX++];
                    dst[dstX++] = this.mCharStr[srcX++];
                    continue block6;
                }
                case 28: {
                    dst[dstX++] = this.mCharStr[srcX++];
                    dst[dstX++] = this.mCharStr[srcX++];
                    dst[dstX++] = this.mCharStr[srcX++];
                    continue block6;
                }
                case 12: 
                case 247: 
                case 248: 
                case 249: 
                case 250: 
                case 251: 
                case 252: 
                case 253: 
                case 254: {
                    dst[dstX++] = this.mCharStr[srcX++];
                    dst[dstX++] = this.mCharStr[srcX++];
                    continue block6;
                }
            }
            dst[dstX++] = this.mCharStr[srcX++];
        }
        return dstX;
    }

    private void newEdgeTable(Node node, int size) {
        node.edgeTableSize = size;
        node.edgeCount = 0;
        node.edgeTable = new Edge[size];
    }

    private void initEdge(Edge edge, int label, int edgeLength, Node son) {
        edge.label = label;
        edge.length = edgeLength;
        edge.son = son;
    }

    private int labelcmp(int length1, int label1, int label2) {
        int cmp;
        if ((cmp = this.mCharStr[label1++] - this.mCharStr[label2]) != 0) {
            return cmp;
        }
        int length2 = this.opLen(label2);
        int length = length1 < length2 ? length1 : length2;
        ++label2;
        while (--length != 0) {
            if ((cmp = this.mCharStr[label1++] - this.mCharStr[label2++]) == 0) continue;
            return cmp;
        }
        return length1 - length2;
    }

    private int hashLabel(int label, int length) {
        int hash = this.mCharStr[label] & 0xFF;
        hash += hash << 5;
        while (--length > 0) {
            int temp = this.mCharStr[++label] & 0xFF;
            hash += temp;
            hash <<= 5;
            hash += temp;
        }
        return hash;
    }

    private Edge lookupEdgeTable(Node node, int length, int label) {
        int tableSize = node.edgeTableSize;
        int tableSizeMinus1 = tableSize - 1;
        int hashValue = tableSize <= 16 ? (this.mCharStr[label] & 0xFF) + length : this.hashLabel(label, length);
        int hashIncrement = 0;
        for (int count = 0; count < tableSize; ++count) {
            Edge edge = node.edgeTable[hashValue & tableSizeMinus1];
            if (edge == null) {
                Edge edge2 = new Edge();
                node.edgeTable[hashValue & tableSizeMinus1] = edge2;
                edge = edge2;
            }
            if (edge.length == 0) {
                return edge;
            }
            if (this.labelcmp(length, label, edge.label) == 0) {
                return edge;
            }
            hashValue += ++hashIncrement;
        }
        return null;
    }

    private void addEdgeToHashTable(Node node, Node son, int length, int label, int edgeLength) {
        Edge edge;
        boolean doubleIt = false;
        if (node.edgeTable == null) {
            this.newEdgeTable(node, 1);
            edge = node.edgeTable[0] = new Edge();
        } else {
            if (node.edgeCount >= node.edgeTableSize) {
                doubleIt = true;
            } else if (node.edgeTableSize >= 128 && node.edgeCount >= node.edgeTableSize - (node.edgeTableSize >> 3)) {
                doubleIt = true;
            }
            if (doubleIt) {
                this.doubleEdgeTable(node);
            }
            edge = this.lookupEdgeTable(node, length, label);
        }
        this.initEdge(edge, label, edgeLength, son);
        ++node.edgeCount;
    }

    private void doubleEdgeTable(Node node) {
        Edge[] oldTable = node.edgeTable;
        int oldTableSize = node.edgeTableSize;
        int newTableSize = node.edgeTableSize * 2;
        Edge[] newTable = new Edge[newTableSize];
        node.edgeTable = newTable;
        node.edgeTableSize = newTableSize;
        node.edgeCount = 0;
        for (int i = 0; i < oldTableSize; ++i) {
            Edge edge = oldTable[i];
            if (edge == null || edge.length == 0) continue;
            this.addEdgeToHashTable(node, edge.son, this.opLen(edge.label), edge.label, edge.length);
        }
    }

    private void addEdge(Node father, Node son, int length, int label, int edgeLength) {
        this.addEdgeToHashTable(father, son, length, label, edgeLength);
    }

    private Edge findEdge(Node node, int length, int label) {
        if (node.misc == -1) {
            return this.mBaseEdge;
        }
        Edge edge = this.lookupEdgeTable(node, length, label);
        if (edge == null || edge.length != 0) {
            return edge;
        }
        return null;
    }

    private void copyEdgeTable(Node destNode, Node srcNode) {
        this.newEdgeTable(destNode, srcNode.edgeTableSize);
        destNode.edgeCount = srcNode.edgeCount;
        for (int i = 0; i < srcNode.edgeTableSize; ++i) {
            Edge srcEdge = srcNode.edgeTable[i];
            if (srcEdge == null) continue;
            Edge destEdge = new Edge();
            this.initEdge(destEdge, srcEdge.label, srcEdge.length, srcEdge.son);
            destNode.edgeTable[i] = destEdge;
        }
    }

    private void walkEdgeTable(Node node, int param1, int param2) {
        for (int i = 0; i < node.edgeTableSize; ++i) {
            Edge edge = node.edgeTable[i];
            if (edge == null || edge.length == 0) continue;
            this.findCandSubrs(edge, param1, param2);
        }
    }

    private boolean checkEndPoint(Node s, int k, int p, int length, int id) {
        if (s.misc == -1) {
            return true;
        }
        if (k < p) {
            Edge edge = this.findEdge(s, this.opLen(k), k);
            return this.labelcmp(length, p, edge.label + p - k) == 0;
        }
        return this.findEdge(s, length, p) != null;
    }

    private Node extension(Node s, int k, int p) {
        if (k >= p) {
            return s;
        }
        return this.findEdge((Node)s, (int)this.opLen((int)k), (int)k).son;
    }

    private void redirect(Node s, int k, int p, Node r) {
        Edge edge = this.findEdge(s, this.opLen(k), k);
        edge.son = r;
        edge.length = p - k;
    }

    private void canonize(Node s, int k, int p, RefPair refPair) {
        if (k < p) {
            int length = this.opLen(k);
            if (s.misc == -1) {
                s = this.mRoot;
                if ((k += length) >= p) {
                    refPair.node = s;
                    refPair.index = k;
                    return;
                }
                length = this.opLen(k);
            }
            Edge edge = this.findEdge(s, length, k);
            while (edge.length <= p - k) {
                s = edge.son;
                if ((k += edge.length) >= p) continue;
                edge = this.findEdge(s, this.opLen(k), k);
            }
        }
        refPair.node = s;
        refPair.index = k;
    }

    private Node splitEdge(Node s, int k, int p, int id) {
        Edge edge = this.findEdge(s, this.opLen(k), k);
        Node r = new Node(s.misc + p - k, edge.son.id != id ? Short.MAX_VALUE : id);
        int newLabel = edge.label + p - k;
        this.addEdge(r, edge.son, this.opLen(newLabel), newLabel, edge.label + edge.length - newLabel);
        edge.length = p - k;
        edge.son = r;
        return r;
    }

    private void separateNode(Node s, int k, int p, RefPair refPair, int id) {
        int ck;
        Node cs;
        this.canonize(s, k, p, refPair);
        Node ss = refPair.node;
        int kk = refPair.index;
        if (kk < p) {
            refPair.node = ss;
            refPair.index = kk;
            return;
        }
        if (s.misc == -1) {
            refPair.node = ss;
            refPair.index = kk;
            return;
        }
        if (ss.misc == s.misc + p - k) {
            Node suffix = ss;
            while (suffix != null) {
                if (suffix.id != id) {
                    suffix.id = Short.MAX_VALUE;
                }
                suffix = suffix.suffix;
            }
            refPair.node = ss;
            refPair.index = kk;
            return;
        }
        Node rr = new Node(s.misc + p - k, ss.id != id ? Short.MAX_VALUE : id);
        this.copyEdgeTable(rr, ss);
        rr.suffix = ss.suffix;
        ss.suffix = rr;
        do {
            int length;
            Edge edge = this.findEdge(s, this.opLen(k), k);
            ss = edge.son;
            this.initEdge(edge, k, p - k, rr);
            int pminus1 = k;
            while (pminus1 + (length = this.opLen(pminus1)) < p) {
                pminus1 += length;
            }
            this.canonize(s.suffix, k, pminus1, refPair);
            s = refPair.node;
            k = refPair.index;
            Node son = k < p ? this.findEdge((Node)s, (int)this.opLen((int)k), (int)k).son : s;
            if (son.id != id) {
                son.id = Short.MAX_VALUE;
            }
            this.canonize(s, k, p, refPair);
            cs = refPair.node;
            ck = refPair.index;
        } while (ss == cs && kk == ck);
        refPair.node = rr;
        refPair.index = p;
    }

    private void addFont(SubrFont font, int iFont, boolean multiFonts) {
        int id;
        byte[] pfd = null;
        RefPair refPair = new RefPair();
        if (font.chars.nStrings == 0) {
            return;
        }
        int p = 0;
        int pfdx = 0;
        int pend = font.chars.offset[font.chars.nStrings - 1];
        this.mCharStr = font.chars.data;
        if (font.subrFontCID) {
            pfd = font.fdIndex;
            id = (short)(iFont + pfd[pfdx++]);
        } else {
            id = iFont;
        }
        if (this.mBase == null) {
            this.mBase = new Node(-1, id);
            this.mBase.misc = -1;
            this.mBase.suffix = null;
        }
        if (this.mRoot == null) {
            this.mRoot = new Node(0, id);
            this.mRoot.suffix = this.mBase;
        }
        this.mBaseEdge = new Edge();
        this.mBaseEdge.son = this.mRoot;
        Node s = this.mRoot;
        int k = p;
        while (p < pend) {
            int length = this.opLen(p);
            Node r = null;
            Node oldr = null;
            Node e = null;
            while (!this.checkEndPoint(s, k, p, length, id)) {
                Node sink;
                if (k < p) {
                    Node newe = this.extension(s, k, p);
                    if (newe == e) {
                        this.redirect(s, k, p, r);
                        this.canonize(s.suffix, k, p, refPair);
                        s = refPair.node;
                        k = refPair.index;
                        continue;
                    }
                    e = newe;
                    r = this.splitEdge(s, k, p, id);
                } else {
                    r = s;
                }
                if (id >= this.mSinks.size()) {
                    this.ensureSize(this.mSinks, id + 1);
                }
                if ((sink = (Node)this.mSinks.get(id)) == null) {
                    sink = new Node(0, id);
                    sink.counted = true;
                    sink.paths = 1;
                    this.mSinks.set(id, sink);
                }
                this.addEdge(r, sink, length, p, pend - p);
                if (oldr != null) {
                    oldr.suffix = r;
                }
                oldr = r;
                this.canonize(s.suffix, k, p, refPair);
                s = refPair.node;
                k = refPair.index;
            }
            if (oldr != null) {
                oldr.suffix = s;
            }
            if (multiFonts) {
                Node ss = s;
                int kk = k;
                int pp = p + length;
                while (ss.misc != -1) {
                    this.canonize(ss.suffix, kk, pp, refPair);
                    ss = refPair.node;
                    kk = refPair.index;
                    if (kk < pp || ss.id == id) continue;
                    ss.id = Short.MAX_VALUE;
                }
            }
            this.separateNode(s, k, p + length, refPair, id);
            s = refPair.node;
            k = refPair.index;
            if (font.subrFontCID && this.mCharStr[p] == 9 && p + length < pend) {
                id = iFont + pfd[pfdx++];
            }
            p += length;
        }
    }

    private int hashSubr(int cstr, int length) {
        int hash = length;
        int delta = length >= 14 ? length / 7 : 1;
        int limit = length - delta;
        for (int i = 0; i < limit; i += delta) {
            hash += this.mCharStr[cstr + i] & 0xFF;
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += this.mCharStr[cstr + length - 1] & 0xFF;
        hash += hash << 10;
        hash ^= hash >> 6;
        hash += hash << 3;
        hash ^= hash >> 11;
        return hash;
    }

    private int lookupSubrHash(int cstr, int length) {
        int hashValue;
        int tableSize = this.mSubrHash.length;
        int tableSizeMinus1 = tableSize - 1;
        int hashIncrement = 0;
        int count = 0;
        if (tableSize <= 262144) {
            int c1 = this.mCharStr[cstr] & 0xFF;
            int c2 = this.mCharStr[cstr + length / 2] & 0xFF;
            int c3 = this.mCharStr[cstr + length - 1] & 0xFF;
            hashValue = c1 + c2 + c3 + length + (length << 5) + (c2 << 9) + (c3 << 14);
        } else {
            hashValue = this.hashSubr(cstr, length);
        }
        while (count < tableSize) {
            int i = hashValue & tableSizeMinus1;
            Subr subr = this.mSubrHash[i];
            if (subr == null) {
                return i;
            }
            if (subr.length == length && (cstr == subr.cstr || this.bytecmp(this.mCharStr, cstr, this.mCharStr, subr.cstr, length) == 0)) {
                return i;
            }
            hashValue += ++hashIncrement;
            ++count;
        }
        return -1;
    }

    private void updateSubrQuickTestTables() {
        Subr subr;
        int i;
        this.mMaxSubrLen = 0;
        this.mMinSubrLen = Integer.MAX_VALUE;
        for (i = 0; i < this.mSubrs.size(); ++i) {
            subr = (Subr)this.mSubrs.get(i);
            if (subr.reject) continue;
            short length = subr.length;
            this.setSubrPrefixMap(subr.cstr);
            if (length > this.mMaxSubrLen) {
                this.mMaxSubrLen = length;
            }
            if (length >= this.mMinSubrLen) continue;
            this.mMinSubrLen = length;
        }
        this.mSubrLenMap = new short[this.mMaxSubrLen + 1];
        for (i = 0; i < this.mSubrs.size(); ++i) {
            subr = (Subr)this.mSubrs.get(i);
            if (subr.reject) continue;
            this.mSubrLenMap[subr.length] = 1;
        }
        int prevSubrLen = 0;
        for (i = 0; i < this.mSubrLenMap.length; ++i) {
            if (this.mSubrLenMap[i] != 0) {
                prevSubrLen = i;
            }
            this.mSubrLenMap[i] = (short)prevSubrLen;
        }
    }

    private void createSubrHash() {
        int hashTableSize;
        int n = this.mSubrs.size();
        n *= 2;
        for (hashTableSize = 1; n > hashTableSize; hashTableSize <<= 1) {
        }
        this.mSubrHash = new Subr[hashTableSize];
        for (int i = 0; i < this.mSubrs.size(); ++i) {
            Subr subr;
            this.mSubrHash[this.lookupSubrHash((int)subr.cstr, (int)subr.length)] = subr = (Subr)this.mSubrs.get(i);
        }
        this.updateSubrQuickTestTables();
    }

    private int countPaths(Edge edge) {
        if (edge == null) {
            return 0;
        }
        Node node = edge.son;
        if (!node.counted) {
            int count = node.paths;
            node.paths = (short)((count += this.countPathsForNode(node)) > Short.MAX_VALUE ? Short.MAX_VALUE : count);
            node.counted = true;
        }
        return node.paths;
    }

    private int countPathsForNode(Node node) {
        int count = 0;
        int tableSize = node.edgeTableSize;
        for (int i = 0; i < tableSize; ++i) {
            Edge edge = node.edgeTable[i];
            if (edge == null || edge.length == 0) continue;
            count += this.countPaths(edge);
        }
        return count;
    }

    private void saveSubr(int edgeEnd, Node node, int maskcnt, boolean tail, int subrLen) {
        short count = node.paths;
        if (subrLen > Short.MAX_VALUE) {
            return;
        }
        switch (subrLen - maskcnt) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                if (count >= 7 - (tail ? 1 : 0)) break;
                return;
            }
            case 4: {
                if (count >= 4) break;
                return;
            }
            case 5: 
            case 6: {
                if (count >= 3) break;
                return;
            }
            case 7: {
                if (count >= 3 - (tail ? 1 : 0)) break;
                return;
            }
            default: {
                if (count >= 2) break;
                return;
            }
        }
        Subr subr = new Subr();
        subr.node = node;
        subr.sups = null;
        subr.infs = null;
        subr.next = null;
        subr.cstr = edgeEnd - subrLen;
        subr.length = (short)subrLen;
        subr.count = count;
        subr.deltalen = 0;
        subr.numsize = 1;
        subr.maskcnt = (short)maskcnt;
        this.mSubrs.add(subr);
        node.misc = this.mSubrs.size() - 1;
        if (tail) {
            node.tail = true;
        }
    }

    private void findCandSubrs(Edge edge, int maskcnt, int misc) {
        if (misc + edge.length == edge.son.misc) {
            int edgeEnd;
            Node node;
            while (true) {
                int oplen;
                int pstr;
                node = edge.son;
                if (node.tested || node.paths == 1) {
                    return;
                }
                node.tested = true;
                edgeEnd = pstr + edge.length;
                for (pstr = edge.label; pstr < edgeEnd; pstr += oplen) {
                    oplen = this.opLen(pstr);
                    int b0 = this.mCharStr[pstr] & 0xFF;
                    if (b0 == 14) {
                        if (node.paths > 1) {
                            this.saveSubr(pstr += oplen, node, maskcnt, true, node.misc - (edge.label + edge.length - pstr));
                        }
                        return;
                    }
                    if (b0 != 19 && b0 != 20) continue;
                    ++maskcnt;
                }
                misc = node.misc;
                if (node.edgeCount > 1) break;
                if (node.paths <= node.edgeTable[0].son.paths) continue;
                this.saveSubr(edgeEnd, node, maskcnt, false, misc);
            }
            this.saveSubr(edgeEnd, node, maskcnt, false, misc);
            this.walkEdgeTable(node, maskcnt, misc);
        }
    }

    private int subrSaved(Subr subr) {
        int length = subr.length - subr.maskcnt;
        return subr.count * (length - 1 - subr.numsize) - (this.mOffSize + length + (subr.node.tail ? 0 : 1));
    }

    private int subrSavedByOneCall(Subr subr) {
        int length = subr.length - subr.maskcnt;
        return length - 1 - subr.numsize;
    }

    private void buildCallList(int buildPhase, int length, int pstart, boolean selfMatch, int id) {
        ArrayList<Call> list;
        int j;
        int pend = pstart + length;
        ArrayList callListArray = new ArrayList();
        this.mPrefixLen = new short[length];
        int p = pstart;
        int i = 0;
        while (i < length) {
            int oplen = this.opLen(p);
            for (j = 0; j < oplen; ++j) {
                this.mPrefixLen[i++] = (short)j;
            }
            p += oplen;
        }
        int substrlen = pend - pstart;
        if (substrlen > this.mMaxSubrLen) {
            substrlen = this.mMaxSubrLen;
        }
        while (substrlen >= this.mMinSubrLen) {
            int subend;
            substrlen = this.mSubrLenMap[substrlen];
            int pstr = pstart;
            while ((subend = pstr + substrlen) <= pend) {
                if (this.testSubrPrefixMap(pstr) && ((subend = pstr + substrlen) >= pend || this.mPrefixLen[subend - pstart] == 0)) {
                    Subr subr;
                    int subrHash = this.lookupSubrHash(pstr, subend - pstr);
                    Subr subr2 = subr = subrHash >= 0 ? this.mSubrHash[subrHash] : null;
                    if (!(subr == null || buildPhase != 0 && !subr.select || subend == pend && pstr == pstart && !selfMatch || buildPhase != 0 && id != subr.node.id && subr.node.id != Short.MAX_VALUE)) {
                        boolean foundGap = false;
                        int subrStartOffset = pstr - pstart;
                        int subrEndOffset = subrStartOffset + subr.length;
                        for (int i2 = 0; i2 < callListArray.size(); ++i2) {
                            Call call;
                            int j2;
                            boolean overlap = false;
                            list = (ArrayList)callListArray.get(i2);
                            int cnt = list.size();
                            for (j2 = 0; j2 < cnt; ++j2) {
                                call = (Call)list.get(j2);
                                if (subrEndOffset <= call.offset) break;
                                if (subrEndOffset > call.offset && subrStartOffset < call.offset + call.subr.length) {
                                    overlap = true;
                                    break;
                                }
                                if (subrStartOffset >= call.offset + call.subr.length || subrEndOffset <= call.offset) continue;
                                overlap = true;
                                break;
                            }
                            if (overlap) continue;
                            call = new Call(subr, subrStartOffset);
                            list.add(j2, call);
                            foundGap = true;
                            break;
                        }
                        if (!foundGap && callListArray.size() < 3) {
                            Call call = new Call(subr, subrStartOffset);
                            list = new ArrayList<Call>();
                            list.add(call);
                            callListArray.add(list);
                        }
                    }
                }
                pstr += this.opLen(pstr);
            }
            --substrlen;
        }
        int maxSaved = 0;
        int bestListIndex = 0;
        for (i = 0; i < callListArray.size(); ++i) {
            int saved = 0;
            list = (ArrayList<Call>)callListArray.get(i);
            for (j = 0; j < list.size(); ++j) {
                saved += this.subrSavedByOneCall(((Call)list.get((int)j)).subr);
            }
            if (saved <= maxSaved) continue;
            maxSaved = saved;
            bestListIndex = i;
        }
        ArrayList arrayList = this.mCalls = callListArray.isEmpty() ? new ArrayList() : (ArrayList)callListArray.get(bestListIndex);
        if (buildPhase == 0) {
            for (i = 0; i < this.mCalls.size(); ++i) {
                Call call = (Call)this.mCalls.get(i);
                call.subr.count = (short)(call.subr.count + 1);
            }
        }
    }

    private void setSubrActCount() {
        Subr subr;
        int i;
        for (i = 0; i < this.mSubrs.size(); ++i) {
            subr = (Subr)this.mSubrs.get(i);
            subr.count = 0;
        }
        for (i = 0; i < this.mSubrs.size(); ++i) {
            subr = (Subr)this.mSubrs.get(i);
            this.buildCallList(0, subr.length, subr.cstr, false, 0);
            Link infs = null;
            for (int j = this.mCalls.size() - 1; j >= 0; --j) {
                Call call = (Call)this.mCalls.get(j);
                Subr inf = call.subr;
                inf.sups = new Link(subr, call.offset, inf.sups);
                infs = new Link(inf, call.offset, infs);
            }
            subr.infs = infs;
        }
    }

    private void sortInfSubrs() {
        Subr subr;
        int i;
        for (i = 0; i < this.mSubrs.size(); ++i) {
            subr = (Subr)this.mSubrs.get(i);
            subr.misc = (short)this.subrSaved(subr);
        }
        for (i = 0; i < this.mSubrs.size(); ++i) {
            Link probe;
            subr = (Subr)this.mSubrs.get(i);
            Link head = subr.infs;
            while (head != null && (probe = head.next) != null) {
                Link best = null;
                short max = head.subr.misc;
                do {
                    short saved;
                    if ((saved = probe.subr.misc) <= max) continue;
                    best = probe;
                    max = saved;
                } while ((probe = probe.next) != null);
                if (best != null) {
                    Call tmp = new Call(head.subr, head.offset);
                    head.subr = best.subr;
                    head.offset = best.offset;
                    best.subr = tmp.subr;
                    best.offset = tmp.offset;
                }
                head = head.next;
            }
        }
    }

    private void selectCandSubrs() {
        this.countPathsForNode(this.mRoot);
        this.mSubrs = new ArrayList();
        this.walkEdgeTable(this.mRoot, 0, 0);
        this.createSubrHash();
    }

    private void assocSubrs() {
        for (int i = 0; i < this.mNumFonts; ++i) {
            int offset = 0;
            SubrFont font = this.mFonts[i];
            for (int j = 0; j < font.chars.nStrings; ++j) {
                int nextoff = font.chars.offset[j];
                this.buildCallList(0, nextoff - offset, offset, true, 0);
                offset = nextoff;
            }
        }
    }

    private void addMember(Subr subr) {
        int listlength = 0;
        Subr[] list = new Subr[4000];
        ArrayList<Subr> subrStack = new ArrayList<Subr>();
        subrStack.add(subr);
        while (subrStack.size() > 0) {
            subr = (Subr)subrStack.remove(subrStack.size() - 1);
            if (subr.member) continue;
            this.mMembers.add(subr);
            subr.member = true;
            Link link = subr.sups;
            while (link != null) {
                list[listlength++] = link.subr;
                if (listlength >= 4000) {
                    return;
                }
                link = link.next;
            }
            link = subr.infs;
            while (link != null) {
                list[listlength++] = link.subr;
                if (listlength >= 4000) {
                    return;
                }
                link = link.next;
            }
            for (int i = listlength - 1; i >= 0; --i) {
                subrStack.add(list[i]);
            }
            listlength = 0;
        }
    }

    private int tieBreaker(Subr a, Subr b) {
        if (a.cstr > b.cstr) {
            return -1;
        }
        if (a.cstr < b.cstr) {
            return 1;
        }
        if (a.length > b.length) {
            return -1;
        }
        if (a.length < b.length) {
            return 1;
        }
        return 0;
    }

    private int cmpGlobalSetSubrs(Subr a, Subr b) {
        if (a.node.id == Short.MAX_VALUE) {
            if (b.node.id == Short.MAX_VALUE) {
                int bsaved;
                int asaved = this.subrSaved(a);
                if (asaved > (bsaved = this.subrSaved(b))) {
                    return -1;
                }
                if (asaved < bsaved) {
                    return 1;
                }
                return this.tieBreaker(a, b);
            }
            return -1;
        }
        if (b.node.id == Short.MAX_VALUE) {
            return 1;
        }
        return this.tieBreaker(a, b);
    }

    private int cmpLocalSetSubrs(Subr a, Subr b) {
        int state = 0;
        if (a.reject) {
            state |= 8;
        }
        if (a.select) {
            state |= 4;
        }
        if (b.reject) {
            state |= 2;
        }
        if (b.select) {
            state |= 1;
        }
        switch (state) {
            case 0: 
            case 5: {
                int asaved = this.subrSaved(a);
                int bsaved = this.subrSaved(b);
                if (asaved > bsaved) {
                    return -1;
                }
                if (asaved < bsaved) {
                    return 1;
                }
                return this.tieBreaker(a, b);
            }
            case 1: 
            case 8: 
            case 9: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: {
                return -1;
            }
            case 10: {
                return this.tieBreaker(a, b);
            }
        }
        System.out.println("cmpLocalSetSubrs() can't happen!\n");
        return 0;
    }

    private void findGroups(int id) {
        this.mLeaders = new ArrayList();
        this.mSubrSortMode = id == Short.MAX_VALUE ? 1 : 0;
        for (int i = 0; i < this.mTmp.size(); ++i) {
            Subr subr = (Subr)this.mTmp.get(i);
            if (subr.member) continue;
            this.mMembers = new ArrayList();
            this.addMember(subr);
            Collections.sort(this.mMembers);
            for (int j = 0; j < this.mMembers.size() - 1; ++j) {
                ((Subr)this.mMembers.get((int)j)).next = (Subr)this.mMembers.get(j + 1);
            }
            ((Subr)this.mMembers.get((int)(this.mMembers.size() - 1))).next = null;
            this.mLeaders.add(this.mMembers.get(0));
        }
    }

    private void updateSups(Subr subr, int deltalen, int id) {
        Link link = subr.sups;
        while (link != null) {
            Subr sup = link.subr;
            if (!sup.select && !sup.reject && sup.node.id == id) {
                this.updateSups(sup, deltalen, id);
                sup.deltalen = (short)(sup.deltalen + deltalen);
            }
            link = link.next;
        }
    }

    private void selectSubr(Subr subr) {
        short count = subr.count;
        int length = subr.length - subr.maskcnt + subr.deltalen;
        int saved = count * (length - 1 - subr.numsize) - (this.mOffSize + length + (subr.node.tail ? 0 : 1));
        if (saved > 0) {
            short id = subr.node.id;
            int deltalen = subr.numsize + 1 - subr.length - subr.deltalen;
            subr.select = true;
            this.updateSups(subr, deltalen, id);
        } else {
            subr.reject = true;
        }
    }

    private void selectGlobalSubrs(Subr subr, int id) {
        while (subr != null) {
            if (subr.node.id != Short.MAX_VALUE) {
                return;
            }
            if (!subr.select && !subr.reject) {
                this.selectSubr(subr);
            }
            subr = subr.next;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void selectLocalSubrs(Subr subr, int id) {
        while (subr != null) {
            if (subr.node.id == Short.MAX_VALUE) {
                if (!subr.select) return;
                this.updateSups(subr, subr.numsize + 1 - subr.length, id);
            } else if (!subr.select && !subr.reject) {
                this.selectSubr(subr);
            }
            subr = subr.next;
        }
    }

    private int cmpSubrFitness(Subr a, Subr b) {
        boolean aselect = a.select;
        boolean bselect = b.select;
        if (aselect == bselect) {
            int bsaved;
            int asaved = this.subrSaved(a);
            if (asaved > (bsaved = this.subrSaved(b))) {
                return -1;
            }
            if (asaved < bsaved) {
                return 1;
            }
            if (a.length > b.length) {
                return -1;
            }
            if (a.length < b.length) {
                return 1;
            }
            if (a.count > b.count) {
                return -1;
            }
            if (a.count < b.count) {
                return 1;
            }
            return this.tieBreaker(a, b);
        }
        if (!aselect && bselect) {
            return 1;
        }
        return -1;
    }

    private void checkSubrStackOvl(Subr subr, int depth) {
        if (depth <= subr.misc) {
            return;
        }
        subr.misc = (short)depth;
        if (subr.select && ++depth >= 10) {
            subr.select = false;
            subr.reject = true;
            --depth;
            this.mSubrStackOvl = true;
        }
        Link sup = subr.sups;
        while (sup != null) {
            this.checkSubrStackOvl(sup.subr, depth);
            sup = sup.next;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void selectFinalSubrSet(int id) {
        nSelected = 0;
        multiplier = this.mSingleton != false ? 2 : 1;
        pass = 0;
        this.findGroups(id);
        while (true) {
            for (i = 0; i < this.mLeaders.size(); ++i) {
                subr = (Subr)this.mLeaders.get(i);
                if (subr.next == null) {
                    if (this.subrSaved(subr) > 0) {
                        subr.select = true;
                        continue;
                    }
                    subr.reject = true;
                    continue;
                }
                if (id == 32767) {
                    this.selectGlobalSubrs(subr, id);
                    continue;
                }
                this.selectLocalSubrs(subr, id);
            }
            for (i = 0; i < this.mTmp.size(); ++i) {
                ((Subr)this.mTmp.get((int)i)).misc = (short)-1;
            }
            for (i = 0; i < this.mLeaders.size(); ++i) {
                subr = (Subr)this.mLeaders.get(i);
                while (subr != null) {
                    if (subr.infs == null) {
                        this.checkSubrStackOvl(subr, 0);
                    }
                    subr.member = false;
                    subr = subr.next;
                }
            }
            this.mSubrSortMode = 2;
            Collections.sort(this.mTmp);
            for (i = this.mTmp.size() - 1; i >= 0; --i) {
                if (!((Subr)this.mTmp.get((int)i)).select) continue;
                nSelected = i + 1;
                break;
            }
            if (++pass == 2) {
                if (this.mSingleton && (nSelected == 2479 || nSelected == 67799)) {
                    subr = new Subr();
                    subr.node = new Node(0, 0);
                    this.mTmp.add(nSelected++, subr);
                }
                if ((limit = this.mMaxNumSubrs) == 0) {
                    limit = 32767;
                }
                if (nSelected > (limit *= multiplier)) {
                    while (limit < this.mTmp.size()) {
                        this.mTmp.remove(this.mTmp.size() - 1);
                    }
                } else {
                    while (nSelected < this.mTmp.size()) {
                        this.mTmp.remove(this.mTmp.size() - 1);
                    }
                }
                return;
            }
            if (nSelected < 215 * multiplier) {
                while (nSelected < this.mTmp.size()) {
                    this.mTmp.remove(this.mTmp.size() - 1);
                }
                return;
            }
            for (i = 0; i < this.mTmp.size(); ++i) {
                ((Subr)this.mTmp.get((int)i)).select = false;
                ((Subr)this.mTmp.get((int)i)).reject = false;
            }
            for (i = this.mTmp.size() - 1; i >= 2263 * multiplier; --i) {
                ((Subr)this.mTmp.get((int)i)).numsize = (short)3;
            }
            while (i >= 215 * multiplier) {
                ((Subr)this.mTmp.get((int)i)).numsize = (short)2;
                --i;
            }
            while (true) {
                if (i < 0) ** continue;
                ((Subr)this.mTmp.get((int)i)).numsize = 1;
                --i;
            }
            break;
        }
    }

    private void stackOverflow() {
    }

    private int subrizeCstr(byte[] dst, int dstX, int srcX, int length) {
        int offset = 0;
        for (int i = 0; i < this.mCalls.size(); ++i) {
            Call call = (Call)this.mCalls.get(i);
            Subr subr = call.subr;
            if (subr == null) continue;
            dstX = this.t2cstrcpy(dst, dstX, srcX, call.offset - offset);
            dstX += this.cfwEncInt(subr.subrnum, dst, dstX);
            dst[dstX++] = subr.node.id == Short.MAX_VALUE ? 29 : 10;
            srcX += call.offset - offset + subr.length;
            offset = call.offset + subr.length;
        }
        return this.t2cstrcpy(dst, dstX, srcX, length - offset);
    }

    private void subrizeChars(SubrCSData chars, int id) {
        int srcX = 0;
        int dstX = 0;
        byte[] dst = new byte[chars.data.length];
        for (int i = 0; i < chars.nStrings; ++i) {
            int nextoff = chars.offset[i];
            int length = nextoff - srcX - 4;
            this.buildCallList(1, length, srcX, true, id);
            chars.offset[i] = dstX = this.subrizeCstr(dst, dstX, srcX, length);
            srcX = nextoff;
        }
        chars.data = new byte[dstX];
        System.arraycopy(dst, 0, chars.data, 0, dstX);
    }

    private void reorderCombined(boolean local) {
        int bias;
        int i;
        int j;
        int count;
        if (local) {
            count = this.mTmp.size() / 2;
            j = (this.mTmp.size() & 0xFFFFFFFE) + 1;
        } else {
            count = (this.mTmp.size() + 1) / 2;
            j = this.mTmp.size() + 1 & 0xFFFFFFFE;
        }
        this.mReorder = new Subr[count];
        if (count < 1240) {
            for (i = count - 1; i >= 0; --i) {
                this.mReorder[i + 0] = (Subr)this.mTmp.get(j -= 2);
            }
            bias = 107;
        } else if (count < 33900) {
            while (i >= 1239) {
                this.mReorder[i + 0] = (Subr)this.mTmp.get(j -= 2);
                --i;
            }
            while (i >= 215) {
                this.mReorder[i - 215] = (Subr)this.mTmp.get(j -= 2);
                --i;
            }
            while (i >= 0) {
                this.mReorder[i + 1024] = (Subr)this.mTmp.get(j -= 2);
                --i;
            }
            bias = 1131;
        } else {
            while (i >= 33900) {
                this.mReorder[i + 0] = (Subr)this.mTmp.get(j -= 2);
                --i;
            }
            while (i >= 2263) {
                this.mReorder[i - 2263] = (Subr)this.mTmp.get(j -= 2);
                --i;
            }
            while (i >= 1239) {
                this.mReorder[i + 31637] = (Subr)this.mTmp.get(j -= 2);
                --i;
            }
            while (i >= 215) {
                this.mReorder[i + 31422] = (Subr)this.mTmp.get(j -= 2);
                --i;
            }
            while (i >= 0) {
                this.mReorder[i + 32661] = (Subr)this.mTmp.get(j -= 2);
                --i;
            }
            bias = 32768;
        }
        if (!local) {
            for (i = 0; i < count; ++i) {
                Subr subr = this.mReorder[i];
                subr.subrnum = (short)(i - bias);
                subr.node.id = Short.MAX_VALUE;
            }
            for (i = 0; i < this.mTmp.size() - 1; i += 2) {
                ((Subr)this.mTmp.get((int)(i + 1))).subrnum = ((Subr)this.mTmp.get((int)i)).subrnum;
            }
        }
    }

    private void reorderSubrs() {
        int bias;
        int i;
        this.mReorder = new Subr[this.mTmp.size()];
        if (this.mTmp.size() < 1240) {
            for (i = this.mTmp.size() - 1; i >= 0; --i) {
                this.mReorder[i + 0] = (Subr)this.mTmp.get(i);
            }
            bias = 107;
        } else if (this.mTmp.size() < 33900) {
            while (i >= 1239) {
                this.mReorder[i + 0] = (Subr)this.mTmp.get(i);
                --i;
            }
            while (i >= 215) {
                this.mReorder[i - 215] = (Subr)this.mTmp.get(i);
                --i;
            }
            while (i >= 0) {
                this.mReorder[i + 1024] = (Subr)this.mTmp.get(i);
                --i;
            }
            bias = 1131;
        } else {
            while (i >= 33900) {
                this.mReorder[i + 0] = (Subr)this.mTmp.get(i);
                --i;
            }
            while (i >= 2263) {
                this.mReorder[i - 2263] = (Subr)this.mTmp.get(i);
                --i;
            }
            while (i >= 1239) {
                this.mReorder[i + 31637] = (Subr)this.mTmp.get(i);
                --i;
            }
            while (i >= 215) {
                this.mReorder[i + 31422] = (Subr)this.mTmp.get(i);
                --i;
            }
            while (i >= 0) {
                this.mReorder[i + 32661] = (Subr)this.mTmp.get(i);
                --i;
            }
            bias = 32768;
        }
        for (i = 0; i < this.mReorder.length; ++i) {
            this.mReorder[i].subrnum = (short)(i - bias);
        }
    }

    private void addSubrs(SubrCSData subrs, int id) {
        if (this.mReorder == null || this.mReorder.length == 0) {
            return;
        }
        subrs.nStrings = (short)this.mReorder.length;
        subrs.offset = new int[this.mReorder.length];
        int maxSize = 0;
        for (int i = 0; i < this.mReorder.length; ++i) {
            maxSize += this.mReorder[i].length + 1;
        }
        int dstX = 0;
        byte[] dst = new byte[maxSize];
        for (int i = 0; i < this.mReorder.length; ++i) {
            Subr subr = this.mReorder[i];
            this.buildCallList(1, subr.length, subr.cstr, false, id);
            dstX = this.subrizeCstr(dst, dstX, subr.cstr, subr.length);
            if (!subr.node.tail) {
                dst[dstX++] = 11;
            }
            subrs.offset[i] = dstX;
        }
        subrs.data = new byte[dstX];
        System.arraycopy(dst, 0, subrs.data, 0, dstX);
    }

    private void subrizeFDChars(SubrCSData dataOut, SubrFont font, int id, int iFD) {
        int dstX = 0;
        SubrCSData dataIn = font.chars;
        this.mCharStr = font.chars.data;
        byte[] dst = new byte[font.chars.data.length];
        dataOut.nStrings = 0;
        for (int i = 0; i < dataIn.nStrings; ++i) {
            if (font.fdIndex[i] != iFD) continue;
            ++dataOut.nStrings;
        }
        dataOut.offset = new int[dataOut.nStrings];
        int iDst = 0;
        for (int i = 0; i < dataIn.nStrings; ++i) {
            if (font.fdIndex[i] != iFD) continue;
            int srcX = i == 0 ? 0 : dataIn.offset[i - 1];
            int length = dataIn.offset[i] - srcX - 4;
            this.buildCallList(1, length, srcX, true, id + iFD);
            dstX = this.subrizeCstr(dst, dstX, srcX, length);
            dataOut.offset[iDst++] = dstX;
        }
        dataOut.data = new byte[dstX];
        System.arraycopy(dst, 0, dataOut.data, 0, dstX);
    }

    private void joinFDChars(SubrFont font) {
        int i;
        int size = 0;
        for (int i2 = 0; i2 < font.fdCount; ++i2) {
            SubrFDInfo info = font.fdInfo[i2];
            if (info.chars.nStrings != 0) {
                size += info.chars.offset[info.chars.nStrings - 1];
            }
            info.iChar = 0;
        }
        font.chars.data = new byte[size];
        int dstX = 0;
        for (i = 0; i < font.chars.nStrings; ++i) {
            SubrFDInfo info = font.fdInfo[font.fdIndex[i]];
            int srcX = info.iChar == 0 ? 0 : info.chars.offset[info.iChar - 1];
            int length = info.chars.offset[info.iChar++] - srcX;
            System.arraycopy(info.chars.data, srcX, font.chars.data, dstX, length);
            font.chars.offset[i] = dstX += length;
        }
        for (i = 0; i < font.fdCount; ++i) {
            SubrCSData chars = font.fdInfo[i].chars;
            chars.offset = null;
            chars.data = null;
        }
    }

    private void buildSubrs(SubrCSData subrs, int id) {
        this.mTmp = new ArrayList();
        for (int i = 0; i < this.mSubrs.size(); ++i) {
            Subr subr = (Subr)this.mSubrs.get(i);
            if (subr.node.id != id) continue;
            this.mTmp.add(subr);
        }
        this.selectFinalSubrSet(id);
        this.updateSubrQuickTestTables();
        this.reorderSubrs();
        this.addSubrs(subrs, id);
    }

    private void cfwSubrSubrize(int nFonts, SubrFont[] fonts) {
        int i;
        byte[] dummycstr = new byte[2];
        this.mNumFonts = nFonts;
        this.mFonts = fonts;
        this.mOpLenCache = new byte[256];
        for (i = 0; i < 256; ++i) {
            dummycstr[0] = (byte)i;
            this.mOpLenCache[i] = (byte)this.t2oplen(dummycstr);
        }
        this.mSingleton = this.mNumFonts == 1 && !this.mFonts[0].subrFontCID;
        int iFont = 0;
        this.mSinks = new ArrayList();
        for (i = 0; i < this.mNumFonts; ++i) {
            this.addFont(this.mFonts[i], iFont, this.mNumFonts > 1 || this.mFonts[i].subrFontCID);
            iFont += this.mFonts[i].subrFontCID ? this.mFonts[i].fdCount : 1;
        }
        this.selectCandSubrs();
        this.setSubrActCount();
        this.assocSubrs();
        this.sortInfSubrs();
        if (this.mSingleton) {
            this.mTmp = new ArrayList();
            this.mTmp.addAll(this.mSubrs);
            this.mSubrStackOvl = false;
            this.selectFinalSubrSet(0);
            this.updateSubrQuickTestTables();
            if (this.mSubrStackOvl) {
                this.stackOverflow();
            }
            if (this.mTmp.size() >= 215) {
                this.reorderCombined(false);
                this.mGSubrs = new SubrCSData();
                this.addSubrs(this.mGSubrs, Short.MAX_VALUE);
                this.reorderCombined(true);
                this.addSubrs(this.mFonts[0].subrs, 0);
            } else {
                this.reorderSubrs();
                this.addSubrs(this.mFonts[0].subrs, 0);
            }
            this.subrizeChars(this.mFonts[0].chars, 0);
        } else {
            this.mGSubrs = new SubrCSData();
            this.buildSubrs(this.mGSubrs, Short.MAX_VALUE);
            iFont = 0;
            for (i = 0; i < this.mNumFonts; ++i) {
                SubrFont font = this.mFonts[i];
                this.mSubrStackOvl = false;
                if (font.subrFontCID) {
                    for (int j = 0; j < this.mFonts[i].fdCount; ++j) {
                        SubrFDInfo info = font.fdInfo[j];
                        this.buildSubrs(info.subrs, iFont + j);
                        this.subrizeFDChars(info.chars, font, iFont, j);
                    }
                    this.joinFDChars(font);
                    iFont += this.mFonts[i].fdCount;
                } else {
                    if (font.chars.nStrings != 0) {
                        this.buildSubrs(font.subrs, iFont);
                        this.subrizeChars(font.chars, iFont);
                    }
                    ++iFont;
                }
                if (!this.mSubrStackOvl) continue;
                this.stackOverflow();
            }
        }
    }

    private int opLen(int idx) {
        int len = this.mOpLenCache[this.mCharStr[idx] & 0xFF] & 0xFF;
        if (len == 0) {
            len = this.mCharStr[idx + 1] & 0xFF;
        }
        return len;
    }

    private void setSubrPrefixMap(int idx) {
        int b0 = this.mCharStr[idx] & 0xFF;
        int b1 = this.mCharStr[idx + 1] & 0xFF;
        int index = b0 << 5 | b1 >> 3;
        int bit = 1 << (b1 & 7);
        int n = index;
        this.mSubrPrefixMap[n] = (byte)(this.mSubrPrefixMap[n] | bit);
    }

    private boolean testSubrPrefixMap(int idx) {
        int b0 = this.mCharStr[idx] & 0xFF;
        int b1 = this.mCharStr[idx + 1] & 0xFF;
        int index = b0 << 5 | b1 >> 3;
        int bit = 1 << (b1 & 7);
        return (this.mSubrPrefixMap[index] & bit) != 0;
    }

    private void ensureSize(ArrayList list, int newSize) {
        list.ensureCapacity(newSize);
        for (int i = list.size(); i < newSize; ++i) {
            list.add(null);
        }
    }

    private int bytecmp(byte[] item1, int offset1, byte[] item2, int offset2, int length) {
        while (length-- != 0) {
            if (item1[offset1++] == item2[offset2++]) continue;
            return (item1[--offset1] & 0xFF) - (item2[--offset2] & 0xFF);
        }
        return 0;
    }

    private int cfwEncInt(long i, byte[] t, int idx) {
        if (-107L <= i && i <= 107L) {
            t[idx] = (byte)(i + 139L);
            return 1;
        }
        if (108L <= i && i <= 1131L) {
            t[idx] = (byte)(((i -= 108L) >> 8) + 247L);
            t[idx + 1] = (byte)i;
            return 2;
        }
        if (-1131L <= i && i <= -108L) {
            t[idx] = (byte)((-(i += 108L) >> 8) + 251L);
            t[idx + 1] = (byte)(-i);
            return 2;
        }
        if (-32768L <= i && i <= 32767L) {
            t[idx] = 28;
            t[idx + 1] = (byte)(i >> 8);
            t[idx + 2] = (byte)i;
            return 3;
        }
        t[idx] = 29;
        t[idx + 1] = (byte)(i >> 24);
        t[idx + 2] = (byte)(i >> 16);
        t[idx + 3] = (byte)(i >> 8);
        t[idx + 4] = (byte)i;
        return 5;
    }

    private static final class RefPair {
        Node node;
        int index;

        private RefPair() {
        }
    }

    private static final class SubrFont {
        boolean subrFontCID;
        byte[] fdIndex;
        int fdCount;
        SubrFDInfo[] fdInfo;
        SubrCSData subrs = new SubrCSData();
        SubrCSData chars = new SubrCSData();

        private SubrFont() {
        }
    }

    private static final class SubrFDInfo {
        SubrCSData subrs = new SubrCSData();
        SubrCSData chars = new SubrCSData();
        int iChar;

        private SubrFDInfo() {
        }
    }

    private static final class SubrCSData {
        int nStrings;
        int[] offset;
        byte[] data;

        private SubrCSData() {
        }
    }

    private static final class Call {
        Subr subr;
        int offset;

        private Call(Subr s, int o) {
            this.subr = s;
            this.offset = o;
        }
    }

    private static final class Link {
        Subr subr;
        Link next;
        int offset;

        private Link(Subr s, int o, Link n) {
            this.subr = s;
            this.offset = o;
            this.next = n;
        }
    }

    private final class Subr
    implements Comparable {
        Node node;
        Link sups;
        Link infs;
        Subr next;
        int cstr;
        short length;
        short count;
        short deltalen;
        short subrnum;
        short numsize;
        short maskcnt;
        short misc;
        boolean select;
        boolean reject;
        boolean member;

        private Subr() {
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int compareTo(Object obj) {
            if (CFFSubrize.this.mSubrSortMode == 0) {
                return CFFSubrize.this.cmpLocalSetSubrs(this, (Subr)obj);
            }
            if (CFFSubrize.this.mSubrSortMode == 1) {
                return CFFSubrize.this.cmpGlobalSetSubrs(this, (Subr)obj);
            }
            return CFFSubrize.this.cmpSubrFitness(this, (Subr)obj);
        }
    }

    private static final class Node {
        Node suffix;
        Edge[] edgeTable;
        int misc;
        int edgeCount;
        int edgeTableSize;
        short paths;
        short id;
        boolean counted;
        boolean tested;
        boolean tail;

        private Node(int length, int fid) {
            this.misc = length;
            this.id = (short)fid;
        }
    }

    private static final class Edge {
        int label;
        Node son;
        int length;

        private Edge() {
        }
    }
}

