/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.HintedOutlineConsumer;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import java.util.ArrayList;

public class AutoColor
implements OutlineConsumer {
    public static final int AC_ALLOWEDIT = 1;
    public static final int AC_HINTSUB = 2;
    public static final int AC_FIXWINDING = 4;
    public static final int AC_GENERATEVSTEMS = 8;
    public static final int ZN_VSTEM = 0;
    public static final int ZN_HSTEM = 1;
    public static final int ZN_CHAREXTREME = 2;
    public static final int ZN_CHARZONE = 3;
    public static final int ZN_ZONE = 4;
    private static final int FIXED_POS_INF = Integer.MAX_VALUE;
    private static final int FIXED_NEG_INF = Integer.MIN_VALUE;
    private static final int FIX_SHIFT = 8;
    private static final int FIX_16 = 4096;
    private static final int FIX_ONE = 256;
    private static final int FIX_HALF = 128;
    private static final int FIX_QUARTER = 64;
    private static final int FIX_SIXTEENTH = 16;
    private static final int S_LINE = 0;
    private static final int S_BEND = 1;
    private static final int S_CURVE = 2;
    private static final int S_GHOST = 3;
    private static final int MOVETO = 0;
    private static final int LINETO = 1;
    private static final int CURVETO = 2;
    private static final int CLOSEPATH = 3;
    private static final int CP_START = 0;
    private static final int CP_CURVE1 = 1;
    private static final int CP_CURVE2 = 2;
    private static final int CP_END = 3;
    private static final int BOTGHST = -21;
    private static final int TOPGHST = -20;
    private static final double THETA = 0.38;
    private static final int BEND_TAN = 577;
    private static final int S_CURVE_TAN = 25;
    private static final boolean Y_GOES_UP = true;
    private static final int MAXBLUES = 20;
    private static final int MAXSERIFS = 5;
    private static final int MAXSTEMS = 20;
    private static final int MAXFIXES = 100;
    private static final int X0 = 0;
    private static final int Y0 = 0;
    private static final int SFACTOR = 20;
    private static final int SPCBONUS = 1000;
    private static final int MAXSTEMDIST = 150;
    private static final int MAXF = 32768;
    private static final int PRNFCTR = 3;
    private static final int MUCHFCTR = 50;
    private static final int VERYMUCHFCTR = 100;
    private static final int STARTING = 0;
    private static final int GOINGUP = 1;
    private static final int GOINGDOWN = 2;
    private static final double LENGTHRATIOCUTOFF = 0.11;
    private static final int MAXCNT = 100;
    private static final int WD_CCW = 0;
    private static final int WD_CW = 1;
    private static final int MINIFLTNMAXDEPTH = 6;
    private static final int MINIBLKSZ = 10;
    private static final int FRP_NZWIND = 0;
    private static final int FRP_YEXTREME = 1;
    private static final int FRP_CHKDT = 2;
    private static final int FRP_CHKBBDT = 3;
    private static final int FRP_FPBBOXPT = 4;
    private static final int MAX_NUM_SUBPATHS = 200;
    private static final int MAX_NUM_PATH_ELEMENTS = 1000;
    private static final int AC_GC_VERT_STEM = 1;
    private static final int AC_GC_STEM3_STEM = 4;
    private static final int AC_GC_NEW_HINTS = 8;
    private PathElt mPathStart;
    private PathElt mPathEnd;
    private double mOrigEmSquare;
    private boolean mGenerateVStems;
    private boolean mUseV;
    private boolean mUseH;
    private boolean mAutoVFix;
    private boolean mAutoHFix;
    private boolean mEditChar;
    private boolean mScalinghints;
    private boolean mExtracolor;
    private boolean mFixWinding;
    private boolean mFlexStrict;
    private boolean mFlexOK;
    private boolean mDoSmoothing;
    private boolean mDoCounters;
    private int mHBigDist;
    private int mVBigDist;
    private int mInitBigDist;
    private int mMinDist;
    private int mGhostWidth;
    private int mGhostLength;
    private int mBendLength;
    private int mBandMargin;
    private int mMaxFlare;
    private int mMaxBendMerge;
    private int mMaxMerge;
    private int mMinColorElementLength;
    private int mFlexCand;
    private int mBluefuzz;
    private int mUnicode;
    private int mPruneA;
    private int mPruneB;
    private int mPruneC;
    private int mPruneD;
    private int mPruneValue;
    private int mBonus;
    private double mHBigDistR;
    private double mVBigDistR;
    private double mMaxVal;
    private double mMinVal;
    private int mDMIN;
    private int mCPpercent;
    private ClrVal mHcoloring;
    private ClrVal mHprimary;
    private ClrVal mValList;
    private ClrVal mVcoloring;
    private ClrVal mVprimary;
    private ClrSeg[] mSegLists = new ClrSeg[4];
    private ClrPoint mPointList;
    private ClrPoint[] mPtLstArray;
    private int mPtLstIndex;
    private int mNumPtLsts;
    private int mMaxPtLsts;
    private int[] mTopBands = new int[20];
    private int[] mBotBands = new int[20];
    private int[] mSerifs = new int[5];
    private int mLenTopBands;
    private int mLenBotBands;
    private int mNumSerifs;
    private int[] mVStems = new int[20];
    private int[] mHStems = new int[20];
    private int mNumVStems;
    private int mNumHStems;
    private boolean mDoAligns;
    private boolean mDoWriteGlyph;
    private boolean mCounterFailed;
    private SegLnkLst mHlnks;
    private SegLnkLst mVlnks;
    private int mCpFrom;
    private int mCpTo;
    private int[] mHFixYs = new int[100];
    private int[] mHFixDYs = new int[100];
    private int mHFixCount;
    private int[] mVFixXs = new int[100];
    private int[] mVFixDXs = new int[100];
    private int mVFixCount;
    private boolean mClrBBox;
    private boolean mClrHBounds;
    private boolean mClrVBounds;
    private boolean mHaveHBnds;
    private boolean mMergeMain;
    private boolean mHaveVBnds;
    private ACBBox mBBox = new ACBBox();
    private byte[] mLinks;
    private int mRowCnt;
    private boolean mSubPathOpen;
    private PathElt mInputPathStart;
    private PathElt mInputPathEnd;
    private double mGlyphWidth;
    private int mNumSubPaths;
    private SubPathInfo[] mSubPaths;
    private ACBBox mPathBBox;
    private boolean mAllStems;
    private int[] mTopZones;
    private int[] mBottomZones;
    private HintedOutlineConsumer mOutlineConsumer;
    private int mEltSN;
    private int mCptSN;
    private int mCvlSN;
    private int mCsgSN;
    private double mCurX;
    private double mCurY;
    private ArrayList mZoneData = new ArrayList();
    private short[] VColorList = new short[]{109, 77, 84, 8230, 0};
    private short[] HColorList = new short[]{8712, 8801, 8713, 247, 0};
    private short[] UpperSpecialChars = new short[]{191, 161, 59, 0};
    private short[] LowerSpecialChars = new short[]{63, 33, 58, 0};
    private short[] NoBlueList = new short[]{64, 8226, 169, 164, 174, 0};

    public AutoColor(HintedOutlineConsumer outlineConsumer, double unitsPerEm, int flags, boolean doWriteGlyph, boolean doAligns, int[] topZones, int[] bottomZones) {
        this.mOutlineConsumer = outlineConsumer;
        this.mOrigEmSquare = unitsPerEm;
        this.mDoWriteGlyph = doWriteGlyph;
        this.mDoAligns = doAligns;
        this.mTopZones = topZones != null ? topZones : new int[]{};
        this.mBottomZones = bottomZones != null ? bottomZones : new int[]{};
        this.mScalinghints = true;
        this.mAllStems = true;
        this.mAutoHFix = false;
        this.mAutoVFix = false;
        this.mSubPathOpen = false;
        this.mExtracolor = (flags & 2) != 0;
        this.mEditChar = (flags & 1) != 0;
        this.mFixWinding = (flags & 4) != 0;
        this.mGenerateVStems = (flags & 8) != 0;
        this.copyBands();
        this.initAll();
    }

    public void newGlyph(int glyphID, double width, int unicode) {
        this.mGlyphWidth = width;
        this.mUnicode = unicode;
        this.mInputPathStart = null;
        this.mInputPathEnd = null;
        this.mZoneData = new ArrayList();
    }

    public int[] reportZones() {
        int[] intArray = new int[this.mZoneData.size()];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = (Integer)this.mZoneData.get(i);
        }
        return intArray;
    }

    private void initData() {
        this.mDMIN = 50;
        this.mInitBigDist = this.psDist(150);
        this.mMinDist = this.psDist(7);
        this.mGhostWidth = this.psDist(20);
        this.mGhostLength = this.psDist(4);
        this.mBendLength = this.psDist(2);
        this.mPruneA = this.fixInt(50);
        this.mPruneC = 100;
        this.mPruneD = 256;
        double tmp = 10.24;
        this.mPruneValue = this.mPruneB = this.fltToFix(tmp);
        this.mCPpercent = 40;
        this.mBandMargin = this.psDist(30);
        this.mMaxFlare = this.psDist(10);
        this.mMaxBendMerge = this.psDist(6);
        this.mMaxMerge = this.psDist(2);
        this.mMinColorElementLength = this.psDist(12);
        this.mFlexCand = this.psDist(4);
        this.mMaxVal = 8000000.0;
        this.mMinVal = 0.00390625;
        this.mAutoVFix = false;
        this.mAutoHFix = false;
        this.mFlexOK = false;
        this.mFlexStrict = false;
        this.mDoSmoothing = false;
        this.mDoCounters = false;
        this.mBluefuzz = (int)(this.mOrigEmSquare / 2000.0);
        this.mPointList = null;
        this.mMaxPtLsts = 5;
        this.mPtLstArray = new ClrPoint[this.mMaxPtLsts];
        this.mPtLstIndex = 0;
        this.mPtLstArray[0] = null;
        this.mNumPtLsts = 1;
        this.mNumSubPaths = 0;
        this.mSubPaths = null;
        this.mPathBBox = null;
        this.mEltSN = 0;
        this.mCptSN = 0;
        this.mCvlSN = 0;
        this.mCsgSN = 0;
    }

    private int scaleAbs(int unscaled) {
        if (!this.mScalinghints) {
            return unscaled;
        }
        return (int)(1000.0 / this.mOrigEmSquare * (double)unscaled);
    }

    private int unScaleAbs(int scaled) {
        if (!this.mScalinghints) {
            return scaled;
        }
        int temp1 = (int)(this.mOrigEmSquare / 1000.0 * (double)scaled);
        temp1 = this.fRnd(temp1);
        return temp1;
    }

    private void initAuto() {
        this.mHaveHBnds = false;
        this.mClrHBounds = false;
        this.mClrBBox = false;
        this.mHaveVBnds = false;
        this.mClrVBounds = false;
    }

    private PathElt getSubPathNxt(PathElt e) {
        if (e.type == 3) {
            return this.getDest(e);
        }
        return e.next;
    }

    private PathElt getSubPathPrv(PathElt e) {
        if (e.type == 0) {
            e = this.getClosedBy(e);
        }
        return e.prev;
    }

    private ClrVal findClosestVal(ClrVal sLst, int loc) {
        int dist = this.fixInt(10000);
        ClrVal best = null;
        while (sLst != null) {
            int top;
            int bot = sLst.vLoc1;
            if (bot > (top = sLst.vLoc2)) {
                int tmp = bot;
                bot = top;
                top = tmp;
            }
            if (loc >= bot && loc <= top) {
                best = sLst;
                break;
            }
            int d = loc < bot ? bot - loc : loc - top;
            if (d < dist) {
                dist = d;
                best = sLst;
            }
            sLst = sLst.vNxt;
        }
        return best;
    }

    private void cpyHClr(PathElt e) {
        Cd endPoint = new Cd();
        this.getEndPoint(e, endPoint);
        ClrVal best = this.findClosestVal(this.mHprimary, endPoint.y);
        if (best != null) {
            this.addHPair(best, 'b');
        }
    }

    private void cpyVClr(PathElt e) {
        Cd endPoint = new Cd();
        this.getEndPoint(e, endPoint);
        ClrVal best = this.findClosestVal(this.mVprimary, endPoint.x);
        if (best != null) {
            this.addVPair(best, 'y');
        }
    }

    private void pruneColorSegs(PathElt e, boolean hFlg) {
        SegLnkLst lst = hFlg ? e.Hs : e.Vs;
        SegLnkLst prv = null;
        while (lst != null) {
            ClrSeg seg;
            ClrVal val = null;
            SegLnk lnk = lst.lnk;
            if (lnk != null && (seg = lnk.seg) != null) {
                val = seg.sLnk;
            }
            SegLnkLst nxt = lst.next;
            if (val == null) {
                if (prv == null) {
                    if (hFlg) {
                        e.Hs = nxt;
                    } else {
                        e.Vs = nxt;
                    }
                } else {
                    prv.next = nxt;
                }
                lst = nxt;
                continue;
            }
            prv = lst;
            lst = nxt;
        }
    }

    private void pruneElementColorSegs() {
        PathElt e = this.mPathStart;
        while (e != null) {
            this.pruneColorSegs(e, true);
            this.pruneColorSegs(e, false);
            e = e.next;
        }
    }

    private SegLnkLst elmntClrSegLst(PathElt e, boolean hFlg) {
        return hFlg ? e.Hs : e.Vs;
    }

    private void remLnk(PathElt e, boolean hFlg, SegLnkLst rm) {
        SegLnkLst lst = hFlg ? e.Hs : e.Vs;
        SegLnkLst prv = null;
        while (lst != null) {
            SegLnkLst nxt = lst.next;
            if (lst == rm) {
                if (prv == null) {
                    if (hFlg) {
                        e.Hs = nxt;
                    } else {
                        e.Vs = nxt;
                    }
                } else {
                    prv.next = nxt;
                }
                return;
            }
            prv = lst;
            lst = nxt;
        }
    }

    private boolean alreadyOnList(ClrVal v, ClrVal lst) {
        while (lst != null) {
            if (v == lst) {
                return true;
            }
            lst = lst.vNxt;
        }
        return false;
    }

    private void autoVSeg(ClrVal sLst) {
        this.addVPair(sLst, 'y');
    }

    private void autoHSeg(ClrVal sLst) {
        this.addHPair(sLst, 'b');
    }

    private void addHColoring(ClrVal h) {
        if (this.mUseH || this.alreadyOnList(h, this.mHcoloring)) {
            return;
        }
        h.vNxt = this.mHcoloring;
        this.mHcoloring = h;
        this.autoHSeg(h);
    }

    private void addVColoring(ClrVal v) {
        if (this.mUseV || this.alreadyOnList(v, this.mVcoloring)) {
            return;
        }
        v.vNxt = this.mVcoloring;
        this.mVcoloring = v;
        this.autoVSeg(v);
    }

    private int testColor(ClrSeg s, ClrVal colorList, boolean flg, boolean doLst) {
        int bot;
        int top;
        if (s == null) {
            return -1;
        }
        ClrVal v = s.sLnk;
        int loc = s.sLoc;
        if (v == null) {
            return -1;
        }
        int vT = top = v.vLoc2;
        int vB = bot = v.vLoc1;
        if (v.vGhst) {
            if (v.vSeg1.sType == 3) {
                bot = top;
            } else {
                top = bot;
            }
        }
        if (v.vGhst) {
            boolean loc1;
            ClrVal clst = colorList;
            if (Math.abs(loc - vT) < Math.abs(loc - vB)) {
                loc1 = false;
                loc = vT;
            } else {
                loc1 = true;
                loc = vB;
            }
            while (clst != null) {
                if ((loc1 ? clst.vLoc1 : clst.vLoc2) == loc) {
                    return -1;
                }
                clst = clst.vNxt;
                if (doLst) continue;
            }
        }
        if (flg) {
            top += this.mBandMargin;
            bot -= this.mBandMargin;
        } else {
            top -= this.mBandMargin;
            bot += this.mBandMargin;
        }
        while (colorList != null) {
            int cTop = colorList.vLoc2;
            int cBot = colorList.vLoc1;
            if (vB == cBot && vT == cTop) {
                return -1;
            }
            if (colorList.vGhst) {
                if (colorList.vSeg1.sType == 3) {
                    cBot = cTop;
                } else {
                    cTop = cBot;
                }
            }
            if (flg && cBot <= top && cTop >= bot || !flg && cBot >= top && cTop <= bot) {
                return 0;
            }
            colorList = colorList.vNxt;
            if (doLst) continue;
            break;
        }
        return 1;
    }

    private int testColorLst(SegLnkLst lst, ClrVal colorList, boolean flg, boolean doLst) {
        int result = -1;
        int cnt = 0;
        while (lst != null) {
            int i = this.testColor(lst.lnk.seg, colorList, flg, doLst);
            if (i == 0) {
                result = 0;
                break;
            }
            if (i == 1) {
                result = 1;
            }
            lst = lst.next;
            if (++cnt <= 100) continue;
            return 0;
        }
        return result;
    }

    private boolean resolveConflictBySplit(PathElt e, boolean Hflg, SegLnkLst lnk1, SegLnkLst lnk2) {
        Cd d0 = new Cd();
        Cd d1 = new Cd();
        Cd d2 = new Cd();
        Cd d3 = new Cd();
        Cd d4 = new Cd();
        Cd d5 = new Cd();
        Cd d6 = new Cd();
        Cd d7 = new Cd();
        if (e.type != 2 || e.isFlex) {
            return false;
        }
        PathElt newPE = new PathElt();
        newPE.next = e.next;
        e.next = newPE;
        newPE.prev = e;
        if (newPE.next == null) {
            this.mPathEnd = newPE;
        } else {
            newPE.next.prev = newPE;
        }
        if (Hflg) {
            e.Hs = lnk1;
            newPE.Hs = lnk2;
        } else {
            e.Vs = lnk1;
            newPE.Vs = lnk2;
        }
        if (lnk1 != null) {
            lnk1.next = null;
        }
        if (lnk2 != null) {
            lnk2.next = null;
        }
        newPE.type = (short)2;
        this.getEndPoint(e.prev, d0);
        d1.x = e.x1;
        d1.y = e.y1;
        d2.x = e.x2;
        d2.y = e.y2;
        d3.x = e.x3;
        d3.y = e.y3;
        d4.copyFrom(d0);
        d5.copyFrom(d1);
        d6.copyFrom(d2);
        d7.copyFrom(d3);
        newPE.x3 = d3.x;
        newPE.y3 = d3.y;
        d2.x = d6.x + d7.x >> 1;
        d2.y = d6.y + d7.y >> 1;
        d7.x = d5.x + d6.x >> 1;
        d7.y = d5.y + d6.y >> 1;
        d5.x = d4.x + d5.x >> 1;
        d5.y = d4.y + d5.y >> 1;
        d6.x = d5.x + d7.x >> 1;
        d6.y = d5.y + d7.y >> 1;
        d1.x = d7.x + d2.x >> 1;
        d1.y = d7.y + d2.y >> 1;
        d7.x = d6.x + d1.x >> 1;
        d7.y = d6.y + d1.y >> 1;
        e.x1 = d5.x;
        e.y1 = d5.y;
        e.x2 = d6.x;
        e.y2 = d6.y;
        e.x3 = d7.x;
        e.y3 = d7.y;
        newPE.x1 = d1.x;
        newPE.y1 = d1.y;
        newPE.x2 = d2.x;
        newPE.y2 = d2.y;
        return true;
    }

    private void remDupLnks(PathElt e, boolean Hflg) {
        SegLnkLst l1;
        SegLnkLst segLnkLst = l1 = Hflg ? e.Hs : e.Vs;
        while (l1 != null) {
            SegLnkLst l2 = l1.next;
            while (l2 != null) {
                SegLnkLst l2nxt = l2.next;
                if (l1.lnk.seg == l2.lnk.seg) {
                    this.remLnk(e, Hflg, l2);
                }
                l2 = l2nxt;
            }
            l1 = l1.next;
        }
    }

    private boolean okToRemLnk(int loc, boolean Hflg, int spc) {
        if (!Hflg || spc == 0) {
            return true;
        }
        if (this.inBlueBand(loc, this.mLenTopBands, this.mTopBands)) {
            return false;
        }
        return !this.inBlueBand(loc, this.mLenBotBands, this.mBotBands);
    }

    private boolean tryResolveConflict(PathElt e, boolean Hflg) {
        int loc3;
        int loc0;
        Cd p0 = new Cd();
        Cd p1 = new Cd();
        this.remDupLnks(e, Hflg);
        short typ = e.type;
        if (typ == 0) {
            this.getEndPoints(this.getClosedBy(e), p0, p1);
        } else if (typ == 2) {
            p0.x = e.x1;
            p0.y = e.y1;
            p1.x = e.x3;
            p1.y = e.y3;
        } else {
            this.getEndPoints(e, p0, p1);
        }
        int loc1 = Hflg ? p0.y : p0.x;
        int loc2 = Hflg ? p1.y : p1.x;
        SegLnkLst lst = Hflg ? e.Hs : e.Vs;
        ClrSeg seg1 = lst.lnk.seg;
        int lc1 = seg1.sLoc;
        SegLnkLst lnk1 = lst;
        lst = lst.next;
        ClrSeg seg2 = lst.lnk.seg;
        int lc2 = seg2.sLoc;
        SegLnkLst lnk2 = lst;
        if (lc1 != loc1 && lc2 != loc2 && (Math.abs(lc1 - loc1) > Math.abs(lc1 - loc2) || Math.abs(lc2 - loc2) > Math.abs(lc2 - loc1))) {
            ClrSeg seg = seg1;
            seg1 = seg2;
            seg2 = seg;
            lst = lnk1;
            lnk1 = lnk2;
            lnk2 = lst;
        }
        ClrVal val1 = seg1.sLnk;
        ClrVal val2 = seg2.sLnk;
        if (val1.vVal < this.fixInt(50) && this.okToRemLnk(loc1, Hflg, val1.vSpc)) {
            this.remLnk(e, Hflg, lnk1);
            return true;
        }
        if (val2.vVal < this.fixInt(50) && val1.vVal > val2.vVal * 20 && this.okToRemLnk(loc2, Hflg, val2.vSpc)) {
            this.remLnk(e, Hflg, lnk2);
            return true;
        }
        if (typ != 2 || (Hflg && this.isHorizontal(p0.x, p0.y, p1.x, p1.y) || !Hflg && this.isVertical(p0.x, p0.y, p1.x, p1.y)) && this.okToRemLnk(loc1, Hflg, val1.vSpc)) {
            this.remLnk(e, Hflg, lnk1);
            return true;
        }
        this.getEndPoints(this.getSubPathPrv(e), p0, p1);
        int n = loc0 = Hflg ? p0.y : p0.x;
        if (this.prodLt0(loc2 - loc1, loc0 - loc1)) {
            this.remLnk(e, Hflg, lnk1);
            return true;
        }
        this.getEndPoint(this.getSubPathNxt(e), p1);
        int n2 = loc3 = Hflg ? p1.y : p1.x;
        if (this.prodLt0(loc3 - loc2, loc1 - loc2)) {
            this.remLnk(e, Hflg, lnk2);
            return true;
        }
        if ((loc2 == val2.vLoc1 || loc2 == val2.vLoc2) && loc1 != val1.vLoc1 && loc1 != val1.vLoc2) {
            this.remLnk(e, Hflg, lnk1);
            return true;
        }
        if ((loc1 == val1.vLoc1 || loc1 == val1.vLoc2) && loc2 != val2.vLoc1 && loc2 != val2.vLoc2) {
            this.remLnk(e, Hflg, lnk2);
            return true;
        }
        return this.mEditChar && this.resolveConflictBySplit(e, Hflg, lnk1, lnk2);
    }

    private boolean checkColorSegs(PathElt e, boolean flg, boolean Hflg) {
        SegLnkLst lst;
        SegLnkLst segLnkLst = lst = Hflg ? e.Hs : e.Vs;
        while (lst != null) {
            ClrSeg seg;
            ClrVal val;
            SegLnkLst lst2 = lst.next;
            if (lst2 != null && (val = (seg = lst.lnk.seg).sLnk) != null && this.testColorLst(lst2, val, flg, false) == 0) {
                if (this.tryResolveConflict(e, Hflg)) {
                    return this.checkColorSegs(e, flg, Hflg);
                }
                if (Hflg) {
                    e.Hs = null;
                } else {
                    e.Vs = null;
                }
                return true;
            }
            lst = lst2;
        }
        return false;
    }

    private void checkElmntClrSegs() {
        PathElt e = this.mPathStart;
        while (e != null) {
            if (!this.checkColorSegs(e, true, true)) {
                this.checkColorSegs(e, true, false);
            }
            e = e.next;
        }
    }

    private boolean clrLstsClash(SegLnkLst lst1, SegLnkLst lst2, boolean flg) {
        while (lst1 != null) {
            ClrSeg seg = lst1.lnk.seg;
            ClrVal val = seg.sLnk;
            if (val != null) {
                SegLnkLst lst = lst2;
                while (lst != null) {
                    if (this.testColorLst(lst, val, flg, false) == 0) {
                        return true;
                    }
                    lst = lst.next;
                }
            }
            lst1 = lst1.next;
        }
        return false;
    }

    private SegLnkLst bestFromLsts(SegLnkLst lst1, SegLnkLst lst2) {
        SegLnkLst bst = null;
        int bstval = 0;
        for (int i = 0; i < 2; ++i) {
            SegLnkLst lst;
            SegLnkLst segLnkLst = lst = i != 0 ? lst1 : lst2;
            while (lst != null) {
                ClrSeg seg = lst.lnk.seg;
                ClrVal val = seg.sLnk;
                if (val != null && val.vVal > bstval) {
                    bst = lst;
                    bstval = val.vVal;
                }
                lst = lst.next;
            }
        }
        return bst;
    }

    private boolean clrsClash(PathElt e, PathElt p, SegLnkLst[] hLst, SegLnkLst[] vLst, SegLnkLst[] phLst, SegLnkLst[] pvLst) {
        SegLnkLst newLst;
        SegLnkLst bst;
        boolean clash = false;
        if (this.clrLstsClash(hLst[0], phLst[0], true)) {
            clash = true;
            bst = this.bestFromLsts(hLst[0], phLst[0]);
            if (bst != null) {
                newLst = new SegLnkLst();
                newLst.next = null;
                newLst.lnk = bst.lnk;
            } else {
                newLst = null;
            }
            hLst[0] = phLst[0] = newLst;
            e.Hs = (p.Hs = phLst[0]);
        }
        if (this.clrLstsClash(vLst[0], pvLst[0], true)) {
            clash = true;
            bst = this.bestFromLsts(vLst[0], pvLst[0]);
            if (bst != null) {
                newLst = new SegLnkLst();
                newLst.next = null;
                newLst.lnk = bst.lnk;
            } else {
                newLst = null;
            }
            vLst[0] = pvLst[0] = newLst;
            e.Vs = (p.Vs = pvLst[0]);
        }
        return clash;
    }

    private void getColorLsts(PathElt e, SegLnkLst[] phLst, SegLnkLst[] pvLst, int[] ph, int[] pv) {
        int v;
        SegLnkLst vLst;
        int h;
        SegLnkLst hLst;
        if (this.mUseH) {
            hLst = null;
            h = -1;
        } else {
            hLst = e.Hs;
            h = hLst == null ? -1 : this.testColorLst(hLst, this.mHcoloring, true, true);
        }
        if (this.mUseV) {
            vLst = null;
            v = -1;
        } else {
            vLst = e.Vs;
            v = vLst == null ? -1 : this.testColorLst(vLst, this.mVcoloring, true, true);
        }
        pvLst[0] = vLst;
        phLst[0] = hLst;
        ph[0] = h;
        pv[0] = v;
    }

    private void reClrBounds(PathElt e) {
        if (!this.mUseH) {
            if (this.mClrHBounds && this.mHcoloring == null && !this.mHaveHBnds) {
                this.reClrHBnds(this.mBBox);
            } else if (!this.mClrBBox) {
                if (this.mHcoloring == null) {
                    this.cpyHClr(e);
                }
                if (this.mMergeMain) {
                    this.mergeFromMainColors('b');
                }
            }
        }
        if (!this.mUseV) {
            if (this.mClrVBounds && this.mVcoloring == null && !this.mHaveVBnds) {
                this.reClrVBnds(this.mBBox);
            } else if (!this.mClrBBox) {
                if (this.mVcoloring == null) {
                    this.cpyVClr(e);
                }
                if (this.mMergeMain) {
                    this.mergeFromMainColors('y');
                }
            }
        }
    }

    private void addColorLst(SegLnkLst lst, boolean vert) {
        while (lst != null) {
            ClrSeg seg = lst.lnk.seg;
            ClrVal val = seg.sLnk;
            if (vert) {
                this.addVColoring(val);
            } else {
                this.addHColoring(val);
            }
            lst = lst.next;
        }
    }

    private void startNewColoring(PathElt e, SegLnkLst hLst, SegLnkLst vLst) {
        this.reClrBounds(e);
        this.xtraClrs(e);
        this.mClrBBox = false;
        if (this.mDoCounters && this.mUseV) {
            this.copyMainV();
        }
        this.mVcoloring = null;
        if (this.mDoCounters && this.mUseH) {
            this.copyMainH();
        }
        this.mHcoloring = null;
        if (!this.mUseH) {
            this.addColorLst(hLst, false);
        }
        if (!this.mUseV) {
            this.addColorLst(vLst, true);
        }
    }

    private boolean isIn(int h, int v) {
        return h == -1 && v == -1;
    }

    private boolean isOk(int h, int v) {
        return h != 0 && v != 0;
    }

    private void addIfNeedV(int v, SegLnkLst vLst) {
        if (!this.mUseV && v == 1) {
            this.addColorLst(vLst, true);
        }
    }

    private void addIfNeedH(int h, SegLnkLst hLst) {
        if (!this.mUseH && h == 1) {
            this.addColorLst(hLst, false);
        }
    }

    private void setHColors(ClrVal lst) {
        if (this.mUseH) {
            return;
        }
        this.mHcoloring = lst;
        while (lst != null) {
            this.autoHSeg(lst);
            lst = lst.vNxt;
        }
    }

    private void setVColors(ClrVal lst) {
        if (this.mUseV) {
            return;
        }
        this.mVcoloring = lst;
        while (lst != null) {
            this.autoVSeg(lst);
            lst = lst.vNxt;
        }
    }

    private ClrVal copyClrs(ClrVal lst) {
        ClrVal vlst = null;
        int cnt = 0;
        while (lst != null) {
            ClrVal v = (ClrVal)lst.clone();
            v.vNxt = vlst;
            vlst = v;
            if (++cnt > 100) {
                return vlst;
            }
            lst = lst.vNxt;
        }
        return vlst;
    }

    private boolean isFlare(int loc, PathElt e, PathElt n, boolean Hflg) {
        Cd p = new Cd();
        while (e != n) {
            this.getEndPoint(e, p);
            if (Hflg && Math.abs(p.y - loc) > this.mMaxFlare || !Hflg && Math.abs(p.x - loc) > this.mMaxFlare) {
                return false;
            }
            e = this.getSubPathNxt(e);
        }
        return true;
    }

    private boolean isTopSegOfVal(int loc, int top, int bot) {
        int d1 = top - loc;
        int d2 = bot - loc;
        return Math.abs(d1) <= Math.abs(d2);
    }

    private void remFlareLnk(PathElt e, boolean hFlg, SegLnkLst rm, PathElt e2, int i) {
        this.remLnk(e, hFlg, rm);
    }

    private boolean compareValues(ClrVal val1, ClrVal val2, int factor, int ghstshift) {
        int v2;
        int v1 = val1.vVal;
        int mx = v1 > (v2 = val2.vVal) ? v1 : v2;
        mx <<= 1;
        while (mx > 0) {
            mx <<= 1;
            v1 <<= 1;
            v2 <<= 1;
        }
        if (ghstshift > 0 && val1.vGhst != val2.vGhst) {
            if (val1.vGhst) {
                v1 >>= ghstshift;
            }
            if (val2.vGhst) {
                v2 >>= ghstshift;
            }
        }
        if (val1.vSpc > 0 && val2.vSpc > 0 || val1.vSpc == 0 && val2.vSpc == 0) {
            return v1 > v2;
        }
        if (val1.vSpc > 0) {
            return v1 < Integer.MAX_VALUE / factor ? v1 * factor > v2 : v1 > v2 / factor;
        }
        return v2 < Integer.MAX_VALUE / factor ? v1 > v2 * factor : v1 / factor > v2;
    }

    private void remFlares(boolean Hflg) {
        boolean Nm2;
        boolean Nm1;
        if (Hflg) {
            Nm1 = true;
            Nm2 = false;
        } else {
            Nm1 = false;
            Nm2 = true;
        }
        PathElt e = this.mPathStart;
        while (e != null) {
            if (Nm1 ? e.Hs == null : e.Vs == null) {
                e = e.next;
                continue;
            }
            PathElt n = this.getSubPathNxt(e);
            boolean nxtE = false;
            while (n != e && !nxtE) {
                if (Nm1 ? n.Hs != null : n.Vs != null) {
                    SegLnkLst lst1 = this.elmntClrSegLst(e, Nm1);
                    while (lst1 != null) {
                        ClrSeg seg1 = lst1.lnk.seg;
                        SegLnkLst nxt1 = lst1.next;
                        SegLnkLst lst2 = this.elmntClrSegLst(n, Nm1);
                        while (lst2 != null) {
                            ClrSeg seg2 = lst2.lnk.seg;
                            SegLnkLst nxt2 = lst2.next;
                            if (seg1 != null && seg2 != null) {
                                int diff = seg1.sLoc - seg2.sLoc;
                                if (Math.abs(diff) > this.mMaxFlare || !this.isFlare(seg1.sLoc, e, n, Hflg)) {
                                    nxtE = true;
                                    lst2 = nxt2;
                                    continue;
                                }
                                ClrVal val1 = seg1.sLnk;
                                ClrVal val2 = seg2.sLnk;
                                if (diff != 0 && this.isTopSegOfVal(seg1.sLoc, val1.vLoc2, val1.vLoc1) == this.isTopSegOfVal(seg2.sLoc, val2.vLoc2, val2.vLoc1)) {
                                    if (this.compareValues(val1, val2, 1000, 0)) {
                                        if (val2.vSpc == 0 && val2.vVal < this.fixInt(1000)) {
                                            this.remFlareLnk(n, Nm1, lst2, e, 1);
                                        }
                                    } else if (val1.vSpc == 0 && val1.vVal < this.fixInt(1000)) {
                                        this.remFlareLnk(e, Nm1, lst1, n, 2);
                                        break;
                                    }
                                }
                            }
                            lst2 = nxt2;
                        }
                        lst1 = nxt1;
                    }
                }
                if (Nm2 ? n.Hs != null : n.Vs != null) break;
                n = this.getSubPathNxt(n);
            }
            e = e.next;
        }
    }

    private void carryIfNeed(int loc, boolean vert, ClrVal clrs) {
        if (vert && this.mUseV || !vert && this.mUseH) {
            return;
        }
        int halfMargin = this.fixHalfMul(this.mBandMargin);
        if (halfMargin > this.fixInt(10)) {
            halfMargin = this.fixInt(10);
        }
        while (clrs != null) {
            ClrSeg seg = clrs.vSeg1;
            if (clrs.vGhst && seg.sType == 3) {
                seg = clrs.vSeg2;
            }
            if (seg != null) {
                int l1;
                int l0 = clrs.vLoc2;
                if (l0 > (l1 = clrs.vLoc1)) {
                    int tmp = l1;
                    l1 = l0;
                    l0 = tmp;
                }
                if (loc > (l0 -= halfMargin) && loc < (l1 += halfMargin)) {
                    ClrVal seglnk = seg.sLnk;
                    seg.sLnk = clrs;
                    if (vert) {
                        if (this.testColor(seg, this.mVcoloring, true, true) == 1) {
                            this.addVColoring(clrs);
                            seg.sLnk = seglnk;
                            break;
                        }
                    } else if (this.testColor(seg, this.mHcoloring, true, true) == 1) {
                        this.addHColoring(clrs);
                        seg.sLnk = seglnk;
                        break;
                    }
                    seg.sLnk = seglnk;
                }
            }
            clrs = clrs.vNxt;
        }
    }

    private void proClrs(PathElt e, boolean hFlg, int loc) {
        Cd c = new Cd();
        SegLnkLst lst = this.elmntClrSegLst(e, hFlg);
        if (lst == null) {
            return;
        }
        if (hFlg ? e.Hcopy : e.Vcopy) {
            return;
        }
        PathElt prv = e;
        SegLnkLst plst;
        while ((plst = this.elmntClrSegLst(prv = this.getSubPathPrv(prv), hFlg)) == null) {
            this.getEndPoint(prv, c);
            int dst = (hFlg ? c.y : c.x) - loc;
            if (Math.abs(dst) > this.fixInt(50)) {
                return;
            }
            if (hFlg) {
                prv.Hs = lst;
                prv.Hcopy = true;
                continue;
            }
            prv.Vs = lst;
            prv.Vcopy = true;
        }
        return;
    }

    private void promoteColors() {
        Cd c = new Cd();
        PathElt e = this.mPathStart;
        while (e != null) {
            this.getEndPoint(e, c);
            this.proClrs(e, true, c.y);
            this.proClrs(e, false, c.x);
            e = e.next;
        }
    }

    private void remPromotedClrs() {
        PathElt e = this.mPathStart;
        while (e != null) {
            if (e.Hcopy) {
                e.Hs = null;
                e.Hcopy = false;
            }
            if (e.Vcopy) {
                e.Vs = null;
                e.Vcopy = false;
            }
            e = e.next;
        }
    }

    private void remShortColors() {
        Cd cdc = new Cd();
        Cd cde = new Cd();
        PathElt e = this.mPathStart;
        while (e != null) {
            this.getEndPoint(e, cde);
            if (Math.abs(cdc.x - cde.x) < this.mMinColorElementLength && Math.abs(cdc.y - cde.y) < this.mMinColorElementLength) {
                e.Hs = null;
                e.Vs = null;
            }
            e = e.next;
            cdc.x = cde.x;
            cdc.y = cde.y;
        }
    }

    private void autoExtraColors(boolean movetoNewClrs) {
        int[] h = new int[1];
        int[] v = new int[1];
        int[] ph = new int[1];
        int[] pv = new int[1];
        SegLnkLst[] hLst = new SegLnkLst[1];
        SegLnkLst[] vLst = new SegLnkLst[1];
        SegLnkLst[] phLst = new SegLnkLst[1];
        SegLnkLst[] pvLst = new SegLnkLst[1];
        boolean newClrs = true;
        Cd cd = new Cd();
        this.mClrHBounds = false;
        this.mClrVBounds = false;
        this.mClrBBox = false;
        this.mMergeMain = this.countSubPaths(null) <= 5;
        PathElt e = this.mPathStart;
        this.remFlares(true);
        this.remFlares(false);
        this.checkElmntClrSegs();
        this.promoteColors();
        this.remShortColors();
        this.mHaveVBnds = this.mClrVBounds;
        this.mHaveHBnds = this.mClrHBounds;
        PathElt p = null;
        boolean tst = false;
        ClrVal mtVclrs = null;
        ClrVal mtHclrs = null;
        while (e != null) {
            boolean tstB;
            PathElt cp;
            short etype = e.type;
            if (movetoNewClrs && etype == 0) {
                this.startNewColoring(e, null, null);
                tst = false;
            }
            if (newClrs && e == p) {
                this.startNewColoring(e, null, null);
                this.setHColors(mtHclrs);
                if (this.mGenerateVStems) {
                    this.setVColors(mtVclrs);
                }
                tst = true;
            }
            this.getColorLsts(e, hLst, vLst, h, v);
            if (etype == 0 && this.isShort(cp = this.getClosedBy(e))) {
                p = cp.prev;
                this.getColorLsts(p, phLst, pvLst, ph, pv);
                if (this.clrsClash(e, p, hLst, vLst, phLst, pvLst)) {
                    this.getColorLsts(e, hLst, vLst, h, v);
                    this.getColorLsts(p, phLst, pvLst, ph, pv);
                }
                boolean bl = tst ? !this.isIn(ph[0], pv[0]) || !this.isIn(h[0], v[0]) : (tstB = !this.isOk(ph[0], pv[0]) || !this.isOk(h[0], v[0]));
                if (tstB) {
                    this.startNewColoring(e, hLst[0], vLst[0]);
                    tst = false;
                    pv[0] = 1;
                    ph[0] = 1;
                } else {
                    this.addIfNeedH(h[0], hLst[0]);
                    this.addIfNeedV(v[0], vLst[0]);
                }
                this.addIfNeedH(ph[0], phLst[0]);
                this.addIfNeedV(pv[0], pvLst[0]);
                newClrs = false;
            } else {
                boolean bl = tst ? !this.isIn(h[0], v[0]) : (tstB = !this.isOk(h[0], v[0]));
                if (tstB) {
                    if (etype == 3) {
                        e = e.prev;
                        this.getColorLsts(e, hLst, vLst, h, v);
                    }
                    ClrVal prvVclrs = null;
                    ClrVal prvHclrs = this.copyClrs(this.mHcoloring);
                    if (this.mGenerateVStems) {
                        prvVclrs = this.copyClrs(this.mVcoloring);
                    }
                    if (!newClrs) {
                        newClrs = true;
                        if (this.mGenerateVStems) {
                            mtVclrs = this.copyClrs(prvVclrs);
                        }
                        mtHclrs = this.copyClrs(prvHclrs);
                    }
                    this.startNewColoring(e, hLst[0], vLst[0]);
                    tst = false;
                    if (etype == 2) {
                        cd.x = e.x1;
                        cd.y = e.y1;
                    } else {
                        this.getEndPoint(e, cd);
                    }
                    this.carryIfNeed(cd.y, false, prvHclrs);
                    if (this.mGenerateVStems) {
                        this.carryIfNeed(cd.x, true, prvVclrs);
                    }
                } else {
                    this.addIfNeedH(h[0], hLst[0]);
                    this.addIfNeedV(v[0], vLst[0]);
                }
            }
            e = e.next;
        }
        this.reClrBounds(this.mPathEnd);
        this.remPromotedClrs();
    }

    private void initGen() {
        for (int i = 0; i < 4; ++i) {
            this.mSegLists[i] = null;
        }
        this.mHlnks = null;
        this.mVlnks = null;
    }

    private void linkSegment(PathElt e, boolean Hflg, ClrSeg seg) {
        SegLnk newlnk = new SegLnk();
        newlnk.seg = seg;
        SegLnkLst newlst = new SegLnkLst();
        SegLnkLst globlst = new SegLnkLst();
        globlst.lnk = newlnk;
        newlst.lnk = newlnk;
        if (Hflg) {
            newlst.next = e.Hs;
            e.Hs = newlst;
            globlst.next = this.mHlnks;
            this.mHlnks = globlst;
        } else {
            newlst.next = e.Vs;
            e.Vs = newlst;
            globlst.next = this.mVlnks;
            this.mVlnks = globlst;
        }
    }

    private void copySegmentLink(PathElt e1, PathElt e2, boolean Hflg) {
        SegLnkLst newlst = new SegLnkLst();
        if (Hflg) {
            newlst.lnk = e1.Hs.lnk;
            newlst.next = e2.Hs;
            e2.Hs = newlst;
        } else {
            newlst.lnk = e1.Vs.lnk;
            newlst.next = e2.Vs;
            e2.Vs = newlst;
        }
    }

    private void addSegment(int from, int to, int loc, int lftLstNm, int rghtLstNm, PathElt e1, PathElt e2, boolean Hflg, int typ) {
        ClrSeg seg = new ClrSeg();
        seg.csgSN = ++this.mCsgSN;
        if (seg.csgSN == 0) {
            ++this.mCsgSN;
        }
        seg.sLoc = loc;
        if (from > to) {
            seg.sMax = from;
            seg.sMin = to;
        } else {
            seg.sMax = to;
            seg.sMin = from;
        }
        seg.sBonus = this.mBonus;
        seg.sType = (short)typ;
        if (e1 != null) {
            if (e1.type == 3) {
                e1 = this.getDest(e1);
            }
            this.linkSegment(e1, Hflg, seg);
            seg.sElt = e1;
        }
        if (e2 != null) {
            if (e2.type == 3) {
                e2 = this.getDest(e2);
            }
            this.copySegmentLink(e1, e2, Hflg);
            if (e1 == null || e2 == e1.prev) {
                seg.sElt = e2;
            }
        }
        int segNm = from > to ? lftLstNm : rghtLstNm;
        ClrSeg segList = this.mSegLists[segNm];
        ClrSeg prevSeg = null;
        while (true) {
            if (segList == null) {
                if (prevSeg == null) {
                    this.mSegLists[segNm] = seg;
                    break;
                }
                prevSeg.sNxt = seg;
                break;
            }
            if (segList.sLoc >= loc) {
                if (prevSeg == null) {
                    this.mSegLists[segNm] = seg;
                } else {
                    prevSeg.sNxt = seg;
                }
                seg.sNxt = segList;
                break;
            }
            prevSeg = segList;
            segList = segList.sNxt;
        }
    }

    private void addVSegment(int from, int to, int loc, PathElt p1, PathElt p2, int typ, int i) {
        this.addSegment(from, to, loc, 0, 1, p1, p2, false, typ);
    }

    private void addHSegment(int from, int to, int loc, PathElt p1, PathElt p2, int typ, int i) {
        this.addSegment(from, to, loc, 2, 3, p1, p2, true, typ);
    }

    private int cpFrom(int cp2, int cp3) {
        return (cp3 - cp2) * this.mCpFrom / 100 + cp2;
    }

    private int cpTo(int cp0, int cp1) {
        return (cp1 - cp0) * this.mCpTo / 100 + cp0;
    }

    private boolean testBend(int x0, int y0, int x1, int y1, int x2, int y2) {
        double lensqprod;
        double dy2;
        double dx1 = this.fixToFlt(x1 - x0);
        double dy1 = this.fixToFlt(y1 - y0);
        double dx2 = this.fixToFlt(x2 - x1);
        double dotprod = dx1 * dx2 + dy1 * (dy2 = this.fixToFlt(y2 - y1));
        return dotprod * dotprod / (lensqprod = (dx1 * dx1 + dy1 * dy1) * (dx2 * dx2 + dy2 * dy2)) <= 0.5;
    }

    private boolean testTan(int d1, int d2) {
        return Math.abs(d1) > Math.abs(d2) * 577 / 1000;
    }

    private int fRound(int x) {
        return this.fTrunc(this.fRnd(x));
    }

    private boolean isCCW(int x0, int y0, int x1, int y1, int x2, int y2) {
        int dx0 = this.fRound(x1 - x0);
        int dy0 = this.fRound(y1 - y0);
        int dx1 = this.fRound(x2 - x1);
        int dy1 = this.fRound(y2 - y1);
        boolean ccw = dx0 * dy1 >= dx1 * dy0;
        return ccw;
    }

    private void doHBendsNxt(int x0, int y0, int x1, int y1, PathElt p) {
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        if (y0 == y1) {
            return;
        }
        this.nxtForBend(p, cd2, cd3);
        boolean ysame = this.prodLt0(cd2.y - y1, y1 - y0);
        if (ysame || this.testTan(x1 - cd2.x, y1 - cd2.y) && (this.prodLt0(cd2.x - x1, x1 - x0) || this.isVertical(x0, y0, x1, y1) && this.testBend(x0, y0, x1, y1, cd2.x, cd2.y))) {
            int delta = this.fixHalfMul(this.mBendLength);
            boolean doboth = false;
            if (!(x0 <= x1 && x1 < cd2.x || x0 < x1 && x1 <= cd2.x)) {
                if (cd2.x < x1 && x1 <= x0 || cd2.x <= x1 && x1 < x0) {
                    delta = -delta;
                } else if (ysame) {
                    boolean ccw;
                    boolean above = y0 > y1;
                    if (above != (ccw = this.isCCW(x0, y0, x1, y1, cd2.x, cd2.y))) {
                        delta = -delta;
                    }
                } else {
                    doboth = true;
                }
            }
            int strt = x1 - delta;
            int end = x1 + delta;
            this.addHSegment(strt, end, y1, p, null, 1, 0);
            if (doboth) {
                this.addHSegment(end, strt, y1, p, null, 1, 1);
            }
        }
    }

    private void doHBendsPrv(int x0, int y0, int x1, int y1, PathElt p) {
        Cd cd2 = new Cd();
        if (y0 == y1) {
            return;
        }
        this.prvForBend(p, cd2);
        boolean ysame = this.prodLt0(cd2.y - y0, y0 - y1);
        if (ysame || this.testTan(x0 - cd2.x, y0 - cd2.y) && (this.prodLt0(cd2.x - x0, x0 - x1) || this.isVertical(x0, y0, x1, y1) && this.testBend(cd2.x, cd2.y, x0, y0, x1, y1))) {
            int delta = this.fixHalfMul(this.mBendLength);
            boolean doboth = false;
            if (!(cd2.x < x0 && x0 <= x1 || cd2.x <= x0 && x0 < x1)) {
                boolean ccw;
                boolean above;
                if (x1 < x0 && x0 <= cd2.x || x1 <= x0 && x0 < cd2.x) {
                    delta = -delta;
                } else if (ysame && (above = cd2.y > y0) != (ccw = this.isCCW(cd2.x, cd2.y, x0, y0, x1, y1))) {
                    delta = -delta;
                }
            }
            int strt = x0 - delta;
            int end = x0 + delta;
            this.addHSegment(strt, end, y0, p.prev, null, 1, 2);
            if (doboth) {
                this.addHSegment(end, strt, y0, p.prev, null, 1, 3);
            }
        }
    }

    private void doVBendsNxt(int x0, int y0, int x1, int y1, PathElt p) {
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        if (x0 == x1) {
            return;
        }
        this.nxtForBend(p, cd2, cd3);
        boolean xsame = this.prodLt0(cd2.x - x1, x1 - x0);
        if (xsame || this.testTan(y1 - cd2.y, x1 - cd2.x) && (this.prodLt0(cd2.y - y1, y1 - y0) || this.isHorizontal(x0, y0, x1, y1) && this.testBend(x0, y0, x1, y1, cd2.x, cd2.y))) {
            int delta = this.fixHalfMul(this.mBendLength);
            boolean doboth = false;
            if (!(y0 <= y1 && y1 < cd2.y || y0 < y1 && y1 <= cd2.y)) {
                if (cd2.y < y1 && y1 <= y0 || cd2.y <= y1 && y1 < y0) {
                    delta = -delta;
                } else if (xsame) {
                    boolean ccw;
                    boolean right = x0 > x1;
                    if (right != (ccw = this.isCCW(x0, y0, x1, y1, cd2.x, cd2.y))) {
                        delta = -delta;
                    }
                } else {
                    doboth = true;
                }
            }
            int strt = y1 - delta;
            int end = y1 + delta;
            this.addVSegment(strt, end, x1, p, null, 1, 0);
            if (doboth) {
                this.addVSegment(end, strt, x1, p, null, 1, 1);
            }
        }
    }

    private void doVBendsPrv(int x0, int y0, int x1, int y1, PathElt p) {
        Cd cd2 = new Cd();
        if (x0 == x1) {
            return;
        }
        this.prvForBend(p, cd2);
        boolean xsame = this.prodLt0(cd2.x - x0, x0 - x1);
        if (xsame || this.testTan(y0 - cd2.y, x0 - cd2.x) && (this.prodLt0(cd2.y - y0, y0 - y1) || this.isHorizontal(x0, y0, x1, y1) && this.testBend(cd2.x, cd2.y, x0, y0, x1, y1))) {
            int delta = this.fixHalfMul(this.mBendLength);
            boolean doboth = false;
            if (!(cd2.y < y0 && y0 <= y1 || cd2.y <= y0 && y0 < y1)) {
                boolean ccw;
                boolean right;
                if (y1 < y0 && y0 <= cd2.y || y1 <= y0 && y0 < cd2.y) {
                    delta = -delta;
                } else if (xsame && (right = x0 > x1) != (ccw = this.isCCW(cd2.x, cd2.y, x0, y0, x1, y1))) {
                    delta = -delta;
                }
            }
            int strt = y0 - delta;
            int end = y0 + delta;
            this.addVSegment(strt, end, x0, p.prev, null, 1, 2);
            if (doboth) {
                this.addVSegment(end, strt, x0, p.prev, null, 1, 3);
            }
        }
    }

    private void MergeLnkSegs(ClrSeg seg1, ClrSeg seg2, SegLnkLst lst) {
        while (lst != null) {
            SegLnk lnk = lst.lnk;
            if (lnk.seg == seg1) {
                lnk.seg = seg2;
            }
            lst = lst.next;
        }
    }

    private void mergeHSegs(ClrSeg seg1, ClrSeg seg2) {
        this.MergeLnkSegs(seg1, seg2, this.mHlnks);
    }

    private void mergeVSegs(ClrSeg seg1, ClrSeg seg2) {
        this.MergeLnkSegs(seg1, seg2, this.mVlnks);
    }

    private void remExtraBends(int l0, int l1) {
        ClrSeg lst0 = this.mSegLists[l0];
        ClrSeg prv = null;
        while (lst0 != null) {
            ClrSeg nxt = lst0.sNxt;
            int loc0 = lst0.sLoc;
            ClrSeg lst = this.mSegLists[l1];
            ClrSeg p = null;
            while (lst != null) {
                ClrSeg n = lst.sNxt;
                int loc = lst.sLoc;
                if (loc > loc0) break;
                if (loc == loc0 && lst.sMin < lst0.sMax && lst.sMax > lst0.sMin) {
                    if (lst0.sType == 1 && lst.sType != 1 && lst.sType != 3 && lst.sMax - lst.sMin > (lst0.sMax - lst0.sMin) * 3) {
                        if (prv == null) {
                            this.mSegLists[l0] = nxt;
                        } else {
                            prv.sNxt = nxt;
                        }
                        lst0 = prv;
                        break;
                    }
                    if (lst.sType == 1 && lst0.sType != 1 && lst0.sType != 3 && lst0.sMax - lst0.sMin > (lst.sMax - lst.sMin) * 3) {
                        if (p == null) {
                            this.mSegLists[l1] = n;
                        } else {
                            p.sNxt = n;
                        }
                        lst = p;
                    }
                }
                p = lst;
                lst = n;
            }
            prv = lst0;
            lst0 = nxt;
        }
    }

    private void compactList(int i, boolean vert) {
        ClrSeg lst = this.mSegLists[i];
        ClrSeg prv = null;
        while (lst != null) {
            boolean flg;
            ClrSeg nxt = lst.sNxt;
            ClrSeg nxtprv = lst;
            while (true) {
                if (nxt == null || nxt.sLoc > lst.sLoc) {
                    flg = true;
                    break;
                }
                int lstmin = lst.sMin;
                int lstmax = lst.sMax;
                int nxtmin = nxt.sMin;
                int nxtmax = nxt.sMax;
                if (lstmax >= nxtmin && lstmin <= nxtmax) {
                    if (Math.abs(lstmax - lstmin) > Math.abs(nxtmax - nxtmin)) {
                        if (vert) {
                            this.mergeVSegs(nxt, lst);
                        } else {
                            this.mergeHSegs(nxt, lst);
                        }
                        lst.sMin = Math.min(lstmin, nxtmin);
                        lst.sMax = Math.max(lstmax, nxtmax);
                        lst.sBonus = Math.max(lst.sBonus, nxt.sBonus);
                        nxtprv.sNxt = nxt.sNxt;
                    } else {
                        if (vert) {
                            this.mergeVSegs(lst, nxt);
                        } else {
                            this.mergeHSegs(lst, nxt);
                        }
                        nxt.sMin = Math.min(lstmin, nxtmin);
                        nxt.sMax = Math.max(lstmax, nxtmax);
                        nxt.sBonus = Math.max(lst.sBonus, nxt.sBonus);
                        lst = lst.sNxt;
                        if (prv == null) {
                            this.mSegLists[i] = lst;
                        } else {
                            prv.sNxt = lst;
                        }
                    }
                    flg = false;
                    break;
                }
                nxtprv = nxt;
                nxt = nxt.sNxt;
            }
            if (!flg) continue;
            prv = lst;
            lst = lst.sNxt;
        }
    }

    private int pickVSpot(int x0, int y0, int x1, int y1, int px1, int py1, int px2, int py2, int prvx, int prvy, int nxtx, int nxty) {
        int a2;
        if (x0 == px1 && x1 != px2) {
            return x0;
        }
        if (x0 != px1 && x1 == px2) {
            return x1;
        }
        if (x0 == prvx && x1 != nxtx) {
            return x0;
        }
        if (x0 != prvx && x1 == nxtx) {
            return x1;
        }
        int a1 = Math.abs(py1 - y0);
        if (a1 > (a2 = Math.abs(py2 - y1))) {
            return x0;
        }
        a1 = Math.abs(py2 - y1);
        if (a1 > (a2 = Math.abs(py1 - y0))) {
            return x1;
        }
        if (x0 == prvx && x1 == nxtx) {
            a1 = Math.abs(y0 - prvy);
            if (a1 > (a2 = Math.abs(y1 - nxty))) {
                return x0;
            }
            return x1;
        }
        return this.fixHalfMul(x0 + x1);
    }

    private int adjDist(int d, int q) {
        if (q == 256) {
            return d;
        }
        return this.fTrunc(d * q);
    }

    private boolean tstFlat(int dmn, int dmx) {
        if (dmn < 0) {
            dmn = -dmn;
        }
        if (dmx < 0) {
            dmx = -dmx;
        }
        return dmx >= this.psDist(50) && dmn <= this.psDist(4);
    }

    private boolean nxtHorz(int x, int y, PathElt p) {
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        this.nxtForBend(p, cd2, cd3);
        return this.tstFlat(cd2.y - y, cd2.x - x);
    }

    private boolean prvHorz(int x, int y, PathElt p) {
        Cd cd2 = new Cd();
        this.prvForBend(p, cd2);
        return this.tstFlat(cd2.y - y, cd2.x - x);
    }

    private boolean nxtVert(int x, int y, PathElt p) {
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        this.nxtForBend(p, cd2, cd3);
        return this.tstFlat(cd2.x - x, cd2.y - y);
    }

    private boolean prvVert(int x, int y, PathElt p) {
        Cd cd2 = new Cd();
        this.prvForBend(p, cd2);
        return this.tstFlat(cd2.x - x, cd2.y - y);
    }

    private boolean tstSameDir(int x0, int y0, int x1, int y1, int x2, int y2) {
        if (this.prodLt0(y0 - y1, y1 - y2) || this.prodLt0(x0 - x1, x1 - x2)) {
            return false;
        }
        return !this.testBend(x0, y0, x1, y1, x2, y2);
    }

    private boolean prvSameDir(int x0, int y0, int x1, int y1, PathElt p) {
        Cd cd2 = new Cd();
        if ((p = this.prvForBend(p, cd2)) != null && p.type == 2 && p.prev != null) {
            this.getEndPoint(p.prev, cd2);
        }
        return this.tstSameDir(x0, y0, x1, y1, cd2.x, cd2.y);
    }

    private boolean nxtSameDir(int x0, int y0, int x1, int y1, PathElt p) {
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        if ((p = this.nxtForBend(p, cd2, cd3)) != null && p.type == 2) {
            cd2.x = p.x3;
            cd2.y = p.y3;
        }
        return this.tstSameDir(x0, y0, x1, y1, cd2.x, cd2.y);
    }

    private void genVPts(int specialCharType) {
        Cd prv = new Cd();
        Cd nxt = new Cd();
        Cd tmp = new Cd();
        Cd ll = new Cd();
        Cd ur = new Cd();
        PathElt p = this.mPathStart;
        boolean flex2 = false;
        boolean flex1 = false;
        this.mCpTo = this.mCPpercent;
        this.mCpFrom = 100 - this.mCpTo;
        int fly0 = 0;
        int flx0 = 0;
        PathElt fl = null;
        while (p != null) {
            int yavg;
            int ydist;
            int q;
            Cd cd0 = new Cd();
            Cd cd1 = new Cd();
            this.getEndPoints(p, cd0, cd1);
            if (p.type == 2) {
                int yend;
                int q2;
                boolean isVert = false;
                if (p.isFlex) {
                    if (flex1) {
                        if (this.isVertical(flx0, fly0, cd1.x, cd1.y)) {
                            this.addVSegment(fly0, cd1.y, cd1.x, fl.prev, p, 0, 4);
                        }
                        flex1 = false;
                        flex2 = true;
                    } else {
                        flex1 = true;
                        flex2 = false;
                        flx0 = cd0.x;
                        fly0 = cd0.y;
                        fl = p;
                    }
                } else {
                    flex2 = false;
                    flex1 = false;
                }
                int px1 = p.x1;
                int py1 = p.y1;
                int px2 = p.x2;
                int py2 = p.y2;
                if (!flex2) {
                    q = this.vertQuo(px1, py1, cd0.x, cd0.y);
                    if (q == 0) {
                        this.doVBendsPrv(cd0.x, cd0.y, px1, py1, p);
                    } else {
                        isVert = true;
                        if (px1 == cd0.x || px2 != cd1.x && (this.prvVert(px1, py1, p) || !this.prvSameDir(cd1.x, cd1.y, cd0.x, cd0.y, p))) {
                            q2 = this.vertQuo(px2, py2, cd0.x, cd0.y);
                            if (q2 > 0 && this.prodGe0(py1 - cd0.y, py2 - cd0.y) && Math.abs(py2 - cd0.y) > Math.abs(py1 - cd0.y)) {
                                ydist = this.adjDist(this.cpTo(py1, py2) - cd0.y, q2);
                                yend = this.adjDist(this.cpTo(cd0.y, py1) - cd0.y, q);
                                if (Math.abs(yend) > Math.abs(ydist)) {
                                    ydist = yend;
                                }
                                this.addVSegment(cd0.y, cd0.y + ydist, cd0.x, p.prev, p, 2, 5);
                            } else {
                                ydist = this.adjDist(this.cpTo(cd0.y, py1) - cd0.y, q);
                                this.addVSegment(cd0.y, this.cpTo(cd0.y, py1), cd0.x, p.prev, p, 2, 6);
                            }
                        }
                    }
                }
                if (!flex1) {
                    q = this.vertQuo(px2, py2, cd1.x, cd1.y);
                    if (q == 0) {
                        this.doVBendsNxt(px2, py2, cd1.x, cd1.y, p);
                    } else if (px2 == cd1.x || px1 != cd0.x && (this.nxtVert(px2, py2, p) || !this.nxtSameDir(cd0.x, cd0.y, cd1.x, cd1.y, p))) {
                        int yd2;
                        ydist = this.adjDist(cd1.y - this.cpFrom(py2, cd1.y), q);
                        isVert = true;
                        q2 = this.vertQuo(cd0.x, cd0.y, cd1.x, cd1.y);
                        int n = yd2 = q2 > 0 ? this.adjDist(cd1.y - cd0.y, q2) : 0;
                        if (isVert && q2 > 0 && Math.abs(yd2) > Math.abs(ydist)) {
                            ydist = this.fixHalfMul(yd2);
                            yavg = this.fixHalfMul(cd0.y + cd1.y);
                            this.prvForBend(p, prv);
                            this.nxtForBend(p, nxt, tmp);
                            this.addVSegment(yavg - ydist, yavg + ydist, this.pickVSpot(cd0.x, cd0.y, cd1.x, cd1.y, px1, py1, px2, py2, prv.x, prv.y, nxt.x, nxt.y), p, null, 2, 7);
                        } else {
                            q2 = this.vertQuo(px1, py1, cd1.x, cd1.y);
                            if (q2 > 0 && this.prodGe0(py1 - cd1.y, py2 - cd1.y) && Math.abs(py2 - cd1.y) < Math.abs(py1 - cd1.y)) {
                                yend = this.adjDist(cd1.y - this.cpFrom(py1, py2), q2);
                                if (Math.abs(yend) > Math.abs(ydist)) {
                                    ydist = yend;
                                }
                                this.addVSegment(cd1.y - ydist, cd1.y, cd1.x, p, null, 2, 8);
                            } else {
                                this.addVSegment(cd1.y - ydist, cd1.y, cd1.x, p, null, 2, 9);
                            }
                        }
                    }
                }
                if (!flex1 && !flex2) {
                    int maxx = Math.max(cd0.x, cd1.x);
                    int minx = Math.min(cd0.x, cd1.x);
                    if (px1 - maxx >= 256 || px2 - maxx >= 256 || px1 - minx <= 256 || px2 - minx <= 256) {
                        this.findCurveBBox(cd0.x, cd0.y, px1, py1, px2, py2, cd1.x, cd1.y, ll, ur);
                        if (ur.x - maxx > 256 || minx - ll.x > 256) {
                            int[] frst = new int[1];
                            int[] lst = new int[1];
                            int loc = minx - ll.x > ur.x - maxx ? ll.x : ur.x;
                            this.checkBBoxEdge(p, true, loc, frst, lst);
                            yavg = this.fixHalfMul(frst[0] + lst[0]);
                            int n = ydist = frst[0] == lst[0] ? (cd1.y - cd0.y) / 10 : this.fixHalfMul(lst[0] - frst[0]);
                            if (Math.abs(ydist) < this.mBendLength) {
                                ydist = ydist > 0 ? this.fixHalfMul(this.mBendLength) : this.fixHalfMul(-this.mBendLength);
                            }
                            this.addVSegment(yavg - ydist, yavg + ydist, loc, p, null, 2, 10);
                        }
                    }
                }
            } else if (p.type == 0) {
                this.mBonus = 0;
                if (specialCharType == -1) {
                    if (this.isLower(p)) {
                        this.mBonus = this.fixInt(200);
                    }
                } else if (specialCharType == 1 && this.isUpper(p)) {
                    this.mBonus = this.fixInt(200);
                }
            } else if (!this.isTiny(p)) {
                q = this.vertQuo(cd0.x, cd0.y, cd1.x, cd1.y);
                if (q > 0) {
                    if (cd0.x == cd1.x) {
                        this.addVSegment(cd0.y, cd1.y, cd0.x, p.prev, p, 0, 11);
                    } else {
                        if (q < 64) {
                            q = 64;
                        }
                        ydist = this.fixHalfMul(this.adjDist(cd1.y - cd0.y, q));
                        yavg = this.fixHalfMul(cd0.y + cd1.y);
                        this.prvForBend(p, prv);
                        this.nxtForBend(p, nxt, tmp);
                        this.addVSegment(yavg - ydist, yavg + ydist, this.pickVSpot(cd0.x, cd0.y, cd1.x, cd1.y, cd0.x, cd0.y, cd1.x, cd1.y, prv.x, prv.y, nxt.x, nxt.y), p, null, 0, 12);
                    }
                } else {
                    this.doVBendsNxt(cd0.x, cd0.y, cd1.x, cd1.y, p);
                    this.doVBendsPrv(cd0.x, cd0.y, cd1.x, cd1.y, p);
                }
            }
            p = p.next;
        }
        this.compactList(0, true);
        this.compactList(1, true);
        this.remExtraBends(0, 1);
    }

    private boolean inBlueBand(int loc, int n, int[] p) {
        if (n <= 0) {
            return false;
        }
        int y = this.itfmy(loc);
        for (int i = 0; i < n; i += 2) {
            if (p[i] - this.mBluefuzz > y || p[i + 1] + this.mBluefuzz < y) continue;
            return true;
        }
        return false;
    }

    private int pickHSpot(int x0, int y0, int x1, int y1, int xdist, int px1, int py1, int px2, int py2, int prvx, int prvy, int nxtx, int nxty) {
        boolean inBlue1;
        boolean inBlue0;
        boolean topSeg;
        boolean bl = topSeg = xdist < 0;
        if (topSeg) {
            inBlue0 = this.inBlueBand(y0, this.mLenTopBands, this.mTopBands);
            inBlue1 = this.inBlueBand(y1, this.mLenTopBands, this.mTopBands);
        } else {
            inBlue0 = this.inBlueBand(y0, this.mLenBotBands, this.mBotBands);
            inBlue1 = this.inBlueBand(y1, this.mLenBotBands, this.mBotBands);
        }
        if (inBlue0 && !inBlue1) {
            return y0;
        }
        if (inBlue1 && !inBlue0) {
            return y1;
        }
        if (y0 == py1 && y1 != py2) {
            return y0;
        }
        if (y0 != py1 && y1 == py2) {
            return y1;
        }
        if (y0 == prvy && y1 != nxty) {
            return y0;
        }
        if (y0 != prvy && y1 == nxty) {
            return y1;
        }
        if (inBlue0 && inBlue1) {
            int lower;
            int upper;
            if (y0 > y1) {
                upper = y0;
                lower = y1;
            } else {
                upper = y1;
                lower = y0;
            }
            return topSeg ? upper : lower;
        }
        if (Math.abs(px1 - x0) > Math.abs(px2 - x1)) {
            return y0;
        }
        if (Math.abs(px2 - x1) > Math.abs(px1 - x0)) {
            return y1;
        }
        if (y0 == prvy && y1 == nxty) {
            if (Math.abs(x0 - prvx) > Math.abs(x1 - nxtx)) {
                return y0;
            }
            return y1;
        }
        return this.fixHalfMul(y0 + y1);
    }

    private void genHPts() {
        Cd prv = new Cd();
        Cd nxt = new Cd();
        Cd tmp = new Cd();
        Cd ll = new Cd();
        Cd ur = new Cd();
        PathElt p = this.mPathStart;
        this.mBonus = 0;
        int fly0 = 0;
        int flx0 = 0;
        PathElt fl = null;
        boolean flex2 = false;
        boolean flex1 = false;
        this.mCpTo = this.mCPpercent;
        this.mCpFrom = 100 - this.mCpTo;
        while (p != null) {
            int xavg;
            int xdist;
            int q;
            Cd cd0 = new Cd();
            Cd cd1 = new Cd();
            this.getEndPoints(p, cd0, cd1);
            if (p.type == 2) {
                int xend;
                int q2;
                boolean isHoriz = false;
                if (p.isFlex) {
                    if (flex1) {
                        flex1 = false;
                        flex2 = true;
                        if (this.isHorizontal(flx0, fly0, cd1.x, cd1.y)) {
                            this.addHSegment(flx0, cd1.x, cd1.y, fl.prev, p, 0, 4);
                        }
                    } else {
                        flex1 = true;
                        flex2 = false;
                        flx0 = cd0.x;
                        fly0 = cd0.y;
                        fl = p;
                    }
                } else {
                    flex2 = false;
                    flex1 = false;
                }
                int px1 = p.x1;
                int py1 = p.y1;
                int px2 = p.x2;
                int py2 = p.y2;
                if (!flex2) {
                    q = this.horzQuo(px1, py1, cd0.x, cd0.y);
                    if (q == 0) {
                        this.doHBendsPrv(cd0.x, cd0.y, px1, py1, p);
                    } else {
                        isHoriz = true;
                        if (py1 == cd0.y || py2 != cd1.y && (this.prvHorz(px1, py1, p) || !this.prvSameDir(cd1.x, cd1.y, cd0.x, cd0.y, p))) {
                            q2 = this.horzQuo(px2, py2, cd0.x, cd0.y);
                            if (q2 > 0 && this.prodGe0(px1 - cd0.x, px2 - cd0.x) && Math.abs(px2 - cd0.x) > Math.abs(px1 - cd0.x)) {
                                xdist = this.adjDist(this.cpTo(px1, px2) - cd0.x, q2);
                                xend = this.adjDist(this.cpTo(cd0.x, px1) - cd0.x, q);
                                if (Math.abs(xend) > Math.abs(xdist)) {
                                    xdist = xend;
                                }
                                this.addHSegment(cd0.x, cd0.x + xdist, cd0.y, p.prev, p, 2, 5);
                            } else {
                                xdist = this.adjDist(this.cpTo(cd0.x, px1) - cd0.x, q);
                                this.addHSegment(cd0.x, cd0.x + xdist, cd0.y, p.prev, p, 2, 6);
                            }
                        }
                    }
                }
                if (!flex1) {
                    q = this.horzQuo(px2, py2, cd1.x, cd1.y);
                    if (q == 0) {
                        this.doHBendsNxt(px2, py2, cd1.x, cd1.y, p);
                    } else if (py2 == cd1.y || py1 != cd0.y && (this.nxtHorz(px2, py2, p) || !this.nxtSameDir(cd0.x, cd0.y, cd1.x, cd1.y, p))) {
                        int xd2;
                        xdist = this.adjDist(cd1.x - this.cpFrom(px2, cd1.x), q);
                        q2 = this.horzQuo(cd0.x, cd0.y, cd1.x, cd1.y);
                        isHoriz = true;
                        int n = xd2 = q2 > 0 ? this.adjDist(cd1.x - cd0.x, q2) : 0;
                        if (isHoriz && q2 > 0 && Math.abs(xd2) > Math.abs(xdist)) {
                            this.prvForBend(p, prv);
                            this.nxtForBend(p, nxt, tmp);
                            xdist = this.fixHalfMul(xd2);
                            xavg = this.fixHalfMul(cd0.x + cd1.x);
                            int hspot = this.pickHSpot(cd0.x, cd0.y, cd1.x, cd1.y, xdist, px1, py1, px2, py2, prv.x, prv.y, nxt.x, nxt.y);
                            this.addHSegment(xavg - xdist, xavg + xdist, hspot, p, null, 2, 7);
                        } else {
                            q2 = this.horzQuo(px1, py1, cd1.x, cd1.y);
                            if (q2 > 0 && this.prodGe0(px1 - cd1.x, px2 - cd1.x) && Math.abs(px2 - cd1.x) < Math.abs(px1 - cd1.x)) {
                                xend = this.adjDist(cd1.x - this.cpFrom(px1, px2), q2);
                                if (Math.abs(xend) > Math.abs(xdist)) {
                                    xdist = xend;
                                }
                                this.addHSegment(cd1.x - xdist, cd1.x, cd1.y, p, null, 2, 8);
                            } else {
                                this.addHSegment(cd1.x - xdist, cd1.x, cd1.y, p, null, 2, 9);
                            }
                        }
                    }
                }
                if (!flex1 && !flex2) {
                    int maxy = Math.max(cd0.y, cd1.y);
                    int miny = Math.min(cd0.y, cd1.y);
                    if (py1 - maxy >= 256 || py2 - maxy >= 256 || py1 - miny <= 256 || py2 - miny <= 256) {
                        this.findCurveBBox(cd0.x, cd0.y, px1, py1, px2, py2, cd1.x, cd1.y, ll, ur);
                        if (ur.y - maxy > 256 || miny - ll.y > 256) {
                            int[] frst = new int[1];
                            int[] lst = new int[1];
                            int loc = miny - ll.y > ur.y - maxy ? ll.y : ur.y;
                            this.checkBBoxEdge(p, false, loc, frst, lst);
                            xavg = this.fixHalfMul(frst[0] + lst[0]);
                            int n = xdist = frst[0] == lst[0] ? (cd1.x - cd0.x) / 10 : this.fixHalfMul(lst[0] - frst[0]);
                            if (Math.abs(xdist) < this.mBendLength) {
                                xdist = (double)xdist > 0.0 ? this.fixHalfMul(this.mBendLength) : this.fixHalfMul(-this.mBendLength);
                            }
                            this.addHSegment(xavg - xdist, xavg + xdist, loc, p, null, 2, 10);
                        }
                    }
                }
            } else if (p.type != 0 && !this.isTiny(p)) {
                q = this.horzQuo(cd0.x, cd0.y, cd1.x, cd1.y);
                if (q > 0) {
                    if (cd0.y == cd1.y) {
                        this.addHSegment(cd0.x, cd1.x, cd0.y, p.prev, p, 0, 11);
                    } else {
                        if (q < 64) {
                            q = 64;
                        }
                        xdist = this.fixHalfMul(this.adjDist(cd1.x - cd0.x, q));
                        xavg = this.fixHalfMul(cd0.x + cd1.x);
                        this.prvForBend(p, prv);
                        this.nxtForBend(p, nxt, tmp);
                        tmp.y = this.pickHSpot(cd0.x, cd0.y, cd1.x, cd1.y, xdist, cd0.x, cd0.y, cd1.x, cd1.y, prv.x, prv.y, nxt.x, nxt.y);
                        this.addHSegment(xavg - xdist, xavg + xdist, tmp.y, p.prev, p, 0, 12);
                    }
                } else {
                    this.doHBendsNxt(cd0.x, cd0.y, cd1.x, cd1.y, p);
                    this.doHBendsPrv(cd0.x, cd0.y, cd1.x, cd1.y, p);
                }
            }
            p = p.next;
        }
        this.compactList(2, false);
        this.compactList(3, false);
        this.remExtraBends(2, 3);
    }

    private void preGenPts() {
        this.mHlnks = null;
        this.mSegLists[2] = null;
        this.mSegLists[3] = null;
        this.mVlnks = null;
        this.mSegLists[0] = null;
        this.mSegLists[1] = null;
    }

    private void initAll() {
        this.initData();
        this.initAuto();
        this.initFix();
        this.initGen();
        this.initPick();
    }

    private int ptLstLen(ClrPoint lst) {
        int cnt = 0;
        while (lst != null) {
            ++cnt;
            lst = lst.next;
        }
        return cnt;
    }

    private int pointListCheck(ClrPoint newCP, ClrPoint lst) {
        int tmp;
        int l1 = 0;
        int l2 = 0;
        int n1 = 0;
        int n2 = 0;
        char ch = newCP.c;
        int halfMargin = this.fixHalfMul(this.mBandMargin);
        switch (ch) {
            case 'm': 
            case 'y': {
                n1 = newCP.x0;
                n2 = newCP.x1;
                break;
            }
            case 'b': 
            case 'v': {
                n1 = newCP.y0;
                n2 = newCP.y1;
            }
        }
        if (n1 > n2) {
            tmp = n1;
            n1 = n2;
            n2 = tmp;
        }
        while (lst != null) {
            if (lst.c == ch) {
                switch (ch) {
                    case 'm': 
                    case 'y': {
                        l1 = lst.x0;
                        l2 = lst.x1;
                        break;
                    }
                    case 'b': 
                    case 'v': {
                        l1 = lst.y0;
                        l2 = lst.y1;
                    }
                }
                if (l1 > l2) {
                    tmp = l1;
                    l1 = l2;
                    l2 = tmp;
                }
                if (l1 == n1 && l2 == n2) {
                    return 1;
                }
                if ((l1 -= halfMargin) <= n2 && n1 <= (l2 += halfMargin)) {
                    return 0;
                }
            }
            lst = lst.next;
        }
        return -1;
    }

    private boolean sameColorLists(ClrPoint lst1, ClrPoint lst2) {
        if (this.ptLstLen(lst1) != this.ptLstLen(lst2)) {
            return false;
        }
        while (lst1 != null) {
            if (this.pointListCheck(lst1, lst2) != 1) {
                return false;
            }
            lst1 = lst1.next;
        }
        return true;
    }

    private boolean sameColors(int cn1, int cn2) {
        if (cn1 == cn2) {
            return true;
        }
        return this.sameColorLists(this.mPtLstArray[cn1], this.mPtLstArray[cn2]);
    }

    private void mergeFromMainColors(char ch) {
        ClrPoint lst = this.mPtLstArray[0];
        while (lst != null) {
            if (lst.c == ch && this.pointListCheck(lst, this.mPointList) == -1) {
                if (ch == 'b') {
                    this.addColorPoint(0, lst.y0, 0, lst.y1, ch, lst.p0, lst.p1);
                } else {
                    this.addColorPoint(lst.x0, 0, lst.x1, 0, ch, lst.p0, lst.p1);
                }
            }
            lst = lst.next;
        }
    }

    private void addColorPoint(int x0, int y0, int x1, int y1, char ch, PathElt p0, PathElt p1) {
        ClrPoint pt = new ClrPoint();
        pt.cptSN = ++this.mCptSN;
        if (pt.cptSN == 0) {
            pt.cptSN++;
        }
        pt.x0 = x0;
        pt.y0 = y0;
        pt.x1 = x1;
        pt.y1 = y1;
        pt.c = ch;
        pt.done = false;
        pt.next = null;
        pt.p0 = p0;
        pt.p1 = p1;
        int chk = this.pointListCheck(pt, this.mPointList);
        if (chk == -1) {
            pt.next = this.mPointList;
            this.mPointList = pt;
        }
    }

    private void copyClrFromLst(char clr, ClrPoint lst) {
        boolean bvflg;
        boolean bl = bvflg = clr == 'b' || clr == 'v';
        while (lst != null) {
            if (lst.c == clr) {
                if (bvflg) {
                    this.addColorPoint(0, lst.y0, 0, lst.y1, clr, lst.p0, lst.p1);
                } else {
                    this.addColorPoint(lst.x0, 0, lst.x1, 0, clr, lst.p0, lst.p1);
                }
            }
            lst = lst.next;
        }
    }

    private void copyMainV() {
        this.copyClrFromLst('m', this.mPtLstArray[0]);
    }

    private void copyMainH() {
        this.copyClrFromLst('v', this.mPtLstArray[0]);
    }

    private void addHPair(ClrVal v, char ch) {
        int bot = this.itfmy(v.vLoc1);
        int top = this.itfmy(v.vLoc2);
        PathElt p0 = v.vBst.vSeg1.sElt;
        PathElt p1 = v.vBst.vSeg2.sElt;
        if (top < bot) {
            int tmp = top;
            top = bot;
            bot = tmp;
            PathElt p = p0;
            p0 = p1;
            p1 = p;
        }
        if (v.vGhst) {
            if (v.vSeg1.sType == 3) {
                bot = top;
                p0 = p1;
                p1 = null;
                top = bot + this.fixInt(-20);
            } else {
                top = bot;
                p1 = p0;
                p0 = null;
                bot = top - this.fixInt(-21);
            }
        }
        this.addColorPoint(0, bot, 0, top, ch, p0, p1);
    }

    private void addVPair(ClrVal v, char ch) {
        int lft = this.itfmx(v.vLoc1);
        int rght = this.itfmx(v.vLoc2);
        PathElt p0 = v.vBst.vSeg1.sElt;
        PathElt p1 = v.vBst.vSeg2.sElt;
        if (lft > rght) {
            int tmp = lft;
            lft = rght;
            rght = tmp;
            PathElt p = p0;
            p0 = p1;
            p1 = p;
        }
        this.addColorPoint(lft, 0, rght, 0, ch, p0, p1);
    }

    private boolean useCounter(ClrVal sLst, boolean mclr) {
        int maxLoc;
        int cnt = 0;
        int midLoc = maxLoc = this.fixInt(20000);
        int minLoc = maxLoc;
        int maxDelta = 0;
        int midDelta = 0;
        int minDelta = 0;
        ClrVal lst = sLst;
        while (lst != null) {
            ++cnt;
            lst = lst.vNxt;
        }
        if (cnt < 3) {
            return false;
        }
        cnt -= 3;
        int prevBstVal = 0;
        while (cnt > 0) {
            if (--cnt == 0) {
                prevBstVal = sLst.vVal;
            }
            sLst = sLst.vNxt;
        }
        int bestVal = sLst.vVal;
        if (prevBstVal > this.fixInt(1000) || bestVal < prevBstVal * 10) {
            return false;
        }
        ClrVal newLst = sLst;
        while (sLst != null) {
            int delta;
            int loc = sLst.vLoc1;
            if ((loc += this.fixHalfMul(delta = sLst.vLoc2 - loc)) < minLoc) {
                maxLoc = midLoc;
                maxDelta = midDelta;
                midLoc = minLoc;
                midDelta = minDelta;
                minLoc = loc;
                minDelta = delta;
            } else if (loc < midLoc) {
                maxLoc = midLoc;
                maxDelta = midDelta;
                midLoc = loc;
                midDelta = delta;
            } else {
                maxLoc = loc;
                maxDelta = delta;
            }
            sLst = sLst.vNxt;
        }
        int th = this.fixInt(5) / 100;
        if (Math.abs(minDelta - maxDelta) < th && Math.abs(maxLoc - midLoc - (midLoc - minLoc)) < th) {
            if (mclr) {
                this.mVcoloring = newLst;
            } else {
                this.mHcoloring = newLst;
            }
            return true;
        }
        return false;
    }

    private void getNewPtLst() {
        if (this.mNumPtLsts >= this.mMaxPtLsts) {
            this.mMaxPtLsts += 5;
            ClrPoint[] newArray = new ClrPoint[this.mMaxPtLsts];
            for (int i = 0; i < this.mMaxPtLsts - 5; ++i) {
                newArray[i] = this.mPtLstArray[i];
            }
            this.mPtLstArray = newArray;
        }
        this.mPtLstIndex = this.mNumPtLsts++;
        this.mPointList = null;
        this.mPtLstArray[this.mPtLstIndex] = null;
    }

    private void xtraClrs(PathElt e) {
        this.mPtLstArray[this.mPtLstIndex] = this.mPointList;
        if (e.newcolors == 0) {
            this.getNewPtLst();
            e.newcolors = (short)this.mPtLstIndex;
        }
        this.mPtLstIndex = e.newcolors;
        this.mPointList = this.mPtLstArray[this.mPtLstIndex];
    }

    private void blues() {
        int pv = 0;
        int pd = 0;
        int pc = 0;
        int pb = 0;
        int pa = 0;
        if (this.noBlueChar(this.mUnicode)) {
            this.mLenBotBands = 0;
            this.mLenTopBands = 0;
        }
        this.genHPts();
        if (this.mDoCounters && !this.mCounterFailed && this.hColorChar(this.mUnicode)) {
            pv = this.mPruneValue;
            this.mPruneValue = this.fltToFix(this.mMinVal);
            pa = this.mPruneA;
            this.mPruneA = this.fltToFix(this.mMinVal);
            pd = this.mPruneD;
            this.mPruneD = this.fltToFix(this.mMinVal);
            pc = this.mPruneC;
            this.mPruneC = this.fltToFix(this.mMaxVal);
            pb = this.mPruneB;
            this.mPruneB = this.fltToFix(this.mMinVal);
        }
        this.evalH();
        this.pruneHVals();
        this.findBestHVals();
        this.mergeVals(false);
        this.markLinks(this.mValList, true);
        this.checkVals(this.mValList, false);
        this.doHStems(this.mValList);
        this.pickHVals(this.mValList);
        if (this.mDoCounters && !this.mCounterFailed && this.hColorChar(this.mUnicode)) {
            this.mPruneValue = pv;
            this.mPruneD = pd;
            this.mPruneC = pc;
            this.mPruneB = pb;
            this.mPruneA = pa;
            this.mUseH = this.useCounter(this.mHcoloring, false);
            if (!this.mUseH) {
                this.addBBoxHV(true, true);
                this.mUseH = this.useCounter(this.mHcoloring, false);
                if (!this.mUseH) {
                    this.mCounterFailed = true;
                }
            }
        } else {
            this.mUseH = false;
        }
        if (this.mHcoloring == null) {
            this.addBBoxHV(true, false);
        }
        ClrVal sLst = this.mHcoloring;
        while (sLst != null) {
            this.addHPair(sLst, this.mUseH ? (char)'v' : 'b');
            sLst = sLst.vNxt;
        }
    }

    private void doHStems(ClrVal sLst1) {
        int charTop = Integer.MIN_VALUE;
        int charBot = Integer.MAX_VALUE;
        ACBBox bbox = new ACBBox();
        if (!this.mDoAligns) {
            return;
        }
        this.findPathBBox(bbox);
        this.addCharExtreme(this.unScaleAbs(this.itfmy(bbox.ymin)), this.unScaleAbs(this.itfmy(bbox.ymax)));
        while (sLst1 != null) {
            int bot = this.itfmy(sLst1.vLoc1);
            int top = this.itfmy(sLst1.vLoc2);
            if (top < bot) {
                int tmp = top;
                top = bot;
                bot = tmp;
            }
            if (top > charTop) {
                charTop = top;
            }
            if (bot < charBot) {
                charBot = bot;
            }
            if (sLst1.vGhst) {
                sLst1 = sLst1.vNxt;
                continue;
            }
            boolean curved = !this.findLineSeg(sLst1.vLoc1, this.botList()) && !this.findLineSeg(sLst1.vLoc2, this.topList());
            this.addHStem(this.unScaleAbs(top), this.unScaleAbs(bot), curved);
            sLst1 = sLst1.vNxt;
            if (top == Integer.MIN_VALUE && bot == Integer.MAX_VALUE) continue;
            this.addZone(this.unScaleAbs(bot), this.unScaleAbs(top));
        }
        if (charTop != Integer.MIN_VALUE || charBot != Integer.MAX_VALUE) {
            this.addCharZone(this.unScaleAbs(charBot), this.unScaleAbs(charTop));
        }
    }

    private void yellows() {
        int pv = 0;
        int pd = 0;
        int pc = 0;
        int pb = 0;
        int pa = 0;
        this.genVPts(this.specialCharType(this.mUnicode));
        if (this.mDoCounters && !this.mCounterFailed && this.vColorChar(this.mUnicode)) {
            pv = this.mPruneValue;
            this.mPruneValue = this.fltToFix(this.mMinVal);
            pa = this.mPruneA;
            this.mPruneA = this.fltToFix(this.mMinVal);
            pd = this.mPruneD;
            this.mPruneD = this.fltToFix(this.mMinVal);
            pc = this.mPruneC;
            this.mPruneC = this.fltToFix(this.mMaxVal);
            pb = this.mPruneB;
            this.mPruneB = this.fltToFix(this.mMinVal);
        }
        this.evalV();
        this.pruneVVals();
        this.findBestVVals();
        this.mergeVals(true);
        this.markLinks(this.mValList, false);
        this.checkVals(this.mValList, true);
        this.doVStems(this.mValList);
        this.pickVVals(this.mValList);
        if (this.mDoCounters && !this.mCounterFailed && this.vColorChar(this.mUnicode)) {
            this.mPruneValue = pv;
            this.mPruneD = pd;
            this.mPruneC = pc;
            this.mPruneB = pb;
            this.mPruneA = pa;
            this.mUseV = this.useCounter(this.mVcoloring, true);
            if (!this.mUseV) {
                this.addBBoxHV(false, true);
                this.mUseV = this.useCounter(this.mVcoloring, true);
                if (!this.mUseV) {
                    this.mCounterFailed = true;
                }
            }
        } else {
            this.mUseV = false;
        }
        if (this.mVcoloring == null) {
            this.addBBoxHV(false, false);
        }
        ClrVal sLst = this.mVcoloring;
        while (sLst != null) {
            this.addVPair(sLst, this.mUseV ? (char)'m' : 'y');
            sLst = sLst.vNxt;
        }
    }

    private void doVStems(ClrVal sLst) {
        if (!this.mDoAligns) {
            return;
        }
        while (sLst != null) {
            int rght;
            boolean curved = !this.findLineSeg(sLst.vLoc1, this.leftList()) && !this.findLineSeg(sLst.vLoc2, this.rightList());
            int lft = this.itfmx(sLst.vLoc1);
            if (lft > (rght = this.itfmx(sLst.vLoc2))) {
                int tmp = lft;
                lft = rght;
                rght = tmp;
            }
            this.addVStem(this.unScaleAbs(rght), this.unScaleAbs(lft), curved);
            sLst = sLst.vNxt;
        }
    }

    private void removeRedundantFirstColors() {
        if (this.mNumPtLsts < 2) {
            return;
        }
        if (!this.sameColors(0, 1)) {
            return;
        }
        PathElt e = this.mPathStart;
        while (e != null) {
            if (e.newcolors == 1) {
                e.newcolors = (short)0;
                return;
            }
            e = e.next;
        }
    }

    private void addColorsSetup() throws ACException {
        int i;
        this.mVBigDist = 0;
        for (i = 0; i < this.mNumVStems; ++i) {
            if (this.mVStems[i] <= this.mVBigDist) continue;
            this.mVBigDist = this.mVStems[i];
        }
        this.mVBigDist = this.dtfmx(this.mVBigDist);
        if (this.mVBigDist < this.mInitBigDist) {
            this.mVBigDist = this.mInitBigDist;
        }
        this.mVBigDist = this.mVBigDist * 23 / 20;
        this.mVBigDistR = this.fixToFlt(this.mVBigDist);
        this.mHBigDist = 0;
        for (i = 0; i < this.mNumHStems; ++i) {
            if (this.mHStems[i] <= this.mHBigDist) continue;
            this.mHBigDist = this.mHStems[i];
        }
        this.mHBigDist = Math.abs(this.dtfmy(this.mHBigDist));
        if (this.mHBigDist < this.mInitBigDist) {
            this.mHBigDist = this.mInitBigDist;
        }
        this.mHBigDist = this.mHBigDist * 23 / 20;
        this.mHBigDistR = this.fixToFlt(this.mHBigDist);
        if (!this.mScalinghints) {
            this.roundPathCoords();
        }
        this.checkForMultiMoveTo();
        this.collectSubPathInfo();
        if (this.mFixWinding) {
            this.fixPathWind(true);
        }
    }

    private void addColorsInnerLoop() throws ACException {
        int retryColoring = 0;
        while (true) {
            this.preGenPts();
            if (this.mDoSmoothing) {
                this.checkSmooth();
            }
            this.initShuffleSubpaths();
            this.blues();
            if (this.mGenerateVStems) {
                this.yellows();
            }
            if (!this.mDoWriteGlyph) {
                return;
            }
            if (this.mEditChar) {
                this.doShuffleSubpaths();
            }
            this.mHprimary = this.copyClrs(this.mHcoloring);
            if (this.mGenerateVStems) {
                this.mVprimary = this.copyClrs(this.mVcoloring);
            }
            this.pruneElementColorSegs();
            if (this.mExtracolor) {
                this.autoExtraColors(this.moveToNewClrs(this.mUnicode));
            }
            this.mPtLstArray[this.mPtLstIndex] = this.mPointList;
            if (!(this.mCounterFailed && ++retryColoring == 1 || this.doFixes() && retryColoring <= 2)) break;
            this.initAll();
            this.resetGlyph();
            this.addColorsSetup();
            if (!this.preCheckForColoring()) break;
            if (!this.mFlexOK) continue;
            this.autoAddFlex();
        }
    }

    private void addColorsCleanup() {
        this.removeRedundantFirstColors();
        if (this.mPathStart != null && this.mPathStart != this.mPathEnd) {
            this.writeGlyph();
        }
        this.initAll();
    }

    private void addColors() throws ACException {
        if (this.mPathStart == null || this.mPathStart == this.mPathEnd) {
            this.writeGlyph();
            return;
        }
        this.mCounterFailed = false;
        this.addColorsSetup();
        if (!this.preCheckForColoring()) {
            this.writeGlyph();
            return;
        }
        if (this.mFlexOK) {
            this.autoAddFlex();
        }
        this.addColorsInnerLoop();
        this.addColorsCleanup();
    }

    private boolean doGlyph() throws ACException {
        this.resetGlyph();
        this.addColors();
        return true;
    }

    private boolean lePruneValue(int val) {
        return val < 256 && val << 10 <= this.mPruneValue;
    }

    private void adjustVal(int[] pv, int l1, int l2, int dist, int d, boolean hFlg) {
        double q;
        double r2;
        double r1;
        if (dist < 256) {
            dist = 256;
        }
        if (l1 < 256) {
            l1 = 256;
        }
        if (l2 < 256) {
            l2 = 256;
        }
        if (Math.abs(l1) < 32768) {
            r1 = l1 * l1;
        } else {
            r1 = l1;
            r1 *= r1;
        }
        if (Math.abs(l2) < 32768) {
            r2 = l2 * l2;
        } else {
            r2 = l2;
            r2 *= r2;
        }
        if (Math.abs(dist) < 32768) {
            q = dist * dist;
        } else {
            q = dist;
            q *= q;
        }
        double v = 1000.0 * r1 * r2 / (q * q);
        if (d > (hFlg ? this.mHBigDist : this.mVBigDist)) {
            double rd = this.fixToFlt(d);
            double d2 = q = hFlg ? this.mHBigDistR : this.mVBigDistR;
            if (q + q <= rd) {
                v = 0.0;
            } else {
                q /= rd;
                q *= q;
                q *= q;
                q *= q;
                v *= q;
            }
        }
        if (v > this.mMaxVal) {
            v = this.mMaxVal;
        } else if (v > 0.0 && v < this.mMinVal) {
            v = this.mMinVal;
        }
        pv[0] = this.fltToFix(v);
    }

    private int calcOverlapDist(int d, int overlaplen, int minlen) {
        double r = d;
        double ro = overlaplen;
        double rm = minlen;
        d = (int)(r *= 1.0 + 0.4 * (1.0 - ro / rm));
        return d;
    }

    private int gapDist(int d) {
        if (d < this.fixInt(127)) {
            return this.fTrunc(d * d / 20);
        }
        return this.fTrunc(d * (d / 20));
    }

    private void evalHPair(ClrSeg botSeg, ClrSeg topSeg, int[] pspc, int[] pv) {
        int dist;
        int tloc;
        pspc[0] = 0;
        int brght = botSeg.sMax;
        int blft = botSeg.sMin;
        int trght = topSeg.sMax;
        int tlft = topSeg.sMin;
        int bloc = botSeg.sLoc;
        int dy = Math.abs(bloc - (tloc = topSeg.sLoc));
        if (dy < this.mMinDist) {
            pv[0] = 0;
            return;
        }
        boolean inBotBand = this.inBlueBand(bloc, this.mLenBotBands, this.mBotBands);
        boolean inTopBand = this.inBlueBand(tloc, this.mLenTopBands, this.mTopBands);
        if (inBotBand && inTopBand) {
            pv[0] = 0;
            return;
        }
        if (inBotBand || inTopBand) {
            pspc[0] = this.fixInt(2);
        }
        if (tlft <= brght && trght >= blft) {
            int overlaplen = Math.min(trght, brght) - Math.max(tlft, blft);
            int minlen = Math.min(trght - tlft, brght - blft);
            dist = minlen == overlaplen ? dy : this.calcOverlapDist(dy, overlaplen, minlen);
        } else {
            int ldst = Math.abs(tlft - brght);
            int rdst = Math.abs(trght - blft);
            int dx = Math.min(ldst, rdst);
            dist = this.gapDist(dx) + 7 * dy / 5;
            if (dx > dy) {
                dist *= dx / dy;
            }
        }
        int mndist = this.fixTwoMul(this.mMinDist);
        dist = Math.max(dist, mndist);
        if (this.mNumHStems > 0) {
            int w = this.idtfmy(dy);
            w = Math.abs(w);
            for (int i = 0; i < this.mNumHStems; ++i) {
                if (w != this.mHStems[i]) continue;
                pspc[0] = pspc[0] + 256;
                break;
            }
        }
        this.adjustVal(pv, brght - blft, trght - tlft, dist, dy, true);
    }

    private void evalVPair(ClrSeg leftSeg, ClrSeg rightSeg, int[] pspc, int[] pv) {
        int dist;
        int rloc;
        pspc[0] = 0;
        int ltop = leftSeg.sMax;
        int lbot = leftSeg.sMin;
        int rtop = rightSeg.sMax;
        int rbot = rightSeg.sMin;
        int lloc = leftSeg.sLoc;
        int dx = Math.abs(lloc - (rloc = rightSeg.sLoc));
        if (dx < this.mMinDist) {
            pv[0] = 0;
            return;
        }
        if (ltop >= rbot && lbot <= rtop) {
            int overlaplen = Math.min(ltop, rtop) - Math.max(lbot, rbot);
            int minlen = Math.min(ltop - lbot, rtop - rbot);
            dist = minlen == overlaplen ? dx : this.calcOverlapDist(dx, overlaplen, minlen);
        } else {
            int tdst = Math.abs(ltop - rbot);
            int bdst = Math.abs(lbot - rtop);
            int dy = Math.min(tdst, bdst);
            dist = 7 * dx / 5 + this.gapDist(dy);
            if (dy > dx) {
                dist *= dy / dx;
            }
        }
        int mndist = this.fixTwoMul(this.mMinDist);
        dist = Math.max(dist, mndist);
        int lbonus = leftSeg.sBonus;
        int rbonus = rightSeg.sBonus;
        int bonus = Math.min(lbonus, rbonus);
        int n = pspc[0] = bonus > 0 ? this.fixInt(2) : 0;
        if (this.mNumVStems > 0) {
            int w = this.idtfmx(dx);
            w = Math.abs(w);
            for (int i = 0; i < this.mNumVStems; ++i) {
                if (w != this.mVStems[i]) continue;
                pspc[0] = pspc[0] + 256;
                break;
            }
        }
        this.adjustVal(pv, ltop - lbot, rtop - rbot, dist, dx, false);
    }

    private void insertVValue(int lft, int rght, int val, int spc, ClrSeg lSeg, ClrSeg rSeg) {
        ClrVal item = new ClrVal();
        item.cvlSN = ++this.mCvlSN;
        if (item.cvlSN == 0) {
            item.cvlSN++;
        }
        item.vVal = val;
        item.initVal = val;
        item.vLoc1 = lft;
        item.vLoc2 = rght;
        item.vSpc = spc;
        item.vSeg1 = lSeg;
        item.vSeg2 = rSeg;
        item.vGhst = false;
        ClrVal vlist = this.mValList;
        ClrVal vprev = null;
        while (vlist != null && vlist.vLoc1 < lft) {
            vprev = vlist;
            vlist = vlist.vNxt;
        }
        while (vlist != null && vlist.vLoc1 == lft && vlist.vLoc2 < rght) {
            vprev = vlist;
            vlist = vlist.vNxt;
        }
        if (vprev == null) {
            this.mValList = item;
        } else {
            vprev.vNxt = item;
        }
        item.vNxt = vlist;
    }

    private void addVValue(int lft, int rght, int val, int spc, ClrSeg lSeg, ClrSeg rSeg) {
        if (val == 0) {
            return;
        }
        if (this.lePruneValue(val) && spc <= 0) {
            return;
        }
        if (lSeg != null && lSeg.sType == 1 && rSeg != null && rSeg.sType == 1) {
            return;
        }
        if (!(val > this.mPruneD || spc > 0 || lSeg == null || rSeg == null || lSeg.sType != 1 && rSeg.sType != 1 && this.checkBBoxes(lSeg.sElt, rSeg.sElt))) {
            return;
        }
        this.insertVValue(lft, rght, val, spc, lSeg, rSeg);
    }

    private void insertHValue(int bot, int top, int val, int spc, ClrSeg bSeg, ClrSeg tSeg, boolean ghst) {
        ClrVal vlist = this.mValList;
        ClrVal vprev = null;
        while (vlist != null && vlist.vLoc2 < top) {
            vprev = vlist;
            vlist = vlist.vNxt;
        }
        while (vlist != null && vlist.vLoc2 == top && vlist.vLoc1 < bot) {
            vprev = vlist;
            vlist = vlist.vNxt;
        }
        ClrVal vl = vlist;
        while (ghst && vl != null && vl.vLoc2 == top && vl.vLoc1 == bot) {
            if (!(vl.vGhst || vl.vSeg1 != bSeg && vl.vSeg2 != tSeg || vl.vVal <= val)) {
                return;
            }
            vl = vl.vNxt;
        }
        ClrVal item = new ClrVal();
        item.cvlSN = ++this.mCvlSN;
        item.vVal = val;
        item.initVal = val;
        item.vSpc = spc;
        item.vLoc1 = bot;
        item.vLoc2 = top;
        item.vSeg1 = bSeg;
        item.vSeg2 = tSeg;
        item.vGhst = ghst;
        if (vprev == null) {
            this.mValList = item;
        } else {
            vprev.vNxt = item;
        }
        item.vNxt = vlist;
    }

    private void addHValue(int bot, int top, int val, int spc, ClrSeg bSeg, ClrSeg tSeg) {
        boolean ghst;
        if (val == 0) {
            return;
        }
        if (this.lePruneValue(val) && spc <= 0) {
            return;
        }
        if (bSeg.sType == 1 && tSeg.sType == 1) {
            return;
        }
        boolean bl = ghst = bSeg.sType == 3 || tSeg.sType == 3;
        if (!(ghst || val > this.mPruneD || spc > 0 || bSeg.sType != 1 && tSeg.sType != 1 && this.checkBBoxes(bSeg.sElt, tSeg.sElt))) {
            return;
        }
        this.insertHValue(bot, top, val, spc, bSeg, tSeg, ghst);
    }

    private double mfabs(double in) {
        if (in > 0.0) {
            return in;
        }
        return -in;
    }

    private int combVals(int v1, int v2) {
        double a;
        double xx = 0.0;
        double r1 = this.fixToFlt(v1);
        double r2 = this.fixToFlt(v2);
        double x = a = r1 * r2;
        for (int i = 0; i < 16; ++i) {
            xx = 0.5 * (x + a / x);
            if (i >= 8 && this.mfabs(xx - x) <= this.mfabs(xx) * 1.0E-7) break;
            x = xx;
        }
        if ((r1 += r2 + 2.0 * xx) > this.mMaxVal) {
            r1 = this.mMaxVal;
        } else if (r1 > 0.0 && r1 < this.mMinVal) {
            r1 = this.mMinVal;
        }
        return this.fltToFix(r1);
    }

    private void combineValues() {
        ClrVal vlist = this.mValList;
        while (vlist != null) {
            ClrVal v1 = vlist.vNxt;
            int loc1 = vlist.vLoc1;
            int loc2 = vlist.vLoc2;
            int val = vlist.vVal;
            boolean match = false;
            while (v1 != null && v1.vLoc1 == loc1 && v1.vLoc2 == loc2) {
                val = v1.vGhst ? v1.vVal : this.combVals(val, v1.vVal);
                match = true;
                v1 = v1.vNxt;
            }
            if (match) {
                while (vlist != v1) {
                    vlist.vVal = val;
                    vlist = vlist.vNxt;
                }
                continue;
            }
            vlist = v1;
        }
    }

    private void evalV() {
        int[] val = new int[1];
        int[] spc = new int[1];
        this.mValList = null;
        ClrSeg lList = this.leftList();
        while (lList != null) {
            ClrSeg rList = this.rightList();
            while (rList != null) {
                int rght;
                int lft = lList.sLoc;
                if (lft < (rght = rList.sLoc)) {
                    this.evalVPair(lList, rList, spc, val);
                    this.addVValue(lft, rght, val[0], spc[0], lList, rList);
                }
                rList = rList.sNxt;
            }
            lList = lList.sNxt;
        }
        this.combineValues();
    }

    private void evalH() {
        int val;
        int spc;
        int top;
        this.mValList = null;
        ClrSeg bList = this.botList();
        while (bList != null) {
            ClrSeg tList = this.topList();
            while (tList != null) {
                int bot = bList.sLoc;
                if (bot >= (top = tList.sLoc)) {
                    if (bot > top) {
                        // empty if block
                    }
                } else {
                    int[] spca = new int[1];
                    int[] vala = new int[1];
                    this.evalHPair(bList, tList, spca, vala);
                    spc = spca[0];
                    val = vala[0];
                    this.addHValue(bot, top, val, spc, bList, tList);
                }
                tList = tList.sNxt;
            }
            bList = bList.sNxt;
        }
        ClrSeg ghostSeg = new ClrSeg();
        ghostSeg.csgSN = ++this.mCsgSN;
        ghostSeg.sType = (short)3;
        ghostSeg.sElt = null;
        if (this.mLenBotBands >= 2 || this.mLenTopBands >= 2) {
            int cntr;
            int tempLoc;
            int lstLoc;
            ClrSeg lst = this.botList();
            while (lst != null) {
                lstLoc = lst.sLoc;
                if (this.inBlueBand(lstLoc, this.mLenBotBands, this.mBotBands)) {
                    tempLoc = lstLoc;
                    ghostSeg.sLoc = (tempLoc += this.mGhostWidth);
                    cntr = (lst.sMax + lst.sMin) / 2;
                    ghostSeg.sMax = cntr + this.mGhostLength / 2;
                    ghostSeg.sMin = cntr - this.mGhostLength / 2;
                    spc = this.fixInt(2);
                    val = this.fixInt(20);
                    this.addHValue(lstLoc, tempLoc, val, spc, lst, ghostSeg);
                }
                lst = lst.sNxt;
            }
            lst = this.topList();
            while (lst != null) {
                lstLoc = lst.sLoc;
                if (this.inBlueBand(lstLoc, this.mLenTopBands, this.mTopBands)) {
                    tempLoc = lstLoc;
                    ghostSeg.sLoc = (tempLoc -= this.mGhostWidth);
                    cntr = (lst.sMin + lst.sMax) / 2;
                    ghostSeg.sMax = cntr + this.mGhostLength / 2;
                    ghostSeg.sMin = cntr - this.mGhostLength / 2;
                    spc = this.fixInt(2);
                    val = this.fixInt(20);
                    this.addHValue(tempLoc, lstLoc, val, spc, ghostSeg, lst);
                }
                lst = lst.sNxt;
            }
            if (this.mLenTopBands != 0 || this.mLenBotBands != 0) {
                ACBBox bbox = new ACBBox();
                this.findPathBBox(bbox);
                top = bbox.ymax;
                int bot = bbox.ymin;
                ClrSeg seg = new ClrSeg();
                seg.csgSN = ++this.mCsgSN;
                seg.sType = (short)0;
                seg.sElt = null;
                seg.sMin = Integer.MIN_VALUE;
                seg.sMax = Integer.MAX_VALUE;
                ghostSeg.sMax = this.mGhostLength / 2;
                ghostSeg.sMin = -this.mGhostLength / 2;
                spc = this.fixInt(2);
                val = this.fixInt(20);
                if (this.inBlueBand(bot, this.mLenBotBands, this.mBotBands)) {
                    seg.sLoc = bot;
                    tempLoc = bot;
                    ghostSeg.sLoc = (tempLoc += this.mGhostWidth);
                    this.addHValue(bot, tempLoc, val, spc, seg, ghostSeg);
                }
                if (this.inBlueBand(top, this.mLenTopBands, this.mTopBands)) {
                    seg.sLoc = top;
                    tempLoc = top;
                    ghostSeg.sLoc = (tempLoc -= this.mGhostWidth);
                    this.addHValue(tempLoc, top, val, spc, ghostSeg, seg);
                }
            }
        }
        this.combineValues();
    }

    private boolean inRange(int x, int x1, int x2) {
        return x >= x1 && x <= x2;
    }

    private void flatReportProc(int frp, Object param, Cd c) {
        switch (frp) {
            case 0: {
                this.nzWindProc(param, c);
                break;
            }
            case 1: {
                this.findYExtremeProc(param, c);
                break;
            }
            case 2: {
                this.chkDT(param, c);
                break;
            }
            case 3: {
                this.chkBBDT(param, c);
                break;
            }
            case 4: {
                this.fpBBoxPt(param, c);
            }
        }
    }

    private void walkSubPath(PathElt sp, boolean yExtreme, Object param) {
        PathElt e = sp;
        Cd curPt = new Cd();
        FltnRec fltnrec = new FltnRec();
        Cd c1 = new Cd();
        Cd c2 = new Cd();
        Cd c3 = new Cd();
        while (e != null) {
            switch (e.type) {
                case 2: {
                    boolean shortcut;
                    this.flatReportProc(yExtreme ? 1 : 0, param, curPt);
                    fltnrec.param = param;
                    c1.x = e.x1;
                    c1.y = e.y1;
                    c2.x = e.x2;
                    c2.y = e.y2;
                    c3.x = e.x3;
                    c3.y = e.y3;
                    if (yExtreme) {
                        fltnrec.report = 1;
                        shortcut = this.yExtremeShortCutProc(curPt, c1, c2, c3, param, fltnrec.report);
                    } else {
                        fltnrec.report = 0;
                        shortcut = this.nzWindShortCutProc(curPt, c1, c2, c3, param, fltnrec.report);
                    }
                    if (!shortcut) {
                        this.fltnCurve(curPt, c1, c2, c3, fltnrec);
                    }
                    curPt.copyFrom(c3);
                    break;
                }
                case 1: {
                    this.flatReportProc(yExtreme ? 1 : 0, param, curPt);
                    curPt.x = e.x;
                    curPt.y = e.y;
                    break;
                }
                case 0: {
                    curPt.x = e.x;
                    curPt.y = e.y;
                    break;
                }
                case 3: {
                    this.flatReportProc(yExtreme ? 1 : 0, param, curPt);
                    return;
                }
            }
            e = e.next;
        }
    }

    private int windTest(Cd prevPt, Cd topPt, Cd nextPt) {
        double ny;
        double x;
        if (prevPt.x > topPt.x && topPt.x > nextPt.x) {
            return 0;
        }
        if (prevPt.x < topPt.x && topPt.x < nextPt.x) {
            return 1;
        }
        if (prevPt.y == topPt.y) {
            if (prevPt.x >= topPt.x) {
                return 0;
            }
            return 1;
        }
        if (topPt.y == nextPt.y) {
            if (topPt.x >= nextPt.x) {
                return 0;
            }
            return 1;
        }
        double px = this.fixToFlt(prevPt.x);
        double py = this.fixToFlt(prevPt.y);
        double tx = this.fixToFlt(topPt.x);
        double ty = this.fixToFlt(topPt.y);
        double nx = this.fixToFlt(nextPt.x);
        if (nx <= (x = ((tx - px) * (ny = this.fixToFlt(nextPt.y)) + (px * ty - tx * py)) / (ty - py))) {
            return 0;
        }
        return 1;
    }

    private void findYExtremeProc(Object param, Cd curPt) {
        FindExParam xp = (FindExParam)param;
        if (xp.hasLastPt && xp.lastPt.x == curPt.x && xp.lastPt.y == curPt.y) {
            return;
        }
        if (xp.lastWasExtreme && curPt.y < xp.yMax) {
            xp.plaeauEnded = true;
            if (xp.hasRisePt) {
                if (xp.risePt.x != xp.lastPt.x) {
                    xp.windDir = xp.risePt.x > xp.lastPt.x ? 0 : 1;
                } else if (xp.hasPrerisePt) {
                    xp.windDir = this.windTest(xp.prerisePt, xp.risePt, curPt);
                    xp.firstWasExtreme = false;
                }
            } else if (!xp.firstWasExtreme) {
                xp.firstWasExtreme = true;
                xp.risePt.copyFrom(xp.firstPt);
                xp.beforeFirstSinkPt.copyFrom(xp.lastPt);
                xp.firstSinkPt.copyFrom(curPt);
            }
        }
        if (xp.hasLastPt) {
            if (curPt.y > xp.yMax || xp.plaeauEnded && curPt.y == xp.yMax) {
                xp.plaeauEnded = false;
                xp.risePt.copyFrom(curPt);
                xp.hasRisePt = true;
                xp.prerisePt.copyFrom(xp.lastPt);
                xp.hasPrerisePt = true;
                xp.firstWasExtreme = false;
            }
        } else {
            xp.firstSinkPt.copyFrom(curPt);
            xp.firstPt.copyFrom(curPt);
        }
        if (xp.firstWasExtreme) {
            if (curPt.y < xp.yMax) {
                xp.prerisePt.copyFrom(curPt);
                xp.hasPrerisePt = true;
            }
            if (xp.hasPrerisePt && curPt.y == xp.yMax && !xp.hasRisePtForFirst) {
                xp.risePt.copyFrom(curPt);
                xp.hasRisePtForFirst = true;
            }
        }
        xp.lastPt.copyFrom(curPt);
        xp.hasLastPt = true;
        xp.lastWasExtreme = curPt.y >= xp.yMax;
        if (xp.lastWasExtreme) {
            xp.yMax = curPt.y;
        }
    }

    private boolean yExtremeShortCutProc(Cd c0, Cd c1, Cd c2, Cd c3, Object param, int frp) {
        FindExParam xp = (FindExParam)param;
        int yMax = xp.yMax;
        if (c0.y < yMax && c1.y < yMax && c2.y < yMax && c3.y < yMax) {
            this.flatReportProc(frp, param, c3);
            return true;
        }
        return false;
    }

    private void collectSubPathInfo() throws ACException {
        Cd cd = new Cd();
        int[] elemCount = new int[1];
        this.mNumSubPaths = this.countSubPaths(elemCount);
        if (this.mNumSubPaths > 200 || elemCount[0] > 1000) {
            throw new ACException("Glyph too complex");
        }
        this.mSubPaths = new SubPathInfo[this.mNumSubPaths];
        int i = 0;
        PathElt e = this.mPathEnd;
        while (i < this.mNumSubPaths && e != null) {
            if ((e = this.getDest(e)) == null) continue;
            ACBBox bbox = new ACBBox();
            this.calcSubpathBBox(bbox, e);
            int n = i++;
            SubPathInfo subPathInfo = new SubPathInfo();
            this.mSubPaths[n] = subPathInfo;
            SubPathInfo sp = subPathInfo;
            sp.head = e;
            sp.startPt.x = e.x;
            sp.startPt.y = e.y;
            sp.bbox = bbox;
            sp.tail = this.getClosedBy(e);
            if (sp.tail == null) continue;
            this.getEndPoint(sp.tail.prev, cd);
            sp.endPt.x = cd.x;
            sp.endPt.y = cd.y;
            e = e.prev;
        }
    }

    private void determineCurrentWind(SubPathInfo[] subPaths, int numSubPaths) {
        for (int i = 0; i < numSubPaths; ++i) {
            SubPathInfo subPath = subPaths[i];
            PathElt e = subPath.head;
            FindExParam param = new FindExParam();
            param.yMax = Integer.MIN_VALUE;
            this.walkSubPath(e, true, param);
            if (param.firstWasExtreme) {
                if (param.risePt.x != param.beforeFirstSinkPt.x) {
                    subPath.currentWind = param.risePt.x > param.beforeFirstSinkPt.x ? 0 : 1;
                    continue;
                }
                subPath.currentWind = this.windTest(param.prerisePt, param.beforeFirstSinkPt, param.firstSinkPt);
                continue;
            }
            if (param.lastWasExtreme) {
                if (param.risePt.x != param.lastPt.x) {
                    subPath.currentWind = param.risePt.x > param.lastPt.x ? 0 : 1;
                    continue;
                }
                subPath.currentWind = this.windTest(param.prerisePt, param.lastPt, param.firstSinkPt);
                continue;
            }
            subPath.currentWind = param.windDir;
        }
    }

    private int testHighLow(int y1, int y2) {
        if (y1 == y2) {
            return 0;
        }
        if (y1 < y2) {
            return 1;
        }
        return -1;
    }

    private void nzWindProc(Object param, Cd pt) {
        NZWindParam eop = (NZWindParam)param;
        if (eop.hasLastPt) {
            int test2;
            int test1 = this.testHighLow(eop.testPt.y, eop.lastPt.y);
            if (test1 * (test2 = this.testHighLow(eop.testPt.y, pt.y)) <= 0 && (eop.testToRight && (eop.lastPt.x > eop.testPt.x || pt.x > eop.testPt.x) || !eop.testToRight && (eop.lastPt.x < eop.testPt.x || pt.x < eop.testPt.x)) && eop.lastPt.y != pt.y) {
                if (pt.y == eop.testPt.y && !(eop.testToRight ^ pt.x > eop.testPt.x)) {
                    eop.onLine = true;
                    eop.fromAbove = eop.lastPt.y > eop.testPt.y;
                    eop.lastPt.copyFrom(pt);
                    eop.hasLastPt = true;
                    return;
                }
                if (eop.onLine) {
                    if (eop.fromAbove && test2 < 0 || !eop.fromAbove && test2 > 0) {
                        eop.windCount += eop.testToRight ^ test2 < 0 ? 1 : -1;
                    }
                    eop.onLine = false;
                    eop.lastPt.copyFrom(pt);
                    eop.hasLastPt = true;
                    return;
                }
                double x1 = this.fixToFlt(eop.lastPt.x);
                double y1 = this.fixToFlt(eop.lastPt.y);
                double x2 = this.fixToFlt(pt.x);
                double y2 = this.fixToFlt(pt.y);
                double x = (eop.testy * (x2 - x1) + x1 * y2 - x2 * y1) / (y2 - y1);
                if (!(eop.testToRight ^ x > eop.testx)) {
                    eop.windCount += eop.testToRight ^ y1 > y2 ? 1 : -1;
                }
            }
        } else {
            eop.firstPt.copyFrom(pt);
        }
        eop.lastPt.copyFrom(pt);
        eop.hasLastPt = true;
    }

    private boolean nzWindShortCutProc(Cd c0, Cd c1, Cd c2, Cd c3, Object param, int frp) {
        NZWindParam eop = (NZWindParam)param;
        int testy = eop.testPt.y;
        if (c0.y > testy && c1.y > testy && c2.y > testy && c3.y > testy || c0.y < testy && c1.y < testy && c2.y < testy && c3.y < testy) {
            this.flatReportProc(frp, param, c3);
            return true;
        }
        return false;
    }

    private int nzWindTest(Cd pt, SubPathInfo sp) {
        NZWindParam param = new NZWindParam();
        param.testPt.copyFrom(pt);
        param.testx = this.fixToFlt(pt.x);
        param.testy = this.fixToFlt(pt.y);
        param.testToRight = sp.startPt.x < pt.x;
        this.walkSubPath(sp.head, false, param);
        if (param.hasLastPt) {
            this.nzWindProc(param, param.firstPt);
        }
        return param.windCount;
    }

    private void determineFillOrUnfill(SubPathInfo[] subPaths, int numSubPaths) {
        for (int i = 0; i < numSubPaths; ++i) {
            int windCount = 0;
            Cd startPt = (Cd)subPaths[i].startPt.clone();
            for (int j = 0; j < numSubPaths; ++j) {
                if (i == j || !this.inRange(startPt.x, subPaths[j].bbox.xmin, subPaths[j].bbox.xmax) || !this.inRange(startPt.y, subPaths[j].bbox.ymin, subPaths[j].bbox.ymax)) continue;
                windCount += this.nzWindTest(startPt, subPaths[j]);
            }
            windCount = subPaths[i].currentWind == 0 ? ++windCount : --windCount;
            subPaths[i].filled = windCount != 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void flipSubPath(SubPathInfo sp) {
        int cx = 0;
        int cy = 0;
        PathElt e = sp.head;
        PathElt prevSubPath = e.prev;
        PathElt nextSubPath = sp.tail.next;
        PathElt newHead = null;
        PathElt newTail = null;
        while (true) {
            PathElt next;
            block12: {
                if (e == null) {
                    sp.head = newHead;
                    sp.tail = newTail;
                    return;
                }
                next = e.next;
                PathElt prev = e.prev;
                switch (e.type) {
                    case 2: {
                        int x1 = e.x1;
                        int y1 = e.y1;
                        int ncx = e.x3;
                        int ncy = e.y3;
                        e.x1 = e.x2;
                        e.y1 = e.y2;
                        e.x2 = x1;
                        e.y2 = y1;
                        e.x3 = cx;
                        e.y3 = cy;
                        cx = ncx;
                        cy = ncy;
                        break;
                    }
                    case 1: {
                        int ncx = e.x;
                        int ncy = e.y;
                        e.x = cx;
                        e.y = cy;
                        cx = ncx;
                        cy = ncy;
                        break;
                    }
                    case 0: {
                        newTail = e;
                        cx = e.x;
                        cy = e.y;
                        e.type = (short)3;
                        e.next = nextSubPath;
                        if (nextSubPath != null) {
                            nextSubPath.prev = e;
                        } else {
                            this.mPathEnd = e;
                        }
                        e.prev = next;
                        e.next = nextSubPath;
                        break block12;
                    }
                    case 3: {
                        newHead = e;
                        e.type = (short)0;
                        e.x = cx;
                        e.y = cy;
                        e.x = sp.tail.x;
                        e.y = sp.tail.y;
                        if (prevSubPath != null) {
                            prevSubPath.next = e;
                        } else {
                            this.mPathStart = e;
                        }
                        e.next = prev;
                        e.prev = prevSubPath;
                        sp.head = newHead;
                        sp.tail = newTail;
                        return;
                    }
                }
                e.next = prev;
                e.prev = next;
            }
            e = next;
        }
    }

    private void flipSubPaths(SubPathInfo[] subPaths, int numSubPaths, boolean forceCCW) {
        for (int i = 0; i < numSubPaths; ++i) {
            SubPathInfo sp = subPaths[i];
            boolean correct = sp.currentWind == 0 ^ sp.filled ^ forceCCW;
            if (correct) continue;
            this.flipSubPath(sp);
        }
    }

    private void fixPathWind(boolean forceCCW) {
        this.determineCurrentWind(this.mSubPaths, this.mNumSubPaths);
        this.determineFillOrUnfill(this.mSubPaths, this.mNumSubPaths);
        this.flipSubPaths(this.mSubPaths, this.mNumSubPaths, forceCCW);
    }

    private boolean closeElements(PathElt e1, PathElt e2, int loc1, int loc2, boolean vert) {
        int tmp;
        Cd cd = new Cd();
        if (e1 == e2) {
            return true;
        }
        int clsmrg = this.psDist(20);
        if (loc1 < loc2) {
            loc1 -= clsmrg;
            loc2 += clsmrg;
        } else {
            tmp = loc1;
            loc1 = loc2 - clsmrg;
            loc2 = tmp + clsmrg;
        }
        PathElt e = e1;
        do {
            if (e == e2) {
                return true;
            }
            this.getEndPoint(e, cd);
            int n = tmp = vert ? cd.x : cd.y;
            if (tmp <= loc2 && tmp >= loc1) continue;
            return false;
        } while ((e = e.type == 3 ? this.getDest(e) : e.next) != e1);
        return false;
    }

    private boolean closeSegs(ClrSeg s1, ClrSeg s2, boolean vert) {
        int loc2;
        if (s1 == s2) {
            return true;
        }
        PathElt e1 = s1.sElt;
        PathElt e2 = s2.sElt;
        if (e1 == null || e2 == null) {
            return true;
        }
        int loc1 = s1.sLoc;
        return this.closeElements(e1, e2, loc1, loc2 = s2.sLoc, vert) || this.closeElements(e2, e1, loc2, loc1, vert);
    }

    private void doPrune() {
        ClrVal vL = this.mValList;
        while (vL != null && vL.pruned) {
            vL = vL.vNxt;
        }
        this.mValList = vL;
        if (vL == null) {
            return;
        }
        ClrVal vPrv = vL;
        vL = vL.vNxt;
        while (vL != null) {
            if (vL.pruned) {
                vL = vL.vNxt;
                vPrv.vNxt = vL;
                continue;
            }
            vPrv = vL;
            vL = vL.vNxt;
        }
    }

    private ClrVal pruneOne(ClrVal sLst, boolean hFlg, ClrVal sL, int i) {
        sLst.pruned = true;
        return sLst.vNxt;
    }

    private boolean pruneLt(int val, int v) {
        if (v < 0xCCCCCCC && val < 0x2AAAAAAA) {
            return val * 3 < v * 10;
        }
        return val / 10 < v / 3;
    }

    private boolean pruneLe(int val, int v) {
        if (val < 0x2AAAAAAA) {
            return v <= val * 3;
        }
        return v / 3 <= val;
    }

    private boolean pruneGt(int val, int v) {
        if (val < 0x2AAAAAAA) {
            return v > val * 3;
        }
        return v / 3 > val;
    }

    private boolean pruneMuchGt(int val, int v) {
        if (val < 42949672) {
            return v > val * 50;
        }
        return v / 50 > val;
    }

    private boolean pruneVeryMuchGt(int val, int v) {
        if (val < 21474836) {
            return v > val * 100;
        }
        return v / 100 > val;
    }

    private void pruneVVals() {
        ClrVal sLst = this.mValList;
        int prndist = this.psDist(10);
        while (sLst != null) {
            boolean flg = true;
            boolean otherRht = false;
            boolean otherLft = false;
            int val = sLst.vVal;
            int lft = sLst.vLoc1;
            int rht = sLst.vLoc2;
            ClrSeg seg1 = sLst.vSeg1;
            ClrSeg seg2 = sLst.vSeg2;
            ClrVal sL = this.mValList;
            while (sL != null) {
                int v = sL.vVal;
                ClrSeg sg1 = sL.vSeg1;
                ClrSeg sg2 = sL.vSeg2;
                int l = sL.vLoc1;
                int r = sL.vLoc2;
                if (!(l == lft && r == rht || this.pruneLe(val, v))) {
                    if (rht + prndist >= r && lft - prndist <= l && (val < this.fixInt(100) && this.pruneMuchGt(val, v) ? this.closeSegs(seg1, sg1, true) || this.closeSegs(seg2, sg2, true) : this.closeSegs(seg1, sg1, true) && this.closeSegs(seg2, sg2, true))) {
                        sLst = this.pruneOne(sLst, false, sL, 1);
                        flg = false;
                        break;
                    }
                    if (seg1 != null && seg2 != null) {
                        if (Math.abs(l - lft) < 256) {
                            if (!otherLft && this.pruneLt(val, v) && Math.abs(l - r) < Math.abs(lft - rht) && this.closeSegs(seg1, sg1, true)) {
                                otherLft = true;
                            }
                            if (seg2.sType == 1 && this.closeSegs(seg1, sg1, true)) {
                                sLst = this.pruneOne(sLst, false, sL, 2);
                                flg = false;
                                break;
                            }
                        }
                        if (Math.abs(r - rht) < 256) {
                            if (!otherRht && this.pruneLt(val, v) && Math.abs(l - r) < Math.abs(lft - rht) && this.closeSegs(seg2, sg2, true)) {
                                otherRht = true;
                            }
                            if (seg1.sType == 1 && this.closeSegs(seg2, sg2, true)) {
                                sLst = this.pruneOne(sLst, false, sL, 3);
                                flg = false;
                                break;
                            }
                        }
                        if (otherLft && otherRht) {
                            sLst = this.pruneOne(sLst, false, sL, 4);
                            flg = false;
                            break;
                        }
                    }
                }
                sL = sL.vNxt;
            }
            if (!flg) continue;
            sLst = sLst.vNxt;
        }
        this.doPrune();
    }

    private void pruneHVals() {
        ClrVal sLst = this.mValList;
        int prndist = this.psDist(10);
        while (sLst != null) {
            boolean flg = true;
            boolean otherBot = false;
            boolean otherTop = false;
            ClrSeg seg1 = sLst.vSeg1;
            ClrSeg seg2 = sLst.vSeg2;
            boolean ghst = sLst.vGhst;
            int val = sLst.vVal;
            int bot = sLst.vLoc1;
            int top = sLst.vLoc2;
            boolean topInBlue = this.inBlueBand(top, this.mLenTopBands, this.mTopBands);
            boolean botInBlue = this.inBlueBand(bot, this.mLenBotBands, this.mBotBands);
            ClrVal sL = this.mValList;
            while (sL != null) {
                ClrSeg sg1 = sL.vSeg1;
                ClrSeg sg2 = sL.vSeg2;
                int v = sL.vVal;
                if (!ghst && sL.vGhst && !this.pruneVeryMuchGt(val, v)) {
                    sL = sL.vNxt;
                    continue;
                }
                int b = sL.vLoc1;
                int t = sL.vLoc2;
                if (t == top && b == bot) {
                    sL = sL.vNxt;
                    continue;
                }
                if (!(!this.pruneGt(val, v) || top + prndist < t || bot - prndist > b || !(val < this.fixInt(100) && this.pruneMuchGt(val, v) ? this.closeSegs(seg1, sg1, false) || this.closeSegs(seg2, sg2, false) : this.closeSegs(seg1, sg1, false) && this.closeSegs(seg2, sg2, false)) || val >= 4096 && (topInBlue && top != t || botInBlue && bot != b))) {
                    sLst = this.pruneOne(sLst, true, sL, 5);
                    flg = false;
                    break;
                }
                if (seg1 != null && seg2 != null) {
                    if (Math.abs(b - bot) < 256) {
                        if (this.pruneGt(val, v) && !topInBlue && seg2.sType == 1 && this.closeSegs(seg1, sg1, false)) {
                            sLst = this.pruneOne(sLst, true, sL, 6);
                            flg = false;
                            break;
                        }
                        if (!otherBot && this.pruneLt(val, v) && Math.abs(t - b) < Math.abs(top - bot) && this.closeSegs(seg1, sg1, false)) {
                            otherBot = true;
                        }
                    }
                    if (Math.abs(t - top) < 256) {
                        if (this.pruneGt(val, v) && !botInBlue && seg2.sType == 1 && this.closeSegs(seg1, sg1, false)) {
                            sLst = this.pruneOne(sLst, true, sL, 7);
                            flg = false;
                            break;
                        }
                        if (!otherTop && this.pruneLt(val, v) && Math.abs(t - b) < Math.abs(top - bot) && this.closeSegs(seg2, sg2, false)) {
                            otherTop = true;
                        }
                    }
                    if (otherBot && otherTop) {
                        sLst = this.pruneOne(sLst, true, sL, 8);
                        flg = false;
                        break;
                    }
                }
                sL = sL.vNxt;
            }
            if (!flg) continue;
            sLst = sLst.vNxt;
        }
        this.doPrune();
    }

    private void findBestVals(ClrVal vL) {
        while (vL != null) {
            if (vL.vBst == null) {
                int bV = vL.vVal;
                int bS = vL.vSpc;
                ClrVal bstV = vL;
                int b = vL.vLoc1;
                int t = vL.vLoc2;
                ClrVal vL2 = vL.vNxt;
                ClrVal vPrv = vL;
                while (vL2 != null) {
                    if (vL2.vBst == null && vL2.vLoc1 == b && vL2.vLoc2 == t) {
                        if (vL2.vSpc == bS && vL2.vVal > bV || vL2.vSpc > bS) {
                            bS = vL2.vSpc;
                            bV = vL2.vVal;
                            bstV = vL2;
                        }
                        vL2.vBst = vPrv;
                        vPrv = vL2;
                    }
                    vL2 = vL2.vNxt;
                }
                while (vPrv != null) {
                    vL2 = vPrv.vBst;
                    vPrv.vBst = bstV;
                    vPrv = vL2;
                }
            }
            vL = vL.vNxt;
        }
    }

    private void replaceVals(int oldB, int oldT, int newB, int newT, ClrVal newBst, boolean vert) {
        ClrVal vL = this.mValList;
        while (vL != null) {
            if (vL.vLoc1 == oldB && vL.vLoc2 == oldT && !vL.merge) {
                vL.vLoc1 = newB;
                vL.vLoc2 = newT;
                vL.vVal = newBst.vVal;
                vL.vSpc = newBst.vSpc;
                vL.vBst = newBst;
                vL.merge = true;
            }
            vL = vL.vNxt;
        }
    }

    private void mergeVals(boolean vert) {
        this.findBestVals(this.mValList);
        ClrVal vL = this.mValList;
        while (vL != null) {
            vL.merge = false;
            vL = vL.vNxt;
        }
        while (true) {
            ClrVal vLst = this.mValList;
            vL = null;
            while (vLst != null) {
                if (!vLst.merge && (vL == null || this.compareValues(vLst.vBst, vL.vBst, 20, 0))) {
                    vL = vLst;
                }
                vLst = vLst.vNxt;
            }
            if (vL == null) break;
            vL.merge = true;
            boolean ghst = vL.vGhst;
            int b = vL.vLoc1;
            int t = vL.vLoc2;
            ClrSeg sg1 = vL.vSeg1;
            ClrSeg sg2 = vL.vSeg2;
            ClrVal bV = vL.vBst;
            int v = bV.vVal;
            int s = bV.vSpc;
            vLst = this.mValList;
            while (vLst != null) {
                if (!vLst.merge && ghst == vLst.vGhst) {
                    int bot = vLst.vLoc1;
                    int top = vLst.vLoc2;
                    if (bot != b || top != t) {
                        ClrVal bstV = vLst.vBst;
                        int val = bstV.vVal;
                        int spc = bstV.vSpc;
                        if (top == t && this.closeSegs(sg2, vLst.vSeg2, vert) && (vert || !this.inBlueBand(t, this.mLenTopBands, this.mTopBands) && !this.inBlueBand(bot, this.mLenBotBands, this.mBotBands) && !this.inBlueBand(b, this.mLenBotBands, this.mBotBands)) || bot == b && this.closeSegs(sg1, vLst.vSeg1, vert) && (vert || !this.inBlueBand(b, this.mLenBotBands, this.mBotBands) && !this.inBlueBand(t, this.mLenTopBands, this.mTopBands) && !this.inBlueBand(top, this.mLenTopBands, this.mTopBands)) || Math.abs(top - t) <= this.mMaxMerge && Math.abs(bot - b) <= this.mMaxMerge && (vert || t == top || !this.inBlueBand(top, this.mLenTopBands, this.mTopBands)) && (vert || b == bot || !this.inBlueBand(bot, this.mLenBotBands, this.mBotBands))) {
                            if (s == spc && val == v && !vert) {
                                if (this.inBlueBand(t, this.mLenTopBands, this.mTopBands)) {
                                    if (t > top) {
                                        this.replaceVals(bot, top, b, t, bV, vert);
                                    }
                                } else if (this.inBlueBand(b, this.mLenBotBands, this.mBotBands) && b < bot) {
                                    this.replaceVals(bot, top, b, t, bV, vert);
                                }
                            } else {
                                this.replaceVals(bot, top, b, t, bV, vert);
                            }
                        } else if (s == spc && sg1 != null && sg2 != null) {
                            ClrSeg seg1 = vLst.vSeg1;
                            ClrSeg seg2 = vLst.vSeg2;
                            if (seg1 != null && seg2 != null) {
                                if (Math.abs(bot - b) <= 256 && Math.abs(top - t) <= this.mMaxBendMerge) {
                                    if (seg2.sType == 1 && (vert || !this.inBlueBand(top, this.mLenTopBands, this.mTopBands))) {
                                        this.replaceVals(bot, top, b, t, bV, vert);
                                    }
                                } else if (Math.abs(top - t) <= 256 && Math.abs(bot - b) <= this.mMaxBendMerge && v > val && seg1.sType == 1 && (vert || !this.inBlueBand(bot, this.mLenBotBands, this.mBotBands))) {
                                    this.replaceVals(bot, top, b, t, bV, vert);
                                }
                            }
                        }
                    }
                }
                vLst = vLst.vNxt;
            }
            vL = vL.vNxt;
        }
    }

    private void initCheckData(CheckData d) {
        d.forMultiMaster = false;
    }

    private void chkBad(CheckData d) {
        d.reCheckSmooth = this.resolveConflictBySplit(d.e, false, null, null);
    }

    private boolean grTan(int n, int d) {
        return Math.abs(n) * 100 > Math.abs(d) * 25;
    }

    private boolean lsTan(int n, int d) {
        return Math.abs(n) * 100 < Math.abs(d) * 25;
    }

    private void chkYDIR(CheckData d) {
        if (d.y > d.yloc) {
            if (d.ystate == 1) {
                return;
            }
            if (d.ystate == 0) {
                d.ystart = (d.ystate = 1);
            } else {
                if (d.ystart == 1) {
                    d.yflatendx = d.xloc;
                    d.yflatendy = d.yloc;
                } else if (!d.yflat) {
                    d.yflatstartx = d.xloc;
                    d.yflatstarty = d.yloc;
                    d.yflat = true;
                }
                d.ystate = 1;
            }
        } else if (d.y < d.yloc) {
            if (d.ystate == 2) {
                return;
            }
            if (d.ystate == 0) {
                d.ystart = (d.ystate = 2);
            } else {
                if (d.ystart == 2) {
                    d.yflatendx = d.xloc;
                    d.yflatendy = d.yloc;
                } else if (!d.yflat) {
                    d.yflatstartx = d.xloc;
                    d.yflatstarty = d.yloc;
                    d.yflat = true;
                }
                d.ystate = 2;
            }
        }
    }

    private void chkYFLAT(CheckData d) {
        if (!d.yflat) {
            if (this.lsTan(d.y - d.yloc, d.x - d.xloc)) {
                d.yflat = true;
                d.yflatstartx = d.xloc;
                d.yflatstarty = d.yloc;
            }
            return;
        }
        if (d.ystate != d.ystart) {
            return;
        }
        if (this.grTan(d.y - d.yloc, d.x - d.xloc)) {
            d.yflatendx = d.xloc;
            d.yflatendy = d.yloc;
            d.ydone = true;
        }
    }

    private void chkXFLAT(CheckData d) {
        if (!d.xflat) {
            if (this.lsTan(d.x - d.xloc, d.y - d.yloc)) {
                d.xflat = true;
                d.xflatstartx = d.xloc;
                d.xflatstarty = d.yloc;
            }
            return;
        }
        if (d.xstate != d.xstart) {
            return;
        }
        if (this.grTan(d.x - d.xloc, d.y - d.yloc)) {
            d.xflatendx = d.xloc;
            d.xflatendy = d.yloc;
            d.xdone = true;
        }
    }

    private void chkXDIR(CheckData d) {
        if (d.x > d.xloc) {
            if (d.xstate == 1) {
                return;
            }
            if (d.xstate == 0) {
                d.xstart = (d.xstate = 1);
            } else {
                if (d.xstart == 1) {
                    d.xflatendx = d.xloc;
                    d.xflatendy = d.yloc;
                } else if (!d.xflat) {
                    d.xflatstartx = d.xloc;
                    d.xflatstarty = d.yloc;
                    d.xflat = true;
                }
                d.xstate = 1;
            }
        } else if (d.x < d.xloc) {
            if (d.xstate == 2) {
                return;
            }
            if (d.xstate == 0) {
                d.xstart = (d.xstate = 2);
            } else {
                if (d.xstart == 2) {
                    d.xflatendx = d.xloc;
                    d.xflatendy = d.yloc;
                } else if (!d.xflat) {
                    d.xflatstartx = d.xloc;
                    d.xflatstarty = d.yloc;
                    d.xflat = true;
                }
                d.xstate = 2;
            }
        }
    }

    private void chkDT(Object param, Cd c) {
        CheckData d = (CheckData)param;
        d.x = c.x;
        d.y = c.y;
        d.ynxt = d.y;
        d.xnxt = d.x;
        if (!d.ydone) {
            this.chkYDIR(d);
            this.chkYFLAT(d);
            if (d.ydone && d.yflat && Math.abs(d.yflatstarty - d.cy0) > this.fixInt(4) && Math.abs(d.cy1 - d.yflatendy) > this.fixInt(4)) {
                if (d.ystart == 1 && d.yflatstarty - d.yflatendy > this.fixInt(4) || d.ystart == 2 && d.yflatendy - d.yflatstarty > this.fixInt(4)) {
                    if (this.mEditChar && !d.forMultiMaster) {
                        this.chkBad(d);
                    }
                    return;
                }
                if (Math.abs(d.yflatstartx - d.yflatendx) > this.fixInt(5) && !d.forMultiMaster) {
                    this.addHSegment(d.yflatstartx, d.yflatendx, (d.yflatstarty + d.yflatendy) / 2, d.e, null, 2, 13);
                }
            }
        }
        if (!d.xdone) {
            this.chkXDIR(d);
            this.chkXFLAT(d);
            if (d.xdone && d.xflat && Math.abs(d.xflatstartx - d.x0) > this.fixInt(4) && Math.abs(d.x1 - d.xflatendx) > this.fixInt(4)) {
                if (d.xstart == 1 && d.xflatstartx - d.xflatendx > this.fixInt(4) || d.xstart == 2 && d.xflatendx - d.xflatstartx > this.fixInt(4)) {
                    if (this.mEditChar && !d.forMultiMaster) {
                        this.chkBad(d);
                    }
                    return;
                }
                if (Math.abs(d.xflatstarty - d.xflatendy) > this.fixInt(5) && !d.forMultiMaster) {
                    this.addVSegment(d.xflatstarty, d.xflatendy, (d.xflatstartx + d.xflatendx) / 2, d.e, null, 2, 13);
                }
            }
        }
        d.xloc = d.xnxt;
        d.yloc = d.ynxt;
    }

    private int cpDirection(int x1, int cy1, int x2, int y2, int x3, int y3) {
        int q1 = (x2 >> 6) * (y3 - cy1 >> 6);
        int q2 = (x1 >> 6) * (y2 - y3 >> 6);
        int q3 = (x3 >> 6) * (cy1 - y2 >> 6);
        int q = q1 + q2 + q3;
        if (q > 0) {
            return 1;
        }
        if (q < 0) {
            return -1;
        }
        return 0;
    }

    private void rMovePoint(int dx, int dy, int whichcp, PathElt e) {
        if (whichcp == 0) {
            e = e.prev;
            whichcp = 3;
        }
        if (whichcp == 3) {
            if (e.type == 3) {
                e = this.getDest(e);
            }
            if (e.type == 2) {
                e.x3 += dx;
                e.y3 += dy;
            } else {
                e.x += dx;
                e.y += dy;
            }
            return;
        }
        if (whichcp == 1) {
            e.x1 += dx;
            e.y1 += dy;
            return;
        }
        if (whichcp == 2) {
            e.x2 += dx;
            e.y2 += dy;
            return;
        }
    }

    private void delete(PathElt e) {
        PathElt nxt = e.next;
        PathElt prv = e.prev;
        if (nxt != null) {
            nxt.prev = prv;
        } else {
            this.mPathEnd = prv;
        }
        if (prv != null) {
            prv.next = nxt;
        } else {
            this.mPathStart = nxt;
        }
    }

    private void checkSCurve(CheckData d, PathElt ee) {
        FltnRec fr = new FltnRec();
        Cd c0 = new Cd();
        Cd c1 = new Cd();
        Cd c2 = new Cd();
        Cd c3 = new Cd();
        this.getEndPoint(ee.prev, c0);
        fr.report = 2;
        fr.param = d;
        c1.x = ee.x1;
        c1.y = ee.y1;
        c2.x = ee.x2;
        c2.y = ee.y2;
        c3.x = ee.x3;
        c3.y = ee.y3;
        d.xstate = (d.ystate = 0);
        d.xdone = (d.ydone = (d.xflat = (d.yflat = false)));
        d.x0 = c0.x;
        d.cy0 = c0.y;
        d.x1 = c3.x;
        d.cy1 = c3.y;
        d.xloc = d.x0;
        d.yloc = d.cy0;
        d.e = ee;
        d.forMultiMaster = false;
        this.fltnCurve(c0, c1, c2, c3, fr);
    }

    private void checkZeroLength(CheckData d) {
        Cd cd0 = new Cd();
        Cd cd1 = new Cd();
        PathElt e = this.mPathStart;
        while (e != null) {
            PathElt NxtE = e.next;
            this.getEndPoints(e, cd0, cd1);
            if (e.type == 1 && cd0.x == cd1.x && cd0.y == cd1.y) {
                this.delete(e);
            } else if (e.type == 2) {
                int x2 = e.x1;
                int y2 = e.y1;
                int x3 = e.x2;
                int y3 = e.y2;
                if (cd0.x == cd1.x && cd0.y == cd1.y && x2 == cd1.x && x3 == cd1.x && y2 == cd1.y && y3 == cd1.y) {
                    this.delete(e);
                }
            }
            e = NxtE;
        }
    }

    private void checkSmooth() {
        Cd cd0 = new Cd();
        Cd cd1 = new Cd();
        Cd cd2 = new Cd();
        Cd tmp = new Cd();
        CheckData data = new CheckData();
        this.initCheckData(data);
        this.checkZeroLength(data);
        do {
            data.reCheckSmooth = false;
            PathElt e = this.mPathStart;
            while (e != null) {
                PathElt NxtE = e.next;
                if (e.type != 0 && !this.isTiny(e) && !e.isFlex) {
                    PathElt nxt;
                    this.getEndPoint(e, cd1);
                    if (e.type == 2) {
                        cd2.x = e.x1;
                        cd2.y = e.y1;
                        int x3 = e.x2;
                        int y3 = e.y2;
                        this.getEndPoint(e.prev, cd0);
                        int cpd0 = this.cpDirection(cd0.x, cd0.y, cd2.x, cd2.y, x3, y3);
                        int cpd1 = this.cpDirection(cd2.x, cd2.y, x3, y3, cd1.x, cd1.y);
                        if (this.prodLt0(cpd0, cpd1)) {
                            this.checkSCurve(data, e);
                        }
                    }
                    if (!(nxt = this.nxtForBend(e, cd2, tmp)).isFlex) {
                        this.prvForBend(nxt, cd0);
                    }
                }
                e = NxtE;
            }
        } while (data.reCheckSmooth);
    }

    private void chkBBDT(Object param, Cd c) {
        CheckData d = (CheckData)param;
        int x = c.x;
        int y = c.y;
        if (d.bbquit) {
            return;
        }
        if (d.vert) {
            d.lst = y;
            if (!d.started && Math.abs(x - d.loc) <= this.fixInt(10)) {
                d.started = true;
                d.frst = y;
            } else if (d.started && Math.abs(x - d.loc) > this.fixInt(10)) {
                d.bbquit = true;
            }
        } else {
            d.lst = x;
            if (!d.started && Math.abs(y - d.loc) <= this.fixInt(10)) {
                d.started = true;
                d.frst = x;
            } else if (d.started && Math.abs(y - d.loc) > this.fixInt(10)) {
                d.bbquit = true;
            }
        }
    }

    private void checkForMultiMoveTo() {
        PathElt e = this.mPathStart;
        boolean moveto = false;
        while (e != null) {
            if (e.type != 0) {
                moveto = false;
            } else if (!moveto) {
                moveto = true;
            } else {
                this.delete(e.prev);
            }
            e = e.next;
        }
    }

    private void checkBBoxEdge(PathElt e, boolean vrt, int lc, int[] pf, int[] pl) {
        CheckData data = new CheckData();
        FltnRec fr = new FltnRec();
        Cd c0 = new Cd();
        Cd c1 = new Cd();
        Cd c2 = new Cd();
        Cd c3 = new Cd();
        this.getEndPoint(e.prev, c0);
        fr.report = 3;
        fr.param = data;
        data.bbquit = false;
        c1.x = e.x1;
        c1.y = e.y1;
        c2.x = e.x2;
        c2.y = e.y2;
        c3.x = e.x3;
        c3.y = e.y3;
        data.loc = lc;
        data.vert = vrt;
        data.started = false;
        this.chkBBDT(data, c0);
        this.fltnCurve(c0, c1, c2, c3, fr);
        pf[0] = data.frst;
        pl[0] = data.lst;
    }

    private void moveSubpathToEnd(PathElt e) {
        PathElt subEnd = e.type == 3 ? e : this.getClosedBy(e);
        PathElt subStart = this.getDest(subEnd);
        if (subEnd == this.mPathEnd) {
            return;
        }
        PathElt subNext = subEnd.next;
        if (subStart == this.mPathStart) {
            this.mPathStart = subNext;
            subNext.prev = null;
        } else {
            PathElt subPrev = subStart.prev;
            subPrev.next = subNext;
            subNext.prev = subPrev;
        }
        this.mPathEnd.next = subStart;
        subStart.prev = this.mPathEnd;
        subEnd.next = null;
        this.mPathEnd = subEnd;
    }

    private void initPick() {
    }

    private boolean ltPruneB(int val) {
        return val < 256 && val << 10 < this.mPruneB;
    }

    private boolean considerPicking(int bestSpc, int bestVal, ClrVal colorList, int prevBestVal) {
        if (bestSpc > 0) {
            return true;
        }
        if (colorList == null) {
            return bestVal >= this.mPruneD;
        }
        if (bestVal > this.mPruneA) {
            return true;
        }
        if (this.ltPruneB(bestVal)) {
            return false;
        }
        return bestVal < Integer.MAX_VALUE / this.mPruneC ? prevBestVal <= bestVal * this.mPruneC : prevBestVal / this.mPruneC <= bestVal;
    }

    private void pickVVals(ClrVal valList) {
        ClrVal nxt;
        ClrVal vlist;
        int bestVal = 0;
        ClrVal rejectList = null;
        ClrVal colorList = null;
        int prevBestVal = 0;
        block0: while (true) {
            vlist = valList;
            ClrVal best = null;
            ClrVal bestPrev = null;
            ClrVal prev = null;
            while (vlist != null) {
                if ((best == null || this.compareValues(vlist, best, 1000, 0)) && this.considerPicking(vlist.vSpc, vlist.vVal, colorList, prevBestVal)) {
                    best = vlist;
                    bestPrev = prev;
                    bestVal = vlist.vVal;
                }
                prev = vlist;
                vlist = vlist.vNxt;
            }
            if (best == null) break;
            if (bestPrev == null) {
                valList = best.vNxt;
            } else {
                bestPrev.vNxt = best.vNxt;
            }
            best.vNxt = colorList;
            colorList = best;
            prevBestVal = bestVal;
            int lft = best.vLoc1 - this.mBandMargin;
            int rght = best.vLoc2 + this.mBandMargin;
            vlist = valList;
            prev = null;
            while (true) {
                if (vlist == null) continue block0;
                int vlft = vlist.vLoc1;
                int vrght = vlist.vLoc2;
                if (vlft <= rght && vrght >= lft) {
                    nxt = vlist.vNxt;
                    vlist.vNxt = rejectList;
                    rejectList = vlist;
                    vlist = nxt;
                    if (prev == null) {
                        valList = vlist;
                        continue;
                    }
                    prev.vNxt = vlist;
                    continue;
                }
                prev = vlist;
                vlist = vlist.vNxt;
            }
            break;
        }
        vlist = valList;
        while (vlist != null) {
            nxt = vlist.vNxt;
            vlist.vNxt = rejectList;
            rejectList = vlist;
            vlist = nxt;
        }
        if (colorList == null) {
            this.clrVBnds(this.mBBox);
        }
        this.mVcoloring = colorList;
    }

    private boolean inSerifBand(int y0, int y1, int n, int[] p) {
        if (n <= 0) {
            return false;
        }
        if ((y0 = this.itfmy(y0)) > (y1 = this.itfmy(y1))) {
            int tmp = y1;
            y1 = y0;
            y0 = tmp;
        }
        for (int i = 0; i < n; i += 2) {
            if (p[i] > y0 || p[i + 1] < y1) continue;
            return true;
        }
        return false;
    }

    private boolean considerValForSeg(ClrVal val, ClrSeg seg, int loc, int nb, int[] b, int ns, int[] s, boolean primary) {
        if (primary && (double)val.vSpc > 0.0) {
            return true;
        }
        if (this.inBlueBand(loc, nb, b)) {
            return true;
        }
        if ((double)val.vSpc <= 0.0 && this.inSerifBand(seg.sMax, seg.sMin, ns, s)) {
            return false;
        }
        return !this.ltPruneB(val.vVal);
    }

    private ClrVal fndBstVal(ClrSeg seg, boolean seg1Flg, ClrVal cList, ClrVal rList, int nb, int[] b, int ns, int[] s, boolean locFlg, boolean hFlg) {
        ClrVal best = null;
        int loc = seg.sLoc;
        ClrVal vList = cList;
        while (true) {
            ClrVal initLst = vList;
            while (vList != null) {
                int vloc;
                ClrSeg vseg;
                if (seg1Flg) {
                    vseg = vList.vSeg1;
                    vloc = vList.vLoc1;
                } else {
                    vseg = vList.vSeg2;
                    vloc = vList.vLoc2;
                }
                if (Math.abs(loc - vloc) <= this.mMaxMerge && (locFlg ? !vList.vGhst : vseg == seg || this.closeSegs(seg, vseg, !hFlg)) && (best == null || vList.vVal == best.vVal && vList.vSpc == best.vSpc && vList.initVal > best.initVal || this.compareValues(vList, best, 1000, 3)) && this.considerValForSeg(vList, seg, loc, nb, b, ns, s, true)) {
                    best = vList;
                }
                vList = vList.vNxt;
            }
            if (initLst == rList) break;
            vList = rList;
        }
        return best;
    }

    private ClrVal findBestValForSeg(ClrSeg seg, boolean seg1Flg, ClrVal cList, ClrVal rList, int nb, int[] b, int ns, int[] s, boolean hFlg) {
        ClrVal nonghst;
        ClrVal ghst = null;
        ClrVal best = this.fndBstVal(seg, seg1Flg, cList, rList, nb, b, ns, s, false, hFlg);
        if (best != null && best.vGhst && (nonghst = this.fndBstVal(seg, seg1Flg, cList, rList, nb, b, ns, s, true, hFlg)) != null && nonghst.vVal >= this.fixInt(2)) {
            ghst = best;
            best = nonghst;
        }
        if (best != null) {
            if (best.vVal < 16 && (ghst == null || ghst.vVal < 16)) {
                best = null;
            } else {
                best.pruned = false;
            }
        }
        return best;
    }

    private boolean membValList(ClrVal val, ClrVal vList) {
        while (vList != null) {
            if (val == vList) {
                return true;
            }
            vList = vList.vNxt;
        }
        return false;
    }

    private ClrVal prevVal(ClrVal val, ClrVal vList) {
        if (val == vList) {
            return null;
        }
        ClrVal prev = vList;
        while ((vList = vList.vNxt) != val) {
            prev = vList;
        }
        return prev;
    }

    private void pickHVals(ClrVal valList) {
        ClrVal nxt;
        ClrVal vlist;
        int bestVal = 0;
        ClrVal rejectList = null;
        ClrVal colorList = null;
        int prevBestVal = 0;
        block0: while (true) {
            vlist = valList;
            ClrVal best = null;
            ClrVal bestPrev = null;
            ClrVal prev = null;
            while (vlist != null) {
                if ((best == null || this.compareValues(vlist, best, 1000, 0)) && this.considerPicking(vlist.vSpc, vlist.vVal, colorList, prevBestVal)) {
                    best = vlist;
                    bestPrev = prev;
                    bestVal = vlist.vVal;
                }
                prev = vlist;
                vlist = vlist.vNxt;
            }
            if (best != null) {
                ClrVal newBst;
                ClrSeg seg1 = best.vSeg1;
                ClrSeg seg2 = best.vSeg2;
                if (best.vGhst) {
                    vlist = valList;
                    while (vlist != null) {
                        if (vlist.vLoc2 == best.vLoc2 && vlist.vLoc1 == best.vLoc1 && !vlist.vGhst) {
                            seg1 = vlist.vSeg1;
                            seg2 = vlist.vSeg2;
                            break;
                        }
                        vlist = vlist.vNxt;
                    }
                }
                if (seg1.sType == 3) {
                    newBst = seg2.sLnk;
                    if (newBst != null && newBst != best && this.membValList(newBst, valList)) {
                        best = newBst;
                        bestPrev = this.prevVal(best, valList);
                    }
                } else if (seg2.sType == 3 && (newBst = seg2.sLnk) != null && newBst != best && this.membValList(newBst, valList)) {
                    best = newBst;
                    bestPrev = this.prevVal(best, valList);
                }
            }
            if (best == null) break;
            prevBestVal = bestVal;
            if (bestPrev == null) {
                valList = best.vNxt;
            } else {
                bestPrev.vNxt = best.vNxt;
            }
            best.vNxt = colorList;
            colorList = best;
            int bot = best.vLoc1;
            int top = best.vLoc2;
            if (best.vGhst) {
                if (best.vSeg1.sType == 3) {
                    bot = top;
                } else {
                    top = bot;
                }
            }
            bot -= this.mBandMargin;
            top += this.mBandMargin;
            vlist = valList;
            prev = null;
            while (true) {
                if (vlist == null) continue block0;
                int vbot = vlist.vLoc1;
                int vtop = vlist.vLoc2;
                if (vlist.vGhst) {
                    if (vlist.vSeg1.sType == 3) {
                        vbot = vtop;
                    } else {
                        vtop = vbot;
                    }
                }
                if (vbot <= top && vtop >= bot) {
                    nxt = vlist.vNxt;
                    vlist.vNxt = rejectList;
                    rejectList = vlist;
                    vlist = nxt;
                    if (prev == null) {
                        valList = vlist;
                        continue;
                    }
                    prev.vNxt = vlist;
                    continue;
                }
                prev = vlist;
                vlist = vlist.vNxt;
            }
            break;
        }
        vlist = valList;
        while (vlist != null) {
            nxt = vlist.vNxt;
            vlist.vNxt = rejectList;
            rejectList = vlist;
            vlist = nxt;
        }
        if (colorList == null) {
            this.clrHBnds(this.mBBox);
        }
        this.mHcoloring = colorList;
    }

    private void findBestValForSegs(ClrSeg sList, boolean seg1Flg, ClrVal cList, ClrVal rList, int nb, int[] b, int ns, int[] s, boolean hFlg) {
        while (sList != null) {
            ClrVal best = this.findBestValForSeg(sList, seg1Flg, cList, rList, nb, b, ns, s, hFlg);
            sList.sLnk = best;
            sList = sList.sNxt;
        }
    }

    private void setPruned() {
        ClrVal vL = this.mValList;
        while (vL != null) {
            vL.pruned = true;
            vL = vL.vNxt;
        }
    }

    private void findBestHVals() {
        this.setPruned();
        this.findBestValForSegs(this.topList(), false, this.mValList, null, this.mLenTopBands, this.mTopBands, 0, null, true);
        this.findBestValForSegs(this.botList(), true, this.mValList, null, this.mLenBotBands, this.mBotBands, 0, null, true);
        this.doPrune();
    }

    private void findBestVVals() {
        this.setPruned();
        this.findBestValForSegs(this.leftList(), true, this.mValList, null, 0, null, this.mNumSerifs, this.mSerifs, false);
        this.findBestValForSegs(this.rightList(), false, this.mValList, null, 0, null, this.mNumSerifs, this.mSerifs, false);
        this.doPrune();
    }

    private void fpBBoxPt(Object param, Cd c) {
        ACBBox bb = (ACBBox)param;
        if (c.x < bb.xmin) {
            bb.xmin = c.x;
            bb.pxmn = bb.pe;
        }
        if (c.x > bb.xmax) {
            bb.xmax = c.x;
            bb.pxmx = bb.pe;
        }
        if (c.y < bb.ymin) {
            bb.ymin = c.y;
            bb.pymn = bb.pe;
        }
        if (c.y > bb.ymax) {
            bb.ymax = c.y;
            bb.pymx = bb.pe;
        }
    }

    private boolean fpBBoxCurveShortCut(Cd c0, Cd c1, Cd c2, Cd c3, Object param) {
        ACBBox bb = (ACBBox)param;
        this.fpBBoxPt(param, c0);
        this.fpBBoxPt(param, c3);
        return this.inRange(c1.x, bb.xmin, bb.xmax) && this.inRange(c1.y, bb.ymin, bb.ymax) && this.inRange(c2.x, bb.xmin, bb.xmax) && this.inRange(c2.y, bb.ymin, bb.ymax);
    }

    private void findPathBBox(ACBBox bb) {
        if (this.mPathBBox != null) {
            bb.copyFrom(this.mPathBBox);
            return;
        }
        FltnRec fr = new FltnRec();
        Cd c0 = new Cd();
        Cd c1 = new Cd();
        Cd c2 = new Cd();
        Cd c3 = new Cd();
        if (this.mPathStart == null) {
            bb.xmin = (bb.ymin = (bb.xmax = (bb.ymax = 0)));
            bb.pxmn = (bb.pxmx = (bb.pymn = (bb.pymx = null)));
            return;
        }
        fr.report = 4;
        fr.param = bb;
        bb.xmin = (bb.ymin = this.fixInt(10000));
        bb.xmax = (bb.ymax = -bb.xmin);
        PathElt e = this.mPathStart;
        while (e != null) {
            switch (e.type) {
                case 0: 
                case 1: {
                    c0.x = e.x;
                    c0.y = e.y;
                    bb.pe = e;
                    this.fpBBoxPt(bb, c0);
                    break;
                }
                case 2: {
                    c1.x = e.x1;
                    c1.y = e.y1;
                    c2.x = e.x2;
                    c2.y = e.y2;
                    c3.x = e.x3;
                    c3.y = e.y3;
                    bb.pe = e;
                    if (!this.fpBBoxCurveShortCut(c0, c1, c2, c3, bb)) {
                        this.fltnCurve(c0, c1, c2, c3, fr);
                    }
                    c0.copyFrom(c3);
                    break;
                }
            }
            e = e.next;
        }
        bb.xmin = this.fHalfRnd(bb.xmin);
        bb.ymin = this.fHalfRnd(bb.ymin);
        bb.xmax = this.fHalfRnd(bb.xmax);
        bb.ymax = this.fHalfRnd(bb.ymax);
        this.mPathBBox = new ACBBox();
        this.mPathBBox.copyFrom(bb);
    }

    private PathElt calcSubpathBBox(ACBBox bb, PathElt e) {
        FltnRec fr = new FltnRec();
        Cd c0 = new Cd();
        Cd c1 = new Cd();
        Cd c2 = new Cd();
        Cd c3 = new Cd();
        if (e == null) {
            bb.xmin = (bb.ymin = (bb.xmax = (bb.ymax = 0)));
            bb.pxmn = (bb.pxmx = (bb.pymn = (bb.pymx = null)));
            return null;
        }
        fr.report = 4;
        fr.param = bb;
        bb.xmin = (bb.ymin = this.fixInt(10000));
        bb.xmax = (bb.ymax = -bb.xmin);
        if (e.type != 0) {
            e = this.getDest(e);
        }
        while (e != null) {
            switch (e.type) {
                case 0: 
                case 1: {
                    c0.x = e.x;
                    c0.y = e.y;
                    bb.pe = e;
                    this.fpBBoxPt(bb, c0);
                    break;
                }
                case 2: {
                    c1.x = e.x1;
                    c1.y = e.y1;
                    c2.x = e.x2;
                    c2.y = e.y2;
                    c3.x = e.x3;
                    c3.y = e.y3;
                    bb.pe = e;
                    if (!this.fpBBoxCurveShortCut(c0, c1, c2, c3, bb)) {
                        this.fltnCurve(c0, c1, c2, c3, fr);
                    }
                    c0.copyFrom(c3);
                    break;
                }
                case 3: {
                    e = e.next;
                    bb.xmin = this.fHalfRnd(bb.xmin);
                    bb.ymin = this.fHalfRnd(bb.ymin);
                    bb.xmax = this.fHalfRnd(bb.xmax);
                    bb.ymax = this.fHalfRnd(bb.ymax);
                    return e;
                }
            }
            e = e.next;
        }
        bb.xmin = this.fHalfRnd(bb.xmin);
        bb.ymin = this.fHalfRnd(bb.ymin);
        bb.xmax = this.fHalfRnd(bb.xmax);
        bb.ymax = this.fHalfRnd(bb.ymax);
        return e;
    }

    private PathElt findSubpathBBox(ACBBox bb, PathElt e) {
        if (this.mSubPaths != null) {
            for (int i = 0; i < this.mNumSubPaths; ++i) {
                if (this.mSubPaths[i].head != e) continue;
                bb.copyFrom(this.mSubPaths[i].bbox);
                e = this.mSubPaths[i].tail;
                if (e != null) {
                    e = e.next;
                }
                return e;
            }
        }
        return this.calcSubpathBBox(bb, e);
    }

    private void findCurveBBox(int x0, int y0, int px1, int py1, int px2, int py2, int x1, int y1, Cd ll, Cd ur) {
        FltnRec fr = new FltnRec();
        Cd c0 = new Cd();
        Cd c1 = new Cd();
        Cd c2 = new Cd();
        Cd c3 = new Cd();
        ACBBox bbox = new ACBBox();
        fr.report = 4;
        fr.param = bbox;
        bbox.xmin = (bbox.ymin = this.fixInt(10000));
        bbox.xmax = (bbox.ymax = -bbox.xmin);
        c0.x = x0;
        c0.y = y0;
        c1.x = px1;
        c1.y = py1;
        c2.x = px2;
        c2.y = py2;
        c3.x = x1;
        c3.y = y1;
        this.fpBBoxPt(bbox, c0);
        this.fltnCurve(c0, c1, c2, c3, fr);
        ll.x = this.fHalfRnd(bbox.xmin);
        ll.y = this.fHalfRnd(bbox.ymin);
        ur.x = this.fHalfRnd(bbox.xmax);
        ur.y = this.fHalfRnd(bbox.ymax);
    }

    private void clrVBnds(ACBBox bb) {
        if (this.mPathStart == null || this.mDoCounters && this.vColorChar(this.mUnicode)) {
            return;
        }
        this.findPathBBox(bb);
        bb.vMn = this.itfmx(bb.xmin);
        bb.vMx = this.itfmx(bb.xmax);
        bb.pvMn = bb.pxmn;
        bb.pvMx = bb.pxmx;
        if (bb.vMn > bb.vMx) {
            int tmp = bb.vMn;
            bb.vMn = bb.vMx;
            bb.vMx = tmp;
            PathElt p = bb.pvMn;
            bb.pvMn = bb.pvMx;
            bb.pvMx = p;
        }
        this.addColorPoint(bb.vMn, 0, bb.vMx, 0, 'y', bb.pvMn, bb.pvMx);
    }

    private void reClrVBnds(ACBBox bb) {
        this.addColorPoint(bb.vMn, 0, bb.vMx, 0, 'y', bb.pvMn, bb.pvMx);
    }

    private void clrHBnds(ACBBox bb) {
        if (this.mPathStart == null || this.mDoCounters && this.hColorChar(this.mUnicode)) {
            return;
        }
        this.findPathBBox(bb);
        bb.hMn = this.itfmy(bb.ymin);
        bb.hMx = this.itfmy(bb.ymax);
        bb.phMn = bb.pymn;
        bb.phMx = bb.pymx;
        if (bb.hMn > bb.hMx) {
            int tmp = bb.hMn;
            bb.hMn = bb.hMx;
            bb.hMx = tmp;
            PathElt p = bb.phMn;
            bb.phMn = bb.phMx;
            bb.phMx = p;
        }
        this.addColorPoint(0, bb.hMn, 0, bb.hMx, 'b', bb.phMn, bb.phMx);
    }

    private void reClrHBnds(ACBBox bb) {
        this.addColorPoint(0, bb.hMn, 0, bb.hMx, 'b', bb.phMn, bb.phMx);
    }

    private boolean checkValOverlaps(int lft, int rht, ClrVal lst, boolean xflg) {
        int tmp;
        if (xflg) {
            lft = this.itfmx(lft);
            rht = this.itfmx(rht);
        } else {
            lft = this.itfmy(lft);
            rht = this.itfmy(rht);
        }
        if (lft > rht) {
            tmp = lft;
            lft = rht;
            rht = tmp;
        }
        while (lst != null) {
            int lft2 = lst.vLoc1;
            int rht2 = lst.vLoc2;
            if (xflg) {
                lft2 = this.itfmx(lft2);
                rht2 = this.itfmx(rht2);
            } else {
                lft2 = this.itfmy(lft2);
                rht2 = this.itfmy(rht2);
            }
            if (lft2 > rht2) {
                tmp = lft2;
                lft2 = rht2;
                rht2 = tmp;
            }
            if (lft2 <= rht && lft <= rht2) {
                return true;
            }
            lst = lst.vNxt;
        }
        return false;
    }

    private void addBBoxHV(boolean Hflg, boolean subs) {
        PathElt e = this.mPathStart;
        while (e != null) {
            ClrSeg seg2;
            ClrSeg seg1;
            ClrVal val;
            ACBBox bbox = new ACBBox();
            if (subs) {
                e = this.findSubpathBBox(bbox, e);
            } else {
                this.findPathBBox(bbox);
                e = null;
            }
            if (!Hflg) {
                if (this.checkValOverlaps(bbox.xmin, bbox.xmax, this.mVcoloring, true)) continue;
                val = new ClrVal();
                val.cvlSN = ++this.mCvlSN;
                seg1 = new ClrSeg();
                seg1.csgSN = ++this.mCsgSN;
                seg1.sLoc = bbox.xmin;
                seg1.sElt = bbox.pxmn;
                seg1.sBonus = 0;
                seg1.sType = (short)0;
                seg1.sMin = bbox.ymin;
                seg1.sMax = bbox.ymax;
                seg1.sNxt = null;
                seg1.sLnk = null;
                seg2 = new ClrSeg();
                seg2.csgSN = ++this.mCsgSN;
                seg2.sLoc = bbox.xmax;
                seg2.sElt = bbox.pxmx;
                seg2.sBonus = 0;
                seg2.sType = (short)0;
                seg2.sMin = bbox.ymin;
                seg2.sMax = bbox.ymax;
                seg2.sNxt = null;
                seg2.sLnk = null;
                val.vVal = 100;
                val.vSpc = 0;
                val.vLoc1 = bbox.xmin;
                val.vLoc2 = bbox.xmax;
                val.vSeg1 = seg1;
                val.vSeg2 = seg2;
                val.vGhst = false;
                val.vNxt = this.mVcoloring;
                val.vBst = val;
                this.mVcoloring = val;
                continue;
            }
            if (this.checkValOverlaps(bbox.ymin, bbox.ymax, this.mHcoloring, false)) continue;
            val = new ClrVal();
            val.cvlSN = ++this.mCvlSN;
            seg1 = new ClrSeg();
            seg1.csgSN = ++this.mCsgSN;
            seg1.sLoc = bbox.ymax;
            seg1.sElt = bbox.pymx;
            seg1.sBonus = 0;
            seg1.sType = (short)0;
            seg1.sMin = bbox.xmin;
            seg1.sMax = bbox.xmax;
            seg1.sNxt = null;
            seg1.sLnk = null;
            seg2 = new ClrSeg();
            seg2.csgSN = ++this.mCsgSN;
            seg2.sLoc = bbox.ymin;
            seg2.sElt = bbox.pymn;
            seg2.sBonus = 0;
            seg2.sType = (short)0;
            seg2.sMin = bbox.xmin;
            seg2.sMax = bbox.xmax;
            seg2.sNxt = null;
            seg2.sLnk = null;
            val.vVal = 100;
            val.vSpc = 0;
            val.vLoc1 = bbox.ymax;
            val.vLoc2 = bbox.ymin;
            val.vSeg1 = seg1;
            val.vSeg2 = seg2;
            val.vGhst = false;
            val.vNxt = this.mHcoloring;
            val.vBst = val;
            this.mHcoloring = val;
        }
    }

    private boolean checkBBoxes(PathElt e1, PathElt e2) {
        ACBBox bbox = new ACBBox();
        if ((e1 = this.getDest(e1)) == (e2 = this.getDest(e2))) {
            return true;
        }
        this.findSubpathBBox(bbox, e1);
        int xmn = bbox.xmin;
        int xmx = bbox.xmax;
        int ymn = bbox.ymin;
        int ymx = bbox.ymax;
        this.findSubpathBBox(bbox, e2);
        return xmn <= bbox.xmin && bbox.xmax <= xmx && ymn <= bbox.ymin && bbox.ymax <= ymx || xmn >= bbox.xmin && bbox.xmax >= xmx && ymn >= bbox.ymin && bbox.ymax >= ymx;
    }

    private void newBest(WriteData wd, ClrPoint lst) {
        wd.bst = lst;
        wd.bch = lst.c;
        if (wd.bch == 'y' || wd.bch == 'm') {
            wd.bstB = true;
            int x0 = lst.x0;
            int x1 = lst.x1;
            wd.bx = Math.min(x0, x1);
        } else {
            wd.bstB = false;
            int y0 = lst.y0;
            int y1 = lst.y1;
            wd.by = Math.min(y0, y1);
        }
    }

    private void writePointItem(WriteData wd, ClrPoint lst) {
        int v2;
        int v1;
        int flags = 0;
        switch (lst.c) {
            case 'v': {
                flags = 4;
                v1 = lst.y0;
                v2 = lst.y1;
                break;
            }
            case 'b': {
                v1 = lst.y0;
                v2 = lst.y1;
                break;
            }
            case 'm': {
                flags = 5;
                v1 = lst.x0;
                v2 = lst.x1;
                break;
            }
            case 'y': {
                flags = 1;
                v1 = lst.x0;
                v2 = lst.x1;
                break;
            }
            default: {
                return;
            }
        }
        int width = v2 - v1;
        if (width == this.fixInt(-20)) {
            v1 = this.unScaleAbs(v1);
            v2 = v1 + width;
        } else if (width == this.fixInt(-21)) {
            v2 = this.unScaleAbs(v2);
            v1 = v2 - width;
        } else {
            v1 = this.unScaleAbs(v1);
            v2 = this.unScaleAbs(v2);
        }
        if (wd.hintArray == null) {
            wd.hintArray = new ArrayList();
        }
        HintData hp = new HintData();
        hp.flags = flags;
        hp.v1 = v1;
        hp.v2 = v2;
        wd.hintArray.add(hp);
    }

    private void flushHintArray(ArrayList ha) {
        if (this.mOutlineConsumer != null) {
            for (int i = 0; i < ha.size(); ++i) {
                HintData hp = (HintData)ha.get(i);
                int flags = hp.flags;
                if (i == 0) {
                    flags |= 8;
                }
                double fv1 = this.fixToFlt(hp.v1);
                double fv2 = this.fixToFlt(hp.v2);
                this.mOutlineConsumer.stem(fv1, fv2, (flags & 8) != 0, (flags & 1) != 0, false);
            }
        }
    }

    private boolean compareHintArray(ArrayList ha1, ArrayList ha2) {
        int size2;
        int size1 = ha1 == null ? 0 : ha1.size();
        int n = size2 = ha2 == null ? 0 : ha2.size();
        if (size1 != size2) {
            return false;
        }
        for (int i = 0; i < size1; ++i) {
            HintData h1 = (HintData)ha1.get(i);
            HintData h2 = (HintData)ha2.get(i);
            if (h1.flags == h2.flags && h1.v1 == h2.v1 && h1.v2 == h2.v2) continue;
            return false;
        }
        return true;
    }

    private void wrtPntLst(WriteData wd, ClrPoint lst) {
        ClrPoint ptLst = lst;
        while (lst != null) {
            lst.done = false;
            lst = lst.next;
        }
        while (true) {
            lst = ptLst;
            wd.bst = null;
            while (lst != null) {
                if (!lst.done) {
                    this.newBest(wd, lst);
                    break;
                }
                lst = lst.next;
            }
            if (wd.bst == null) break;
            lst = wd.bst.next;
            while (lst != null) {
                if (!lst.done) {
                    char ch = lst.c;
                    if (ch > wd.bch) {
                        this.newBest(wd, lst);
                    } else if (ch == wd.bch) {
                        if (wd.bstB) {
                            int x1;
                            int x0 = lst.x0;
                            if (Math.min(x0, x1 = lst.x1) < wd.bx) {
                                this.newBest(wd, lst);
                            }
                        } else {
                            int y1;
                            int y0 = lst.y0;
                            if (Math.min(y0, y1 = lst.y1) < wd.by) {
                                this.newBest(wd, lst);
                            }
                        }
                    }
                }
                lst = lst.next;
            }
            wd.bst.done = true;
            this.writePointItem(wd, wd.bst);
        }
    }

    private void wrtNewClrs(WriteData wd, PathElt e) {
        if (!wd.wrtColorInfo) {
            return;
        }
        wd.hintArray = null;
        this.wrtPntLst(wd, this.mPtLstArray[e.newcolors]);
        if (!this.compareHintArray(wd.prevHintArray, wd.hintArray)) {
            this.flushHintArray(wd.hintArray);
            wd.prevHintArray = new ArrayList(wd.hintArray);
        }
    }

    private boolean isFlex(WriteData wd, PathElt e) {
        PathElt e1;
        PathElt e0;
        if (wd.firstFlex) {
            e0 = e;
            e1 = e.next;
        } else {
            e0 = e.prev;
            e1 = e;
        }
        return e0 != null && e0.isFlex && e1 != null && e1.isFlex;
    }

    private void mt(WriteData wd, Cd c, PathElt e) {
        if (this.mOutlineConsumer != null) {
            if (e.newcolors != 0) {
                this.wrtNewClrs(wd, e);
            }
            double fcx = this.fixToFlt(c.x);
            double fcy = this.fixToFlt(c.y);
            this.mOutlineConsumer.moveto(fcx, fcy);
        }
    }

    private void dt(WriteData wd, Cd c, PathElt e) {
        if (this.mOutlineConsumer != null) {
            if (e.newcolors != 0) {
                this.wrtNewClrs(wd, e);
            }
            double fcx = this.fixToFlt(c.x);
            double fcy = this.fixToFlt(c.y);
            this.mOutlineConsumer.lineto(fcx, fcy);
        }
    }

    private void wrtFlex(WriteData wd, Cd c1, Cd c2, Cd c3, PathElt e) {
        if (this.mOutlineConsumer != null) {
            if (wd.firstFlex) {
                wd.fc1.copyFrom(c1);
                wd.fc2.copyFrom(c2);
                wd.fc3.copyFrom(c3);
                wd.firstFlex = false;
                return;
            }
            double fdmin = this.fixToFlt(this.mDMIN);
            double fc1x = this.fixToFlt(wd.fc1.x);
            double fc1y = this.fixToFlt(wd.fc1.y);
            double fc2x = this.fixToFlt(wd.fc2.x);
            double fc2y = this.fixToFlt(wd.fc2.y);
            double fc3x = this.fixToFlt(wd.fc3.x);
            double fc3y = this.fixToFlt(wd.fc3.y);
            double c1x = this.fixToFlt(c1.x);
            double c1y = this.fixToFlt(c1.y);
            double c2x = this.fixToFlt(c2.x);
            double c2y = this.fixToFlt(c2.y);
            double c3x = this.fixToFlt(c3.x);
            double c3y = this.fixToFlt(c3.y);
            this.mOutlineConsumer.flex(fdmin, fc1x, fc1y, fc2x, fc2y, fc3x, fc3y, c1x, c1y, c2x, c2y, c3x, c3y);
            wd.firstFlex = true;
        }
    }

    private void ct(WriteData wd, Cd c1, Cd c2, Cd c3, PathElt e) {
        if (this.mOutlineConsumer != null) {
            if (e.newcolors != 0) {
                this.wrtNewClrs(wd, e);
            }
            if (e.isFlex && this.isFlex(wd, e)) {
                this.wrtFlex(wd, c1, c2, c3, e);
            }
            double fc1x = this.fixToFlt(c1.x);
            double fc1y = this.fixToFlt(c1.y);
            double fc2x = this.fixToFlt(c2.x);
            double fc2y = this.fixToFlt(c2.y);
            double fc3x = this.fixToFlt(c3.x);
            double fc3y = this.fixToFlt(c3.y);
            this.mOutlineConsumer.curveto(fc1x, fc1y, fc2x, fc2y, fc3x, fc3y);
        }
    }

    private void cp(WriteData wd, PathElt e) {
        if (e.newcolors != 0) {
            this.wrtNewClrs(wd, e);
        }
    }

    private void beginGlyph() {
    }

    private void endGlyph() {
        if (this.mOutlineConsumer != null) {
            this.mOutlineConsumer.endchar();
        }
    }

    private boolean writeWidth() {
        if (this.mOutlineConsumer != null) {
            return this.mOutlineConsumer.width(this.mGlyphWidth);
        }
        return true;
    }

    private void numberPath() {
        PathElt e = this.mPathStart;
        short cnt = 1;
        while (e != null) {
            short s = cnt;
            cnt = (short)(cnt + 1);
            e.count = s;
            e = e.next;
        }
    }

    private void writeGlyph() {
        if (this.mDoWriteGlyph) {
            PathElt e = this.mPathStart;
            Cd c1 = new Cd();
            Cd c2 = new Cd();
            Cd c3 = new Cd();
            WriteData writeData = new WriteData();
            writeData.wrtColorInfo = this.mPathStart != null && this.mPathStart != this.mPathEnd;
            this.numberPath();
            this.beginGlyph();
            if (!this.writeWidth()) {
                return;
            }
            if (writeData.wrtColorInfo && e.newcolors == 0) {
                this.wrtPntLst(writeData, this.mPtLstArray[0]);
                this.flushHintArray(writeData.hintArray);
                writeData.prevHintArray = new ArrayList(writeData.hintArray);
            }
            writeData.firstFlex = true;
            while (e != null) {
                switch (e.type) {
                    case 2: {
                        c1.x = this.unScaleAbs(this.itfmx(e.x1));
                        c1.y = this.unScaleAbs(this.itfmy(e.y1));
                        c2.x = this.unScaleAbs(this.itfmx(e.x2));
                        c2.y = this.unScaleAbs(this.itfmy(e.y2));
                        c3.x = this.unScaleAbs(this.itfmx(e.x3));
                        c3.y = this.unScaleAbs(this.itfmy(e.y3));
                        this.ct(writeData, c1, c2, c3, e);
                        break;
                    }
                    case 1: {
                        c1.x = this.unScaleAbs(this.itfmx(e.x));
                        c1.y = this.unScaleAbs(this.itfmy(e.y));
                        this.dt(writeData, c1, e);
                        break;
                    }
                    case 0: {
                        c1.x = this.unScaleAbs(this.itfmx(e.x));
                        c1.y = this.unScaleAbs(this.itfmy(e.y));
                        this.mt(writeData, c1, e);
                        break;
                    }
                    case 3: {
                        this.cp(writeData, e);
                    }
                }
                e = e.next;
            }
            this.endGlyph();
            writeData.hintArray = null;
            writeData.prevHintArray = null;
        }
    }

    private void initFix() {
        this.mVFixCount = 0;
        this.mHFixCount = 0;
    }

    private void recordHFix(int y, int dy) {
        this.mHFixYs[this.mHFixCount] = y;
        this.mHFixDYs[this.mHFixCount] = dy;
        ++this.mHFixCount;
    }

    private void recordVFix(int x, int dx) {
        this.mVFixXs[this.mVFixCount] = x;
        this.mVFixDXs[this.mVFixCount] = dx;
        ++this.mVFixCount;
    }

    private void recordForFix(boolean vert, int w, int minW, int b, int t) {
        int mx;
        int mn;
        if (b < t) {
            mn = b;
            mx = t;
        } else {
            mn = t;
            mx = b;
        }
        if (!vert && this.mHFixCount + 4 < 100 && this.mAutoHFix) {
            int fixdy = w - minW;
            if (Math.abs(fixdy) <= 256) {
                this.recordHFix(mn, fixdy);
                this.recordHFix(mx - fixdy, fixdy);
            } else {
                int delta = this.fixHalfMul(fixdy);
                this.recordHFix(mn, delta);
                this.recordHFix(mn + fixdy, -delta);
                this.recordHFix(mx, -delta);
                this.recordHFix(mx - fixdy, delta);
            }
        } else if (vert && this.mVFixCount + 4 < 100 && this.mAutoVFix) {
            int fixdx = w - minW;
            if (Math.abs(fixdx) <= 256) {
                this.recordVFix(mn, fixdx);
                this.recordVFix(mx - fixdx, fixdx);
            } else {
                int delta = this.fixHalfMul(fixdx);
                this.recordVFix(mn, delta);
                this.recordVFix(mn + fixdx, -delta);
                this.recordVFix(mx, -delta);
                this.recordVFix(mx - fixdx, delta);
            }
        }
    }

    private boolean findLineSeg(int loc, ClrSeg sL) {
        while (sL != null) {
            if (sL.sLoc == loc && sL.sType == 0) {
                return true;
            }
            sL = sL.sNxt;
        }
        return false;
    }

    private void checkVal(ClrVal val, boolean vert) {
        int t;
        int b;
        int numstems;
        int[] stems;
        if (vert) {
            stems = this.mVStems;
            numstems = this.mNumVStems;
            b = this.itfmx(val.vLoc1);
            t = this.itfmx(val.vLoc2);
        } else {
            stems = this.mHStems;
            numstems = this.mNumHStems;
            b = this.itfmy(val.vLoc1);
            t = this.itfmy(val.vLoc2);
        }
        int w = Math.abs(t - b);
        int minDiff = this.fixInt(1000);
        int minW = 0;
        for (int i = 0; i < numstems; ++i) {
            int wd = stems[i];
            int diff = Math.abs(wd - w);
            if (diff >= minDiff) continue;
            minDiff = diff;
            minW = wd;
            if (minDiff == 0) break;
        }
        if (minDiff == 0 || minDiff > this.fixInt(2)) {
            return;
        }
        if (vert && this.mAutoVFix || !vert && this.mAutoHFix) {
            this.recordForFix(vert, w, minW, b, t);
        }
    }

    private void checkVals(ClrVal vlst, boolean vert) {
        while (vlst != null) {
            this.checkVal(vlst, vert);
            vlst = vlst.vNxt;
        }
    }

    private void fixH(PathElt e, int fixy, int fixdy) {
        PathElt nxt;
        this.rMovePoint(0, fixdy, 0, e);
        this.rMovePoint(0, fixdy, 3, e);
        PathElt prev = e.prev;
        if (prev != null && prev.type == 2 && prev.y2 == fixy) {
            this.rMovePoint(0, fixdy, 2, prev);
        }
        if (e.type == 3) {
            e = this.getDest(e);
        }
        if ((nxt = e.next) != null && nxt.type == 2 && nxt.y1 == fixy) {
            this.rMovePoint(0, fixdy, 1, nxt);
        }
    }

    private void fixHs(int fixy, int fixdy) {
        int xlst = 0;
        int ylst = 0;
        int xinit = 0;
        int yinit = 0;
        fixy = this.tfmy(fixy);
        fixdy = this.dtfmy(fixdy);
        PathElt e = this.mPathStart;
        while (e != null) {
            switch (e.type) {
                case 0: {
                    xlst = xinit = e.x;
                    ylst = yinit = e.y;
                    break;
                }
                case 1: {
                    if (e.y == fixy && ylst == fixy) {
                        this.fixH(e, fixy, fixdy);
                    }
                    xlst = e.x;
                    ylst = e.y;
                    break;
                }
                case 2: {
                    xlst = e.x3;
                    ylst = e.y3;
                    break;
                }
                case 3: {
                    if (yinit != fixy || ylst != fixy || xinit == xlst) break;
                    this.fixH(e, fixy, fixdy);
                }
            }
            e = e.next;
        }
    }

    private void fixV(PathElt e, int fixx, int fixdx) {
        PathElt nxt;
        this.rMovePoint(fixdx, 0, 0, e);
        this.rMovePoint(fixdx, 0, 3, e);
        PathElt prev = e.prev;
        if (prev != null && prev.type == 2 && prev.x2 == fixx) {
            this.rMovePoint(fixdx, 0, 2, prev);
        }
        if (e.type == 3) {
            e = this.getDest(e);
        }
        if ((nxt = e.next) != null && nxt.type == 2 && nxt.x1 == fixx) {
            this.rMovePoint(fixdx, 0, 1, nxt);
        }
    }

    private void fixVs(int fixx, int fixdx) {
        int xlst = 0;
        int ylst = 0;
        int xinit = 0;
        int yinit = 0;
        fixx = this.tfmx(fixx);
        fixdx = this.dtfmx(fixdx);
        PathElt e = this.mPathStart;
        while (e != null) {
            switch (e.type) {
                case 0: {
                    xlst = xinit = e.x;
                    ylst = yinit = e.y;
                    break;
                }
                case 1: {
                    if (e.x == fixx && xlst == fixx) {
                        this.fixV(e, fixx, fixdx);
                    }
                    xlst = e.x;
                    ylst = e.y;
                    break;
                }
                case 2: {
                    xlst = e.x3;
                    ylst = e.y3;
                    break;
                }
                case 3: {
                    if (xinit != fixx || xlst != fixx || yinit == ylst) break;
                    this.fixV(e, fixx, fixdx);
                }
            }
            e = e.next;
        }
    }

    private boolean doFixes() {
        int i;
        boolean didfixes = false;
        if (this.mHFixCount > 0 && this.mAutoHFix) {
            didfixes = true;
            for (i = 0; i < this.mHFixCount; ++i) {
                this.fixHs(this.mHFixYs[i], this.mHFixDYs[i]);
            }
        }
        if (this.mVFixCount > 0 && this.mAutoVFix) {
            didfixes = true;
            for (i = 0; i < this.mVFixCount; ++i) {
                this.fixVs(this.mVFixXs[i], this.mVFixDXs[i]);
            }
        }
        return didfixes;
    }

    private PathElt getDest(PathElt cldest) {
        if (cldest == null) {
            return null;
        }
        do {
            if ((cldest = cldest.prev) != null) continue;
            return this.mPathStart;
        } while (cldest.type != 0);
        return cldest;
    }

    private PathElt getClosedBy(PathElt clsdby) {
        if (clsdby == null) {
            return null;
        }
        if (clsdby.type == 3) {
            return clsdby;
        }
        do {
            if ((clsdby = clsdby.next) == null) {
                return null;
            }
            if (clsdby.type != 0) continue;
            return null;
        } while (clsdby.type != 3);
        return clsdby;
    }

    private void getEndPoint(PathElt e, Cd endPoint) {
        if (e == null) {
            endPoint.x = 0;
            endPoint.y = 0;
            return;
        }
        block5: while (true) {
            switch (e.type) {
                case 0: 
                case 1: {
                    endPoint.x = e.x;
                    endPoint.y = e.y;
                    return;
                }
                case 2: {
                    endPoint.x = e.x3;
                    endPoint.y = e.y3;
                    return;
                }
                case 3: {
                    e = this.getDest(e);
                    continue block5;
                }
            }
        }
    }

    private void getEndPoints(PathElt p, Cd p0, Cd p1) {
        this.getEndPoint(p, p1);
        this.getEndPoint(p.prev, p0);
    }

    private double interpolate(double q, double v0, double q0, double v1, double q1) {
        return v0 + (q - q0) * ((v1 - v0) / (q1 - q0));
    }

    private int hvNess(double q) {
        double result = q < 0.25 ? this.interpolate(q, 1.0, 0.0, 0.841, 0.25) : (q < 0.5 ? this.interpolate(q, 0.841, 0.25, 0.707, 0.5) : (q < 1.0 ? this.interpolate(q, 0.707, 0.5, 0.5, 1.0) : (q < 2.0 ? this.interpolate(q, 0.5, 1.0, 0.25, 2.0) : (q < 4.0 ? this.interpolate(q, 0.25, 2.0, 0.0, 4.0) : 0.0))));
        return this.fltToFix(result);
    }

    private int vertQuo(int xk, int yk, int xl, int yl) {
        int xabs = xk - xl;
        if (xabs < 0) {
            xabs = -xabs;
        }
        if (xabs == 0) {
            return 256;
        }
        int yabs = yk - yl;
        if (yabs < 0) {
            yabs = -yabs;
        }
        if (yabs == 0) {
            return 0;
        }
        double rx = this.fixToFlt(xabs);
        double ry = this.fixToFlt(yabs);
        double q = 2.0 * rx * rx / (0.38 * ry);
        return this.hvNess(q);
    }

    private int horzQuo(int xk, int yk, int xl, int yl) {
        int yabs = yk - yl;
        if (yabs < 0) {
            yabs = -yabs;
        }
        if (yabs == 0) {
            return 256;
        }
        int xabs = xk - xl;
        if (xabs < 0) {
            xabs = -xabs;
        }
        if (xabs == 0) {
            return 0;
        }
        double rx = this.fixToFlt(xabs);
        double ry = this.fixToFlt(yabs);
        double q = 2.0 * ry * ry / (0.38 * rx);
        return this.hvNess(q);
    }

    private boolean isTiny(PathElt e) {
        Cd cd0 = new Cd();
        Cd cd1 = new Cd();
        this.getEndPoints(e, cd0, cd1);
        return Math.abs(cd0.x - cd1.x) < 256 && Math.abs(cd0.y - cd1.y) < 256;
    }

    private boolean isShort(PathElt e) {
        int mx;
        int mn;
        Cd cd0 = new Cd();
        Cd cd1 = new Cd();
        this.getEndPoints(e, cd0, cd1);
        int dx = Math.abs(cd0.x - cd1.x);
        int dy = Math.abs(cd0.y - cd1.y);
        if (dx > dy) {
            mn = dy;
            mx = dx;
        } else {
            mn = dx;
            mx = dy;
        }
        return mx + mn * 42 / 125 < this.fixInt(3);
    }

    private PathElt nxtForBend(PathElt p, Cd p2, Cd p3) {
        PathElt nxtMT = null;
        Cd ep = new Cd();
        PathElt nxt = p;
        this.getEndPoint(p, ep);
        do {
            if (nxt.type == 3) {
                nxt = this.getDest(nxt);
                if (nxtMT != null && nxtMT == nxt) {
                    nxt = null;
                } else {
                    nxtMT = nxt;
                    nxt = nxt.next;
                }
            } else {
                nxt = nxt.next;
            }
            if (nxt != null) continue;
            p2.x = (p2.y = (p3.x = (p3.y = this.fixInt(-9999))));
            return nxt;
        } while (this.isTiny(nxt));
        if (nxt.type == 2) {
            int x2 = nxt.x1;
            int y2 = nxt.y1;
            if (x2 == ep.x && y2 == ep.y) {
                x2 = nxt.x2;
                y2 = nxt.y2;
            }
            p2.x = x2;
            p2.y = y2;
        } else {
            this.getEndPoint(nxt, p2);
        }
        this.getEndPoint(nxt, p3);
        return nxt;
    }

    private PathElt prvForBend(PathElt p, Cd p2) {
        PathElt prvCP = null;
        PathElt prv = p;
        do {
            if ((prv = prv.prev) == null) {
                p2.x = (p2.y = this.fixInt(-9999));
                return prv;
            }
            if (prv.type != 0) continue;
            if ((prv = this.getClosedBy(prv)) == null || prvCP != null && prvCP == prv) {
                p2.x = (p2.y = this.fixInt(-9999));
                return prv;
            }
            prvCP = prv;
        } while (this.isTiny(prv));
        if (prv.type == 2) {
            int x2 = prv.x2;
            int y2 = prv.y2;
            if (x2 == prv.x3 && y2 == prv.y3) {
                x2 = prv.x1;
                y2 = prv.y1;
            }
            p2.x = x2;
            p2.y = y2;
        } else {
            p = prv.prev;
            if (p == null) {
                p2.x = (p2.y = this.fixInt(-9999));
                return prv;
            }
            this.getEndPoint(p, p2);
        }
        return prv;
    }

    private boolean checkHeight(boolean upperFlag, PathElt p) {
        PathElt ee = this.mPathStart;
        int y = this.itfmy(p.y);
        while (ee != null) {
            if (ee.type == 0 && ee != p) {
                int yy = this.itfmy(ee.y);
                if (upperFlag && yy > y || !upperFlag && yy < y) {
                    return false;
                }
            }
            ee = ee.next;
        }
        return true;
    }

    private boolean isLower(PathElt p) {
        return this.checkHeight(false, p);
    }

    private boolean isUpper(PathElt p) {
        return this.checkHeight(true, p);
    }

    private short sh_abs(short a) {
        return a < 0 ? (short)(-a) : a;
    }

    private short mdpt(int a, int b) {
        int result = a + b >> 1;
        return (short)result;
    }

    private void fMiniFltn(Cd f0, Cd f1, Cd f2, Cd f3, FltnRec fr, boolean inside) {
        int eps;
        short[] cds = new short[60];
        short bbLLX = 0;
        short bbLLY = 0;
        short bbURX = 0;
        short bbURY = 0;
        int idx = 0;
        int dpth = 1;
        cds[idx++] = inside ? (short)1 : 0;
        cds[idx++] = 0;
        int llx = fr.llx;
        int lly = fr.lly;
        cds[idx++] = (short)(f0.x - llx);
        cds[idx++] = (short)(f0.y - lly);
        cds[idx++] = (short)(f1.x - llx);
        cds[idx++] = (short)(f1.y - lly);
        cds[idx++] = (short)(f2.x - llx);
        cds[idx++] = (short)(f2.y - lly);
        cds[idx++] = (short)(f3.x - llx);
        cds[idx++] = (short)(f3.y - lly);
        if (cds[idx - 10] == 0) {
            int c = fr.ll.x;
            bbLLX = c <= 0 ? (short)0 : (short)c;
            c = fr.ll.y;
            bbLLY = c <= 0 ? (short)0 : (short)c;
            int f128 = this.fixInt(128);
            c = fr.ur.x;
            bbURX = (short)(c >= f128 ? Short.MAX_VALUE : (short)c);
            c = fr.ur.y;
            short s = bbURY = (short)(c >= f128 ? Short.MAX_VALUE : (short)c);
        }
        if ((eps = (int)fr.feps) < 8) {
            eps = 8;
        }
        while (true) {
            block38: {
                short d2;
                short d1;
                short c0;
                block40: {
                    block39: {
                        if (dpth == 6) break block38;
                        if (cds[idx - 10] != 0) break block39;
                        int c = cds[idx - 6];
                        int urx = cds[idx - 8];
                        llx = urx;
                        if (c < llx) {
                            llx = c;
                        } else if (c > urx) {
                            urx = c;
                        }
                        c = cds[idx - 4];
                        if (c < llx) {
                            llx = c;
                        } else if (c > urx) {
                            urx = c;
                        }
                        c = cds[idx - 2];
                        if (c < llx) {
                            llx = c;
                        } else if (c > urx) {
                            urx = c;
                        }
                        if (urx < bbLLX || llx > bbURX) break block38;
                        c = cds[idx - 5];
                        int ury = cds[idx - 7];
                        lly = ury;
                        if (c < lly) {
                            lly = c;
                        } else if (c > ury) {
                            ury = c;
                        }
                        c = cds[idx - 3];
                        if (c < lly) {
                            lly = c;
                        } else if (c > ury) {
                            ury = c;
                        }
                        c = cds[idx - 1];
                        if (c < lly) {
                            lly = c;
                        } else if (c > ury) {
                            ury = c;
                        }
                        if (ury < bbLLY || lly > bbURY) break block38;
                        if (urx <= bbURX && ury <= bbURY && llx >= bbLLX && lly >= bbLLY) {
                            cds[idx - 10] = 1;
                        }
                    }
                    if (cds[idx - 9] == 0) {
                        short c;
                        short ur;
                        short ll;
                        int mrgn = eps;
                        short r0 = cds[idx - 8];
                        short r3 = cds[idx - 2];
                        if (r0 < r3) {
                            ll = (short)(r0 - mrgn);
                            ur = (short)(r3 + mrgn);
                        } else {
                            ll = (short)(r3 - mrgn);
                            ur = (short)(r0 + mrgn);
                        }
                        if (ur < 0) {
                            ur = Short.MAX_VALUE;
                        }
                        if ((c = cds[idx - 6]) > ll && c < ur && (c = cds[idx - 4]) > ll && c < ur) {
                            r0 = cds[idx - 7];
                            r3 = cds[idx - 1];
                            if (r0 < r3) {
                                ll = (short)(r0 - mrgn);
                                ur = (short)(r3 + mrgn);
                            } else {
                                ll = (short)(r3 - mrgn);
                                ur = (short)(r0 + mrgn);
                            }
                            if (ur < 0) {
                                ur = Short.MAX_VALUE;
                            }
                            if ((c = cds[idx - 5]) > ll && c < ur && (c = cds[idx - 3]) > ll && c < ur) {
                                cds[idx - 9] = 1;
                            }
                        }
                    }
                    if (cds[idx - 9] == 0) break block40;
                    short x = cds[idx - 8];
                    short y = cds[idx - 7];
                    short eqa = (short)(cds[idx - 1] - y);
                    short eqb = (short)(x - cds[idx - 2]);
                    if (eqa == 0 && eqb == 0) break block38;
                    int EPS = (this.sh_abs(eqa) > this.sh_abs(eqb) ? eqa : eqb) * eps;
                    if (EPS < 0) {
                        EPS = -EPS;
                    }
                    int d = eqa * (cds[idx - 6] - x);
                    if (Math.abs(d += eqb * (cds[idx - 5] - y)) >= EPS) break block40;
                    d = eqa * (cds[idx - 4] - x);
                    if (Math.abs(d += eqb * (cds[idx - 3] - y)) < EPS) break block38;
                }
                cds[idx + 2] = c0 = cds[idx - 8];
                short c1 = cds[idx - 6];
                short c2 = cds[idx - 4];
                cds[idx + 4] = d1 = this.mdpt(c0, c1);
                short d3 = this.mdpt(c1, c2);
                cds[idx + 6] = d2 = this.mdpt(d1, d3);
                cds[idx - 4] = c2 = this.mdpt(c2, cds[idx - 2]);
                cds[idx - 6] = c1 = this.mdpt(d3, c2);
                short s = this.mdpt(d2, c1);
                cds[idx + 8] = s;
                cds[idx - 8] = s;
                cds[idx + 3] = c0 = cds[idx - 7];
                c1 = cds[idx - 5];
                c2 = cds[idx - 3];
                cds[idx + 5] = d1 = this.mdpt(c0, c1);
                d3 = this.mdpt(c1, c2);
                cds[idx + 7] = d2 = this.mdpt(d1, d3);
                cds[idx - 3] = c2 = this.mdpt(c2, cds[idx - 1]);
                cds[idx - 5] = c1 = this.mdpt(d3, c2);
                short s2 = this.mdpt(d2, c1);
                cds[idx + 9] = s2;
                cds[idx - 7] = s2;
                cds[idx + 1] = cds[idx - 9];
                cds[idx + 0] = cds[idx - 10];
                idx += 10;
                dpth = (short)(dpth + 1);
                continue;
            }
            Cd c = new Cd();
            if ((dpth = (int)((short)(dpth - 1))) == 0) {
                c.copyFrom(f3);
            } else {
                c.x = cds[idx - 2] + fr.llx;
                c.y = cds[idx - 1] + fr.lly;
            }
            this.flatReportProc(fr.report, fr.param, c);
            if (dpth == 0) {
                return;
            }
            idx -= 10;
        }
    }

    private void fFltnCurve(Cd c0, Cd c1, Cd c2, Cd c3, FltnRec fr, boolean inrect) {
        int th;
        int ury;
        int urx;
        c0 = (Cd)c0.clone();
        c1 = (Cd)c1.clone();
        c2 = (Cd)c2.clone();
        c3 = (Cd)c3.clone();
        Cd d0 = new Cd();
        Cd d1 = new Cd();
        Cd d2 = new Cd();
        Cd d3 = new Cd();
        if (c0.x == c1.x && c0.y == c1.y && c2.x == c3.x && c2.y == c3.y || fr.limit <= 0) {
            this.flatReportProc(fr.report, fr.param, c3);
            return;
        }
        int llx = urx = c0.x;
        int c = c1.x;
        if (c < llx) {
            llx = c;
        } else if (c > urx) {
            urx = c;
        }
        c = c2.x;
        if (c < llx) {
            llx = c;
        } else if (c > urx) {
            urx = c;
        }
        c = c3.x;
        if (c < llx) {
            llx = c;
        } else if (c > urx) {
            urx = c;
        }
        int lly = ury = c0.y;
        c = c1.y;
        if (c < lly) {
            lly = c;
        } else if (c > ury) {
            ury = c;
        }
        c = c2.y;
        if (c < lly) {
            lly = c;
        } else if (c > ury) {
            ury = c;
        }
        c = c3.y;
        if (c < lly) {
            lly = c;
        } else if (c > ury) {
            ury = c;
        }
        if (!inrect) {
            if (urx < fr.ll.x || llx > fr.ur.x || ury < fr.ll.y || lly > fr.ur.y) {
                this.flatReportProc(fr.report, fr.param, c3);
                return;
            }
            if (urx <= fr.ur.x && ury <= fr.ur.y && llx >= fr.ll.x && lly >= fr.ll.y) {
                inrect = true;
            }
        }
        if (urx - llx >= (th = this.fixInt(127)) || ury - lly >= th) {
            d3.copyFrom(c3);
            d2.x = c2.x + c3.x >> 1;
            d2.y = c2.y + c3.y >> 1;
            c3.x = c1.x + c2.x >> 1;
            c3.y = c1.y + c2.y >> 1;
            c1.x = c0.x + c1.x >> 1;
            c1.y = c0.y + c1.y >> 1;
            c2.x = c1.x + c3.x >> 1;
            c2.y = c1.y + c3.y >> 1;
            d1.x = c3.x + d2.x >> 1;
            d1.y = c3.y + d2.y >> 1;
            d0.x = c2.x + d1.x >> 1;
            d0.y = c2.y + d1.y >> 1;
            c3.copyFrom(d0);
            FltnRec.access$17710(fr);
            this.fFltnCurve(c0, c1, c2, c3, fr, inrect);
            this.fFltnCurve(d0, d1, d2, d3, fr, inrect);
            FltnRec.access$17708(fr);
            return;
        }
        fr.llx = llx;
        fr.lly = lly;
        if (!inrect) {
            fr.ll.x -= llx;
            fr.ur.x -= llx;
            fr.ll.y -= lly;
            fr.ur.y -= lly;
        }
        this.fMiniFltn(c0, c1, c2, c3, fr, inrect);
        if (!inrect) {
            fr.ll.x += llx;
            fr.ur.x += llx;
            fr.ll.y += lly;
            fr.ur.y += lly;
        }
    }

    private void fltnCurve(Cd c0, Cd c1, Cd c2, Cd c3, FltnRec fr) {
        fr.limit = (short)6;
        fr.feps = 128;
        this.fFltnCurve(c0, c1, c2, c3, fr, true);
    }

    private int countSubPaths(int[] elemCount) {
        int numSubPaths = 0;
        int numElem = 0;
        PathElt e = this.mPathEnd;
        while (e != null) {
            do {
                e = e.prev;
                ++numElem;
            } while (e != null && e.type != 0);
            ++numSubPaths;
            if (e == null) continue;
            e = e.prev;
        }
        if (elemCount != null) {
            elemCount[0] = numElem;
        }
        return numSubPaths;
    }

    private void roundPathCoords() {
        PathElt e = this.mPathStart;
        while (e != null) {
            if (e.type == 2) {
                e.x1 = this.fHalfRnd(e.x1);
                e.y1 = this.fHalfRnd(e.y1);
                e.x2 = this.fHalfRnd(e.x2);
                e.y2 = this.fHalfRnd(e.y2);
                e.x3 = this.fHalfRnd(e.x3);
                e.y3 = this.fHalfRnd(e.y3);
            } else if (e.type == 1 || e.type == 0) {
                e.x = this.fHalfRnd(e.x);
                e.y = this.fHalfRnd(e.y);
            }
            e = e.next;
        }
    }

    private int checkForClr() {
        PathElt mt = this.mPathStart;
        while (mt != null) {
            PathElt cp = this.getClosedBy(mt);
            mt = cp.next;
        }
        return 0;
    }

    private boolean preCheckForColoring() {
        int chk;
        int cnt = 0;
        while (this.mPathEnd != null) {
            if (this.mPathEnd.type == 0) {
                this.delete(this.mPathEnd);
                continue;
            }
            if (this.mPathEnd.type == 3) break;
            return false;
        }
        PathElt e = this.mPathStart;
        while (e != null) {
            if (e.type == 3) {
                if (e == this.mPathEnd) break;
                PathElt nxt = e.next;
                if (nxt.type == 0) {
                    e = nxt;
                    continue;
                }
                if (nxt.type == 3) {
                    this.delete(nxt);
                    continue;
                }
            }
            e = e.next;
        }
        do {
            if ((chk = this.checkForClr()) != -1) continue;
            return false;
        } while (chk != 0 && ++cnt <= 10);
        return true;
    }

    private PathElt getSubpathNext(PathElt e) {
        do {
            if (e.type != 3) continue;
            e = this.getDest(e);
        } while ((e = e.next) != null && this.isTiny(e));
        return e;
    }

    private PathElt getSubpathPrev(PathElt e) {
        while ((e = e.prev) != null) {
            if (e.type == 0) {
                e = this.getClosedBy(e);
            }
            if (this.isTiny(e)) continue;
            break;
        }
        return e;
    }

    private boolean addAutoFlexProp(PathElt e, boolean yflag) {
        PathElt e0 = e;
        PathElt e1 = e.next;
        if (yflag && e0.y3 == e1.y1 && e1.y1 == e1.y2 && e1.y2 == e1.y3) {
            return false;
        }
        if (e0.x3 == e1.x1 && e1.x1 == e1.x2 && e1.x2 == e1.x3) {
            return false;
        }
        e0.isFlex = true;
        e1.isFlex = true;
        return true;
    }

    private void tryYFlex(PathElt e, PathElt n, int x0, int y0, int x1, int y1) {
        double quot;
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        this.getEndPoint(n, cd2);
        if (Math.abs(y0 - cd2.y) > this.mFlexCand) {
            return;
        }
        if (this.prodLt0(y1 - y0, y1 - cd2.y)) {
            return;
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d0sq = dx * dx + dy * dy;
        double d1sq = (dx = (double)(cd2.x - x1)) * dx + (dy = (double)(cd2.y - y1)) * dy;
        double d = quot = d0sq > d1sq ? d1sq / d0sq : d0sq / d1sq;
        if (quot < 0.11) {
            return;
        }
        if (this.mFlexStrict) {
            boolean dwn;
            PathElt q = this.getSubpathNext(n);
            this.getEndPoint(q, cd3);
            if (this.prodLt0(cd3.y - cd2.y, y1 - cd2.y)) {
                return;
            }
            PathElt p = this.getSubpathPrev(e);
            this.getEndPoint(p.prev, cd4);
            if (this.prodLt0(cd4.y - y0, y1 - y0)) {
                return;
            }
            boolean top = x0 > x1;
            boolean bl = dwn = y1 < y0;
            if (top && !dwn || !top && dwn) {
                return;
            }
        }
        if (n != e.next) {
            return;
        }
        if (y0 != cd2.y) {
            return;
        }
        this.addAutoFlexProp(e, true);
    }

    private void tryXFlex(PathElt e, PathElt n, int x0, int y0, int x1, int y1) {
        double quot;
        Cd cd2 = new Cd();
        Cd cd3 = new Cd();
        Cd cd4 = new Cd();
        this.getEndPoint(n, cd2);
        if (Math.abs(x0 - cd2.x) > this.mFlexCand) {
            return;
        }
        if (this.prodLt0(x1 - x0, x1 - cd2.x)) {
            return;
        }
        double dx = x1 - x0;
        double dy = y1 - y0;
        double d0sq = dx * dx + dy * dy;
        double d1sq = (dx = (double)(cd2.x - x1)) * dx + (dy = (double)(cd2.y - y1)) * dy;
        double d = quot = d0sq > d1sq ? d1sq / d0sq : d0sq / d1sq;
        if (quot < 0.11) {
            return;
        }
        if (this.mFlexStrict) {
            boolean lft;
            PathElt q = this.getSubpathNext(n);
            this.getEndPoint(q, cd3);
            if (this.prodLt0(cd3.x - cd2.x, x1 - cd2.x)) {
                return;
            }
            PathElt p = this.getSubpathPrev(e);
            this.getEndPoint(p.prev, cd4);
            if (this.prodLt0(cd4.x - x0, x1 - x0)) {
                return;
            }
            boolean bl = lft = y0 > cd2.y;
            if (lft && x0 > x1 || !lft && x0 < x1) {
                return;
            }
        }
        if (n != e.next) {
            return;
        }
        if (x0 != cd2.x) {
            return;
        }
        this.addAutoFlexProp(e, false);
    }

    private void autoAddFlex() {
        Cd cd0 = new Cd();
        Cd cd1 = new Cd();
        PathElt e = this.mPathStart;
        while (e != null) {
            PathElt n;
            if (e.type == 2 && !e.isFlex && (n = this.getSubpathNext(e)).type == 2) {
                this.getEndPoints(e, cd0, cd1);
                if (Math.abs(cd0.y - cd1.y) <= this.psDist(20)) {
                    this.tryYFlex(e, n, cd0.x, cd0.y, cd1.x, cd1.y);
                }
                if (Math.abs(cd0.x - cd1.x) <= this.psDist(20)) {
                    this.tryXFlex(e, n, cd0.x, cd0.y, cd1.x, cd1.y);
                }
            }
            e = e.next;
        }
    }

    private boolean findCodeInList(int unicode, short[] lst) {
        short u;
        int idx = 0;
        do {
            if ((u = lst[idx++]) != 0) continue;
            return false;
        } while (unicode != u);
        return true;
    }

    private int specialCharType(int unicode) {
        if (this.findCodeInList(unicode, this.UpperSpecialChars)) {
            return 1;
        }
        if (this.findCodeInList(unicode, this.LowerSpecialChars)) {
            return -1;
        }
        return 0;
    }

    private boolean hColorChar(int unicode) {
        return this.findCodeInList(unicode, this.HColorList);
    }

    private boolean vColorChar(int unicode) {
        return this.findCodeInList(unicode, this.VColorList);
    }

    private boolean noBlueChar(int unicode) {
        return this.findCodeInList(unicode, this.NoBlueList);
    }

    private boolean moveToNewClrs(int unicode) {
        return unicode == 37 || unicode == 8240;
    }

    private void initShuffleSubpaths() {
        int cnt = -1;
        PathElt e = this.mPathStart;
        while (e != null) {
            if (e.type == 0) {
                ++cnt;
            }
            e.count = (short)cnt;
            e = e.next;
        }
        this.mRowCnt = ++cnt;
        this.mLinks = cnt < 4 || cnt >= 100 ? null : new byte[cnt * cnt];
    }

    private void markLinks(ClrVal vL, boolean hFlg) {
        if (this.mLinks == null) {
            return;
        }
        while (vL != null) {
            PathElt e;
            ClrSeg seg;
            if (vL != null && (seg = vL.vSeg1) != null && (e = seg.sElt) != null) {
                short j;
                short i = e.count;
                seg = vL.vSeg2;
                if (seg != null && (e = seg.sElt) != null && i != (j = e.count)) {
                    this.mLinks[this.mRowCnt * i + j] = 1;
                    this.mLinks[this.mRowCnt * j + i] = 1;
                }
            }
            vL = vL.vNxt;
        }
    }

    private void outPath(byte[] links, byte[] outlinks, byte[] output, int bst) {
        int i = bst;
        PathElt e = this.mPathStart;
        while (e != null && e.count != i) {
            e = e.next;
        }
        if (e != null) {
            this.moveSubpathToEnd(e);
        }
        output[bst] = 1;
        int srcIdx = bst * this.mRowCnt;
        i = 0;
        while (i < this.mRowCnt) {
            int n = i++;
            outlinks[n] = (byte)(outlinks[n] + links[srcIdx + 1]);
        }
    }

    private void doShuffleSubpaths() {
        int i;
        byte[] sumlinks = new byte[100];
        byte[] output = new byte[100];
        byte[] outlinks = new byte[100];
        if (this.mLinks == null) {
            return;
        }
        for (i = 0; i < this.mRowCnt; ++i) {
            outlinks[i] = 0;
            sumlinks[i] = 0;
            output[i] = 0;
        }
        int idx = 0;
        for (i = 0; i < this.mRowCnt; ++i) {
            for (int j = 0; j < this.mRowCnt; ++j) {
                if (this.mLinks[idx++] == 0) continue;
                int n = i;
                sumlinks[n] = (byte)(sumlinks[n] + 1);
            }
        }
        block3: while (true) {
            int bst = -1;
            byte bstsum = 0;
            for (i = 0; i < this.mRowCnt; ++i) {
                if (output[i] != 0 || bst != -1 && sumlinks[i] <= bstsum) continue;
                bstsum = sumlinks[i];
                bst = i;
            }
            if (bst == -1) break;
            this.outPath(this.mLinks, outlinks, output, bst);
            while (true) {
                bst = -1;
                bstsum = 0;
                byte bstlnks = 0;
                for (i = 0; i < this.mRowCnt; ++i) {
                    if (output[i] != 0 || outlinks[i] < bstlnks || outlinks[i] <= 0 || bst != -1 && outlinks[i] <= bstlnks && (outlinks[i] != bstlnks || sumlinks[i] <= bstsum)) continue;
                    bstlnks = outlinks[i];
                    bst = i;
                    bstsum = sumlinks[i];
                }
                if (bst == -1) continue block3;
                this.outPath(this.mLinks, outlinks, output, bst);
            }
            break;
        }
    }

    private void addVStem(int right, int left, boolean curved) {
        if (!curved || this.mAllStems) {
            this.mZoneData.add(0);
            this.mZoneData.add(this.fTrunc(this.fRnd(right)));
            this.mZoneData.add(this.fTrunc(this.fRnd(left)));
        }
    }

    private void addHStem(int top, int bottom, boolean curved) {
        if (!curved || this.mAllStems) {
            this.mZoneData.add(1);
            this.mZoneData.add(this.fTrunc(this.fRnd(top)));
            this.mZoneData.add(this.fTrunc(this.fRnd(bottom)));
        }
    }

    private void addCharExtreme(int bot, int top) {
        this.mZoneData.add(2);
        this.mZoneData.add(this.fTrunc(this.fRnd(top)));
        this.mZoneData.add(this.fTrunc(this.fRnd(bot)));
    }

    private void addCharZone(int bot, int top) {
        this.mZoneData.add(3);
        this.mZoneData.add(this.fTrunc(this.fRnd(top)));
        this.mZoneData.add(this.fTrunc(this.fRnd(bot)));
    }

    private void addZone(int bot, int top) {
        this.mZoneData.add(4);
        this.mZoneData.add(this.fTrunc(this.fRnd(top)));
        this.mZoneData.add(this.fTrunc(this.fRnd(bot)));
    }

    private double fixToFlt(int x) {
        return (double)x / 256.0;
    }

    private int fltToFix(double f) {
        if (f >= 8388607.99609375) {
            return Integer.MAX_VALUE;
        }
        if (f <= -8388608.0) {
            return Integer.MIN_VALUE;
        }
        return (int)(f * 256.0);
    }

    private PathElt appendElement(int etype) {
        PathElt e = new PathElt();
        e.eltSN = ++this.mEltSN;
        if (e.eltSN == 0) {
            e.eltSN++;
        }
        e.type = (short)etype;
        if (this.mInputPathEnd != null) {
            this.mInputPathEnd.next = e;
            e.prev = this.mInputPathEnd;
        } else {
            this.mInputPathStart = e;
        }
        this.mInputPathEnd = e;
        return e;
    }

    private void closeSubPath() {
        if (this.mSubPathOpen) {
            this.mSubPathOpen = false;
            this.appendElement(3);
        }
    }

    public void moveto(double x0, double y0) {
        this.closeSubPath();
        PathElt newElt = this.appendElement(0);
        newElt.x = this.tfmx(this.scaleAbs(this.fltToFix(x0)));
        newElt.y = this.tfmy(this.scaleAbs(this.fltToFix(y0)));
        this.mCurX = x0;
        this.mCurY = y0;
        this.mSubPathOpen = true;
    }

    public void lineto(double x1, double y1) {
        PathElt newElt = this.appendElement(1);
        newElt.x = this.tfmx(this.scaleAbs(this.fltToFix(x1)));
        newElt.y = this.tfmy(this.scaleAbs(this.fltToFix(y1)));
        this.mCurX = x1;
        this.mCurY = y1;
    }

    public void curveto(double x1, double y1, double x2, double y2) {
        this.curveto(Math.round((this.mCurX + 2.0 * x1) / 3.0), Math.round((this.mCurY + 2.0 * y1) / 3.0), Math.round((2.0 * x1 + x2) / 3.0), Math.round((2.0 * y1 + y2) / 3.0), Math.round(x2), Math.round(y2));
    }

    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        PathElt newElt = this.appendElement(2);
        newElt.x1 = this.tfmx(this.scaleAbs(this.fltToFix(x1)));
        newElt.y1 = this.tfmy(this.scaleAbs(this.fltToFix(y1)));
        newElt.x2 = this.tfmx(this.scaleAbs(this.fltToFix(x2)));
        newElt.y2 = this.tfmy(this.scaleAbs(this.fltToFix(y2)));
        newElt.x3 = this.tfmx(this.scaleAbs(this.fltToFix(x3)));
        newElt.y3 = this.tfmy(this.scaleAbs(this.fltToFix(y3)));
        this.mCurX = x3;
        this.mCurY = y3;
    }

    public void endchar() {
        this.closeSubPath();
        try {
            this.doGlyph();
        }
        catch (ACException e) {
            this.emitRawPath();
        }
    }

    public void setMatrix(Matrix matrix) {
        if (this.mOutlineConsumer != null) {
            this.mOutlineConsumer.setMatrix(matrix);
        }
    }

    private void emitRawPath() {
        if (this.mOutlineConsumer != null) {
            PathElt e = this.mPathStart;
            while (e != null) {
                switch (e.type) {
                    case 0: {
                        double x = this.fixToFlt(this.unScaleAbs(this.itfmx(e.x)));
                        double y = this.fixToFlt(this.unScaleAbs(this.itfmx(e.y)));
                        this.mOutlineConsumer.moveto(x, y);
                        break;
                    }
                    case 1: {
                        double x = this.fixToFlt(this.unScaleAbs(this.itfmx(e.x)));
                        double y = this.fixToFlt(this.unScaleAbs(this.itfmx(e.y)));
                        this.mOutlineConsumer.lineto(x, y);
                        break;
                    }
                    case 2: {
                        double c1x = this.fixToFlt(this.unScaleAbs(this.itfmx(e.x1)));
                        double c1y = this.fixToFlt(this.unScaleAbs(this.itfmy(e.y1)));
                        double c2x = this.fixToFlt(this.unScaleAbs(this.itfmx(e.x2)));
                        double c2y = this.fixToFlt(this.unScaleAbs(this.itfmy(e.y2)));
                        double c3x = this.fixToFlt(this.unScaleAbs(this.itfmx(e.x3)));
                        double c3y = this.fixToFlt(this.unScaleAbs(this.itfmy(e.y3)));
                        this.mOutlineConsumer.curveto(c1x, c1y, c2x, c2y, c3x, c3y);
                        break;
                    }
                }
                e = e.next;
            }
            this.mOutlineConsumer.endchar();
        }
    }

    private void resetGlyph() {
        this.mPathEnd = null;
        this.mPathStart = null;
        this.mCurY = 0.0;
        this.mCurX = 0.0;
        PathElt ie = this.mInputPathStart;
        while (ie != null) {
            PathElt ce = (PathElt)ie.clone();
            if (this.mPathEnd != null) {
                this.mPathEnd.next = ce;
                ce.prev = this.mPathEnd;
            } else {
                this.mPathStart = ce;
            }
            this.mPathEnd = ce;
            ie = ie.next;
        }
    }

    private void copyBands() {
        int i;
        this.mLenTopBands = Math.min(this.mTopZones.length, 20);
        for (i = 0; i < this.mLenTopBands; ++i) {
            this.mTopBands[i] = this.scaleAbs(this.fixInt(this.mTopZones[i]));
        }
        this.mLenBotBands = Math.min(this.mBottomZones.length, 20);
        for (i = 0; i < this.mLenBotBands; ++i) {
            this.mBotBands[i] = this.scaleAbs(this.fixInt(this.mBottomZones[i]));
        }
    }

    private int fixInt(int i) {
        return i << 8;
    }

    private int fRnd(int x) {
        return x + 128 & 0xFFFFFF00;
    }

    private int fHalfRnd(int x) {
        return x + 64 & 0xFFFFFF80;
    }

    private int fTrunc(int x) {
        return x >> 8;
    }

    private int fixHalfMul(int f) {
        return f >> 1;
    }

    private int fixTwoMul(int f) {
        return f << 1;
    }

    private int tfmx(int x) {
        return this.fixHalfMul(x) + 0;
    }

    private int tfmy(int y) {
        return this.fixHalfMul(y) + 0;
    }

    private int itfmx(int x) {
        return this.fixTwoMul(x) - 0;
    }

    private int itfmy(int y) {
        return this.fixTwoMul(y) - 0;
    }

    private int dtfmx(int x) {
        return this.fixHalfMul(x);
    }

    private int dtfmy(int y) {
        return this.fixHalfMul(y);
    }

    private int idtfmx(int x) {
        return this.fixTwoMul(x);
    }

    private int idtfmy(int y) {
        return this.fixTwoMul(y);
    }

    private int psDist(int d) {
        return this.dtfmx(this.fixInt(d));
    }

    private boolean isVertical(int x1, int y1, int x2, int y2) {
        return this.vertQuo(x1, y1, x2, y2) > 0;
    }

    private boolean isHorizontal(int x1, int y1, int x2, int y2) {
        return this.horzQuo(x1, y1, x2, y2) > 0;
    }

    private boolean prodLt0(int f0, int f1) {
        return f0 < 0 && f1 > 0 || f0 > 0 && f1 < 0;
    }

    private boolean prodGe0(int f0, int f1) {
        return !this.prodLt0(f0, f1);
    }

    private ClrSeg leftList() {
        return this.mSegLists[0];
    }

    private ClrSeg rightList() {
        return this.mSegLists[1];
    }

    private ClrSeg topList() {
        return this.mSegLists[2];
    }

    private ClrSeg botList() {
        return this.mSegLists[3];
    }

    private static final class WriteData {
        private boolean firstFlex;
        private boolean wrtColorInfo;
        private ClrPoint bst;
        private char bch;
        private int bx;
        private int by;
        private boolean bstB;
        private Cd fc1 = new Cd();
        private Cd fc2 = new Cd();
        private Cd fc3 = new Cd();
        private ArrayList hintArray;
        private ArrayList prevHintArray;

        private WriteData() {
        }
    }

    private static final class HintData {
        private int flags;
        private int v1;
        private int v2;

        private HintData() {
        }
    }

    private static final class CheckData {
        private boolean xflat;
        private boolean yflat;
        private boolean xdone;
        private boolean ydone;
        private boolean bbquit;
        private int xstate;
        private int ystate;
        private int xstart;
        private int ystart;
        private int x0;
        private int cy0;
        private int x1;
        private int cy1;
        private int xloc;
        private int yloc;
        private int x;
        private int y;
        private int xnxt;
        private int ynxt;
        private int yflatstartx;
        private int yflatstarty;
        private int yflatendx;
        private int yflatendy;
        private int xflatstarty;
        private int xflatstartx;
        private int xflatendx;
        private int xflatendy;
        private boolean vert;
        private boolean started;
        private boolean reCheckSmooth;
        private int loc;
        private int frst;
        private int lst;
        private PathElt e;
        private boolean forMultiMaster;

        private CheckData() {
        }
    }

    private static final class NZWindParam {
        private int windCount;
        private double testx;
        private double testy;
        private Cd testPt = new Cd();
        private Cd lastPt = new Cd();
        private Cd firstPt = new Cd();
        private boolean onLine;
        private boolean fromAbove;
        private boolean hasLastPt;
        private boolean testToRight;

        private NZWindParam() {
        }
    }

    private static final class FindExParam {
        private int yMax;
        private int windDir;
        private Cd prerisePt = new Cd();
        private Cd risePt = new Cd();
        private Cd lastPt = new Cd();
        private Cd firstPt = new Cd();
        private Cd beforeFirstSinkPt = new Cd();
        private Cd firstSinkPt = new Cd();
        private boolean hasPrerisePt;
        private boolean hasRisePt;
        private boolean hasLastPt;
        private boolean lastWasExtreme;
        private boolean firstWasExtreme;
        private boolean hasRisePtForFirst;
        private boolean plaeauEnded;

        private FindExParam() {
        }
    }

    private static final class SubPathInfo {
        private PathElt head;
        private PathElt tail;
        private Cd startPt = new Cd();
        private Cd endPt = new Cd();
        private ACBBox bbox = new ACBBox();
        private int currentWind;
        private boolean filled;

        private SubPathInfo() {
        }
    }

    private static final class ACBBox {
        private int xmin;
        private int ymin;
        private int xmax;
        private int ymax;
        private int vMn;
        private int vMx;
        private int hMn;
        private int hMx;
        private PathElt pxmn;
        private PathElt pxmx;
        private PathElt pymn;
        private PathElt pymx;
        private PathElt pe;
        private PathElt pvMn;
        private PathElt pvMx;
        private PathElt phMn;
        private PathElt phMx;

        private ACBBox() {
        }

        void copyFrom(ACBBox src) {
            this.xmin = src.xmin;
            this.ymin = src.ymin;
            this.xmax = src.xmax;
            this.ymax = src.ymax;
            this.vMn = src.vMn;
            this.vMx = src.vMx;
            this.hMn = src.hMn;
            this.hMx = src.hMx;
            this.pxmn = src.pxmn;
            this.pxmx = src.pxmx;
            this.pymn = src.pymn;
            this.pymx = src.pymx;
            this.pe = src.pe;
            this.pvMn = src.pvMn;
            this.pvMx = src.pvMx;
            this.phMn = src.phMn;
            this.phMx = src.phMx;
        }
    }

    private static final class ClrPoint {
        private int cptSN;
        private ClrPoint next;
        private int x0;
        private int y0;
        private int x1;
        private int y1;
        private PathElt p0;
        private PathElt p1;
        private char c;
        private boolean done;

        private ClrPoint() {
        }
    }

    private static final class PathElt
    implements Cloneable {
        private int eltSN;
        private PathElt prev;
        private PathElt next;
        private short type;
        private SegLnkLst Hs;
        private SegLnkLst Vs;
        private boolean Hcopy;
        private boolean Vcopy;
        private boolean isFlex;
        private short count;
        private short newcolors;
        private int x;
        private int y;
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private int x3;
        private int y3;

        private PathElt() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static final class ClrVal
    implements Cloneable {
        private int cvlSN;
        private ClrVal vNxt;
        private int vVal;
        private int vSpc;
        private int initVal;
        private int vLoc1;
        private int vLoc2;
        private boolean vGhst;
        private boolean pruned;
        private boolean merge;
        private ClrSeg vSeg1;
        private ClrSeg vSeg2;
        private ClrVal vBst;

        private ClrVal() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static final class SegLnkLst {
        private SegLnkLst next;
        private SegLnk lnk;

        private SegLnkLst() {
        }
    }

    private static final class SegLnk {
        private ClrSeg seg;

        private SegLnk() {
        }
    }

    private static final class ClrSeg {
        private int csgSN;
        private ClrSeg sNxt;
        private int sLoc;
        private int sMax;
        private int sMin;
        private int sBonus;
        private ClrVal sLnk;
        private PathElt sElt;
        private short sType;

        private ClrSeg() {
        }
    }

    private static final class FltnRec {
        private short limit;
        private int feps;
        private int report;
        private Object param;
        private Cd ll = new Cd();
        private Cd ur = new Cd();
        private int llx;
        private int lly;

        private FltnRec() {
        }

        static /* synthetic */ short access$17710(FltnRec x0) {
            short s = x0.limit;
            x0.limit = (short)(s - 1);
            return s;
        }

        static /* synthetic */ short access$17708(FltnRec x0) {
            short s = x0.limit;
            x0.limit = (short)(s + 1);
            return s;
        }
    }

    private static final class Cd
    implements Cloneable {
        private int x;
        private int y;

        private Cd() {
        }

        private void copyFrom(Cd src) {
            this.x = src.x;
            this.y = src.y;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static final class ACException
    extends Exception {
        static final long serialVersionUID = 1L;

        public ACException() {
        }

        public ACException(String message) {
            super(message);
        }

        public ACException(String message, Throwable cause) {
            super(message, cause);
        }

        public ACException(Throwable cause) {
            super(cause);
        }
    }
}

