/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;

public class SubsetDefaultImpl
implements Subset {
    protected final boolean doSubset;
    protected int subsetGlyphCount;
    protected int[] fullGid2subsetGid;
    protected int[] subsetGid2fullGid;

    public SubsetDefaultImpl(int numGlyphs, boolean doSubset) throws InvalidFontException, UnsupportedFontException {
        this.doSubset = doSubset;
        if (!doSubset) {
            this.subsetGlyphCount = numGlyphs;
            this.fullGid2subsetGid = null;
            this.subsetGid2fullGid = null;
        } else {
            this.subsetGlyphCount = 0;
            this.fullGid2subsetGid = new int[numGlyphs];
            this.subsetGid2fullGid = new int[numGlyphs];
            for (int i = this.subsetGlyphCount; i < numGlyphs; ++i) {
                this.fullGid2subsetGid[i] = -1;
            }
        }
    }

    public boolean doSubset() {
        return this.doSubset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumGlyphs() {
        SubsetDefaultImpl subsetDefaultImpl = this;
        synchronized (subsetDefaultImpl) {
            return this.subsetGlyphCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubsetGid(int fullGid) throws InvalidFontException, UnsupportedFontException {
        if (this.doSubset) {
            SubsetDefaultImpl subsetDefaultImpl = this;
            synchronized (subsetDefaultImpl) {
                try {
                    if (this.fullGid2subsetGid[fullGid] == -1) {
                        this.fullGid2subsetGid[fullGid] = this.subsetGlyphCount;
                        this.subsetGid2fullGid[this.subsetGlyphCount] = fullGid;
                        ++this.subsetGlyphCount;
                        this.pullComponentGlyphs(fullGid);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new InvalidFontException(e);
                }
                return this.fullGid2subsetGid[fullGid];
            }
        }
        return fullGid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFullGid(int subsetGid) {
        if (this.doSubset) {
            SubsetDefaultImpl subsetDefaultImpl = this;
            synchronized (subsetDefaultImpl) {
                return this.subsetGid2fullGid[subsetGid];
            }
        }
        return subsetGid;
    }

    protected void pullComponentGlyphs(int fullGid) throws UnsupportedFontException, InvalidFontException {
    }

    public int getExistingSubsetGid(int fullGid) {
        if (this.doSubset) {
            if (fullGid >= this.fullGid2subsetGid.length) {
                return -1;
            }
            return this.fullGid2subsetGid[fullGid];
        }
        return fullGid;
    }
}

