/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.ComparingOutlineConsumer;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.IteratingOutlineConsumer;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;

public abstract class FontData {
    private final byte[] containerFingerprint;
    protected static final int[] typicalCharactersForIdeoEmBoxComputation = new int[]{27704, 39729, 44332, 12539};
    protected static final int[] typicalCharactersForIcfBoxComputation = new int[]{27704, 39729, 44332, 12507};
    protected static final int[][] typicalCharactersForProportionalRomanDecision = new int[][]{{32, 46, 77}, {32, 46, 924}, {32, 46, 64259}};

    public FontData(byte[] digest) {
        this.containerFingerprint = digest == null ? null : (byte[])digest.clone();
    }

    public byte[] getContainerFingerprint() {
        if (this.containerFingerprint == null) {
            return new byte[0];
        }
        return (byte[])this.containerFingerprint.clone();
    }

    public abstract int getNumGlyphs() throws InvalidFontException, UnsupportedFontException;

    public boolean isSymbolic() throws UnsupportedFontException, InvalidFontException {
        return false;
    }

    public abstract double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException;

    public abstract double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException;

    public double getCoolTypeUnitsPerEm() throws UnsupportedFontException, InvalidFontException {
        return 1000.0;
    }

    public abstract Rect getFontBBox() throws InvalidFontException, UnsupportedFontException;

    protected abstract Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException;

    public Rect getCoolTypeFontBBox() throws InvalidFontException, UnsupportedFontException {
        Rect r = this.getCoolTypeRawFontBBox();
        if (r.xmin == r.xmax || r.ymin == r.ymax) {
            double unitsPerEmX = this.getUnitsPerEmX();
            double unitsPerEmY = this.getUnitsPerEmY();
            return new Rect(-0.5 * unitsPerEmX, -0.5 * unitsPerEmY, 1.5 * unitsPerEmX, 1.0 * unitsPerEmY);
        }
        return r;
    }

    public abstract CoolTypeScript getCoolTypeScript() throws UnsupportedFontException, InvalidFontException;

    protected boolean useCoolTypeCJKHeuristics() throws UnsupportedFontException, InvalidFontException {
        CoolTypeScript ctScript = this.getCoolTypeScript();
        return ctScript == CoolTypeScript.JAPANESE || ctScript == CoolTypeScript.SIMPLIFIED_CHINESE || ctScript == CoolTypeScript.TRADITIONAL_CHINESE || ctScript == CoolTypeScript.KOREAN;
    }

    protected double getCoolTypeCapHeightFromGlyphs() throws UnsupportedFontException, InvalidFontException {
        int gidO = this.getCoolTypeGlyphForChar(79);
        int gidH = this.getCoolTypeGlyphForChar(72);
        if (gidO != 0 && gidH != 0) {
            Rect bboxO = this.getGlyphBBox(gidO);
            Rect bboxH = this.getGlyphBBox(gidH);
            if (!bboxO.equals(Rect.emptyRect) && !bboxH.equals(Rect.emptyRect)) {
                return Math.min(bboxO.ymax, bboxH.ymax);
            }
        }
        return Double.NaN;
    }

    protected double getCoolTypeXHeightFromGlyphs() throws UnsupportedFontException, InvalidFontException {
        Rect bboxX;
        int gidx = this.getCoolTypeGlyphForChar(120);
        if (gidx != 0 && !(bboxX = this.getGlyphBBox(gidx)).equals(Rect.emptyRect)) {
            return bboxX.ymax;
        }
        return Double.NaN;
    }

    public double getCoolTypeCapHeight() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeCapHeightFromGlyphs();
    }

    public double getCoolTypeXHeight() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeXHeightFromGlyphs();
    }

    protected Rect snapToKnownIdeoEmBox(double ymin, double ymax) throws UnsupportedFontException, InvalidFontException {
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        if (unitsPerEmY == 1000.0 && Math.abs(ymin - -120.0) <= 0.004 * unitsPerEmY && Math.abs(ymax - 880.0) <= 0.004 * unitsPerEmY) {
            return new Rect(0.0, -0.12 * unitsPerEmY, unitsPerEmX, 0.88 * unitsPerEmY);
        }
        if (unitsPerEmY == 256.0 && Math.abs(ymin - -36.0) <= 0.0045 * unitsPerEmY && Math.abs(ymax - 220.0) <= 0.0045 * unitsPerEmY) {
            return new Rect(0.0, -0.140625 * unitsPerEmY, unitsPerEmX, 0.859375 * unitsPerEmY);
        }
        return null;
    }

    protected Rect getCoolTypeIdeoEmBoxFromFullBoxCharacter() throws InvalidFontException, UnsupportedFontException {
        int gid = this.getCoolTypeGlyphForChar(9532);
        if (gid != 0) {
            Rect bbox = this.getGlyphBBox(gid);
            double unitsPerEmY = this.getUnitsPerEmY();
            if (!bbox.equals(Rect.emptyRect)) {
                if (bbox.ymax - bbox.ymin != unitsPerEmY) {
                    return null;
                }
                return this.snapToKnownIdeoEmBox(bbox.ymin, bbox.ymax);
            }
        }
        return null;
    }

    protected Rect getCoolTypeIdeoEmBoxFromTypicalCharacter() throws InvalidFontException, UnsupportedFontException {
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        for (int i = 0; i < typicalCharactersForIdeoEmBoxComputation.length; ++i) {
            Rect bbox;
            int gid = this.getCoolTypeGlyphForChar(typicalCharactersForIdeoEmBoxComputation[i]);
            if (gid == 0 || (bbox = this.getGlyphBBox(gid)).equals(Rect.emptyRect)) continue;
            double yMax = bbox.ymax + (unitsPerEmY - (bbox.ymax - bbox.ymin)) / 2.0;
            Rect r = this.snapToKnownIdeoEmBox(yMax - unitsPerEmY, yMax);
            if (r != null) {
                return r;
            }
            return new Rect(0.0, yMax - unitsPerEmY, unitsPerEmX, yMax);
        }
        return null;
    }

    public abstract Rect getCoolTypeIdeoEmBox() throws UnsupportedFontException, InvalidFontException;

    protected Rect getCoolTypeIcfBoxFromTypicalCharacter(Rect ideoEmBox) throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < typicalCharactersForIcfBoxComputation.length; ++i) {
            Rect bbox;
            int gid = this.getCoolTypeGlyphForChar(typicalCharactersForIcfBoxComputation[i]);
            if (gid == 0 || (bbox = this.getGlyphBBox(gid)).equals(Rect.emptyRect)) continue;
            double margin = (ideoEmBox.ymax - bbox.ymax + (bbox.ymin - ideoEmBox.ymin)) / 2.0;
            if (margin < 0.0 && this.useCoolTypeCJKHeuristics()) {
                return null;
            }
            return new Rect(ideoEmBox.xmin + margin, ideoEmBox.ymin + margin, ideoEmBox.xmax - margin, ideoEmBox.ymax - margin);
        }
        return null;
    }

    protected Rect getCoolTypeIcfBoxFromIdeoEmBox(Rect ideoEmBox) throws InvalidFontException, UnsupportedFontException {
        double marginInEm = (1.0 - Math.sqrt(0.9)) / 2.0;
        double marginXInMetricUnits = marginInEm * this.getUnitsPerEmX();
        double marginYInMetricUnits = marginInEm * this.getUnitsPerEmY();
        return new Rect(ideoEmBox.xmin + marginXInMetricUnits, ideoEmBox.ymin + marginYInMetricUnits, ideoEmBox.xmax - marginXInMetricUnits, ideoEmBox.ymax - marginYInMetricUnits);
    }

    public abstract Rect getCoolTypeIcfBox() throws UnsupportedFontException, InvalidFontException;

    protected LineMetrics getCoolTypeLineMetricsFromFontBbox() throws UnsupportedFontException, InvalidFontException {
        double descender;
        double ascender;
        Rect bbox = this.getCoolTypeFontBBox();
        if (bbox == null) {
            return null;
        }
        double unitsPerEmY = this.getUnitsPerEmY();
        long yMinCT = Math.round(65536.0 * bbox.ymin / unitsPerEmY);
        long yMaxCT = Math.round(65536.0 * bbox.ymax / unitsPerEmY);
        long extentCT = yMaxCT - yMinCT;
        if (extentCT > 78643L) {
            ascender = bbox.ymax * unitsPerEmY / (bbox.ymax - bbox.ymin);
            descender = ascender - unitsPerEmY;
        } else if (extentCT >= 65536L) {
            descender = bbox.ymin;
            ascender = descender + unitsPerEmY;
        } else {
            ascender = bbox.ymax;
            descender = ascender - unitsPerEmY;
        }
        return new LineMetrics(ascender, descender, unitsPerEmY / 5.0);
    }

    public Rect getCoolTypeGlyphBBox(int glyphID) throws UnsupportedFontException, InvalidFontException {
        return this.getGlyphBBox(glyphID);
    }

    public abstract LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException;

    public LineMetrics getLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return null;
    }

    public abstract UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException;

    public boolean hasCoolTypeProportionalRoman() throws InvalidFontException, UnsupportedFontException {
        int i;
        boolean notdef = false;
        double firstWidth = 0.0;
        boolean gotFirstWidth = false;
        int[] gids = new int[typicalCharactersForProportionalRomanDecision[0].length];
        for (i = 0; i < typicalCharactersForProportionalRomanDecision.length; ++i) {
            int glyphsFound = 0;
            for (int j = 0; j < typicalCharactersForProportionalRomanDecision[i].length; ++j) {
                gids[j] = this.getGlyphForChar(typicalCharactersForProportionalRomanDecision[i][j]);
                if (gids[j] == 0) continue;
                ++glyphsFound;
            }
            if (glyphsFound == typicalCharactersForProportionalRomanDecision[i].length) break;
        }
        if (i > 0 && this.useCoolTypeCJKHeuristics()) {
            return false;
        }
        if (i < typicalCharactersForProportionalRomanDecision.length) {
            for (int j = 0; j < typicalCharactersForProportionalRomanDecision[i].length; ++j) {
                double thisWidth = this.getHorizontalAdvance(gids[j]);
                if (!gotFirstWidth) {
                    if (Math.round(thisWidth) == 0L) continue;
                    gotFirstWidth = true;
                    firstWidth = thisWidth;
                    continue;
                }
                if (!(Math.abs(firstWidth - thisWidth) > 1.0)) continue;
                return true;
            }
            return false;
        }
        return this.getCoolTypeProportionalRomanFromFontProperties();
    }

    public abstract boolean getCoolTypeProportionalRomanFromFontProperties() throws InvalidFontException;

    public abstract int getGlyphForChar(int var1) throws InvalidFontException, UnsupportedFontException;

    public int getCoolTypeGlyphForChar(int unicodeScalarValue) throws InvalidFontException, UnsupportedFontException {
        return this.getGlyphForChar(unicodeScalarValue);
    }

    public abstract double getHorizontalAdvance(int var1) throws InvalidGlyphException, UnsupportedFontException, InvalidFontException;

    public abstract void getGlyphOutline(int var1, OutlineConsumer var2) throws InvalidFontException, UnsupportedFontException;

    public abstract Rect getGlyphBBox(int var1) throws UnsupportedFontException, InvalidFontException;

    public Scaler getScaler() throws InvalidFontException, UnsupportedFontException {
        return this.getScaler(null);
    }

    public abstract Scaler getScaler(ScanConverter var1) throws InvalidFontException, UnsupportedFontException;

    public abstract SWFFontDescription getSWFFontDescription(boolean var1) throws UnsupportedFontException, InvalidFontException;

    public abstract SWFFont4Description getSWFFont4Description(boolean var1) throws UnsupportedFontException, InvalidFontException;

    public abstract Permission getEmbeddingPermission(boolean var1) throws InvalidFontException, UnsupportedFontException;

    public abstract PDFFontDescription getPDFFontDescription(Font var1) throws UnsupportedFontException, InvalidFontException;

    public abstract XDCFontDescription getXDCFontDescription(Font var1) throws UnsupportedFontException, InvalidFontException;

    public abstract Subset createSubset() throws InvalidFontException, UnsupportedFontException;

    public abstract void subsetAndStream(Subset var1, OutputStream var2, boolean var3) throws InvalidFontException, UnsupportedFontException, IOException;

    protected boolean isSmallCapFont(int gid1, double xHeight) throws UnsupportedFontException, InvalidFontException {
        if (gid1 == 0) {
            return false;
        }
        Rect bbox1 = this.getGlyphBBox(gid1);
        double ppemY = this.getUnitsPerEmY();
        return bbox1.ymax > 0.0 && Math.abs(bbox1.ymax - xHeight) / ppemY < 0.02;
    }

    protected boolean isAllCapFont(int gid1, int gid2) throws InvalidFontException, UnsupportedFontException {
        if (gid1 == 0 || gid2 == 0) {
            return false;
        }
        IteratingOutlineConsumer consumer1 = new IteratingOutlineConsumer();
        this.getGlyphOutline(gid1, consumer1);
        ComparingOutlineConsumer consumer2 = new ComparingOutlineConsumer(consumer1);
        this.getGlyphOutline(gid2, consumer2);
        return consumer2.hasOutlines && consumer2.compares;
    }

    protected boolean isSerifFont(int gidForl, int gidForI, double italicAngle) throws InvalidFontException, UnsupportedFontException {
        if (gidForl == 0 && gidForI == 0) {
            return false;
        }
        int scale = 250;
        boolean serifFound = true;
        SerifEvaluator evaluator = new SerifEvaluator(250, italicAngle);
        Scaler rasterizer = this.getScaler();
        rasterizer.setScale(250.0, 250.0, 250.0, 0.0, 0.0);
        try {
            if (gidForl != 0) {
                evaluator.startBitmap(gidForl);
                rasterizer.getBitmap(gidForl, evaluator);
                serifFound = evaluator.hasSerif();
                evaluator.endBitmap();
            }
        }
        catch (InvalidGlyphException e) {
            // empty catch block
        }
        if (serifFound && gidForI != 0) {
            evaluator.startBitmap(gidForI);
            rasterizer.getBitmap(gidForI, evaluator);
            serifFound = evaluator.hasSerif();
            evaluator.endBitmap();
        }
        return serifFound;
    }

    protected abstract Set getCSSFamilyNames() throws InvalidFontException, UnsupportedFontException;

    protected abstract String getPreferredCSSFamilyName() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSStyleNormal() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSStyleItalic() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSStyleOblique() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSVariantNormal() throws InvalidFontException, UnsupportedFontException;

    protected abstract boolean isCSSVariantSmallCaps() throws InvalidFontException, UnsupportedFontException;

    protected abstract int getCSSWeight() throws InvalidFontException, UnsupportedFontException;

    protected abstract CSS20Attribute.CSSStretchValue getCSSStretchValue() throws InvalidFontException, UnsupportedFontException;

    public abstract CacheSupportInfo getCacheSupportInfo() throws UnsupportedFontException, InvalidFontException;

    public abstract PostscriptFontDescription[] getPostscriptFontDescription() throws InvalidFontException, UnsupportedFontException;

    public abstract FXGFontDescription[] getFXGFontDescription(Platform var1, ULocale var2) throws InvalidFontException, UnsupportedFontException;

    public abstract PlatformFontDescription[] getPlatformFontDescription(Platform var1, ULocale var2) throws InvalidFontException, UnsupportedFontException;

    public double[] getPointSizeRange() throws InvalidFontException, UnsupportedFontException {
        return new double[]{0.0, Double.POSITIVE_INFINITY};
    }

    public CSS20FontDescription[] getCSS20FontDescription() throws InvalidFontException, UnsupportedFontException {
        Set names = this.getCSSFamilyNames();
        int numNames = names.size();
        int numVariants = 0;
        CSS20Attribute.CSSVariantValue[] variants = new CSS20Attribute.CSSVariantValue[2];
        if (this.isCSSVariantSmallCaps()) {
            variants[numVariants++] = CSS20Attribute.CSSVariantValue.SMALL_CAPS;
        }
        if (this.isCSSVariantNormal()) {
            variants[numVariants++] = CSS20Attribute.CSSVariantValue.NORMAL;
        }
        int numStyles = 0;
        CSS20Attribute.CSSStyleValue[] styles = new CSS20Attribute.CSSStyleValue[3];
        if (this.isCSSStyleOblique()) {
            styles[numStyles++] = CSS20Attribute.CSSStyleValue.OBLIQUE;
        }
        if (this.isCSSStyleItalic()) {
            styles[numStyles++] = CSS20Attribute.CSSStyleValue.ITALIC;
        }
        if (this.isCSSStyleNormal()) {
            styles[numStyles++] = CSS20Attribute.CSSStyleValue.NORMAL;
        }
        int cssWeight = this.getCSSWeight();
        CSS20Attribute.CSSStretchValue stretch = this.getCSSStretchValue();
        int numDescriptions = numNames * numStyles * numVariants;
        CSS20FontDescription[] retval = new CSS20FontDescription[numDescriptions];
        Iterator nameIter = names.iterator();
        int currIndex = 0;
        double[] pointSizeRange = this.getPointSizeRange();
        for (int i = 0; i < numNames; ++i) {
            String familyName = (String)nameIter.next();
            for (int j = 0; j < numStyles; ++j) {
                for (int k = 0; k < numVariants; ++k) {
                    retval[currIndex++] = new CSS20FontDescription(familyName, styles[j], variants[k], stretch, cssWeight, pointSizeRange[0] / 10.0, pointSizeRange[1] / 10.0);
                }
            }
        }
        return retval;
    }

    public CSS20FontDescription getPreferredCSS20FontDescription() throws InvalidFontException, UnsupportedFontException {
        CSS20Attribute.CSSStyleValue style;
        CSS20Attribute.CSSVariantValue variant;
        String name = this.getPreferredCSSFamilyName();
        if (name == null) {
            return null;
        }
        if (this.isCSSVariantNormal()) {
            variant = CSS20Attribute.CSSVariantValue.NORMAL;
        } else if (this.isCSSVariantSmallCaps()) {
            variant = CSS20Attribute.CSSVariantValue.SMALL_CAPS;
        } else {
            return null;
        }
        if (this.isCSSStyleNormal()) {
            style = CSS20Attribute.CSSStyleValue.NORMAL;
        } else if (this.isCSSStyleItalic()) {
            style = CSS20Attribute.CSSStyleValue.ITALIC;
        } else if (this.isCSSStyleOblique()) {
            style = CSS20Attribute.CSSStyleValue.OBLIQUE;
        } else {
            return null;
        }
        int cssWeight = this.getCSSWeight();
        CSS20Attribute.CSSStretchValue stretch = this.getCSSStretchValue();
        double[] pointSizeRange = this.getPointSizeRange();
        CSS20FontDescription retval = new CSS20FontDescription(name, style, variant, stretch, cssWeight, pointSizeRange[0] / 10.0, pointSizeRange[1] / 10.0);
        return retval;
    }

    public abstract CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException;

    static class SerifEvaluator
    implements BitmapConsumer {
        int[][] runs = null;
        int minY;
        int minMarked;
        int maxMarked;
        final double widthProportion;
        final int scale;
        final double minDistanceFromVertical;
        final double tangent;

        SerifEvaluator(int scale, double italicAngle) {
            this.scale = scale;
            this.widthProportion = (double)scale * 0.005;
            this.minDistanceFromVertical = (double)scale * 0.008;
            this.tangent = Math.tan(Math.toRadians(-italicAngle));
        }

        boolean hasSerif() {
            if (this.runs == null) {
                return false;
            }
            int middle = this.minMarked + (this.maxMarked - this.minMarked) / 2;
            double minWidth = (int)Math.floor((double)(this.runs[middle][1] - this.runs[middle][0]) * 1.2);
            for (int i = this.minMarked; i <= this.maxMarked; ++i) {
                int middleXMoved;
                int width = this.runs[i][1] - this.runs[i][0];
                if (!((double)width > minWidth) || !((double)((middleXMoved = (int)Math.floor((double)this.runs[middle][0] + (double)(i - middle) * this.tangent)) - this.runs[i][0]) > this.minDistanceFromVertical)) continue;
                return true;
            }
            return false;
        }

        public void addRun(double xOn, double xOff, double y) {
            int i;
            if (this.runs == null) {
                this.minY = (int)y - this.scale;
                this.runs = new int[this.scale * 2][2];
                for (int j = 0; j < this.scale * 2; ++j) {
                    this.runs[j][0] = Integer.MAX_VALUE;
                    this.runs[j][1] = 0;
                }
                this.minMarked = this.maxMarked = (i = this.scale);
                this.runs[i][0] = (int)xOn;
                this.runs[i][1] = (int)xOff;
            } else if ((int)y < this.minY) {
                int[][] newRuns = new int[this.minY - (int)y + this.runs.length][2];
                for (int j = 0; j < this.minY; ++j) {
                    newRuns[j][0] = Integer.MAX_VALUE;
                    newRuns[j][1] = 0;
                }
                this.minMarked += this.minY - (int)y;
                this.maxMarked += this.minY - (int)y;
                System.arraycopy(this.runs, 0, newRuns, this.minY - (int)y, this.runs.length);
                this.runs = newRuns;
                this.minY = (int)y;
                i = 0;
                this.runs[i][0] = (int)xOn;
                this.runs[i][1] = (int)xOff;
            } else {
                i = (int)y - this.minY;
                if ((int)y >= this.minY + this.runs.length) {
                    int[][] newRuns = new int[(int)y - this.minY + 1][2];
                    for (int j = this.runs.length; j <= (int)y - this.minY; ++j) {
                        newRuns[j][0] = 0;
                        newRuns[j][1] = 0;
                    }
                    System.arraycopy(this.runs, 0, newRuns, 0, this.runs.length);
                    this.runs = newRuns;
                    this.runs[i][0] = (int)xOn;
                    this.runs[i][1] = (int)xOff;
                } else if (xOn <= (double)this.runs[i][0]) {
                    if (xOff < (double)this.runs[i][0]) {
                        this.runs[i][1] = (int)xOff;
                    }
                    this.runs[i][0] = (int)xOn;
                } else if (xOn <= (double)this.runs[i][1] && xOff > (double)this.runs[i][1]) {
                    this.runs[i][1] = (int)xOff;
                }
            }
            if (i < this.minMarked) {
                this.minMarked = i;
            }
            if (i > this.maxMarked) {
                this.maxMarked = i;
            }
        }

        public void endBitmap() {
        }

        public void startBitmap(int n) {
            this.runs = null;
        }
    }
}

