/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine;

import com.adobe.agl.charset.CharsetICU;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.concurrent.ConcurrentHashMap;

public class CharsetUtil {
    private static ConcurrentHashMap<String, Charset> charSetMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoderResult encodeLoop(CharBuffer input, ByteBuffer output, CharsetEncoder encoder, boolean throwExceptions) throws MalformedInputException, UnmappableCharacterException {
        CoderResult result = null;
        try {
            result = encoder.encode(input, output, true);
            if ((result.isMalformed() || !result.isError()) && (result = encoder.flush(output)).isError() && !result.isUnderflow()) {
                CharsetUtil.conditionallyThrowCodingError(result);
            }
            CharsetUtil.conditionallyThrowCodingError(result);
        }
        catch (MalformedInputException e) {
            if (throwExceptions) {
                throw e;
            }
        }
        catch (UnmappableCharacterException e) {
            if (throwExceptions) {
                throw e;
            }
        }
        return result;
    }

    public static CoderResult encodeLoopNoExceptions(CharBuffer input, ByteBuffer output, CharsetEncoder encoder) {
        CoderResult result = null;
        try {
            result = CharsetUtil.encodeLoop(input, output, encoder, false);
        }
        catch (MalformedInputException e) {
        }
        catch (UnmappableCharacterException e) {
            // empty catch block
        }
        return result;
    }

    public static CoderResult encodeLoop(CharBuffer input, ByteBuffer output, Charset charset, boolean throwExceptions) throws MalformedInputException, UnmappableCharacterException {
        CharsetEncoder encoder = charset.newEncoder();
        return CharsetUtil.encodeLoop(input, output, encoder, throwExceptions);
    }

    public static CoderResult encodeLoopNoExceptions(CharBuffer input, ByteBuffer output, Charset charset) throws MalformedInputException, UnmappableCharacterException {
        CharsetEncoder encoder = charset.newEncoder();
        return CharsetUtil.encodeLoopNoExceptions(input, output, encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoderResult decodeLoop(ByteBuffer input, CharBuffer output, CharsetDecoder decoder, boolean throwExceptions) throws MalformedInputException, UnmappableCharacterException {
        CoderResult result = null;
        try {
            result = decoder.decode(input, output, true);
            CharsetUtil.conditionallyThrowCodingError(result);
            result = decoder.flush(output);
            CharsetUtil.conditionallyThrowCodingError(result);
            decoder.reset();
        }
        catch (MalformedInputException e) {
            if (throwExceptions) {
                throw e;
            }
        }
        catch (UnmappableCharacterException e) {
            if (throwExceptions) {
                throw e;
            }
        }
        return result;
    }

    public static CoderResult decodeLoopNoExceptions(ByteBuffer input, CharBuffer output, CharsetDecoder decoder) {
        CoderResult result = null;
        try {
            result = CharsetUtil.decodeLoop(input, output, decoder, false);
        }
        catch (MalformedInputException e) {
        }
        catch (UnmappableCharacterException e) {
            // empty catch block
        }
        return result;
    }

    public static CoderResult decodeLoop(ByteBuffer input, CharBuffer output, Charset charset, boolean throwExceptions) throws MalformedInputException, UnmappableCharacterException {
        CharsetDecoder decoder = charset.newDecoder();
        return CharsetUtil.decodeLoop(input, output, decoder, throwExceptions);
    }

    public static CoderResult decodeLoopNoExceptions(ByteBuffer input, CharBuffer output, Charset charset) throws MalformedInputException, UnmappableCharacterException {
        CharsetDecoder decoder = charset.newDecoder();
        return CharsetUtil.decodeLoopNoExceptions(input, output, decoder);
    }

    public static void conditionallyThrowCodingError(CoderResult result) throws MalformedInputException, UnmappableCharacterException {
        if (result.isError()) {
            if (result.isMalformed()) {
                throw new MalformedInputException(result.length());
            }
            if (result.isOverflow()) {
                // empty if block
            }
            if (result.isUnmappable()) {
                throw new UnmappableCharacterException(result.length());
            }
            if (result.isUnderflow()) {
                // empty if block
            }
        }
    }

    public static Charset forNameICU(String charsetName) {
        Charset prev;
        if (charsetName == null) {
            return null;
        }
        Charset charSet = charSetMap.get(charsetName);
        if (charSet == null && (prev = charSetMap.putIfAbsent(charsetName, charSet = CharsetICU.forNameICU(charsetName))) != null) {
            charSet = prev;
        }
        return charSet;
    }
}

