/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import coldfusion.lucene.SolrServiceImpl;
import coldfusion.runtime.SearchEngineException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.search.SearchEngineLibraryException;
import coldfusion.tagext.search.SolrUtils;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;

public class Utils {
    private static final SolrServiceImpl solrService = (SolrServiceImpl)ServiceFactory.getSolrService();
    public static final String[] luceneLanguage = new String[]{"english", "brazilian", "russian", "chinese", "cjk", "german", "french", "dutch", "czech", "greek", "thai"};
    private static final String styleAlias = "ColdFusionK2";
    private static Hashtable collection_pi_cache = new Hashtable();
    public static HashMap language_map = new HashMap();
    public static HashMap reverse_language_map;
    public static HashMap charset_map;

    private Utils() {
    }

    public static void PICacheRemove(String collection) {
        collection_pi_cache.remove(collection);
    }

    public static void deleteCollectionDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                Utils.deleteCollectionDir(new File(dir, children[i]));
            }
        }
        dir.delete();
    }

    public static void doCollectionOptimization(String collectionName) throws SearchEngineLibraryException, SolrServerException, IOException {
        String solrurl = SolrUtils.getSolrURL(solrService);
        if (SolrUtils.isSolrCore(solrurl, collectionName)) {
            collectionName = SolrUtils.fixURL(collectionName);
            SolrClient client = SolrUtils.getSolrClient(solrurl, collectionName);
            SolrUtils.optimizeCollection(client);
        }
    }

    public static void checkCollectionExists(String collectionname) {
        String solrurl = SolrUtils.getSolrURL(solrService);
        boolean result = SolrUtils.isSolrCore(solrurl, collectionname);
        if (result) {
            throw new SolrCollectionExistsException(collectionname);
        }
    }

    public static Date getNow() {
        Date now = new Date();
        return now;
    }

    public static long getDirectorySize(File file) {
        long size = 0L;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    long tmpSize = Utils.getDirectorySize(files[i]);
                    if (tmpSize == -1L) continue;
                    size += tmpSize;
                }
                return size;
            }
            return -1L;
        }
        return file.length();
    }

    public static String getPIName(String collectionName) {
        return collectionName.toLowerCase() + "_pi";
    }

    public static boolean isDirectory(final File f) {
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return f.isDirectory();
            }
        });
        return b;
    }

    static {
        language_map.put("bokmal", "bokmalx");
        language_map.put("bulgarian", "bulgaria");
        language_map.put("danish", "danishx");
        language_map.put("dutch", "dutchx");
        language_map.put("finnish", "finnishx");
        language_map.put("french", "frenchx");
        language_map.put("german", "germanx");
        language_map.put("italian", "italianx");
        language_map.put("japanese", "japanb");
        language_map.put("korean", "koreab");
        language_map.put("nynorsk", "nynorskx");
        language_map.put("nynorski", "nynorskx");
        language_map.put("norwegian", "nynorskx");
        language_map.put("norweg", "nynorskx");
        language_map.put("portug", "portugx");
        language_map.put("portuguese", "portugx");
        language_map.put("simplified_chinese", "simpcb");
        language_map.put("spanish", "spanishx");
        language_map.put("swedish", "swedishx");
        language_map.put("traditional_chinese", "tradcb");
        reverse_language_map = new HashMap();
        reverse_language_map.put("bokmalx", "bokmal");
        reverse_language_map.put("bulgaria", "bulgarian");
        reverse_language_map.put("danishx", "danish");
        reverse_language_map.put("dutchx", "dutch");
        reverse_language_map.put("finnishx", "finnish");
        reverse_language_map.put("frenchx", "french");
        reverse_language_map.put("germanx", "german");
        reverse_language_map.put("italianx", "italian");
        reverse_language_map.put("japanb", "japanese");
        reverse_language_map.put("koreab", "korean");
        reverse_language_map.put("nynorskx", "norwegian");
        reverse_language_map.put("portugx", "portuguese");
        reverse_language_map.put("simpcb", "simplified_chinese");
        reverse_language_map.put("spanishx", "spanish");
        reverse_language_map.put("swedishx", "swedish");
        reverse_language_map.put("tradcb", "traditional_chinese");
        charset_map = new HashMap();
        charset_map.put("uni", "utf8");
        charset_map.put("arabic", "1256");
        charset_map.put("bulgaria", "1251");
        charset_map.put("czech", "1250");
        charset_map.put("danishx", "1252");
        charset_map.put("dutchx", "1252");
        charset_map.put("english", "1252");
        charset_map.put("englishx", "1252");
        charset_map.put("finnishx", "1252");
        charset_map.put("frenchx", "1252");
        charset_map.put("germanx", "1252");
        charset_map.put("greek", "1253");
        charset_map.put("hebrew", "1255");
        charset_map.put("hungarian", "1250");
        charset_map.put("italianx", "1252");
        charset_map.put("japanb", "sjis");
        charset_map.put("koreab", "ksc");
        charset_map.put("bokmalx", "1252");
        charset_map.put("nynorskx", "1252");
        charset_map.put("polish", "1250");
        charset_map.put("portugx", "1252");
        charset_map.put("russian", "1251");
        charset_map.put("russian2", "koi8-r");
        charset_map.put("simpcb", "gb");
        charset_map.put("spanishx", "1252");
        charset_map.put("swedishx", "1252");
        charset_map.put("tradcb", "big5");
        charset_map.put("turkish", "1254");
    }

    public static class UnableToCreateCollectionException
    extends SearchEngineException {
        public String collection;
        public String error;

        public UnableToCreateCollectionException(String collection, Throwable ex) {
            this.collection = collection;
            this.error = ex.toString();
        }
    }

    public static class UnableToCreateSolrCollectionException
    extends SearchEngineException {
        public String collection;
        public String error;

        public UnableToCreateSolrCollectionException(String collection, Throwable ex) {
            this.collection = collection;
            this.error = ex.toString().split(":")[0];
        }
    }

    public static class SolrCollectionExistsException
    extends SearchEngineException {
        public String collection;

        public SolrCollectionExistsException(String collection) {
            this.collection = collection;
        }
    }

    public static class CollectionExistsException
    extends SearchEngineException {
        public String collection;

        public CollectionExistsException(String collection) {
            this.collection = collection;
        }
    }
}

