/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ContactAddress;
import coldfusion.exchange.ContactOtherDetails;
import coldfusion.exchange.ExchangeContact;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.exchange.ContactConstants;
import coldfusion.tagext.net.exchange.ContactQueryMetaData;
import java.util.ArrayList;

public class ContactQuery
extends QueryTable
implements ContactConstants {
    public void populate(ArrayList resultArray) {
        this.meta = new ContactQueryMetaData();
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (resultArray == null || resultArray.size() == 0) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(resultArray.size());
        for (ExchangeContact ct : resultArray) {
            Object[] colData = new Object[this.col_count];
            ContactOtherDetails detail = ct.getDetails();
            Struct homeAddress = null;
            Struct businessAddress = null;
            Struct otherAddress = null;
            ContactAddress addr = ct.getHomeAddress();
            String tmpStr = null;
            if (addr != null) {
                homeAddress = new Struct();
                tmpStr = addr.getStreet();
                homeAddress.put((Object)"street", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getCity();
                homeAddress.put((Object)"city", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getState();
                homeAddress.put((Object)"state", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getPostalCode();
                homeAddress.put((Object)"zip", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getCountry();
                homeAddress.put((Object)"country", (Object)(tmpStr == null ? "" : tmpStr));
            }
            if ((addr = ct.getBusinessAddress()) != null) {
                businessAddress = new Struct();
                tmpStr = addr.getStreet();
                businessAddress.put((Object)"street", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getCity();
                businessAddress.put((Object)"city", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getState();
                businessAddress.put((Object)"state", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getPostalCode();
                businessAddress.put((Object)"zip", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getCountry();
                businessAddress.put((Object)"country", (Object)(tmpStr == null ? "" : tmpStr));
            }
            if ((addr = ct.getOtherAddress()) != null) {
                otherAddress = new Struct();
                tmpStr = addr.getStreet();
                otherAddress.put((Object)"street", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getCity();
                otherAddress.put((Object)"city", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getState();
                otherAddress.put((Object)"state", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getPostalCode();
                otherAddress.put((Object)"zip", (Object)(tmpStr == null ? "" : tmpStr));
                tmpStr = addr.getCountry();
                otherAddress.put((Object)"country", (Object)(tmpStr == null ? "" : tmpStr));
            }
            colData[0] = ct.getFirstName();
            colData[1] = ct.getLastName();
            colData[2] = ct.getMiddleName();
            colData[3] = ct.getDislpayName();
            colData[4] = ct.getJobTitle();
            colData[5] = ct.getCompany();
            colData[6] = ct.getBusinessHomePage();
            colData[7] = ct.getEMail1();
            colData[8] = ct.getEMail2();
            colData[9] = ct.getEMail3();
            colData[10] = ct.getHomePhone();
            colData[11] = ct.getBusinessPhone();
            colData[12] = ct.getOtherPhone();
            colData[13] = ct.getMobilePhone();
            colData[14] = ct.getPager();
            colData[15] = detail == null ? null : detail.getOffice();
            colData[16] = detail == null ? null : detail.getProfession();
            colData[17] = detail == null ? null : detail.getManager();
            colData[18] = detail == null ? null : detail.getAssistant();
            colData[19] = detail == null ? null : detail.getNickname();
            colData[20] = detail == null ? null : detail.getPartner();
            colData[21] = homeAddress;
            colData[22] = businessAddress;
            colData[23] = otherAddress;
            colData[24] = ct.getHasAttachment();
            colData[25] = ct.getId();
            colData[26] = ct.getDescription();
            colData[27] = ct.getHtmlMessage();
            colData[28] = detail == null ? null : detail.getDepartment();
            colData[29] = ct.getBusinessFax();
            Integer type = ct.getMailingAdressType();
            String mailingAddrType = null;
            if (type != null) {
                switch (type) {
                    case 1: {
                        mailingAddrType = "HOME";
                        break;
                    }
                    case 2: {
                        mailingAddrType = "BUSINESS";
                        break;
                    }
                    case 3: {
                        mailingAddrType = "OTHER";
                    }
                }
            }
            colData[30] = mailingAddrType;
            colData[31] = ct.getCategories();
            colData[32] = ct.getLastModified() != null ? CFPage.CreateODBCDateTime((Object)ct.getLastModified()) : null;
            this.addRow(colData);
        }
    }
}

