/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webservice;

import coldfusion.exchange.ExchangeAbstractObject;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webservice.Exchange2007Exception;
import coldfusion.exchange.webservice.Exchange2007Manager;
import coldfusion.exchange.webservice.Exchange2007WebServiceHelper;
import coldfusion.wddx.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Exchange2007AttachmentManager
extends Exchange2007Manager {
    public Exchange2007AttachmentManager(WebDAVConnection con) {
        super(con);
    }

    public ArrayList getAttachments(ExchangeAbstractObject exchangeObj, String folderPath) throws Exception {
        String[] ids = null;
        String keyName = null;
        String folderName = null;
        if (exchangeObj instanceof ExchangeAppointment) {
            keyName = "CalendarItem";
            folderName = "calendar";
        } else if (exchangeObj instanceof ExchangeMessage) {
            keyName = "Message";
            folderName = folderPath == null ? "inbox" : folderPath;
        } else if (exchangeObj instanceof ExchangeContact) {
            keyName = "Contact";
            folderName = "contacts";
        } else if (exchangeObj instanceof ExchangeTask) {
            keyName = "Task";
            folderName = "tasks";
        } else {
            return null;
        }
        ids = this.findItemIdHelper(exchangeObj, folderName, keyName);
        if (ids == null) {
            return null;
        }
        String itemId = ids[0];
        String changeKey = ids[1];
        ArrayList attachIds = this.getAttachmentIDs(itemId, changeKey, keyName);
        if (attachIds != null) {
            ArrayList<ExchangeAttachment> attachments = new ArrayList<ExchangeAttachment>();
            for (int i = 0; i < attachIds.size(); ++i) {
                ExchangeAttachment atch = this.getAttachmentContent(attachIds.get(i).toString());
                if (atch == null) continue;
                attachments.add(atch);
            }
            return attachments;
        }
        return null;
    }

    private String[] findItemIdHelper(ExchangeAbstractObject exchObj, String folderPath, String itemKeyName) throws Exception {
        String parentFoldeId = null;
        String parentFolderChangeKey = null;
        String[] ids = this.getSubFolderId(folderPath);
        if (ids == null) {
            throw new Exchange2007Exception(7, "Folder " + folderPath + " not found");
        }
        parentFoldeId = ids[0];
        parentFolderChangeKey = ids[1];
        String msg = Exchange2007WebServiceHelper.createFindItemRequest(exchObj, folderPath, parentFoldeId, parentFolderChangeKey, null);
        String response = this.postExchangeRequest(msg);
        Document doc = Exchange2007AttachmentManager.parseResponseXML(response);
        Exchange2007AttachmentManager.validateResponse(doc);
        String messagePath = "soap:Envelope/soap:Body/m:FindItemResponse/m:ResponseMessages/m:FindItemResponseMessage/m:RootFolder/t:Items";
        Object resultObjs = Exchange2007AttachmentManager.searchNode(doc, messagePath);
        if (!(resultObjs instanceof Node)) {
            return null;
        }
        Node itemsNode = (Node)resultObjs;
        Object resultObj = Exchange2007AttachmentManager.searchNode(itemsNode, "t:" + itemKeyName);
        if (resultObj == null) {
            return null;
        }
        Node ctNode = null;
        if (resultObj instanceof Node) {
            ctNode = (Node)resultObj;
        } else if (resultObj instanceof Node[]) {
            Node[] resultNodes = (Node[])resultObj;
            ArrayList<Node> matches = new ArrayList<Node>();
            String itemTimeReceived = Utils.localToLongExchangeDate(exchObj.getTimeReceived(), true);
            for (int i = 0; i < resultNodes.length; ++i) {
                String hasAttachment;
                String timeReceived = Exchange2007AttachmentManager.getNodeValue(resultNodes[i], "t:DateTimeReceived");
                if (timeReceived == null || !itemTimeReceived.equals(timeReceived) || (hasAttachment = Exchange2007AttachmentManager.getNodeValue(resultNodes[i], "t:HasAttachments")) == null || !hasAttachment.equalsIgnoreCase("true")) continue;
                matches.add(resultNodes[i]);
            }
            if (matches.size() == 0) {
                return null;
            }
            if (matches.size() > 1) {
                return null;
            }
            ctNode = (Node)matches.get(0);
        }
        Object itemObj = Exchange2007AttachmentManager.searchNode(ctNode, "t:ItemId");
        if (itemObj != null) {
            Node itemNode = (Node)itemObj;
            NamedNodeMap attribMap = itemNode.getAttributes();
            String wsItemId = attribMap.getNamedItem("Id").getNodeValue();
            String changeKey = attribMap.getNamedItem("ChangeKey").getNodeValue();
            return new String[]{wsItemId, changeKey};
        }
        return null;
    }

    private ArrayList getAttachmentIDs(String exchangeItemId, String changeKey, String keyName) throws Exception {
        String msg = Exchange2007WebServiceHelper.createGetItemRequest(exchangeItemId, changeKey, null);
        String response = this.postExchangeRequest(msg);
        Document doc = Exchange2007AttachmentManager.parseResponseXML(response);
        Exchange2007AttachmentManager.validateResponse(doc);
        String attachmentPath = "soap:Envelope/soap:Body/m:GetItemResponse/m:ResponseMessages/m:GetItemResponseMessage/m:Items/t:" + keyName + "/t:Attachments/t:FileAttachment";
        Object msgObjs = Exchange2007AttachmentManager.searchNode(doc, attachmentPath);
        if (msgObjs == null) {
            return null;
        }
        Node[] msgNodes = null;
        if (msgObjs instanceof Node) {
            msgNodes = new Node[]{(Node)msgObjs};
        } else if (msgObjs instanceof Node[]) {
            msgNodes = (Node[])msgObjs;
        }
        if (msgNodes != null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < msgNodes.length; ++i) {
                Object attachObj = Exchange2007AttachmentManager.searchNode(msgNodes[i], "t:AttachmentId");
                if (attachObj == null) continue;
                Node attachNode = (Node)attachObj;
                NamedNodeMap attribMap = attachNode.getAttributes();
                ids.add(attribMap.getNamedItem("Id").getNodeValue());
            }
            return ids;
        }
        return null;
    }

    private ExchangeAttachment getAttachmentContent(String atchId) throws Exception {
        String msg = Exchange2007WebServiceHelper.createGetAttachmentRequest(atchId, null);
        String response = this.postExchangeRequest(msg);
        Document doc = Exchange2007AttachmentManager.parseResponseXML(response);
        Exchange2007AttachmentManager.validateResponse(doc);
        String attachmentPath = "soap:Envelope/soap:Body/m:GetAttachmentResponse/m:ResponseMessages/m:GetAttachmentResponseMessage/m:Attachments/t:FileAttachment";
        Object msgObjs = Exchange2007AttachmentManager.searchNode(doc, attachmentPath);
        if (msgObjs == null) {
            return null;
        }
        Node atchNode = null;
        if (msgObjs instanceof Node) {
            atchNode = (Node)msgObjs;
        } else if (msgObjs instanceof Node[]) {
            atchNode = ((Node[])msgObjs)[0];
        }
        if (atchNode != null) {
            String contentType;
            String fileName;
            ExchangeAttachment attachmentObj = new ExchangeAttachment();
            String contentB64 = Exchange2007AttachmentManager.getNodeValue(atchNode, "t:Content");
            if (contentB64 != null) {
                byte[] contentBytes = Base64Encoder.decode((String)contentB64);
                attachmentObj.setFileContent(new ByteArrayInputStream(contentBytes));
                attachmentObj.setFileSize(contentBytes.length);
            }
            if ((fileName = Exchange2007AttachmentManager.getNodeValue(atchNode, "t:Name")) != null) {
                attachmentObj.setFileName(fileName);
            }
            if ((contentType = Exchange2007AttachmentManager.getNodeValue(atchNode, "t:ContentType")) != null) {
                attachmentObj.setMimeType(contentType);
            }
            return attachmentObj;
        }
        return null;
    }
}

