/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs.s3;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.UriParser;

public class S3FileName
extends AbstractFileName {
    private String bucket;
    private String accessKeyId;
    private String secretAccessKey;
    private String baseName;

    public S3FileName(String scheme, String absPath, FileType type, String bucket, String accessKeyId, String secretAccessKey) {
        super(scheme, absPath, type);
        this.bucket = bucket;
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public FileName createName(String absPath, FileType type) {
        return new S3FileName(this.getScheme(), absPath, type, this.bucket, this.accessKeyId, this.secretAccessKey);
    }

    public String getBaseName() {
        if (this.baseName == null) {
            this.baseName = super.getPath();
            if (this.baseName != null && this.baseName.length() > 1 && this.baseName.charAt(0) == '/') {
                this.baseName = this.baseName.substring(1);
            }
        }
        return this.baseName;
    }

    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        this.appendCredentials(buffer, addPassword);
        buffer.append(this.bucket);
    }

    protected void appendCredentials(StringBuilder buffer, boolean addPassword) {
        if (this.accessKeyId != null && this.accessKeyId.length() != 0) {
            UriParser.appendEncoded((StringBuilder)buffer, (String)this.accessKeyId, (char[])new char[0]);
            if (this.secretAccessKey != null && this.secretAccessKey.length() != 0) {
                buffer.append(':');
                if (addPassword) {
                    UriParser.appendEncoded((StringBuilder)buffer, (String)this.secretAccessKey, (char[])new char[0]);
                }
            }
            buffer.append('@');
        }
    }
}

