/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.SerializationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Struct;
import coldfusion.s3.RootReference;
import coldfusion.s3.S3ServiceImpl;
import coldfusion.s3.S3Utils;
import coldfusion.s3.consumer.BucketLifecycleConfigurationConsumer;
import coldfusion.s3.consumer.DeleteObjectRequestConsumer;
import coldfusion.s3.consumer.DownloadFileRequestConsumer;
import coldfusion.s3.consumer.DownloadObjectRequestConsumer;
import coldfusion.s3.consumer.FileMultipartUploadRequestConsumer;
import coldfusion.s3.consumer.GetObjectAclRequestConsumer;
import coldfusion.s3.consumer.GetObjectDetailConsumer;
import coldfusion.s3.consumer.GetObjectLegalHoldRequestConsumer;
import coldfusion.s3.consumer.GetObjectPresignedRequestConsumer;
import coldfusion.s3.consumer.GetObjectRetentionRequestConsumer;
import coldfusion.s3.consumer.GetObjectTaggingRequestConsumer;
import coldfusion.s3.consumer.LifecycleRuleConsumer;
import coldfusion.s3.consumer.ListObjectVersionsRequestConsumer;
import coldfusion.s3.consumer.ListObjectsRequestConsumer;
import coldfusion.s3.consumer.ObjectCopyRequestConsumer;
import coldfusion.s3.consumer.ObjectLockConfigurationConsumer;
import coldfusion.s3.consumer.ParallelFileDownloadConsumer;
import coldfusion.s3.consumer.PutBucketAclRequestConsumer;
import coldfusion.s3.consumer.PutBucketPolicyRequestConsumer;
import coldfusion.s3.consumer.PutObjectAclRequestConsumer;
import coldfusion.s3.consumer.PutObjectLegalHoldRequestConsumer;
import coldfusion.s3.consumer.PutObjectLockConfigurationRequestConsumer;
import coldfusion.s3.consumer.PutObjectPresignedRequestConsumer;
import coldfusion.s3.consumer.PutObjectRetentionRequestConsumer;
import coldfusion.s3.consumer.PutPublicAccessBlockRequestConsumer;
import coldfusion.s3.consumer.TaggingConsumer;
import coldfusion.s3.consumer.UploadDirectoryS3RequestConsumer;
import coldfusion.s3.consumer.UploadFileRequestConsumer;
import coldfusion.s3.consumer.UploadObjectRequestConsumer;
import coldfusion.s3.exception.S3APIException;
import coldfusion.s3.request.DownloadFileRequest;
import coldfusion.s3.request.DownloadObjectRequest;
import coldfusion.s3.request.FileMultipartUploadRequest;
import coldfusion.s3.request.GetObjectPresignedRequest;
import coldfusion.s3.request.ObjectCopyRequest;
import coldfusion.s3.request.ObjectTagging;
import coldfusion.s3.request.ObjectVersioning;
import coldfusion.s3.request.ParallelFileDownloadRequest;
import coldfusion.s3.request.PutObjectPresignRequest;
import coldfusion.s3.request.UploadDirectoryS3Request;
import coldfusion.s3.request.UploadFileRequest;
import coldfusion.s3.request.UploadObjectRequest;
import coldfusion.s3.request.VersionConsumer;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.servlet.jsp.PageContext;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.internal.http.InterruptMonitor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.internal.presigner.DefaultS3Presigner;
import software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration;
import software.amazon.awssdk.services.s3.model.BucketVersioningStatus;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.InventoryOptionalField;
import software.amazon.awssdk.services.s3.model.LifecycleRule;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.MFADelete;
import software.amazon.awssdk.services.s3.model.Payer;
import software.amazon.awssdk.services.s3.model.PublicAccessBlockConfiguration;
import software.amazon.awssdk.services.s3.model.PutBucketAclRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAclResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.model.VersioningConfiguration;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringUtils;

@GenerateCFNamedInvoke
public class BucketReference
implements RootReference,
NamedInvokable {
    private static final String RESPONSE = "response";
    private Logger logger = CFLogs.SERVER_LOG;
    private ExecutorService executorService;
    private String bucketName;
    private S3Client s3Client;
    private S3ServiceImpl s3Service;
    private ValidatorFiller filler = ValidatorFiller.INSTANCE;
    private Integer DEFAULT_PART_SIZE = 0x2000000;
    private Integer MINIMUM_PART_SIZE = 0x500000;
    private final String STATUS = "status";
    private final String STATUS_CODE = "statusCode";
    private final String SUCCESS = "Success";
    private final String FAILURE = "Failure";
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.S3.name());
    private static InvokeNamedMethodInvocationMap<BucketReference> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    BucketReference(S3ServiceImpl s3Service, String bucketName) {
        this.bucketName = bucketName;
        this.s3Service = s3Service;
        this.s3Client = s3Service.getS3Client();
        this.tagAttributeList.addTagAttribute("bucket", (Object)bucketName);
        int cores = Runtime.getRuntime().availableProcessors();
        this.executorService = Executors.newFixedThreadPool(2 * cores / (cores + 1));
    }

    void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public Struct getLocation() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getLocation", (boolean)true);
        String statusCode = "Success";
        GetBucketLocationRequest request = (GetBucketLocationRequest)GetBucketLocationRequest.builder().bucket(this.bucketName).build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getLocation, request : " + request.toString()));
            String location = this.s3Client.getBucketLocation(request).locationConstraintAsString();
            location = StringUtils.isEmpty((CharSequence)location) ? "us-east-1" : location;
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getLocation is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"location", (Object)location);
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getLocation : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getBucketLocationError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getLocation : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getBucketLocationError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getLocation", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public Struct listAll() {
        return this.listAll(null);
    }

    @Override
    public Struct listAll(Map listRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"listAll", (boolean)true);
        ListObjectsRequest.Builder request = ListObjectsRequest.builder().bucket(this.bucketName);
        if (Objects.nonNull(listRequest)) {
            this.filler.fillObject((Object)request, listRequest, (ConsumerMap)new ListObjectsRequestConsumer());
        }
        String statusCode = "Success";
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in listAll, request : " + request.toString()));
            ListObjectsResponse listObjectsResponse = this.s3Client.listObjects((ListObjectsRequest)request.build());
            List list = listObjectsResponse.contents().stream().map(s3Object -> {
                Struct objectStruct = new Struct();
                objectStruct.put((Object)"key", (Object)s3Object.key());
                objectStruct.put((Object)"eTag", (Object)s3Object.eTag());
                objectStruct.put((Object)"lastModified", (Object)s3Object.lastModified().toString());
                objectStruct.put((Object)"ownerId", (Object)s3Object.owner().id());
                objectStruct.put((Object)"storageClass", (Object)s3Object.storageClass().toString());
                return objectStruct;
            }).collect(Collectors.toList());
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in listAll is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)RESPONSE, list);
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in listAll : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"listAllObjectError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in listAll : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"listAllObjectError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listAll", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct listAllVersions() {
        Struct listRequest = new Struct();
        return this.listAllVersions((Map)listRequest);
    }

    public Struct listAllVersions(Map listRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"listAllVersions", (boolean)true);
        ListObjectVersionsRequest.Builder request = ListObjectVersionsRequest.builder().bucket(this.bucketName);
        if (Objects.nonNull(listRequest)) {
            this.filler.fillObject((Object)request, listRequest, (ConsumerMap)new ListObjectVersionsRequestConsumer());
        }
        String statusCode = "Success";
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in listAllVersions, request : " + request.toString()));
            List list = this.s3Client.listObjectVersions((ListObjectVersionsRequest)request.build()).versions().stream().map(s3Object -> {
                Struct objectStruct = new Struct();
                objectStruct.put((Object)"key", (Object)s3Object.key());
                objectStruct.put((Object)"eTag", (Object)s3Object.eTag());
                objectStruct.put((Object)"versionId", (Object)s3Object.versionId());
                objectStruct.put((Object)"lastModified", (Object)s3Object.lastModified().toString());
                objectStruct.put((Object)"ownerId", (Object)s3Object.owner().id());
                objectStruct.put((Object)"storageClass", (Object)s3Object.storageClass().toString());
                return objectStruct;
            }).collect(Collectors.toList());
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in listAllVersions is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)RESPONSE, list);
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in listAllVersions : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"listAllVersionError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in listAllVersions : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"listAllVersionError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"listAllVersions", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public Struct putPolicy(Map putPolicyRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"putPolicy", (boolean)true);
        PutBucketPolicyRequest.Builder builder = PutBucketPolicyRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, putPolicyRequest, (ConsumerMap)new PutBucketPolicyRequestConsumer());
        String statusCode = "Success";
        PutBucketPolicyRequest request = (PutBucketPolicyRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in putPolicy, request : " + request.toString()));
            PutBucketPolicyResponse response = this.s3Client.putBucketPolicy(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in putPolicy is completed in  " + (endTime - startTime) + " ms"));
            Struct responce = new Struct();
            responce.put((Object)"status", (Object)"Success");
            Struct struct = responce;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in putPolicy : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putPolicyError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in putPolicy : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putPolicyError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"putPolicy", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public Struct getPolicies() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getPolicies", (boolean)true);
        GetBucketPolicyRequest.Builder builder = GetBucketPolicyRequest.builder().bucket(this.bucketName);
        String statusCode = "Success";
        GetBucketPolicyRequest request = (GetBucketPolicyRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getPolicies, request : " + request.toString()));
            GetBucketPolicyResponse policyResponse = this.s3Client.getBucketPolicy(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getPolicies is completed in  " + (endTime - startTime) + " ms"));
            Struct responce = new Struct();
            responce.put((Object)"policy", (Object)policyResponse.policy());
            responce.put((Object)"status", (Object)"Success");
            Struct struct = responce;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getPolicies : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getPoliciesError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getPolicies : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getPoliciesError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getPolicies", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public Struct deletePolicies() {
        RequestMonitorEventProcessor.onFunctionStart((String)"deletePolicies", (boolean)true);
        DeleteBucketPolicyRequest.Builder builder = DeleteBucketPolicyRequest.builder().bucket(this.bucketName);
        String statusCode = "Success";
        DeleteBucketPolicyRequest request = (DeleteBucketPolicyRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in deletePolicies, request : " + request.toString()));
            this.s3Client.deleteBucketPolicy(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in deletePolicies is completed in  " + (endTime - startTime) + " ms"));
            statusCode = "Success";
            Struct struct = new Struct();
            struct.put((Object)"status", (Object)"Success");
            Struct struct2 = struct;
            return struct2;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in deletePolicies : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"deletePoliciesError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in deletePolicies : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"deletePoliciesError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"deletePolicies", (String)"delete", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public Struct uploadFile(String srcFile, String key) {
        Struct struct = new Struct();
        struct.put((Object)"srcFile", (Object)srcFile);
        struct.put((Object)"key", (Object)key);
        return this.uploadFile((Map)struct);
    }

    @Override
    public Struct uploadFile(Map uploadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"uploadFile", (boolean)true);
        String statusCode = "Success";
        try {
            Struct struct = this.performUploadFile(uploadRequest);
            return struct;
        }
        catch (S3APIException e) {
            statusCode = "Failure";
            throw e;
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"uploadFile", (String)"put", (Object)statusCode, null, (String)((String)uploadRequest.get("key")), (TagAttributeList)this.tagAttributeList);
        }
    }

    private Struct performUploadFile(Map uploadRequest) {
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        this.filler.fillObject((Object)uploadFileRequest, uploadRequest, (ConsumerMap)UploadFileRequestConsumer.getInstance());
        String srcFileName = uploadFileRequest.getSrcFile();
        try {
            if (uploadFileRequest.isValidateContentMD5()) {
                uploadFileRequest.getPutObjectRequest().contentMD5(Md5Utils.md5AsBase64((File)VFSFileFactory.getFileObject((String)srcFileName)));
            }
            PutObjectRequest request = (PutObjectRequest)uploadFileRequest.getPutObjectRequest().bucket(this.bucketName).build();
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in uploadFile, request : " + request.toString()));
            PutObjectResponse response = this.s3Client.putObject(request, VFSFileFactory.getFileObject((String)uploadFileRequest.getSrcFile()).toPath());
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in uploadFile is completed in  " + (endTime - startTime) + " ms"));
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"Success");
            if (Objects.nonNull(response.versionId())) {
                structResponse.put((Object)"versionId", (Object)response.versionId());
            }
            return structResponse;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in uploadFile : ", (Throwable)e);
            throw new S3APIException(RB.getString(BucketReference.class, (String)"uploadFileError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in uploadFile : ", (Throwable)e);
            throw new S3APIException(RB.getString(BucketReference.class, (String)"uploadFileError"), e);
        }
    }

    @Override
    public Struct uploadObject(Map uploadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"uploadObject", (boolean)true);
        UploadObjectRequest uploadObjectRequest = new UploadObjectRequest();
        String statusCode = "Success";
        try {
            this.filler.fillObject((Object)uploadObjectRequest, uploadRequest, (ConsumerMap)UploadObjectRequestConsumer.getInstance());
            Object inputObject = uploadObjectRequest.getInputObject();
            String serializedString = SerializationUtil.Serialize((Object)inputObject, (String)uploadObjectRequest.getType(), (boolean)uploadObjectRequest.isUseCustomSerializer());
            if (uploadObjectRequest.isValidateContentMD5()) {
                uploadObjectRequest.getPutObjectRequest().contentMD5(Md5Utils.md5AsBase64((byte[])serializedString.getBytes()));
            }
            PutObjectRequest request = (PutObjectRequest)uploadObjectRequest.getPutObjectRequest().bucket(this.bucketName).build();
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in uploadObject, request : " + request.toString()));
            PutObjectResponse response = this.s3Client.putObject(request, RequestBody.fromString((String)serializedString));
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in uploadObject is completed in  " + (endTime - startTime) + " ms"));
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"Success");
            if (Objects.nonNull(response.versionId())) {
                structResponse.put((Object)"versionId", (Object)response.versionId());
            }
            Struct struct = structResponse;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in uploadObject : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"uploadObjectError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in uploadObject : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"uploadObjectError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"uploadObject", (String)"put", (Object)statusCode, null, (String)((String)uploadRequest.get("key")), (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public Struct downloadObject(Map downloadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"downloadObject", (boolean)true);
        DownloadObjectRequest downloadObjectRequest = new DownloadObjectRequest();
        String statusCode = "Success";
        try {
            this.filler.fillObject((Object)downloadObjectRequest, downloadRequest, (ConsumerMap)DownloadObjectRequestConsumer.getInstance());
            GetObjectRequest request = (GetObjectRequest)downloadObjectRequest.getObjectRequest().bucket(this.bucketName).build();
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in downloadObject, request : " + request.toString()));
            ResponseInputStream responseInputStream = this.s3Client.getObject(request);
            GetObjectResponse response = (GetObjectResponse)responseInputStream.response();
            StringBuilder textBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)responseInputStream));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    textBuilder.append((char)c);
                }
            }
            String serializedString = textBuilder.toString();
            Object object = SerializationUtil.Deserialize((String)serializedString, (String)downloadObjectRequest.getType(), (boolean)downloadObjectRequest.isUseCustomSerializer());
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in downloadObject is completed in  " + (endTime - startTime) + " ms"));
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"Success");
            structResponse.put((Object)"object", object);
            if (Objects.nonNull(response.versionId())) {
                structResponse.put((Object)"versionId", (Object)response.versionId());
            }
            Struct struct = structResponse;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in downloadObject : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"downloadObjectError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in downloadObject : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"downloadObjectError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"downloadObject", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public Struct downloadToFile(String destinationFile, String key) {
        Struct downloadRequest = new Struct();
        downloadRequest.put((Object)"key", (Object)key);
        downloadRequest.put((Object)"destinationFile", (Object)destinationFile);
        return this.downloadToFile((Map)downloadRequest);
    }

    @Override
    public Struct downloadToFile(Map downloadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"downloadToFile", (boolean)true);
        DownloadFileRequest downloadFileRequest = new DownloadFileRequest();
        this.filler.fillObject((Object)downloadFileRequest, downloadRequest, (ConsumerMap)DownloadFileRequestConsumer.getInstance());
        GetObjectRequest request = (GetObjectRequest)downloadFileRequest.getObjectRequest().bucket(this.bucketName).build();
        String statusCode = "Success";
        Optional<Object> backupFile = Optional.empty();
        try {
            File destFile = VFSFileFactory.getFileObject((String)downloadFileRequest.getDestinationFile());
            backupFile = this.backupDestinationFile(destFile);
            if (destFile instanceof VFile) {
                this.s3Client.getObject(request, BucketReference.toFile((VFile)destFile));
            } else {
                this.s3Client.getObject(request, destFile.toPath());
            }
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in downloadToFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"downloadFileError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in downloadToFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"downloadFileError"), e);
        }
        finally {
            if (statusCode.equalsIgnoreCase("Failure") && backupFile.isPresent()) {
                this.restoreBackupFile((File)backupFile.get(), downloadFileRequest.getDestinationFile());
            }
            backupFile.ifPresent(File::deleteOnExit);
            CloudMonitoringUtil.onCloudFunctionEnd((String)"downloadToFile", (String)"get", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
        Struct structResponse = new Struct();
        structResponse.put((Object)"status", (Object)"Success");
        return structResponse;
    }

    static <ResponseT> ResponseTransformer<ResponseT, ResponseT> toFile(VFile vFile) {
        return (resp, in) -> {
            try {
                InterruptMonitor.checkInterrupted();
                FileUtils.bufferCopy((InputStream)in, (File)vFile);
                return resp;
            }
            catch (IOException copyException) {
                throw new IOException("Failed to read response into file: " + vFile.getPath(), copyException);
            }
        };
    }

    private void restoreBackupFile(File backupFile, String destinationFile) {
        VFSFileFactory.getFileObject((String)destinationFile).deleteOnExit();
        try {
            FileUtils.copyFile((File)backupFile, (String)destinationFile);
        }
        catch (IOException e) {
            this.logger.error((Object)"Error occurred in restoreBackupFile : ", (Throwable)e);
            throw new S3APIException(RB.getString(BucketReference.class, (String)"restoreBackupFileError"), e);
        }
    }

    private Optional<File> backupDestinationFile(File destinationFile) throws IOException {
        if (!destinationFile.exists()) {
            return Optional.empty();
        }
        long currentTimeStamp = System.currentTimeMillis();
        this.logger.info((Object)("taking backup for file : " + destinationFile.getAbsolutePath()));
        String backupFileName = destinationFile.getName() + currentTimeStamp + ".bck";
        File backupFile = VFSFileFactory.getFileObject((String)(destinationFile.getParent() + "\\" + backupFileName));
        int count = 1;
        while (backupFile.exists()) {
            backupFileName = destinationFile.getName() + currentTimeStamp + "-" + count + ".bck";
            backupFile = VFSFileFactory.getFileObject((String)(destinationFile.getParent() + "\\" + backupFileName));
        }
        FileUtils.copyFile((File)destinationFile, (String)backupFileName);
        destinationFile.delete();
        return Optional.ofNullable(backupFile);
    }

    @Override
    public Struct delete(Object key) {
        if (key instanceof Struct) {
            return this.delete((Map)((Struct)key));
        }
        return this.delete(String.valueOf(key));
    }

    private Struct delete(String key) {
        Struct structRequest = new Struct();
        structRequest.put((Object)"key", (Object)key);
        String statusCode = "Success";
        this.delete((Map)structRequest);
        Struct structResponse = new Struct();
        structResponse.put((Object)"status", (Object)"Success");
        return structResponse;
    }

    private Struct delete(Map deleteRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"delete", (boolean)true);
        DeleteObjectRequest.Builder builder = DeleteObjectRequest.builder().bucket(this.bucketName);
        DeleteObjectRequestConsumer consumer = DeleteObjectRequestConsumer.getInstance();
        this.filler.fillObject((Object)builder, deleteRequest, (ConsumerMap)consumer);
        DeleteObjectRequest request = (DeleteObjectRequest)builder.build();
        String statusCode = "Success";
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in delete, request : " + request.toString()));
            this.s3Client.deleteObject(request);
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"Success");
            Struct struct = structResponse;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"deleteObjectError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in delete : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"deleteObjectError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"delete", (String)"delete", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    @Override
    public Struct copy(Map copyRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"copy", (boolean)true);
        ObjectCopyRequest objectCopyRequest = new ObjectCopyRequest();
        this.filler.fillObject((Object)objectCopyRequest, copyRequest, (ConsumerMap)new ObjectCopyRequestConsumer());
        String statusCode = "Success";
        String key = "";
        try {
            long startTime = System.currentTimeMillis();
            String encodedUrl = URLEncoder.encode(objectCopyRequest.getSourceBucket() + "/" + objectCopyRequest.getSourceKey(), StandardCharsets.UTF_8.toString());
            objectCopyRequest.getObjectCopyRequest().bucket(this.bucketName).copySource(encodedUrl);
            CopyObjectRequest request = (CopyObjectRequest)objectCopyRequest.getObjectCopyRequest().build();
            key = request.key();
            this.logger.debug((Object)("Calling S3 in copy, request : " + request.toString()));
            CopyObjectResponse response = this.s3Client.copyObject(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in copy is completed in  " + (endTime - startTime) + " ms"));
            Struct cfResponse = new Struct();
            cfResponse.put((Object)"versionId", (Object)response.versionId());
            cfResponse.put((Object)"requestCharged", (Object)response.requestCharged());
            Struct struct = cfResponse;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in copy : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"copyObjectError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in copy : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"copyObjectError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"copy", (String)"put", (Object)statusCode, null, (String)key, (TagAttributeList)this.tagAttributeList);
        }
    }

    public void enableVersioning() {
        this.enableVersioning(null);
    }

    public void enableVersioning(Map enableVersioningRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"enableVersioning", (boolean)true);
        String statusCode = "Success";
        ObjectVersioning versioningRequest = new ObjectVersioning();
        VersionConsumer versionConsumer = new VersionConsumer();
        this.filler.fillObject((Object)versioningRequest, enableVersioningRequest, (ConsumerMap)versionConsumer);
        PutBucketVersioningRequest.Builder builder = PutBucketVersioningRequest.builder().bucket(this.bucketName);
        builder.versioningConfiguration((VersioningConfiguration)VersioningConfiguration.builder().mfaDelete(versioningRequest.getMfaDelete()).status(BucketVersioningStatus.ENABLED).build()).contentMD5(versioningRequest.getContentMD5()).mfa(versioningRequest.getMfa());
        PutBucketVersioningRequest request = (PutBucketVersioningRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in enableVersioning, request : " + request.toString()));
            this.s3Client.putBucketVersioning(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in enableVersioning is completed in  " + (endTime - startTime) + " ms"));
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in enableVersioning : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"enableVersioningError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in enableVersioning : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"enableVersioningError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"enableVersioning", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public void suspendVersioning() {
        this.suspendVersioning(null);
    }

    public void suspendVersioning(Map suspendVersioningRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"suspendVersioning", (boolean)true);
        String statusCode = "Success";
        ObjectVersioning versioningRequest = new ObjectVersioning();
        VersionConsumer versionConsumer = new VersionConsumer();
        this.filler.fillObject((Object)versioningRequest, suspendVersioningRequest, (ConsumerMap)versionConsumer);
        PutBucketVersioningRequest.Builder builder = PutBucketVersioningRequest.builder().bucket(this.bucketName);
        builder.versioningConfiguration((VersioningConfiguration)VersioningConfiguration.builder().mfaDelete(versioningRequest.getMfaDelete()).status(BucketVersioningStatus.SUSPENDED).build()).contentMD5(versioningRequest.getContentMD5()).mfa(versioningRequest.getMfa());
        PutBucketVersioningRequest request = (PutBucketVersioningRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in suspendVersioning, request : " + request.toString()));
            this.s3Client.putBucketVersioning(request);
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in suspendVersioning : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"suspendVersioningError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in suspendVersioning : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"suspendVersioningError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"suspendVersioning", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getVersioningStatus() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getVersioningStatus", (boolean)true);
        GetBucketVersioningRequest request = (GetBucketVersioningRequest)GetBucketVersioningRequest.builder().bucket(this.bucketName).build();
        String statusCode = "Success";
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getVersioningStatus, request : " + request.toString()));
            GetBucketVersioningResponse bucketVersioningResponse = this.s3Client.getBucketVersioning(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getVersioningStatus is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            if (Objects.nonNull(bucketVersioningResponse.mfaDelete())) {
                response.put((Object)"mfaDelete", (Object)bucketVersioningResponse.mfaDelete().name());
            } else {
                response.put((Object)"mfaDelete", (Object)MFADelete.DISABLED.name());
            }
            if (Objects.nonNull(bucketVersioningResponse.status())) {
                response.put((Object)"versionStatus", (Object)bucketVersioningResponse.status().name());
            } else {
                response.put((Object)"versionStatus", (Object)BucketVersioningStatus.SUSPENDED);
            }
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getVersioningStatus : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getVersioningStatusError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getVersioningStatus : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getVersioningStatusError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getVersioningStatus", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public void setRules(Map setRulesRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"setRules", (boolean)true);
        String statusCode = "Success";
        BucketLifecycleConfiguration.Builder bucketLifecycleConfiguration = BucketLifecycleConfiguration.builder();
        this.filler.fillObject((Object)bucketLifecycleConfiguration, setRulesRequest, (ConsumerMap)new BucketLifecycleConfigurationConsumer());
        PutBucketLifecycleConfigurationRequest.Builder builder = PutBucketLifecycleConfigurationRequest.builder().bucket(this.bucketName).lifecycleConfiguration((BucketLifecycleConfiguration)bucketLifecycleConfiguration.build());
        PutBucketLifecycleConfigurationRequest request = (PutBucketLifecycleConfigurationRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in setRules, request : " + request.toString()));
            PutBucketLifecycleConfigurationResponse putBucketLifecycleConfigurationResponse = this.s3Client.putBucketLifecycleConfiguration(request);
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in setRules : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"setRulesError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in setRules : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"setRulesError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"setRules", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct deleteRules() {
        RequestMonitorEventProcessor.onFunctionStart((String)"deleteRules", (boolean)true);
        String statusCode = "Success";
        DeleteBucketLifecycleRequest request = (DeleteBucketLifecycleRequest)DeleteBucketLifecycleRequest.builder().bucket(this.bucketName).build();
        try {
            this.logger.debug((Object)("Calling S3 in deleteRules, request : " + request.toString()));
            DeleteBucketLifecycleResponse response = this.s3Client.deleteBucketLifecycle(request);
            Struct structResponse = new Struct();
            structResponse.put((Object)"status", (Object)"Success");
            Struct struct = structResponse;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in deleteRules : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"deleteRulesError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in deleteRules : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"deleteRulesError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"deleteRules", (String)"delete", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public void appendRules(Map appendRulesRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"appendRules", (boolean)true);
        String statusCode = "Success";
        BucketLifecycleConfiguration.Builder bucketLifecycleConfiguration = BucketLifecycleConfiguration.builder();
        this.filler.fillObject((Object)bucketLifecycleConfiguration, appendRulesRequest, (ConsumerMap)new BucketLifecycleConfigurationConsumer());
        PutBucketLifecycleConfigurationRequest.Builder builder = PutBucketLifecycleConfigurationRequest.builder().bucket(this.bucketName).lifecycleConfiguration((BucketLifecycleConfiguration)bucketLifecycleConfiguration.build());
        PutBucketLifecycleConfigurationRequest request = (PutBucketLifecycleConfigurationRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in appendRules, request : " + request.toString()));
            List<LifecycleRule> existingRules = this.getBucketRule((GetBucketLifecycleConfigurationRequest)GetBucketLifecycleConfigurationRequest.builder().bucket(this.bucketName).build());
            if (!CollectionUtils.isNullOrEmpty(existingRules)) {
                LinkedList<LifecycleRule> allRules = new LinkedList<LifecycleRule>(existingRules);
                allRules.addAll(request.lifecycleConfiguration().rules());
                request = (PutBucketLifecycleConfigurationRequest)builder.lifecycleConfiguration((BucketLifecycleConfiguration)bucketLifecycleConfiguration.rules(allRules).build()).build();
            }
            PutBucketLifecycleConfigurationResponse putBucketLifecycleConfigurationResponse = this.s3Client.putBucketLifecycleConfiguration(request);
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in appendRules : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"setRulesError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in appendRules : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"setRulesError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"appendRules", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getRules() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getRules", (boolean)true);
        String statusCode = "Success";
        GetBucketLifecycleConfigurationRequest.Builder builder = GetBucketLifecycleConfigurationRequest.builder().bucket(this.bucketName);
        Struct response = new Struct();
        GetBucketLifecycleConfigurationRequest request = (GetBucketLifecycleConfigurationRequest)builder.build();
        try {
            List<LifecycleRule> rules = this.getBucketRule(request);
            List list = ((List)Optional.ofNullable(rules).orElse(new LinkedList())).stream().map(lifecycleRule -> LifecycleRuleConsumer.getInstance().getRuleStruct((LifecycleRule)lifecycleRule)).collect(Collectors.toList());
            response.put((Object)"rules", list);
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getRules : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getRulesError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getRules : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getRulesError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getRules", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
        return response;
    }

    private List<LifecycleRule> getBucketRule(GetBucketLifecycleConfigurationRequest request) {
        long startTime = System.currentTimeMillis();
        this.logger.debug((Object)("Calling S3 in getBucketRule, request : " + request.toString()));
        GetBucketLifecycleConfigurationResponse s3Response = this.s3Client.getBucketLifecycleConfiguration(request);
        long endTime = System.currentTimeMillis();
        this.logger.info((Object)("Call to s3 in getBucketRule is completed in  " + (endTime - startTime) + " ms"));
        return s3Response.rules();
    }

    public void addTags(Map addTagsRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"addTags", (boolean)true);
        String statusCode = "Success";
        ObjectTagging objectTagging = new ObjectTagging();
        this.filler.fillObject((Object)objectTagging, addTagsRequest, (ConsumerMap)TaggingConsumer.getInstance());
        PutObjectTaggingRequest.Builder builder = PutObjectTaggingRequest.builder().bucket(this.bucketName).key(objectTagging.getKey()).contentMD5(objectTagging.getContentMD5()).versionId(objectTagging.getVersionId()).tagging((Tagging)Tagging.builder().tagSet(objectTagging.getTags()).build());
        PutObjectTaggingRequest request = (PutObjectTaggingRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in addTags, request : " + request.toString()));
            this.s3Client.putObjectTagging(request);
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in addTags : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"addTagError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in addTags : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"addTagError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"addTags", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getObjectDetails(Object getObejctDetailRequest) {
        if (getObejctDetailRequest instanceof Map) {
            return this.getObjectDetails((Map)getObejctDetailRequest);
        }
        return this.getObjectDetails(String.valueOf(getObejctDetailRequest));
    }

    private Struct getObjectDetails(String key) {
        Struct struct = new Struct();
        struct.put((Object)"key", (Object)key);
        return this.getObjectDetails((Map)struct);
    }

    private Struct getObjectDetails(Map getObejctDetailRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getObjectDetails", (boolean)true);
        String statusCode = "Success";
        DownloadObjectRequest downloadObjectRequest = new DownloadObjectRequest();
        this.filler.fillObject((Object)downloadObjectRequest, getObejctDetailRequest, (ConsumerMap)GetObjectDetailConsumer.getInstance());
        GetObjectRequest request = (GetObjectRequest)downloadObjectRequest.getObjectRequest().bucket(this.bucketName).build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getObjectDetails, request : " + request.toString()));
            GetObjectResponse getObjectResponse = (GetObjectResponse)this.s3Client.getObject(request).response();
            Struct response = new Struct();
            response.put((Object)"deleteMarker", (Object)getObjectResponse.deleteMarker());
            response.put((Object)"eTag", (Object)getObjectResponse.eTag());
            response.put((Object)"expiration", (Object)getObjectResponse.expiration());
            response.put((Object)"expires", (Object)String.valueOf(getObjectResponse.expires()));
            response.put((Object)"lastModified", (Object)String.valueOf(getObjectResponse.lastModified()));
            response.put((Object)"metadata", (Object)getObjectResponse.metadata());
            response.put((Object)"missingData", (Object)getObjectResponse.missingMeta());
            Optional.ofNullable(getObjectResponse.objectLockLegalHoldStatus()).ifPresent(objectLockLegalHoldStatus -> response.put((Object)"objectLockLegalHoldStatus", (Object)objectLockLegalHoldStatus.name()));
            Optional.ofNullable(getObjectResponse.objectLockMode()).ifPresent(objectLockMode -> response.put((Object)"objectLockMode", (Object)objectLockMode.name()));
            response.put((Object)"objectLockRetainUntilDate", (Object)String.valueOf(getObjectResponse.objectLockRetainUntilDate()));
            response.put((Object)InventoryOptionalField.REPLICATION_STATUS, (Object)getObjectResponse.replicationStatus());
            response.put((Object)"restore", (Object)getObjectResponse.restore());
            response.put((Object)"contentLength", (Object)getObjectResponse.contentLength());
            response.put((Object)"websiteRedirectLocation", (Object)getObjectResponse.websiteRedirectLocation());
            response.put((Object)"contentLanguage", (Object)getObjectResponse.contentLanguage());
            response.put((Object)"contentType", (Object)getObjectResponse.contentType());
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getObjectDetails : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getObjectDetailError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getObjectDetails : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getObjectDetailError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getObjectDetails", (String)"get", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getObjectMetadata(Object getMetadataRequest) {
        if (getMetadataRequest instanceof Map) {
            return this.getObjectMetadata((Map)getMetadataRequest);
        }
        return this.getObjectMetadata(String.valueOf(getMetadataRequest));
    }

    private Struct getObjectMetadata(String key) {
        Struct struct = new Struct();
        struct.put((Object)"key", (Object)key);
        return this.getObjectMetadata((Map)struct);
    }

    private Struct getObjectMetadata(Map getMetadataRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getObjectMetadata", (boolean)true);
        String statusCode = "Success";
        DownloadObjectRequest downloadObjectRequest = new DownloadObjectRequest();
        this.filler.fillObject((Object)downloadObjectRequest, getMetadataRequest, (ConsumerMap)GetObjectDetailConsumer.getInstance());
        GetObjectRequest request = (GetObjectRequest)downloadObjectRequest.getObjectRequest().bucket(this.bucketName).build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getObjectMetadata, request : " + request.toString()));
            ResponseInputStream response = this.s3Client.getObject(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getObjectMetadata is completed in  " + (endTime - startTime) + " ms"));
            Struct struct = new Struct();
            struct.putAll(((GetObjectResponse)response.response()).metadata());
            struct.put((Object)"cacheControl", (Object)((GetObjectResponse)response.response()).cacheControl());
            struct.put((Object)"contentDisposition", (Object)((GetObjectResponse)response.response()).contentDisposition());
            struct.put((Object)"contentEncoding", (Object)((GetObjectResponse)response.response()).contentEncoding());
            struct.put((Object)"contentLanguage", (Object)((GetObjectResponse)response.response()).contentLanguage());
            struct.put((Object)"contentType", (Object)((GetObjectResponse)response.response()).contentType());
            Optional.ofNullable(((GetObjectResponse)response.response()).expires()).ifPresent(e -> struct.put((Object)"expires", (Object)e.toString()));
            struct.put((Object)"websiteRedirectLocation", (Object)((GetObjectResponse)response.response()).websiteRedirectLocation());
            Struct struct2 = struct;
            return struct2;
        }
        catch (S3Exception e2) {
            this.logger.error((Object)"Error occurred in getObjectMetadata : ", (Throwable)e2);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getObjectMetadataError"), e2);
        }
        catch (Exception e3) {
            this.logger.error((Object)"Error occurred in getObjectMetadata : ", (Throwable)e3);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getObjectMetadataError"), e3);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getObjectMetadata", (String)"get", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getTagObjects(String key) {
        return this.getTagObjects(key, null);
    }

    public Struct getTagObjects(String key, String versionId) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getTagObjects", (boolean)true);
        String statusCode = "Success";
        GetObjectTaggingRequest.Builder builder = GetObjectTaggingRequest.builder();
        Struct request = new Struct();
        request.put((Object)"key", (Object)key);
        if (StringUtils.isNotBlank((CharSequence)versionId)) {
            request.put((Object)"versionId", (Object)versionId);
        }
        this.filler.fillObject((Object)builder, (Map)request, (ConsumerMap)GetObjectTaggingRequestConsumer.getInstance());
        GetObjectTaggingRequest getObjectTaggingRequest = (GetObjectTaggingRequest)builder.bucket(this.bucketName).build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getTagObjects, request : " + getObjectTaggingRequest.toString()));
            GetObjectTaggingResponse response = this.s3Client.getObjectTagging(getObjectTaggingRequest);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getTagObjects is completed in  " + (endTime - startTime) + " ms"));
            Struct struct = new Struct();
            struct.put((Object)"status", (Object)"Success");
            struct.putAll((Map)GetObjectTaggingRequestConsumer.getInstance().getObjectTagging(response));
            Struct struct2 = struct;
            return struct2;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getTagObjects : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getTaggedObjectsError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getTagObjects : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getTaggedObjectsError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getTagObjects", (String)"get", (Object)statusCode, null, (String)key, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct parallelDownloadFile(Map fileDownloadRequest) {
        ParallelFileDownloadRequest parallelFileDownloadRequest = new ParallelFileDownloadRequest();
        this.filler.fillObject((Object)parallelFileDownloadRequest, fileDownloadRequest, (ConsumerMap)ParallelFileDownloadConsumer.getInstance());
        String key = ((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).key();
        RandomAccessFile randomAccessFile = null;
        try {
            HeadObjectResponse headObjectResponse = this.s3Client.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).ifMatch(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).ifMatch()).ifModifiedSince(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).ifModifiedSince()).ifNoneMatch(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).ifNoneMatch()).ifUnmodifiedSince(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).ifUnmodifiedSince()).requestPayer(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).requestPayer()).versionId(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).versionId()).sseCustomerAlgorithm(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).sseCustomerAlgorithm()).sseCustomerKey(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).sseCustomerKey()).sseCustomerKeyMD5(((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().build()).sseCustomerKeyMD5()).key(key).build());
            File file = VFSFileFactory.getFileObject((String)parallelFileDownloadRequest.getDestinationFile());
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            randomAccessFile = VFSFileFactory.getRandomAccessFile((File)file, (String)"rw");
            long bytesRemaining = headObjectResponse.contentLength();
            int chunkLength = parallelFileDownloadRequest.getChunkLengthInBytes();
            long offset = 0L;
            int count = 0;
            ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(this.executorService);
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
            while (bytesRemaining > 0L) {
                int cl = Integer.valueOf(String.valueOf(Math.min((long)chunkLength, bytesRemaining)));
                bytesRemaining -= (long)chunkLength;
                long finalOffset = offset;
                int n = ++count;
                RandomAccessFile finalRandomAccessFile = randomAccessFile;
                futures.add(completionService.submit(() -> {
                    try {
                        this.logger.info((Object)("started downloading from offset : " + finalOffset));
                        byte[] bytes = new byte[cl];
                        int downloaded = this.s3Client.getObject((GetObjectRequest)parallelFileDownloadRequest.getObjectRequest().bucket(this.bucketName).range("bytes=" + finalOffset + "-" + (finalOffset + (long)chunkLength)).build()).read(bytes);
                        this.logger.info((Object)("finished downloading from offset : " + finalOffset));
                        finalRandomAccessFile.seek(Integer.valueOf(String.valueOf(finalOffset)).intValue());
                        finalRandomAccessFile.write(bytes);
                        this.logger.info((Object)("written to file from offset : " + finalOffset));
                        this.logger.info((Object)("part number : " + finalCount));
                        return downloaded;
                    }
                    catch (IOException | S3Exception e) {
                        this.logger.error((Object)"Error occurred in parallelDownloadFile", e);
                        throw new S3APIException(RB.getString(BucketReference.class, (String)"parallelDownloadFileError"), e);
                    }
                }));
                offset += (long)chunkLength;
            }
            long totaldownloads = 0L;
            for (Future future : futures) {
                totaldownloads += (long)((Integer)completionService.take().get(5L, TimeUnit.MINUTES)).intValue();
            }
            this.logger.info((Object)("Total bytes downloaded " + totaldownloads));
            Struct struct = new Struct();
            struct.put((Object)"status", (Object)"Success");
            Struct struct2 = struct;
            return struct2;
        }
        catch (Exception e) {
            throw new S3APIException(RB.getString(BucketReference.class, (String)"parallelDownloadFileError"), e);
        }
        finally {
            try {
                if (Objects.nonNull(randomAccessFile)) {
                    randomAccessFile.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"parallelDownloadFileError", (Throwable)e);
            }
        }
    }

    @Override
    public Struct uploadDirectory(Map uploadDirectoryRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"uploadDirectory", (boolean)true);
        String statusCode = "Success";
        UploadDirectoryS3Request request = new UploadDirectoryS3Request();
        this.filler.fillObject((Object)request, uploadDirectoryRequest, (ConsumerMap)new UploadDirectoryS3RequestConsumer());
        File file = VFSFileFactory.getFileObject((String)request.getSrcDirectory());
        ExecutorCompletionService<Struct> completionService = new ExecutorCompletionService<Struct>(this.executorService);
        LinkedList<Struct> filesUploadStatus = new LinkedList<Struct>();
        try {
            List<Future> futures = this.uploadDirectory(request, file, completionService);
            for (Future future : futures) {
                filesUploadStatus.add(completionService.take().get(5L, TimeUnit.MINUTES));
            }
            Struct response = new Struct();
            response.put((Object)"result", filesUploadStatus);
            Struct struct = response;
            return struct;
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error((Object)"Error occurred in uploadDirectory : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"uploadDirectoryError"), e);
        }
        catch (TimeoutException e) {
            this.logger.error((Object)"Error occurred in uploadDirectory : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"uploadDirectoryError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in uploadDirectory : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"uploadDirectoryError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"uploadDirectory", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    private List<Future> uploadDirectory(final UploadDirectoryS3Request request, File file, ExecutorCompletionService<Struct> completionService) {
        String[] fileNames;
        if (!file.isDirectory()) {
            throw new ValidationException(request.getSrcDirectory() + " is not a directory.");
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        for (String fileName : fileNames = Optional.ofNullable(file.list()).orElse(new String[0])) {
            final File childFile = VFSFileFactory.getFileObject((String)(file.getAbsolutePath() + File.separator + fileName));
            if (childFile.isDirectory()) {
                if (!request.isUploadNestedDirectory()) continue;
                futures.addAll(this.uploadDirectory(request, childFile, completionService));
                continue;
            }
            futures.add(completionService.submit(new Callable<Struct>(){

                @Override
                public Struct call() throws Exception {
                    String srcFile = childFile.getAbsolutePath();
                    String key = Optional.ofNullable(request.getPrefix()).orElse("") + childFile.getAbsolutePath().replace(request.getSrcDirectory() + File.separator, "");
                    Struct struct = new Struct();
                    struct.put((Object)"srcFile", (Object)srcFile);
                    struct.put((Object)"key", (Object)key);
                    return BucketReference.this.performUploadFile((Map)struct);
                }
            }));
        }
        return futures;
    }

    public Struct parallelUploadFile(Map parallelUploadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"parallelUploadFile", (boolean)true);
        String statusCode = "Success";
        FileMultipartUploadRequest fileMultipartUploadRequest = new FileMultipartUploadRequest();
        try {
            this.filler.fillObject((Object)fileMultipartUploadRequest, parallelUploadRequest, (ConsumerMap)new FileMultipartUploadRequestConsumer());
            CreateMultipartUploadRequest request = (CreateMultipartUploadRequest)fileMultipartUploadRequest.getPartUploadRequest().bucket(this.bucketName).build();
            CreateMultipartUploadResponse createMultipartUploadResponse = this.s3Client.createMultipartUpload(request);
            File file = VFSFileFactory.getFileObject((String)fileMultipartUploadRequest.getSrcFile());
            InputStream inputStream = VFSFileFactory.getInputStream((File)file);
            long count = 0L;
            int partSize = Optional.ofNullable(fileMultipartUploadRequest.getPartSize()).orElse(this.DEFAULT_PART_SIZE);
            long length = file.length();
            int part = 1;
            ArrayList completedParts = new ArrayList();
            ArrayList<Future<UploadPartResponse>> futures = new ArrayList<Future<UploadPartResponse>>();
            ExecutorCompletionService<UploadPartResponse> completionService = new ExecutorCompletionService<UploadPartResponse>(this.executorService);
            HashMap<Integer, UploadPartResponse> partResponseMap = new HashMap<Integer, UploadPartResponse>();
            while (count < length) {
                int contentSize = Integer.min(inputStream.available(), partSize);
                if (length - count - (long)contentSize < (long)this.MINIMUM_PART_SIZE.intValue()) {
                    contentSize = (int)(length - count);
                }
                byte[] bytes = new byte[contentSize];
                int readCount = inputStream.read(bytes);
                count += (long)readCount;
                RequestBody requestBody = RequestBody.fromBytes((byte[])bytes);
                UploadPartRequest partRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.bucketName).key(request.key()).requestPayer(request.requestPayer()).contentMD5(fileMultipartUploadRequest.isValidateContentMD5() ? Md5Utils.md5AsBase64((byte[])bytes) : null).sseCustomerAlgorithm(request.sseCustomerAlgorithm()).sseCustomerKey(request.sseCustomerKey()).sseCustomerKeyMD5(request.sseCustomerKeyMD5()).uploadId(createMultipartUploadResponse.uploadId()).partNumber(Integer.valueOf(part)).contentLength(Long.valueOf(readCount)).build();
                Integer partNumber = part;
                Future<UploadPartResponse> future = completionService.submit(() -> {
                    UploadPartResponse response = this.s3Client.uploadPart(partRequest, requestBody);
                    partResponseMap.put(partNumber, response);
                    return response;
                });
                futures.add(future);
                ++part;
            }
            CompletableFuture[] completableFutures = new CompletableFuture[futures.size()];
            for (int i = 0; i < futures.size(); ++i) {
                UploadPartResponse readCount = (UploadPartResponse)completionService.take().get(fileMultipartUploadRequest.getTimeOutInSeconds(), TimeUnit.MINUTES);
            }
            partResponseMap.forEach((key, value) -> {
                CompletedPart completedPart = (CompletedPart)CompletedPart.builder().eTag(value.eTag()).partNumber(key).build();
                completedParts.add(completedPart);
            });
            CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build();
            CompleteMultipartUploadRequest.Builder multipartUploadRequest = CompleteMultipartUploadRequest.builder().bucket(this.bucketName).key(request.key()).multipartUpload(completedMultipartUpload).uploadId(createMultipartUploadResponse.uploadId());
            Optional.ofNullable(request.requestPayer()).ifPresent(arg_0 -> ((CompleteMultipartUploadRequest.Builder)multipartUploadRequest).requestPayer(arg_0));
            CompleteMultipartUploadResponse multipartUploadResponse = this.s3Client.completeMultipartUpload((CompleteMultipartUploadRequest)multipartUploadRequest.build());
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            if (Objects.nonNull(multipartUploadResponse.versionId())) {
                response.put((Object)"versionId", (Object)multipartUploadResponse.versionId());
            }
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in parallelUploadFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"parallelUploadError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in parallelUploadFile : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"parallelUploadError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"parallelUploadFile", (String)"put", (Object)statusCode, null, (String)((CreateMultipartUploadRequest)fileMultipartUploadRequest.getPartUploadRequest().build()).key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct multipartUpload(Map multipartUploadRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"mulitipartUpload", (boolean)true);
        String statusCode = "Success";
        FileMultipartUploadRequest fileMultipartUploadRequest = new FileMultipartUploadRequest();
        this.filler.fillObject((Object)fileMultipartUploadRequest, multipartUploadRequest, (ConsumerMap)new FileMultipartUploadRequestConsumer());
        CreateMultipartUploadRequest request = (CreateMultipartUploadRequest)fileMultipartUploadRequest.getPartUploadRequest().bucket(this.bucketName).build();
        CreateMultipartUploadResponse createMultipartUploadResponse = this.s3Client.createMultipartUpload(request);
        File file = VFSFileFactory.getFileObject((String)fileMultipartUploadRequest.getSrcFile());
        try {
            InputStream inputStream = VFSFileFactory.getInputStream((File)file);
            long count = 0L;
            int partSize = Optional.ofNullable(fileMultipartUploadRequest.getPartSize()).orElse(this.DEFAULT_PART_SIZE);
            long length = file.length();
            int part = 1;
            ArrayList<CompletedPart> completedParts = new ArrayList<CompletedPart>();
            while (count < length) {
                int contentSize = Integer.min(inputStream.available(), partSize);
                if (length - count - (long)contentSize < (long)this.MINIMUM_PART_SIZE.intValue()) {
                    contentSize = (int)(length - count);
                }
                byte[] bytes = new byte[contentSize];
                int readCount = inputStream.read(bytes);
                count += (long)readCount;
                RequestBody requestBody = RequestBody.fromBytes((byte[])bytes);
                UploadPartRequest partRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.bucketName).key(request.key()).requestPayer(request.requestPayer()).contentMD5(fileMultipartUploadRequest.getContentMd5()).sseCustomerAlgorithm(request.sseCustomerAlgorithm()).sseCustomerKey(request.sseCustomerKey()).sseCustomerKeyMD5(request.sseCustomerKeyMD5()).uploadId(createMultipartUploadResponse.uploadId()).partNumber(Integer.valueOf(part)).contentLength(Long.valueOf(readCount)).build();
                UploadPartResponse uploadPartResponse = this.s3Client.uploadPart(partRequest, requestBody);
                CompletedPart completedPart = (CompletedPart)CompletedPart.builder().eTag(uploadPartResponse.eTag()).partNumber(Integer.valueOf(part)).build();
                completedParts.add(completedPart);
                ++part;
            }
            CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build();
            CompleteMultipartUploadRequest.Builder multipartUploadRequestBuilder = CompleteMultipartUploadRequest.builder().bucket(this.bucketName).key(request.key()).multipartUpload(completedMultipartUpload).uploadId(createMultipartUploadResponse.uploadId());
            Optional.ofNullable(request.requestPayer()).ifPresent(arg_0 -> ((CompleteMultipartUploadRequest.Builder)multipartUploadRequestBuilder).requestPayer(arg_0));
            CompleteMultipartUploadResponse multipartUploadResponse = this.s3Client.completeMultipartUpload((CompleteMultipartUploadRequest)multipartUploadRequestBuilder.build());
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            if (Objects.nonNull(multipartUploadResponse.versionId())) {
                response.put((Object)"versionId", (Object)multipartUploadResponse.versionId());
            }
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in mulitipartUpload : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"mulitipartUploadError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in mulitipartUpload : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"mulitipartUploadError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"mulitipartUpload", (String)"get", (Object)statusCode, null, (String)((CreateMultipartUploadRequest)fileMultipartUploadRequest.getPartUploadRequest().build()).key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getRetentionLock(Map retentionRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getRetentionLock", (boolean)true);
        String statusCode = "Success";
        GetObjectRetentionRequest.Builder builder = GetObjectRetentionRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, retentionRequest, (ConsumerMap)new GetObjectRetentionRequestConsumer());
        GetObjectRetentionRequest request = (GetObjectRetentionRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getRetentionLock, request : " + request.toString()));
            GetObjectRetentionResponse retentionResponse = this.s3Client.getObjectRetention(request);
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            if (retentionResponse.retention() != null) {
                response.put((Object)"mode", (Object)retentionResponse.retention().modeAsString());
                if (retentionResponse.retention().retainUntilDate() != null) {
                    response.put((Object)"retainUntilDate", (Object)retentionResponse.retention().retainUntilDate().toString());
                }
            }
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getRetentionLock : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getRetentionLockError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getRetentionLock : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getRetentionLockError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getRetentionLock", (String)"get", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct acquireRetentionLock(Map retentionRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"acquireRetentionLock", (boolean)true);
        String statusCode = "Success";
        PutObjectRetentionRequest.Builder builder = PutObjectRetentionRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, retentionRequest, (ConsumerMap)PutObjectRetentionRequestConsumer.getInstance());
        PutObjectRetentionRequest request = (PutObjectRetentionRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in acquireRetentionLock, request : " + request.toString()));
            PutObjectRetentionResponse retentionResponse = this.s3Client.putObjectRetention(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in acquireRetentionLock is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in acquireRetentionLock : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"acquireRetentionLockError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in acquireRetentionLock : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"acquireRetentionLockError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"acquireRetentionLock", (String)"put", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getLegalHold(Map legalHoldRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getLegalHold", (boolean)true);
        String statusCode = "Success";
        GetObjectLegalHoldRequest.Builder builder = GetObjectLegalHoldRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, legalHoldRequest, (ConsumerMap)new GetObjectLegalHoldRequestConsumer());
        GetObjectLegalHoldRequest request = (GetObjectLegalHoldRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getLegalHold, request : " + request.toString()));
            GetObjectLegalHoldResponse legalHoldResponse = this.s3Client.getObjectLegalHold(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getLegalHold is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"legalHold", (Object)legalHoldResponse.legalHold().status().name());
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getLegalHold : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getLegalHoldError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getLegalHold : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getLegalHoldError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getLegalHold", (String)"get", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct acquireLegalHold(Map legalHoldRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"acquireLegalHold", (boolean)true);
        String statusCode = "Success";
        PutObjectLegalHoldRequest.Builder builder = PutObjectLegalHoldRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, legalHoldRequest, (ConsumerMap)PutObjectLegalHoldRequestConsumer.getInstance());
        PutObjectLegalHoldRequest request = (PutObjectLegalHoldRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in acquireLegalHold, request : " + request.toString()));
            PutObjectLegalHoldResponse legalHoldResponse = this.s3Client.putObjectLegalHold(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in acquireLegalHold is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in acquireLegalHold : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"acquireLegalHoldError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in acquireLegalHold : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"acquireLegalHoldError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"acquireLegalHold", (String)"put", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getObjectLockConfiguration() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getObjectLockConfiguration", (boolean)true);
        String statusCode = "Success";
        GetObjectLockConfigurationRequest.Builder builder = GetObjectLockConfigurationRequest.builder().bucket(this.bucketName);
        GetObjectLockConfigurationRequest request = (GetObjectLockConfigurationRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getObjectLockConfiguration, request : " + request.toString()));
            GetObjectLockConfigurationResponse lockConfigurationResponse = this.s3Client.getObjectLockConfiguration(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getObjectLockConfiguration is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"objectLockConfiguration", (Object)ObjectLockConfigurationConsumer.getInstance().getStruct(lockConfigurationResponse.objectLockConfiguration()));
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getObjectLockConfiguration : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getObjectLockConfigurationError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getObjectLockConfiguration : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getObjectLockConfigurationError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getObjectLockConfiguration", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct putObjectLockConfiguration(Map putObjectLockConfigurationRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"putObjectLockConfiguration", (boolean)true);
        String statusCode = "Success";
        PutObjectLockConfigurationRequest.Builder builder = PutObjectLockConfigurationRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, putObjectLockConfigurationRequest, (ConsumerMap)PutObjectLockConfigurationRequestConsumer.getInstance());
        PutObjectLockConfigurationRequest request = (PutObjectLockConfigurationRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in putObjectLockConfiguration, request : " + request.toString()));
            if (request.objectLockConfiguration().rule().defaultRetention().days() != null && request.objectLockConfiguration().rule().defaultRetention().years() != null) {
                throw new ValidationException(RB.getString(BucketReference.class, (String)"EitherDaysOrYear"));
            }
            PutObjectLockConfigurationResponse lockConfigurationResponse = this.s3Client.putObjectLockConfiguration(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in putObjectLockConfiguration is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in putObjectLockConfiguration : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putObjectLockConfigurationError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in putObjectLockConfiguration : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putObjectLockConfigurationError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"putObjectLockConfiguration", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getBucketAcl() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getBucketAcl", (boolean)true);
        String statusCode = "Success";
        GetBucketAclRequest request = (GetBucketAclRequest)GetBucketAclRequest.builder().bucket(this.bucketName).build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getBucketAcl, request : " + request.toString()));
            GetBucketAclResponse aclResponse = this.s3Client.getBucketAcl(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getBucketAcl is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            List grants = aclResponse.grants().stream().map(grant -> {
                Struct g = new Struct();
                g.put((Object)"grantee", (Object)grant.grantee().toString());
                g.put((Object)"permission", (Object)grant.permission().name());
                return g;
            }).collect(Collectors.toList());
            response.put((Object)"grants", grants);
            response.put((Object)"ownerId", (Object)aclResponse.owner().id());
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getBucketAcl : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getBucketAclError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getBucketAcl : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getBucketAclError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getBucketAcl", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct putBucketAcl(Map putBucketAclRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"putBucketAcl", (boolean)true);
        String statusCode = "Success";
        PutBucketAclRequest.Builder builder = PutBucketAclRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, putBucketAclRequest, (ConsumerMap)new PutBucketAclRequestConsumer());
        PutBucketAclRequest request = (PutBucketAclRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in putBucketAcl, request : " + request.toString()));
            PutBucketAclResponse aclResponse = this.s3Client.putBucketAcl(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in putBucketAcl is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in putBucketAcl : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putBucketAclError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in putBucketAcl : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putBucketAclError"), e);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"putBucketAcl", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("action", (Object)"put").addTagAttribute("statusCode", (Object)statusCode).getTagAttributes(), (boolean)true);
        }
    }

    public Struct getObjectAcl(Object getObjectAclRequest) {
        if (getObjectAclRequest instanceof Map) {
            return this.getObjectAcl((Map)getObjectAclRequest);
        }
        return this.getObjectAcl(String.valueOf(getObjectAclRequest));
    }

    private Struct getObjectAcl(String key) {
        Struct struct = new Struct();
        struct.put((Object)"key", (Object)key);
        return this.getObjectAcl((Map)struct);
    }

    private Struct getObjectAcl(Map getObjectAclRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getObjectAcl", (boolean)true);
        String statusCode = "Success";
        GetObjectAclRequest.Builder builder = GetObjectAclRequest.builder();
        this.filler.fillObject((Object)builder, getObjectAclRequest, (ConsumerMap)GetObjectAclRequestConsumer.getInstance());
        GetObjectAclRequest request = (GetObjectAclRequest)builder.bucket(this.bucketName).build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getObjectAcl, request : " + request.toString()));
            GetObjectAclResponse aclResponse = this.s3Client.getObjectAcl(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getObjectAcl is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            List grants = aclResponse.grants().stream().map(grant -> {
                Struct g = new Struct();
                g.put((Object)"grantee", (Object)grant.grantee().toString());
                g.put((Object)"permission", (Object)grant.permission().name());
                return g;
            }).collect(Collectors.toList());
            response.put((Object)"status", (Object)"Success");
            response.put((Object)"grants", grants);
            response.put((Object)"ownerId", (Object)aclResponse.owner().id());
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getObjectAcl : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getObjectAclError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getObjectAcl : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getObjectAclError"), e);
        }
        finally {
            RequestMonitorEventProcessor.onFunctionEnd((String)"getObjectAcl", null, (List)TagAttributeList.getInstance((TagAttributeList)this.tagAttributeList).addTagAttribute("action", (Object)"get").addTagAttribute("statusCode", (Object)statusCode).addTagAttribute("object", (Object)request.key()).getTagAttributes(), (boolean)true);
        }
    }

    public Struct putObjectAcl(Map putObjectAclRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"putObjectAcl", (boolean)true);
        String statusCode = "Success";
        PutObjectAclRequest.Builder builder = PutObjectAclRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, putObjectAclRequest, (ConsumerMap)new PutObjectAclRequestConsumer());
        PutObjectAclRequest request = (PutObjectAclRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in putObjectAcl, request : " + request.toString()));
            PutObjectAclResponse aclResponse = this.s3Client.putObjectAcl(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in putObjectAcl is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in putObjectAcl : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putObjectAclError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in putObjectAcl : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putObjectAclError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"putObjectAcl", (String)"put", (Object)statusCode, null, (String)request.key(), (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct putSecurityAccessBlock(Map putSecurityAccessBlockRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"putSecurityAccessBlock", (boolean)true);
        String statusCode = "Success";
        PutPublicAccessBlockRequest.Builder builder = PutPublicAccessBlockRequest.builder().bucket(this.bucketName);
        this.filler.fillObject((Object)builder, putSecurityAccessBlockRequest, (ConsumerMap)new PutPublicAccessBlockRequestConsumer());
        PutPublicAccessBlockRequest request = (PutPublicAccessBlockRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in putSecurityAccessBlock, request : " + request.toString()));
            PutPublicAccessBlockResponse putPublicAccessBlockResponse = this.s3Client.putPublicAccessBlock(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in putSecurityAccessBlock is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in putSecurityAccessBlock : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putSecurityAccessBlockError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in putSecurityAccessBlock : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"putSecurityAccessBlockError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"putSecurityAccessBlock", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getSecurityAccessBlock() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getSecurityAccessBlock", (boolean)true);
        String statusCode = "Success";
        GetPublicAccessBlockRequest.Builder builder = GetPublicAccessBlockRequest.builder().bucket(this.bucketName);
        GetPublicAccessBlockRequest request = (GetPublicAccessBlockRequest)builder.build();
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in getSecurityAccessBlock, request : " + request.toString()));
            GetPublicAccessBlockResponse response = this.s3Client.getPublicAccessBlock(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getSecurityAccessBlock is completed in  " + (endTime - startTime) + " ms"));
            PublicAccessBlockConfiguration configuration = response.publicAccessBlockConfiguration();
            Struct struct = new Struct();
            struct.put((Object)"restrictPublicBuckets", (Object)configuration.restrictPublicBuckets());
            struct.put((Object)"blockPublicPolicy", (Object)configuration.blockPublicPolicy());
            struct.put((Object)"ignorePublicAcls", (Object)configuration.ignorePublicAcls());
            struct.put((Object)"blockPublicAcls", (Object)configuration.blockPublicAcls());
            Struct struct2 = struct;
            return struct2;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getSecurityAccessBlock : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getSecurityAccessBlockError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getSecurityAccessBlock : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getSecurityAccessBlockError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getSecurityAccessBlock", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct enableRequesterPay() {
        RequestMonitorEventProcessor.onFunctionStart((String)"enableRequesterPay", (boolean)true);
        PutBucketRequestPaymentRequest request = (PutBucketRequestPaymentRequest)PutBucketRequestPaymentRequest.builder().bucket(this.bucketName).requestPaymentConfiguration((RequestPaymentConfiguration)RequestPaymentConfiguration.builder().payer(Payer.REQUESTER).build()).build();
        String statusCode = "Success";
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in enableRequesterPay, request : " + request.toString()));
            PutBucketRequestPaymentResponse putBucketRequestPaymentResponse = this.s3Client.putBucketRequestPayment(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in enableRequesterPay is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in enableRequesterPay : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"enableRequesterPayError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in enableRequesterPay : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"enableRequesterPayError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"enableRequesterPay", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct disableRequesterPay() {
        RequestMonitorEventProcessor.onFunctionStart((String)"disableRequesterPay", (boolean)true);
        PutBucketRequestPaymentRequest request = (PutBucketRequestPaymentRequest)PutBucketRequestPaymentRequest.builder().bucket(this.bucketName).requestPaymentConfiguration((RequestPaymentConfiguration)RequestPaymentConfiguration.builder().payer(Payer.BUCKET_OWNER).build()).build();
        String statusCode = "Success";
        try {
            long startTime = System.currentTimeMillis();
            this.logger.debug((Object)("Calling S3 in disableRequesterPay, request : " + request.toString()));
            PutBucketRequestPaymentResponse putBucketRequestPaymentResponse = this.s3Client.putBucketRequestPayment(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in disableRequesterPay is completed in  " + (endTime - startTime) + " ms"));
            Struct response = new Struct();
            response.put((Object)"status", (Object)"Success");
            Struct struct = response;
            return struct;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in disableRequesterPay : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"disableRequesterPayError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in disableRequesterPay : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"disableRequesterPayError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"disableRequesterPay", (String)"put", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct getRequesterPayStatus() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getRequesterPayStatus", (boolean)true);
        String statusCode = "Success";
        try {
            long startTime = System.currentTimeMillis();
            GetBucketRequestPaymentRequest request = (GetBucketRequestPaymentRequest)GetBucketRequestPaymentRequest.builder().bucket(this.bucketName).build();
            this.logger.debug((Object)("Calling S3 in getRequesterPayStatus, request : " + request.toString()));
            GetBucketRequestPaymentResponse response = this.s3Client.getBucketRequestPayment(request);
            long endTime = System.currentTimeMillis();
            this.logger.info((Object)("Call to s3 in getRequesterPayStatus is completed in  " + (endTime - startTime) + " ms"));
            Struct struct = new Struct();
            struct.put((Object)"status", (Object)"Success");
            struct.put((Object)"payer", (Object)Optional.ofNullable(response.payer()).orElse(Payer.BUCKET_OWNER).name());
            Struct struct2 = struct;
            return struct2;
        }
        catch (S3Exception e) {
            this.logger.error((Object)"Error occurred in getRequesterPayStatus : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getRequesterPayStatusError"), e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error occurred in getRequesterPayStatus : ", (Throwable)e);
            statusCode = "Failure";
            throw new S3APIException(RB.getString(BucketReference.class, (String)"getRequesterPayStatusError"), e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"getRequesterPayStatus", (String)"get", (Object)statusCode, (TagAttributeList)this.tagAttributeList);
        }
    }

    public Struct generateGetPresignedUrl(Map presignedGetRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"generateGetPresignedUrl", (boolean)true);
        GetObjectPresignedRequest getObjectPresignedRequest = new GetObjectPresignedRequest();
        this.filler.fillObject((Object)getObjectPresignedRequest, presignedGetRequest, (ConsumerMap)GetObjectPresignedRequestConsumer.getInstance());
        S3Presigner presigner = DefaultS3Presigner.builder().region(Region.of((String)this.s3Service.getCredential().getRegion())).credentialsProvider(S3Utils.getAWSCredential(this.s3Service.getCredential())).build();
        PresignedGetObjectRequest presignedGetObjectRequest = presigner.presignGetObject(z -> z.signatureDuration(getObjectPresignedRequest.getDuration()).getObjectRequest((GetObjectRequest)getObjectPresignedRequest.getObjectRequest().bucket(this.bucketName).build()));
        URL url = presignedGetObjectRequest.url();
        Struct struct = new Struct();
        struct.put((Object)"status", (Object)"Success");
        struct.put((Object)"url", (Object)url.toString());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"generateGetPresignedUrl", (String)"post", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        return struct;
    }

    public Struct generatePutPresignedUrl(Map presignedPutRequest) {
        RequestMonitorEventProcessor.onFunctionStart((String)"generatePutPresignedUrl", (boolean)true);
        PutObjectPresignRequest putObjectPresignRequest = new PutObjectPresignRequest();
        this.filler.fillObject((Object)putObjectPresignRequest, presignedPutRequest, (ConsumerMap)PutObjectPresignedRequestConsumer.getInstance());
        S3Presigner presigner = DefaultS3Presigner.builder().region(Region.of((String)this.s3Service.getCredential().getRegion())).credentialsProvider(S3Utils.getAWSCredential(this.s3Service.getCredential())).build();
        PresignedPutObjectRequest presignedPutObjectRequest = presigner.presignPutObject(z -> z.signatureDuration(putObjectPresignRequest.getDuration()).putObjectRequest((PutObjectRequest)putObjectPresignRequest.getPutObjectRequest().bucket(this.bucketName).build()));
        URL url = presignedPutObjectRequest.url();
        Struct struct = new Struct();
        struct.put((Object)"status", (Object)"Success");
        struct.put((Object)"url", (Object)url.toString());
        struct.put((Object)"method", (Object)presignedPutObjectRequest.httpRequest().method().name());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"generatePutPresignedUrl", (String)"post", (Object)"Success", (TagAttributeList)this.tagAttributeList);
        return struct;
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        return NamedMethodInvoker2.invoke((Object)this, args);
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"getLocation", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getLocation();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getLocation", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listAll", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listAll();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"listRequest"}, args);
                    return obj.listAll((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"listRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listAll", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listAllVersions", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listAllVersions();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"listRequest"}, args);
                    return obj.listAllVersions((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"listRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listAllVersions", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"putPolicy", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"putPolicyRequest"}, args);
                    return obj.putPolicy((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"putPolicyRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("putPolicy", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getPolicies", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getPolicies();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getPolicies", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deletePolicies", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.deletePolicies();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deletePolicies", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"srcFile", "key"}, args);
                    return obj.uploadFile(Cast._String((Object)argColl.get((Object)"srcFile")), Cast._String((Object)argColl.get((Object)"key")));
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadRequest"}, args);
                    return obj.uploadFile((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"uploadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadObject", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadRequest"}, args);
                    return obj.uploadObject((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"uploadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadObject", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"downloadObject", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"downloadRequest"}, args);
                    return obj.downloadObject((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"downloadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("downloadObject", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"downloadToFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"destinationFile", "key"}, args);
                    return obj.downloadToFile(Cast._String((Object)argColl.get((Object)"destinationFile")), Cast._String((Object)argColl.get((Object)"key")));
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"downloadRequest"}, args);
                    return obj.downloadToFile((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"downloadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("downloadToFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"delete", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"key"}, args);
                    return obj.delete(argColl.get((Object)"key"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("delete", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"copy", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"copyRequest"}, args);
                    return obj.copy((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"copyRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("copy", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"enableVersioning", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    obj.enableVersioning();
                    return null;
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"enableVersioningRequest"}, args);
                    obj.enableVersioning((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"enableVersioningRequest"), Map.class));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("enableVersioning", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"suspendVersioning", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    obj.suspendVersioning();
                    return null;
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"suspendVersioningRequest"}, args);
                    obj.suspendVersioning((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"suspendVersioningRequest"), Map.class));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("suspendVersioning", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getVersioningStatus", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getVersioningStatus();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getVersioningStatus", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"setRules", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"setRulesRequest"}, args);
                    obj.setRules((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"setRulesRequest"), Map.class));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("setRules", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"deleteRules", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.deleteRules();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("deleteRules", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"appendRules", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"appendRulesRequest"}, args);
                    obj.appendRules((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"appendRulesRequest"), Map.class));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("appendRules", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRules", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getRules();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRules", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"addTags", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"addTagsRequest"}, args);
                    obj.addTags((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"addTagsRequest"), Map.class));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("addTags", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getObjectDetails", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"getObejctDetailRequest"}, args);
                    return obj.getObjectDetails(argColl.get((Object)"getObejctDetailRequest"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getObjectDetails", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getObjectMetadata", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"getMetadataRequest"}, args);
                    return obj.getObjectMetadata(argColl.get((Object)"getMetadataRequest"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getObjectMetadata", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getTagObjects", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"key"}, args);
                    return obj.getTagObjects(Cast._String((Object)argColl.get((Object)"key")));
                }
                case 2: {
                    argColl = new ArgumentCollection((Object[])new String[]{"key", "versionId"}, args);
                    return obj.getTagObjects(Cast._String((Object)argColl.get((Object)"key")), Cast._String((Object)argColl.get((Object)"versionId")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getTagObjects", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"parallelDownloadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"fileDownloadRequest"}, args);
                    return obj.parallelDownloadFile((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"fileDownloadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("parallelDownloadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"uploadDirectory", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"uploadDirectoryRequest"}, args);
                    return obj.uploadDirectory((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"uploadDirectoryRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("uploadDirectory", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"parallelUploadFile", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"parallelUploadRequest"}, args);
                    return obj.parallelUploadFile((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"parallelUploadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("parallelUploadFile", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"multipartUpload", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"multipartUploadRequest"}, args);
                    return obj.multipartUpload((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"multipartUploadRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("multipartUpload", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRetentionLock", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"retentionRequest"}, args);
                    return obj.getRetentionLock((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"retentionRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRetentionLock", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"acquireRetentionLock", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"retentionRequest"}, args);
                    return obj.acquireRetentionLock((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"retentionRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("acquireRetentionLock", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getLegalHold", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"legalHoldRequest"}, args);
                    return obj.getLegalHold((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"legalHoldRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getLegalHold", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"acquireLegalHold", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"legalHoldRequest"}, args);
                    return obj.acquireLegalHold((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"legalHoldRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("acquireLegalHold", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getObjectLockConfiguration", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getObjectLockConfiguration();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getObjectLockConfiguration", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"putObjectLockConfiguration", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"putObjectLockConfigurationRequest"}, args);
                    return obj.putObjectLockConfiguration((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"putObjectLockConfigurationRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("putObjectLockConfiguration", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getBucketAcl", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getBucketAcl();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getBucketAcl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"putBucketAcl", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"putBucketAclRequest"}, args);
                    return obj.putBucketAcl((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"putBucketAclRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("putBucketAcl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getObjectAcl", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"getObjectAclRequest"}, args);
                    return obj.getObjectAcl(argColl.get((Object)"getObjectAclRequest"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getObjectAcl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"putObjectAcl", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"putObjectAclRequest"}, args);
                    return obj.putObjectAcl((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"putObjectAclRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("putObjectAcl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"putSecurityAccessBlock", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"putSecurityAccessBlockRequest"}, args);
                    return obj.putSecurityAccessBlock((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"putSecurityAccessBlockRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("putSecurityAccessBlock", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getSecurityAccessBlock", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getSecurityAccessBlock();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getSecurityAccessBlock", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"enableRequesterPay", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.enableRequesterPay();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("enableRequesterPay", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"disableRequesterPay", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.disableRequesterPay();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("disableRequesterPay", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getRequesterPayStatus", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getRequesterPayStatus();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getRequesterPayStatus", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"generateGetPresignedUrl", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"presignedGetRequest"}, args);
                    return obj.generateGetPresignedUrl((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"presignedGetRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("generateGetPresignedUrl", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"generatePutPresignedUrl", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"presignedPutRequest"}, args);
                    return obj.generatePutPresignedUrl((Map)Cast._castForInvokeGen((Object)argColl.get((Object)"presignedPutRequest"), Map.class));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("generatePutPresignedUrl", obj);
        });
    }
}

