/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenAction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternTiling;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectPostScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.pdfa2.ColorSpaceContainer;
import com.adobe.internal.pdftoolkit.services.pdfa2.EmbeddedFilePDFA1ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.EmbeddedFilePDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2InvalidNamespaceUsage;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2SaveTypes;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2XMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractAnnotationErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractBookmarkErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractCatalogErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractColorSpaceErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractContentStreamErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractDocumentMetadataErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractExtGStateErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFieldErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFileStructureErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractOutputIntentErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractPageErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractPatternErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractXObjectErrorCode;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.xmp.options.PropertyOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PDFA2BasicConversionHandler
implements PDFA2ConversionHandler {
    boolean errorsFound;
    public PDFA2SaveTypes saveTypes;
    private PDFField field;
    private boolean fieldDisplayed;
    private PDFPage page;
    private boolean pageDisplayed;
    private int pageIndex;
    private PDFAnnotation annot;
    private boolean annotDisplayed;
    private ArrayList resourceChain = new ArrayList();
    private int lastResourceDisplayed = -1;
    private StringBuilder archiveSummary = new StringBuilder();
    private ArrayList<String> aissues = new ArrayList();
    private final int ARCHIVEERRORSCONST = 1;
    private final int ARCHIVEMODANDISSUESCONST = 2;
    private final int ARCHIVESUMMARYCONST = 3;
    private final String kUnfixableIssueLabel = "UNFIXABLE ISSUE(S): ";
    private final String kFixAppliedLabel = "FIX APPLIED: ";
    private final String CATALOGERROR = "CATALOG ERROR";
    private final String DOCMETADATAERROR = "DOC METADATA ERROR";
    private final String FILESTRUCTURERROR = "FILE STRUCTURE ERROR";
    private final String BOOKMARKERROR = "BOOKMARK ERROR";
    private final String OUTPUTINTENTERROR = "OUTPUT INTENT ERROR";
    private final String ANNOTATIONERROR = "ANNOTATION ERROR";
    private final String COLORSPACEERROR = "COLOR SPACE ERROR";
    private final String CONTENTERROR = "CONTENT ERROR";
    private final String EXTJSSTATEERROR = "EXTJS STATE ERROR";
    private final String FONTERROR = "FONT ERROR";
    private final String FORMFIELDERROR = "FORM FIELD ERROR";
    private final String PAGEERROR = "PAGE ERROR";
    private final String PATTERNERROR = "PATTERN ERROR";
    private final String XOBJECTERROR = "XOBJECT ERROR";
    private final String DOCXMP = "DOCXMP";
    private Map<String, ArrayList<String>> globalErrorMap = new HashMap<String, ArrayList<String>>();

    private void reportResourceError(PDFA2ErrorSet errorSet, String source) {
        if (errorSet == null || !errorSet.hasErrors()) {
            return;
        }
        this.errorsFound = true;
        this.reportResourceIssue("UNFIXABLE ISSUE(S): " + errorSet.toString(), source);
    }

    private void reportResourceModification(String modification) {
        this.reportResourceIssue("FIX APPLIED: " + modification, "");
    }

    private void reportResourceIssue(String issue, String source) {
        StringBuilder res = new StringBuilder();
        try {
            int indentLevel = 0;
            if (this.field != null && !this.fieldDisplayed) {
                res.append("FIELD: " + this.field.getQualifiedName() + "\n");
                this.fieldDisplayed = true;
            }
            if (this.page != null && !this.pageDisplayed) {
                res.append("PAGE: " + this.pageIndex + "\n");
                this.pageDisplayed = true;
            }
            if (this.annot != null) {
                ++indentLevel;
                if (!this.annotDisplayed) {
                    String subtype = this.annot.getSubtype().asString();
                    String id = this.annot.getID();
                    if (id == null) {
                        if (this.annot instanceof PDFAnnotationWidget) {
                            PDFAnnotationWidget widget = (PDFAnnotationWidget)this.annot;
                            if (widget.isField()) {
                                id = widget.getField().getQualifiedName();
                                res.append("FIELD/ANNOT (" + subtype + "): " + (id != null ? id : "") + "\n");
                            } else {
                                res.append("ANNOT (" + subtype + "): \n");
                            }
                        } else {
                            res.append("ANNOT (" + subtype + "): \n");
                        }
                    } else {
                        res.append("ANNOT (" + subtype + "): " + (id != null ? id : "") + "\n");
                    }
                    this.annotDisplayed = true;
                }
            }
            if (this.resourceChain != null) {
                for (ResourceInfo info : this.resourceChain) {
                    String label;
                    Object subtype;
                    if (++indentLevel <= this.lastResourceDisplayed) continue;
                    ASName name = info.resourceName;
                    PDFObject resource = info.resource;
                    if (resource instanceof PDFColorSpace) {
                        subtype = ((PDFColorSpace)resource).getName();
                        label = "COLOR SPACE (" + subtype + "): ";
                    } else if (resource instanceof PDFFont) {
                        subtype = ((PDFFont)resource).getSubtype();
                        label = "FONT (" + subtype + "): ";
                    } else if (resource instanceof PDFXObject) {
                        subtype = ((PDFXObject)resource).getSubtype();
                        label = "XOBJECT (" + subtype + "): ";
                    } else if (resource instanceof PDFPatternTiling) {
                        subtype = String.valueOf(((PDFPatternTiling)resource).getPatternType());
                        label = "PATTERN (Type " + (String)subtype + "): ";
                    } else {
                        throw new RuntimeException("Test code is missing support for a resource type.");
                    }
                    res.append(label + (name != null ? name.asString() : "") + "\n");
                    ++this.lastResourceDisplayed;
                }
            }
            res.append(issue + "\n");
            this.report(0, res.toString(), 0, source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void report(PDFOutputIntent intent, PDFA2ErrorSet errors) {
        try {
            this.reportError(0, "OUTPUT INTENT: " + intent.getSubType().asString(), "OUTPUT INTENT ERROR");
        }
        catch (PDFException e) {
            throw new RuntimeException("Could not get output intent subtype", e);
        }
        this.reportError(1, errors.toString(), "OUTPUT INTENT ERROR");
    }

    private void report(PDFBookmark bookmark, PDFA2ErrorSet errors) {
        try {
            this.reportError(0, "BOOKMARK: " + bookmark.getTitle(), "BOOKMARK ERROR");
        }
        catch (PDFException e) {
            throw new RuntimeException("Could not get output intent subtype", e);
        }
        this.reportError(1, errors.toString(), "BOOKMARK ERROR");
    }

    private void reportError(int indentLevel, String string, String source) {
        this.errorsFound = true;
        this.report(indentLevel, "UNFIXABLE ISSUE(S): " + string, 1, source);
    }

    private void reportModification(String modification) {
        this.report(0, "FIX APPLIED: " + modification, 2, "");
    }

    private void report(int indentLevel, String string, int errortype, String source) {
        String indent = "";
        for (int i = 0; i < indentLevel; ++i) {
            indent = indent + "  ";
        }
        if (errortype == 3) {
            this.archiveSummary.append(indent + string + "\n");
        }
        if (source.equals("") && errortype != 3) {
            this.aissues.add(string);
        }
        if (!source.equals("")) {
            if (this.globalErrorMap.containsKey(source)) {
                this.globalErrorMap.get(source).add(string);
            } else {
                ArrayList<String> a = new ArrayList<String>();
                a.add(string);
                this.globalErrorMap.put(source, a);
            }
        }
    }

    private void pushResourceInfo(ASName resourceName, PDFObject resource) {
        this.resourceChain.add(new ResourceInfo(resourceName, resource));
    }

    private void popResourceInfo() {
        this.resourceChain.remove(this.resourceChain.size() - 1);
        if (this.lastResourceDisplayed >= this.resourceChain.size()) {
            this.lastResourceDisplayed = this.resourceChain.size() - 1;
        }
    }

    public boolean annotationError(PDFA2ErrorSet<PDFA2AbstractAnnotationErrorCode> errors) {
        this.reportResourceError(errors, "ANNOTATION ERROR");
        return true;
    }

    public boolean beginAnnotationScan(PDFAnnotation annot) {
        this.annot = annot;
        return true;
    }

    public boolean beginAnnotationsScan() {
        return true;
    }

    public boolean beginColorSpaceScan(ASName name, PDFColorSpace colorSpace) {
        this.pushResourceInfo(name, (PDFObject)colorSpace);
        return true;
    }

    public boolean beginContentScan(PDFContents contents, PDFResources resources) {
        return true;
    }

    public boolean beginDocMetadataScan() {
        return true;
    }

    public boolean beginDocumentScan() {
        return true;
    }

    public boolean beginFileStructureScan() {
        return true;
    }

    public boolean beginFontScan(ASName name, PDFFont font) {
        this.pushResourceInfo(name, (PDFObject)font);
        return true;
    }

    public boolean beginFormFieldScan(PDFField field) {
        this.field = field;
        return true;
    }

    public boolean beginFormFieldTreeScan() {
        return true;
    }

    public boolean beginOutputIntentScan() {
        return true;
    }

    public boolean beginPageScan(PDFPage page, int index) {
        this.page = page;
        this.pageIndex = index;
        return true;
    }

    public boolean beginPageTreeScan() {
        return true;
    }

    public boolean beginPatternScan(ASName name, PDFPattern pattern) {
        this.pushResourceInfo(name, (PDFObject)pattern);
        return true;
    }

    public boolean beginXObjectScan(ASName name, PDFXObject xObject) {
        this.pushResourceInfo(name, (PDFObject)xObject);
        return true;
    }

    public boolean bookmarkError(PDFBookmark bookmark, PDFA2ErrorSet<PDFA2AbstractBookmarkErrorCode> errors) {
        this.report(bookmark, errors);
        return true;
    }

    public boolean catalogError(PDFA2ErrorSet<PDFA2AbstractCatalogErrorCode> errors) {
        this.reportError(0, errors.toString(), "CATALOG ERROR");
        return true;
    }

    public boolean colorSpaceError(PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode> errors) {
        this.reportResourceError(errors, "COLOR SPACE ERROR");
        return true;
    }

    public boolean contentError(ASName operatorName, PDFA2ErrorSet<PDFA2AbstractContentStreamErrorCode> errors) {
        this.reportResourceError(errors, "CONTENT ERROR");
        return true;
    }

    public boolean docMetadataError(PDFA2ErrorSet<PDFA2AbstractDocumentMetadataErrorCode> errors) {
        this.reportError(0, errors.toString(), "DOC METADATA ERROR");
        return true;
    }

    public boolean docXMPError(PDFA2XMPErrorCollector errors) {
        this.reportError(0, errors.toString(), "DOCXMP");
        return true;
    }

    public boolean endAnnotationScan() {
        this.annot = null;
        this.annotDisplayed = false;
        return true;
    }

    public boolean endAnnotationsScan() {
        return true;
    }

    public boolean endColorSpaceScan() {
        this.popResourceInfo();
        return true;
    }

    public boolean endContentScan() {
        return true;
    }

    public boolean endDocMetadataScan() {
        return true;
    }

    public boolean endDocumentScan(boolean errorsFound) {
        if (errorsFound) {
            this.report(0, "VALIDATION SUMMARY: PDFA2Service reports that un-fixed PDF/2A errors were found.", 3, "");
        } else {
            this.report(0, "VALIDATION SUMMARY: PDFA2Service reports that no un-fixed PDF/2A errors were found.", 3, "");
        }
        return true;
    }

    public boolean endFileStructureScan(PDFA2SaveTypes saveTypes) {
        this.saveTypes = saveTypes;
        return true;
    }

    public boolean endFontScan() {
        this.popResourceInfo();
        return true;
    }

    public boolean endFormFieldScan() {
        this.field = null;
        this.fieldDisplayed = false;
        return true;
    }

    public boolean endFormFieldTreeScan() {
        return true;
    }

    public boolean endOutputIntentScan() {
        return true;
    }

    public boolean endPageScan() {
        this.page = null;
        this.pageIndex = 0;
        this.pageDisplayed = false;
        return true;
    }

    public boolean endPageTreeScan() {
        return true;
    }

    public boolean endPatternScan() {
        this.popResourceInfo();
        return true;
    }

    public boolean endXObjectScan() {
        this.popResourceInfo();
        return true;
    }

    public boolean extGStateError(PDFExtGState extGState, PDFA2ErrorSet<PDFA2AbstractExtGStateErrorCode> errors) {
        this.reportResourceError(errors, "EXTJS STATE ERROR");
        return true;
    }

    public boolean fileStructureError(PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> errors) {
        if (errors.hasErrors()) {
            this.reportError(0, errors.toString(), "FILE STRUCTURE ERROR");
        }
        return true;
    }

    public boolean fontError(PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errors) {
        this.reportResourceError(errors, "FONT ERROR");
        return true;
    }

    public boolean fontXMPError(PDFA2XMPErrorCollector font) {
        this.reportResourceModification("Invalid XMP in font removed");
        return true;
    }

    public boolean formFieldError(PDFA2ErrorSet<PDFA2AbstractFieldErrorCode> errors) {
        this.reportResourceError(errors, "FORM FIELD ERROR");
        return true;
    }

    public EmbeddedFilePDFA1ValidationHandler getEmbeddedFilePDFA1ValidationHandler() {
        return null;
    }

    public EmbeddedFilePDFA2ValidationHandler getEmbeddedFilePDFA2ValidationHandler() {
        return null;
    }

    public boolean iccProfileXMPError(PDFA2XMPErrorCollector errors) {
        return true;
    }

    public boolean imageXMPError(PDFA2XMPErrorCollector arg0) {
        return true;
    }

    public boolean invalidNamespaceUsage(Collection<PDFA2InvalidNamespaceUsage> invalidUsage) {
        this.report(0, "METADATA: Invalid Namespace Usage Found.", 2, "");
        this.report(1, invalidUsage.toString(), 2, "");
        return true;
    }

    public boolean invalidTypeUsage(Map<XMLElement, PropertyOptions> invalidTypes) {
        this.report(0, "METADATA: Invalid Type Usage Found.", 2, "");
        this.report(1, invalidTypes.toString(), 2, "");
        return true;
    }

    public boolean outputIntentsError(PDFOutputIntent intent, PDFA2ErrorSet<PDFA2AbstractOutputIntentErrorCode> errors) {
        this.report(intent, errors);
        return true;
    }

    public boolean pageError(PDFA2ErrorSet<PDFA2AbstractPageErrorCode> errors) {
        this.reportResourceError(errors, "PAGE ERROR");
        return true;
    }

    public boolean pageXMPError(PDFA2XMPErrorCollector arg0) {
        return true;
    }

    public boolean patternError(PDFA2ErrorSet<PDFA2AbstractPatternErrorCode> errors) {
        this.reportResourceError(errors, "PATTERN ERROR");
        return true;
    }

    public boolean type1FormXMPError(PDFA2XMPErrorCollector errors) {
        return true;
    }

    public boolean xObjectError(PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errors) {
        this.reportResourceError(errors, "XOBJECT ERROR");
        return true;
    }

    public boolean CIDSetUpdatedInType0Font(PDFFont font) {
        this.reportResourceModification("CIDSet updated");
        return true;
    }

    public boolean CIDToGIDMapUpdatedInType0Font(PDFFont font) {
        this.reportResourceModification("CIDToGIDMap updated");
        return true;
    }

    public boolean alternateColorSpaceUsedAsInvalidICCProfileFound(PDFColorSpaceICCBased pIccCS) {
        this.report(0, "ICCProfile based color space found with invalid ICC profile. Falling back to alternate color space.", 2, "");
        this.report(1, pIccCS.getName().toString(), 2, "");
        return true;
    }

    public boolean alternatePresentationsRemovedFromNameTree() {
        return true;
    }

    public boolean alternatesRemovedFromImage(PDFXObjectImage image) {
        this.reportResourceModification("Alternates removed from image XOject");
        return true;
    }

    public boolean annotWithInvalidFlagValueRemoved(PDFAnnotation arg0) {
        return true;
    }

    public boolean annotationAppearanceSet(PDFAnnotation arg0) {
        return true;
    }

    public boolean annotationFlagsSet(PDFAnnotation annot, int oldFlags, int newFlags) {
        this.reportResourceModification("Annotation flags repaired (Old: " + oldFlags + ", New: " + newFlags + ")");
        return true;
    }

    public boolean asKeyRemovedFromOptionalContentConfig() {
        return true;
    }

    public boolean cMapEmbeddedInType0Font(PDFFont font) {
        this.reportResourceModification("CMap embedded");
        return true;
    }

    public boolean charSetUpdatedInType1Font(PDFFont font) {
        this.reportResourceModification("CharSet updated");
        return true;
    }

    public boolean conversionSummary(boolean fixesApplied, boolean unfixableFound) {
        if (fixesApplied) {
            this.report(0, "CONVERSION SUMMARY: PDFAService reports that PDF/A fixes were applied.", 3, "");
        } else {
            this.report(0, "CONVERSION SUMMARY: PDFAService reports that no PDF/A fixes were applied.", 3, "");
        }
        return true;
    }

    public boolean defaultColorSpaceSet(ASName colorSpaceName, PDFColorSpace colorSpace) {
        this.reportResourceModification(colorSpaceName.asString() + " color space set");
        return true;
    }

    public boolean embeddedFileRemovedFromNameTree(PDFFileSpecification arg0) {
        this.reportModification("EmbeddedFiles name tree removed");
        return true;
    }

    public boolean extGStateHTPKeyRemoved(PDFExtGState arg0) {
        return true;
    }

    public boolean fileStructureErrorsFixed(PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> errorsFound, PDFA2ErrorSet<PDFA2AbstractFileStructureErrorCode> errorsFixed) {
        if (errorsFound.hasErrors()) {
            this.report(0, "FileStructureErrorsFound: " + errorsFound.toString(), 1, "");
        }
        if (errorsFixed.hasErrors()) {
            this.report(0, "FileStructureErrorsFixed: " + errorsFixed.toString(), 1, "");
        }
        return true;
    }

    public boolean fontEmbedded(PDFFont font) {
        this.reportResourceModification("Font embedded");
        return true;
    }

    public boolean getAnnotationAppearance(PDFAnnotation arg0, PDFAppearance arg1) {
        return true;
    }

    public boolean getColorSpaceBasedOnColorComponents(int arg0, ColorSpaceContainer arg1) {
        return true;
    }

    public PDFICCProfile getValidICCProfile(PDFICCProfile arg0) {
        return null;
    }

    public boolean illegalActionRemoved(PDFAction arg0) {
        this.reportResourceModification("Action removed");
        return true;
    }

    public boolean illegalAdditionalActionsRemoved(PDFAdditionalActions arg0) {
        this.reportResourceModification("Additional actions removed");
        return true;
    }

    public boolean illegalAnnotationRemoved(PDFAnnotation arg0) {
        this.reportResourceModification("Illegal annotation removed");
        return true;
    }

    public boolean illegalInstructionRemoved(ASName op) {
        this.reportResourceModification("Illegal instruction removed: " + op);
        return true;
    }

    public boolean illegalInterpolationRemoved() {
        this.reportResourceModification("Illegal interpolation removed");
        return true;
    }

    public boolean inlineImageInvalidFilterReplaced(ASName newFilter) {
        if (newFilter == null) {
            this.reportResourceModification("Inline image LZW filter removed");
        } else {
            this.reportResourceModification("Inline image LZW filter replaced with \"" + newFilter.asString() + "\"");
        }
        return true;
    }

    public boolean javaScriptNameTreeRemoved() {
        this.reportModification("JavaScript name tree removed");
        return true;
    }

    public boolean jpxDecodeFilterReplaced(PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> arg0, PDFFilterList arg1) {
        return true;
    }

    public boolean nonNormalAnnotAppearanceRemoved(PDFAnnotation arg0, ASName apType) {
        this.reportResourceModification("Non-normal appearance removed (" + apType.toString() + ")");
        return true;
    }

    public boolean normalAPDictConvertedToStream(PDFAnnotation arg0) {
        this.reportResourceModification("Normal appearance dictionary converted to stream");
        return true;
    }

    public boolean normalAPStreamConvertedToDictForButton(PDFAnnotation pdfAnnotation) {
        this.reportResourceModification("Normal APStream converted to dict for button");
        return true;
    }

    public boolean notdefGlyphRemoved(PDFFont arg0) {
        return true;
    }

    public boolean openActionRemovedFromCatalog(PDFOpenAction arg0) {
        this.reportModification("Illegal OpenAction entry removed from catalog");
        return true;
    }

    public boolean opiRemovedFromXObject(PDFXObject arg0) {
        this.reportResourceModification("OPI removed from XObject");
        return true;
    }

    public boolean orderKeyRemovedFromOptionalContentConfig() {
        return true;
    }

    public boolean pdfaInfoSetInMetadata(PDFA2ConformanceLevel conformance) {
        this.reportModification("PDF/A metadata set to " + conformance);
        return true;
    }

    public boolean pdfaOutputIntentSet(PDFOutputIntent arg0) {
        this.reportModification("PDF/A output intent set");
        return true;
    }

    public boolean postScriptXObjectRemoved(ASName name, PDFXObjectPostScript arg1) {
        this.reportResourceModification("PostScript XObject (" + name + ") removed from content stream");
        return true;
    }

    public boolean presStepsRemoved(PDFPage entryName) {
        return true;
    }

    public boolean psRemovedFromXObject(PDFXObjectForm arg0, ASName entryName) {
        this.reportResourceModification("PS or Subtype2 removed from form XObject (" + entryName + ")");
        return true;
    }

    public boolean referenceXObjectRemoved(ASName name, PDFXObjectForm arg1) {
        this.reportResourceModification("Reference XObject (" + name + ") removed from content stream");
        return true;
    }

    public boolean renderingIntentOverridden(ASName oldIntent, ASName newIntent) {
        this.reportResourceModification("Rendering intent overridden (Old: " + oldIntent.asString() + ", " + newIntent.asString() + ")");
        return true;
    }

    public boolean requirementsRemovedFromCatalog() {
        return true;
    }

    public boolean schemasForInsertion(Collection<PDFA2InvalidNamespaceUsage> invalidUsage, Collection<PDFA2XMPSchema> schemas) {
        this.report(0, "METADATA: Invalid Usage Remaining.", 2, "");
        this.report(1, invalidUsage.toString(), 2, "");
        this.report(0, "METADATA: Schemas to be inserted into the XMP.", 2, "");
        this.report(1, schemas.toString(), 2, "");
        return true;
    }

    public boolean streamObjectDLKeyRemoved(PDFStream arg0) {
        return true;
    }

    public boolean transferFunctionRemoved(PDFExtGState arg0, ASName trEntryName) {
        this.reportResourceModification("Transfer function removed or reset (" + trEntryName + ")");
        return true;
    }

    public boolean trueTypeFontReEmbedded(PDFFont arg0) {
        this.reportResourceModification("True Type font re-embedded");
        return true;
    }

    public boolean wModeUpdatedInType0Font(PDFFont arg0) {
        this.reportResourceModification("CIDToGIDMap updated");
        return true;
    }

    public boolean widthsMetricsUpdated(PDFFont arg0) {
        this.reportResourceModification("Widths metrics updated");
        return true;
    }

    public boolean xfaRemoved() {
        this.reportModification("XFA removed");
        return true;
    }

    public Map<String, ArrayList<String>> getArchiveErrorReport() {
        return this.globalErrorMap;
    }

    public boolean hasErrors() {
        return this.errorsFound;
    }

    public String getConfigName(PDFOCConfig arg0, Set<String> ocConfigNames) {
        String ns = "Default";
        int i = 0;
        while (!ocConfigNames.add(ns)) {
            ns = ns + ++i;
        }
        return ns;
    }

    public byte[] getUnicodeValue(PDFFont arg0, Integer arg1) {
        return null;
    }

    class ResourceInfo {
        ASName resourceName;
        PDFObject resource;

        ResourceInfo(ASName resourceName, PDFObject resource) {
            this.resourceName = resourceName;
            this.resource = resource;
        }
    }
}

