/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.webkit;

import coldfusion.document.webkit.core.DocumentSettingsWebkit;
import coldfusion.document.webkit.core.HtmlToPdfMargin;
import coldfusion.document.webkit.core.HtmlToPdfPageLayout;
import coldfusion.runtime.RequestMonitor;
import coldfusion.vfs.VFSFileFactory;
import org.apache.commons.lang3.StringEscapeUtils;

public final class PDFgServiceRequestCreator {
    private static final String VALUE = "' value='";
    private static final String SETTING_NAME = "<Setting name='";
    private static final String AUTHPASSWORD = "<Setting name='AuthPassword' value='";
    private static final String AUTHUSER = "<Setting name='AuthUser' value='";
    private static final String DEVWATERMARK = "<Setting name='AddDeveloperWatermark' value='";
    private static final String BOOKMARKS = "<Setting name='Bookmarks' value='";
    private static final String FONTEMBED = "<Setting name='FontEmbed' value='";
    private static final String SCALE = "<Setting name='Scale' value='";
    private static final String ORIENTATION = "<Setting name='Orientation' value='";
    private static final String PAGEHEIGHT = "<Setting name='PageHeight' value='";
    private static final String PAGEWIDTH = "<Setting name='PageWidth' value='";
    private static final String MARGINBOTTOM = "<Setting name='MarginBottom' value='";
    private static final String MARGINTOP = "<Setting name='MarginTop' value='";
    private static final String MARGINRIGHT = "<Setting name='MarginRight' value='";
    private static final String MARGINLEFT = "<Setting name='MarginLeft' value='";
    private static final String MIMETYPE = "<Setting name='MimeType' value='";
    private static final String OVERWRITE = "<Setting name='Overwrite' value='";
    private static final String DESTFILE = "<Setting name='DestFile' value='";
    private static final String BASEURL = "<Setting name='BaseURL' value='";
    private static final String SOURCEURL = "<Setting name='SourceURL' value='";
    private static final String HEADERFOOTER = "<Setting name='HeaderFooter' value='";
    private static final String CONVERSION_TIMEOUT = "<Setting name='ConversionTimeout' value='";
    private static final String CONVERT_PDF = "<PDFConversion><PDFOperation name='ConvertPDF'>";
    public static final String END_OPERATION = "</PDFOperation></PDFConversion>";
    private static final String TASK_START_ELEMENT = "<PDFTask>";
    private static final String TASK_END_ELEMENT = "</PDFTask>";
    private static final String END_ELEMENT = "'/>";

    public static String buildSectionConvertPDFRequestTask(DocumentSettingsWebkit sectionSettings) {
        StringBuffer initData = new StringBuffer();
        initData.append(TASK_START_ELEMENT);
        PDFgServiceRequestCreator.addSectionConvertData(sectionSettings, initData);
        initData.append(TASK_END_ELEMENT);
        return initData.toString();
    }

    public static String buildConvertPDFRequestForSection(DocumentSettingsWebkit pdfSettings) {
        StringBuffer initData = new StringBuffer();
        initData.append(CONVERT_PDF);
        PDFgServiceRequestCreator.addCommonConversionData(pdfSettings, initData);
        return initData.toString();
    }

    public static String buildConvertPDFRequest(DocumentSettingsWebkit pdfSettings) {
        StringBuffer initData = new StringBuffer();
        initData.append(CONVERT_PDF);
        PDFgServiceRequestCreator.addEntry(initData, SOURCEURL, StringEscapeUtils.escapeXml((String)StringEscapeUtils.unescapeXml((String)pdfSettings.getPageURL())));
        PDFgServiceRequestCreator.addEntry(initData, BASEURL, pdfSettings.getBaseURL());
        PDFgServiceRequestCreator.addCommonConversionData(pdfSettings, initData);
        initData.append(END_OPERATION);
        return initData.toString();
    }

    private static void addCommonConversionData(DocumentSettingsWebkit pdfSettings, StringBuffer initData) {
        String outputFile = pdfSettings.getOutputFile();
        if (outputFile != null && !VFSFileFactory.checkIfVFile((String)outputFile)) {
            PDFgServiceRequestCreator.addEntry(initData, DESTFILE, outputFile);
        }
        PDFgServiceRequestCreator.addEntry(initData, OVERWRITE, pdfSettings.isOverwrite());
        PDFgServiceRequestCreator.addEntry(initData, MIMETYPE, pdfSettings.getMimeType());
        PDFgServiceRequestCreator.addEntry(initData, ORIENTATION, pdfSettings.getPageLayout().getOrientation());
        PDFgServiceRequestCreator.addEntry(initData, SCALE, pdfSettings.getScale());
        PDFgServiceRequestCreator.addEntry(initData, FONTEMBED, pdfSettings.isFontEmbed());
        PDFgServiceRequestCreator.addEntry(initData, BOOKMARKS, pdfSettings.isBookmark() ? "TRUE" : "FALSE");
        PDFgServiceRequestCreator.addEntry(initData, DEVWATERMARK, pdfSettings.isAddDevWatermark());
        PDFgServiceRequestCreator.addEntry(initData, HEADERFOOTER, pdfSettings.isShowHeader());
        PDFgServiceRequestCreator.addEntry(initData, AUTHUSER, pdfSettings.getAuthUser());
        PDFgServiceRequestCreator.addEntry(initData, AUTHPASSWORD, pdfSettings.getAuthPassword());
        PDFgServiceRequestCreator.addEntry(initData, PAGEWIDTH, pdfSettings.getPageLayout().getPagewidth() * 72.0);
        PDFgServiceRequestCreator.addEntry(initData, PAGEHEIGHT, pdfSettings.getPageLayout().getPageheight() * 72.0);
        PDFgServiceRequestCreator.addMargins(pdfSettings, initData);
        long requestTimeout = RequestMonitor.getRequestTimeout();
        PDFgServiceRequestCreator.addEntry(initData, CONVERSION_TIMEOUT, requestTimeout);
    }

    private static void addSectionConvertData(DocumentSettingsWebkit sectionSettings, StringBuffer initData) {
        PDFgServiceRequestCreator.addEntry(initData, SOURCEURL, sectionSettings.getPageURL());
        PDFgServiceRequestCreator.addEntry(initData, BASEURL, sectionSettings.getBaseURL());
        PDFgServiceRequestCreator.addEntry(initData, MIMETYPE, sectionSettings.getMimeType());
        PDFgServiceRequestCreator.addEntry(initData, AUTHUSER, sectionSettings.getAuthUser());
        PDFgServiceRequestCreator.addEntry(initData, AUTHPASSWORD, sectionSettings.getAuthPassword());
        PDFgServiceRequestCreator.addMargins(sectionSettings, initData);
    }

    private static void addEntry(StringBuffer initData, String key, String value) {
        if (value != null) {
            initData.append(key);
            initData.append(value);
            initData.append(END_ELEMENT);
        }
    }

    private static void addEntry(StringBuffer initData, String key, boolean value) {
        initData.append(key);
        initData.append(value);
        initData.append(END_ELEMENT);
    }

    private static void addEntry(StringBuffer initData, String key, long value) {
        if (value >= 0L) {
            initData.append(key);
            initData.append(value);
            initData.append(END_ELEMENT);
        }
    }

    private static void addEntry(StringBuffer initData, String key, double value) {
        if (value >= 0.0) {
            initData.append(key);
            initData.append(value);
            initData.append(END_ELEMENT);
        }
    }

    private static void addMargins(DocumentSettingsWebkit pdfSettings, StringBuffer initData) {
        HtmlToPdfPageLayout pageLayout = pdfSettings.getPageLayout();
        if (pageLayout != null) {
            HtmlToPdfMargin margin = pageLayout.getMargin();
            if (margin.getLeft() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINLEFT, String.valueOf(margin.getLeft() * 72.0));
            }
            if (margin.getRight() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINRIGHT, String.valueOf(margin.getRight() * 72.0));
            }
            if (margin.getTop() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINTOP, String.valueOf(margin.getTop() * 72.0));
            }
            if (margin.getBottom() != -1.0) {
                PDFgServiceRequestCreator.addEntry(initData, MARGINBOTTOM, String.valueOf(margin.getBottom() * 72.0));
            }
        }
    }
}

