/*
 * Decompiled with CFR 0.152.
 */
package com.ddtek.pool;

import com.ddtek.jdbc.extensions.ExtDataSource;
import com.ddtek.pool.ConnectionPool;
import com.ddtek.pool.ConnectionPoolGroup;
import com.ddtek.pool.ConnectionPoolMonitor;
import com.ddtek.pool.PooledConnectionDataSourceFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public class PooledConnectionDataSource
implements DataSource,
Referenceable,
Serializable {
    private static Hashtable hash;
    static final String DESCRIPTION = "description";
    static final String DATASOURCENAME = "dataSourceName";
    static final String POOLNAME = "poolName";
    static final String INITIALPOOLSIZE = "initialPoolSize";
    static final String MINPOOLSIZE = "minPoolSize";
    static final String MAXPOOLSIZE = "maxPoolSize";
    static final String MAXIDLETIME = "maxIdleTime";
    static final String PROPERTYCYCLE = "propertyCycle";
    static final String TRACING = "tracing";
    static final String LOGTIMESTAMP = "logTimestamp";
    static final String LOGTNAME = "logTName";
    static final String REAUTHENTICATION = "reauthentication";
    static final String MAXPOOLSIZEBEHAVIOR = "maxPoolSizeBehavior";
    private static String footprint;
    private ConnectionPoolDataSource cpds;
    private boolean createdByLookup = false;
    private String description;
    private String poolName;
    private String dataSourceName;
    private int initialPoolSize;
    private int minPoolSize;
    private int maxPoolSize;
    private int maxIdleTime;
    private int propertyCycle;
    private boolean tracing;
    private boolean logTimestamp;
    private boolean logTName;
    private String reauthentication = "disable";
    private static ArrayList monitors;
    private boolean supportsMBeans = true;
    private String maxPoolSizeBehavior = "SoftCap";

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), new PooledConnectionDataSourceFactory().getClass().getName(), null);
        if (this.description != null) {
            reference.add(new StringRefAddr(DESCRIPTION, this.description));
        }
        if (this.dataSourceName == null) {
            throw new NamingException("The DataSource used to create connections for this connection pool must be specified by calling one of the setDataSourceName methods.");
        }
        reference.add(new StringRefAddr(DATASOURCENAME, this.dataSourceName));
        if (this.poolName == null) {
            reference.add(new StringRefAddr(POOLNAME, ""));
        } else {
            reference.add(new StringRefAddr(POOLNAME, this.poolName));
        }
        reference.add(new StringRefAddr(INITIALPOOLSIZE, Integer.toString(this.initialPoolSize)));
        reference.add(new StringRefAddr(MINPOOLSIZE, Integer.toString(this.minPoolSize)));
        reference.add(new StringRefAddr(MAXPOOLSIZE, Integer.toString(this.maxPoolSize)));
        reference.add(new StringRefAddr(PROPERTYCYCLE, Integer.toString(this.propertyCycle)));
        reference.add(new StringRefAddr(MAXIDLETIME, Integer.toString(this.maxIdleTime)));
        reference.add(new StringRefAddr(TRACING, this.tracing ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        reference.add(new StringRefAddr(LOGTIMESTAMP, this.logTimestamp ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        reference.add(new StringRefAddr(LOGTNAME, this.logTName ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        reference.add(new StringRefAddr(REAUTHENTICATION, this.reauthentication));
        reference.add(new StringRefAddr(MAXPOOLSIZEBEHAVIOR, this.maxPoolSizeBehavior));
        return reference;
    }

    public void setDescription(String string) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setCreatedByLookup() {
        this.createdByLookup = true;
    }

    public void setDataSourceName(String string) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.dataSourceName = string;
    }

    public void setDataSourceName(String string, ConnectionPoolDataSource connectionPoolDataSource) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.dataSourceName = string;
        this.cpds = connectionPoolDataSource;
    }

    public void setDataSourceName(String string, Context context) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        try {
            this.cpds = (ConnectionPoolDataSource)context.lookup(string);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setPoolName(String string) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.poolName = string;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setInitialPoolSize(int n) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.initialPoolSize = n;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setMinPoolSize(int n) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.minPoolSize = n;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMaxPoolSize(int n) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.maxPoolSize = n;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setPropertyCycle(int n) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.propertyCycle = n;
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public void setMaxIdleTime(int n) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.maxIdleTime = n;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setTracing(boolean bl) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.tracing = bl;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    public void setLogTimestamp(boolean bl) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.logTimestamp = bl;
    }

    public boolean getLogTimestamp() {
        return this.logTimestamp;
    }

    public void setLogTName(boolean bl) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.logTName = bl;
    }

    public boolean getLogTName() {
        return this.logTName;
    }

    public void setReauthentication(String string) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.reauthentication = string.equalsIgnoreCase("enable") ? string : "disable";
    }

    public String getReauthentication() {
        return this.reauthentication;
    }

    public void setMaxPoolSizeBehavior(String string) {
        if (this.createdByLookup) {
            throw new UnsupportedOperationException("Property is read only.");
        }
        this.maxPoolSizeBehavior = string != null && string.equalsIgnoreCase("HardCap") ? string : "SoftCap";
    }

    public String getMaxPoolSizeBehavior() {
        return this.maxPoolSizeBehavior;
    }

    @Override
    public Connection getConnection() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.getCpds();
        return this.getConnection(((ExtDataSource)connectionPoolDataSource).getUser(), ((ExtDataSource)connectionPoolDataSource).getPassword());
    }

    @Override
    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        Connection connection;
        ConnectionPoolGroup connectionPoolGroup;
        if (this.poolName == null || this.poolName.length() == 0) {
            this.poolName = this.getDataSourceName();
        }
        if ((connectionPoolGroup = (ConnectionPoolGroup)hash.get(this.poolName)) == null) {
            connectionPoolGroup = new ConnectionPoolGroup(this);
            hash.put(this.poolName, connectionPoolGroup);
        }
        if (this.reauthentication.equalsIgnoreCase("disable")) {
            String string3 = ((ExtDataSource)this.getCpds()).getAuthenticatedUser(string);
            String string4 = string3 == null || string3.length() == 0 ? (string == null ? "$NULL$" : string) : string3;
            ConnectionPool connectionPool = connectionPoolGroup.getConnectionPool(string, string2, string4);
            this.createMonitor(connectionPool, this.poolName + "-" + string4);
            connection = connectionPool.getConnection();
        } else {
            String string5 = "$NULL$";
            ConnectionPool connectionPool = connectionPoolGroup.getConnectionPool(string, string2, string5);
            this.createMonitor(connectionPool, this.poolName);
            connection = connectionPool.getConnection(string, string2);
        }
        return connection;
    }

    private synchronized void createMonitor(ConnectionPool connectionPool, String string) {
        ConnectionPoolMonitor connectionPoolMonitor = PooledConnectionDataSource.getMonitor(string);
        if (connectionPoolMonitor == null) {
            connectionPoolMonitor = new ConnectionPoolMonitor(connectionPool, string);
            monitors.add(connectionPoolMonitor);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getCpds().getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getCpds().getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.getCpds().setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.getCpds().setLoginTimeout(n);
    }

    public void close() {
        for (ConnectionPoolGroup connectionPoolGroup : hash.values()) {
            connectionPoolGroup.close();
        }
        hash.clear();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.dataSourceName == null) {
            throw new IOException("The DataSource used to create connections for this connection pool must be specified by calling one of the setDataSourceName methods.");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createdByLookup = true;
    }

    ConnectionPoolDataSource getCpds() throws SQLException {
        if (this.cpds == null) {
            throw new SQLException("The PooledConnectionDataSource is not able to obtain the necessary connection information from the named data source. Please verify the data source name specified by the call to setDataSourceName. If the name is accurate, then it may be necessary to call setDataSourceName(String, ConnectionPoolDataSource) or setDataSourceName(String, Context).");
        }
        return this.cpds;
    }

    public static synchronized ConnectionPoolMonitor[] getMonitors() {
        ConnectionPoolMonitor[] connectionPoolMonitorArray = new ConnectionPoolMonitor[monitors.size()];
        int n = monitors.size();
        for (int i = 0; i < n; ++i) {
            connectionPoolMonitorArray[i] = (ConnectionPoolMonitor)monitors.get(i);
        }
        return connectionPoolMonitorArray;
    }

    public static synchronized ConnectionPoolMonitor getMonitor(String string) {
        ConnectionPoolMonitor connectionPoolMonitor = null;
        int n = monitors.size();
        for (int i = 0; i < n; ++i) {
            connectionPoolMonitor = (ConnectionPoolMonitor)monitors.get(i);
            if (!connectionPoolMonitor.getName().equals(string)) continue;
            return connectionPoolMonitor;
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        try {
            clazz.cast(this);
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("Cannot unwrap object to class " + clazz.getCanonicalName());
        }
    }

    static {
        footprint = "$Revision: #2 $";
        hash = new Hashtable();
        monitors = new ArrayList();
    }
}

