/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.syndication;

import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.Struct;
import coldfusion.runtime.StructUtils;
import coldfusion.sql.QueryTable;
import coldfusion.syndication.FeedReader;
import coldfusion.syndication.FeedTable;
import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.module.DCSubject;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.itunes.EntryInformation;
import com.sun.syndication.feed.module.itunes.FeedInformation;
import com.sun.syndication.feed.rss.Category;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Cloud;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Enclosure;
import com.sun.syndication.feed.rss.Guid;
import com.sun.syndication.feed.rss.Image;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.feed.rss.Source;
import com.sun.syndication.feed.rss.TextInput;
import com.sun.syndication.io.impl.DateParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

final class RSSParser {
    private static final int separator_length = ",".length();

    RSSParser() {
    }

    public static Struct getMetadataAsStruct(Channel rssFeed) {
        DCModule dcMod;
        List skipDays;
        List skipHrs;
        Struct rssMetadataStruct = new Struct();
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "version", rssFeed.getFeedType());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "encoding", rssFeed.getEncoding());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "title", rssFeed.getTitle());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "link", rssFeed.getLink());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "description", rssFeed.getDescription());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "language", rssFeed.getLanguage());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "copyright", rssFeed.getCopyright());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "managingEditor", rssFeed.getManagingEditor());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "webMaster", rssFeed.getWebMaster());
        if (rssFeed.getPubDate() != null) {
            StructUtils.StructInsert((Map)rssMetadataStruct, (String)"pubDate", (Object)DateParser.formatRFC822((Date)rssFeed.getPubDate()), (boolean)false);
        }
        if (rssFeed.getLastBuildDate() != null) {
            StructUtils.StructInsert((Map)rssMetadataStruct, (String)"lastBuildDate", (Object)DateParser.formatRFC822((Date)rssFeed.getLastBuildDate()), (boolean)false);
        }
        Array categoriesArray = new Array();
        List categories = rssFeed.getCategories();
        if (categories != null && categories.size() > 0) {
            Iterator it = categories.iterator();
            while (it.hasNext()) {
                Struct categoryStruct = new Struct();
                Category rssCategory = (Category)it.next();
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "domain", rssCategory.getDomain());
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "value", rssCategory.getValue());
                if (categoryStruct.isEmpty()) continue;
                categoriesArray.add((Object)categoryStruct);
            }
            if (categoriesArray.size() > 0) {
                StructUtils.StructInsert((Map)rssMetadataStruct, (String)"category", (Object)categoriesArray, (boolean)false);
            }
        }
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "generator", rssFeed.getGenerator());
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "docs", rssFeed.getDocs());
        Struct cloudStruct = new Struct();
        Cloud feedCloud = rssFeed.getCloud();
        if (feedCloud != null) {
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(cloudStruct, "domain", feedCloud.getDomain());
            if (feedCloud.getPort() != null) {
                StructUtils.StructInsert((Map)cloudStruct, (String)"port", (Object)feedCloud.getPort(), (boolean)false);
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(cloudStruct, "path", feedCloud.getPath());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(cloudStruct, "protocol", feedCloud.getProtocol());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(cloudStruct, "registerProcedure", feedCloud.getRegisterProcedure());
            if (!cloudStruct.isEmpty()) {
                StructUtils.StructInsert((Map)rssMetadataStruct, (String)"cloud", (Object)cloudStruct, (boolean)false);
            }
        }
        if (rssFeed.getTtl() != null) {
            StructUtils.StructInsert((Map)rssMetadataStruct, (String)"ttl", (Object)rssFeed.getTtl(), (boolean)false);
        }
        Struct imageStruct = new Struct();
        Image feedImage = rssFeed.getImage();
        if (feedImage != null) {
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(imageStruct, "url", feedImage.getUrl());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(imageStruct, "title", feedImage.getTitle());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(imageStruct, "link", feedImage.getLink());
            if (feedImage.getWidth() != null) {
                StructUtils.StructInsert((Map)imageStruct, (String)"width", (Object)feedImage.getWidth(), (boolean)false);
            }
            if (feedImage.getHeight() != null) {
                StructUtils.StructInsert((Map)imageStruct, (String)"height", (Object)feedImage.getHeight(), (boolean)false);
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(imageStruct, "description", feedImage.getDescription());
            if (!imageStruct.isEmpty()) {
                StructUtils.StructInsert((Map)rssMetadataStruct, (String)"image", (Object)imageStruct, (boolean)false);
            }
        }
        RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "rating", rssFeed.getRating());
        Struct textInputStruct = new Struct();
        TextInput feedTextInput = rssFeed.getTextInput();
        if (feedTextInput != null) {
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(textInputStruct, "title", feedTextInput.getTitle());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(textInputStruct, "description", feedTextInput.getDescription());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(textInputStruct, "name", feedTextInput.getName());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(textInputStruct, "link", feedTextInput.getLink());
            if (!textInputStruct.isEmpty()) {
                StructUtils.StructInsert((Map)rssMetadataStruct, (String)"textInput", (Object)textInputStruct, (boolean)false);
            }
        }
        if ((skipHrs = rssFeed.getSkipHours()) != null && skipHrs.size() > 0) {
            StringBuffer skipHoursList = new StringBuffer();
            Iterator it1 = skipHrs.iterator();
            while (it1.hasNext()) {
                skipHoursList.append(Cast._int(it1.next()));
                skipHoursList.append(',');
            }
            if (skipHoursList.length() > 0) {
                skipHoursList.deleteCharAt(skipHoursList.length() - 1);
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "skipHours", skipHoursList.toString());
        }
        if ((skipDays = rssFeed.getSkipDays()) != null && skipDays.size() > 0) {
            StringBuffer skipDaysList = new StringBuffer();
            Iterator it1 = skipDays.iterator();
            while (it1.hasNext()) {
                skipDaysList.append((String)it1.next());
                skipDaysList.append(',');
            }
            if (skipDaysList.length() > 0) {
                skipDaysList.deleteCharAt(skipDaysList.length() - 1);
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "skipDays", skipDaysList.toString());
        }
        if ((dcMod = (DCModule)rssFeed.getModule("http://purl.org/dc/elements/1.1/")) != null) {
            RSSParser.getDCElementsAsStruct(dcMod, rssMetadataStruct);
        }
        Iterator itemIterator = rssFeed.getItems().iterator();
        boolean isDCExtension = false;
        while (itemIterator.hasNext()) {
            Item item = (Item)itemIterator.next();
            Module module = item.getModule("http://purl.org/dc/elements/1.1/");
            if (module == null) continue;
            isDCExtension = true;
            break;
        }
        if (isDCExtension || dcMod != null) {
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "feedextension", "DublinCore");
        }
        itemIterator = rssFeed.getItems().iterator();
        boolean isItunesExtension = false;
        while (itemIterator.hasNext()) {
            Item item = (Item)itemIterator.next();
            Module module = item.getModule("http://www.itunes.com/dtds/podcast-1.0.dtd");
            if (module == null) continue;
            isItunesExtension = true;
            break;
        }
        if (isItunesExtension || rssFeed.getModule("http://www.itunes.com/dtds/podcast-1.0.dtd") != null) {
            String feedExtension = (String)rssMetadataStruct.get((Object)"feedextension");
            if (feedExtension == null) {
                feedExtension = "itunes";
            } else {
                StructUtils.StructDelete((Map)rssMetadataStruct, (String)"feedextension", (boolean)false);
                feedExtension = feedExtension + ",itunes";
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "feedExtension", feedExtension);
        }
        RSSParser.getItunesMetadata(rssMetadataStruct, rssFeed);
        return rssMetadataStruct;
    }

    private static void getDCElementsAsStruct(DCModule dcMod, Struct dcElementsStruct) {
        RSSParser.addListAsString(dcMod.getCreators(), dcElementsStruct, "dc_creator");
        RSSParser.addListAsString(dcMod.getContributors(), dcElementsStruct, "dc_contributor");
        RSSParser.addListAsString(dcMod.getCoverages(), dcElementsStruct, "dc_coverage");
        RSSParser.addListAsString(dcMod.getDescriptions(), dcElementsStruct, "dc_description");
        RSSParser.addListAsString(dcMod.getFormats(), dcElementsStruct, "dc_format");
        RSSParser.addListAsString(dcMod.getIdentifiers(), dcElementsStruct, "dc_identifier");
        RSSParser.addListAsString(dcMod.getLanguages(), dcElementsStruct, "dc_language");
        RSSParser.addListAsString(dcMod.getPublishers(), dcElementsStruct, "dc_publisher");
        RSSParser.addListAsString(dcMod.getRelations(), dcElementsStruct, "dc_relation");
        RSSParser.addListAsString(dcMod.getRightsList(), dcElementsStruct, "dc_right");
        RSSParser.addListAsString(dcMod.getSources(), dcElementsStruct, "dc_source");
        RSSParser.addListAsString(dcMod.getTitles(), dcElementsStruct, "dc_title");
        RSSParser.addListAsString(dcMod.getTypes(), dcElementsStruct, "dc_type");
        List dates = dcMod.getDates();
        if (dates != null && dates.size() > 0) {
            StringBuffer dateBuf = new StringBuffer();
            for (Date dt : dates) {
                if (dt == null) continue;
                if (dateBuf.length() > 0) {
                    dateBuf.append(",").append(DateParser.formatRFC822((Date)dt));
                    continue;
                }
                dateBuf.append(DateParser.formatRFC822((Date)dt));
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(dcElementsStruct, "dc_date", dateBuf.toString());
        }
        Array subjectsArray = new Array();
        List subjects = dcMod.getSubjects();
        if (subjects != null && subjects.size() > 0) {
            for (DCSubject content : subjects) {
                Struct contentStruct = new Struct();
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(contentStruct, "taxonomyuri", content.getTaxonomyUri());
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(contentStruct, "value", content.getValue());
                if (contentStruct.isEmpty()) continue;
                subjectsArray.add((Object)contentStruct);
            }
            if (subjectsArray.size() > 0) {
                StructUtils.StructInsert((Map)dcElementsStruct, (String)"dc_subject", (Object)subjectsArray, (boolean)false);
            }
        }
    }

    private static void addListAsString(List inList, Struct elementsStruct, String key) {
        if (inList != null && inList.size() > 0) {
            StringBuffer inBuf = new StringBuffer();
            for (String value : inList) {
                if (value == null || value.length() <= 0) continue;
                inBuf.append(value);
                inBuf.append(",");
            }
            if (inBuf.length() - separator_length > -1) {
                inBuf.deleteCharAt(inBuf.length() - separator_length);
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(elementsStruct, key, inBuf.toString());
        }
    }

    private static void getItunesMetadata(Struct rssMetadataStruct, Channel rssFeed) {
        Module module = rssFeed.getModule("http://www.itunes.com/dtds/podcast-1.0.dtd");
        if (module != null) {
            String[] keywords;
            FeedInformation feedInfo = (FeedInformation)module;
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_author", feedInfo.getAuthor());
            if (feedInfo.getBlock()) {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_block", "yes");
            } else {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_block", "no");
            }
            if (feedInfo.getCategories() != null) {
                Array cat;
                String categories = feedInfo.getCategories().toString();
                if (categories.length() > 0) {
                    categories = categories.substring(1, categories.length() - 1);
                }
                if ((cat = RSSParser.getItunesCategoryStruct(categories)) != null) {
                    rssMetadataStruct.put((Object)"itunes_category", (Object)cat);
                }
            }
            if (feedInfo.getExplicit()) {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_explicit", "yes");
            } else {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_explicit", "no");
            }
            if (feedInfo.getImage() != null) {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_image", feedInfo.getImage().toString());
            }
            if ((keywords = feedInfo.getKeywords()) != null) {
                StringBuffer keywordsBuffer = new StringBuffer("");
                for (int i = 0; i < keywords.length; ++i) {
                    keywordsBuffer.append(keywords[i]).append(",");
                }
                if (keywordsBuffer.toString().endsWith(",")) {
                    keywordsBuffer.deleteCharAt(keywordsBuffer.length() - 1);
                }
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_keywords", keywordsBuffer.toString());
            }
            if (feedInfo.getOwnerName() != null || feedInfo.getOwnerEmailAddress() != null) {
                Struct ownerStruct = new Struct();
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(ownerStruct, "itunes_name", feedInfo.getOwnerName());
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(ownerStruct, "itunes_email", feedInfo.getOwnerEmailAddress());
                if (!ownerStruct.isEmpty()) {
                    StructUtils.StructInsert((Map)rssMetadataStruct, (String)"itunes_owner", (Object)ownerStruct, (boolean)false);
                }
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_subtitle", feedInfo.getSubtitle());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(rssMetadataStruct, "itunes_summary", feedInfo.getSummary());
        }
    }

    private static Array getItunesCategoryStruct(String categoryString) {
        Array categories = null;
        if (categoryString != null && !categoryString.equals("")) {
            StringTokenizer token = new StringTokenizer(categoryString, ",");
            categories = new Array();
            while (token.hasMoreElements()) {
                String categoryStr = token.nextToken();
                Struct cat = null;
                if (categoryStr.indexOf("->") != -1) {
                    StringTokenizer categoryToken = new StringTokenizer(categoryStr, "->");
                    while (categoryToken.hasMoreElements()) {
                        cat = new Struct();
                        cat.put((Object)"category", (Object)categoryToken.nextToken());
                        String subCat = categoryToken.nextToken();
                        if (subCat == null) continue;
                        cat.put((Object)"subcategory", (Object)subCat);
                    }
                } else {
                    cat = new Struct();
                    cat.put((Object)"category", (Object)categoryStr);
                }
                categories.add((Object)cat);
            }
        }
        return categories;
    }

    private static void getItunesItemsAsArray(Struct itemStruct, Item item) {
        Module module = item.getModule("http://www.itunes.com/dtds/podcast-1.0.dtd");
        if (module != null) {
            EntryInformation entryInfo = (EntryInformation)module;
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_author", entryInfo.getAuthor());
            if (entryInfo.getBlock()) {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_block", "yes");
            } else {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_block", "no");
            }
            if (entryInfo.getDuration() != null) {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_duration", entryInfo.getDuration().toString());
            }
            if (entryInfo.getExplicit()) {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_explicit", "yes");
            } else {
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_explicit", "no");
            }
            String[] keywords = entryInfo.getKeywords();
            if (keywords != null) {
                StringBuffer keywordsBuffer = new StringBuffer("");
                for (int i = 0; i < keywords.length; ++i) {
                    keywordsBuffer.append(keywords[i]).append(",");
                }
                if (keywordsBuffer.toString().endsWith(",")) {
                    keywordsBuffer.deleteCharAt(keywordsBuffer.length() - 1);
                }
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_keywords", keywordsBuffer.toString());
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_subtitle", entryInfo.getSubtitle());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(itemStruct, "itunes_summary", entryInfo.getSummary());
        }
    }

    public static Array getItemsAsArray(Channel rssFeed) {
        String feedType = rssFeed.getFeedType().toLowerCase();
        int start = feedType.indexOf(95) + 1;
        int end = feedType.indexOf(117);
        if (end == -1) {
            end = feedType.length();
        }
        double rssVersion = Double.parseDouble(feedType.substring(start, end));
        Array rssItemsArray = new Array();
        List feedItems = rssFeed.getItems();
        for (Item item : feedItems) {
            DCModule dcMod;
            Guid guid;
            Struct currentItem = new Struct();
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(currentItem, "title", item.getTitle());
            Description desc = item.getDescription();
            if (desc != null) {
                String value = desc.getValue();
                if (rssVersion < 0.94) {
                    RSSParser.insertNotNullAndNonZeroLengthValueInStruct(currentItem, "description", value);
                } else {
                    Struct description = new Struct();
                    RSSParser.insertNotNullAndNonZeroLengthValueInStruct(description, "type", desc.getType());
                    RSSParser.insertNotNullAndNonZeroLengthValueInStruct(description, "value", value);
                    if (!description.isEmpty()) {
                        StructUtils.StructInsert((Map)currentItem, (String)"description", (Object)description, (boolean)false);
                    }
                }
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(currentItem, "link", item.getLink());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(currentItem, "uri", item.getUri());
            Source source = item.getSource();
            if (source != null) {
                Struct sourceStruct = new Struct();
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(sourceStruct, "value", source.getValue());
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(sourceStruct, "url", source.getUrl());
                if (!sourceStruct.isEmpty()) {
                    StructUtils.StructInsert((Map)currentItem, (String)"source", (Object)sourceStruct, (boolean)false);
                }
            }
            if ((guid = item.getGuid()) != null) {
                Struct guidStruct = new Struct();
                RSSParser.insertNotNullAndNonZeroLengthValueInStruct(guidStruct, "value", guid.getValue());
                StructUtils.StructInsert((Map)guidStruct, (String)"isPermaLink", (Object)guid.isPermaLink(), (boolean)false);
                StructUtils.StructInsert((Map)currentItem, (String)"guid", (Object)guidStruct, (boolean)false);
            }
            Array enclosuresArray = new Array();
            List enclosures = item.getEnclosures();
            if (enclosures != null && enclosures.size() > 0) {
                Iterator it1 = enclosures.iterator();
                while (it1.hasNext()) {
                    Struct enclosureStruct = new Struct();
                    Enclosure rssEnclosure = (Enclosure)it1.next();
                    RSSParser.insertNotNullAndNonZeroLengthValueInStruct(enclosureStruct, "url", rssEnclosure.getUrl());
                    if (rssEnclosure.getLength() != null) {
                        StructUtils.StructInsert((Map)enclosureStruct, (String)"length", (Object)rssEnclosure.getLength(), (boolean)false);
                    }
                    RSSParser.insertNotNullAndNonZeroLengthValueInStruct(enclosureStruct, "type", rssEnclosure.getType());
                    if (enclosureStruct.isEmpty()) continue;
                    enclosuresArray.add((Object)enclosureStruct);
                }
                if (enclosuresArray.size() > 0) {
                    StructUtils.StructInsert((Map)currentItem, (String)"enclosure", (Object)enclosuresArray, (boolean)false);
                }
            }
            Array categoriesArray = new Array();
            List categories = item.getCategories();
            if (categories != null && categories.size() > 0) {
                Iterator it2 = categories.iterator();
                while (it2.hasNext()) {
                    Struct categoryStruct = new Struct();
                    Category rssCategory = (Category)it2.next();
                    RSSParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "domain", rssCategory.getDomain());
                    RSSParser.insertNotNullAndNonZeroLengthValueInStruct(categoryStruct, "value", rssCategory.getValue());
                    if (categoryStruct.isEmpty()) continue;
                    categoriesArray.add((Object)categoryStruct);
                }
                if (categoriesArray.size() > 0) {
                    StructUtils.StructInsert((Map)currentItem, (String)"category", (Object)categoriesArray, (boolean)false);
                }
            }
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(currentItem, "comments", item.getComments());
            RSSParser.insertNotNullAndNonZeroLengthValueInStruct(currentItem, "author", item.getAuthor());
            if (item.getPubDate() != null) {
                StructUtils.StructInsert((Map)currentItem, (String)"pubDate", (Object)DateParser.formatRFC822((Date)item.getPubDate()), (boolean)false);
            }
            if (item.getExpirationDate() != null) {
                StructUtils.StructInsert((Map)currentItem, (String)"expirationDate", (Object)DateParser.formatRFC822((Date)item.getExpirationDate()), (boolean)false);
            }
            if ((dcMod = (DCModule)item.getModule("http://purl.org/dc/elements/1.1/")) != null) {
                RSSParser.getDCElementsAsStruct(dcMod, currentItem);
            }
            RSSParser.getItunesItemsAsArray(currentItem, item);
            rssItemsArray.add((Object)currentItem);
        }
        return rssItemsArray;
    }

    public static QueryTable getItemsAsQuery(Channel rssFeed) {
        Module module;
        int separator_length = ",".length();
        String feedType = rssFeed.getFeedType().toLowerCase();
        int start = feedType.indexOf(95) + 1;
        int end = feedType.indexOf(117);
        if (end == -1) {
            end = feedType.length();
        }
        double rssVersion = Double.parseDouble(feedType.substring(start, end));
        List feedItems = rssFeed.getItems();
        Iterator itemIterator = feedItems.iterator();
        boolean isDCExtension = false;
        boolean isItunesExtension = false;
        while (itemIterator.hasNext()) {
            Item item = (Item)itemIterator.next();
            module = item.getModule("http://www.itunes.com/dtds/podcast-1.0.dtd");
            if (module == null) continue;
            isItunesExtension = true;
            break;
        }
        for (Item item : feedItems) {
            module = item.getModule("http://purl.org/dc/elements/1.1/");
            if (module == null) continue;
            isDCExtension = true;
            break;
        }
        QueryTable rssItemsTable = isDCExtension && isItunesExtension ? new QueryTable(0, FeedTable.columnNamesWithDCAndItunesElements, FeedTable.columnTypesWithDCAndItunesElements) : (isDCExtension ? new QueryTable(0, FeedTable.columnNamesWithDCElements, FeedTable.columnTypesWithDCElements) : (isItunesExtension ? new QueryTable(0, FeedTable.iTunesColumnNames, FeedTable.itunesColumnTypes) : new QueryTable(0, FeedTable.columnNames, FeedTable.columnTypes)));
        for (Item item : feedItems) {
            Module itunesMod;
            QueryFunction.QueryAddRow((Object)rssItemsTable);
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"TITLE", (Object)item.getTitle());
            Description desc = item.getDescription();
            if (desc != null) {
                if (rssVersion >= 0.94) {
                    QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"CONTENTTYPE", (Object)RSSParser.checkNotNullAndZeroLengthGetNull(desc.getType()));
                }
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"CONTENT", (Object)RSSParser.checkNotNullAndZeroLengthGetNull(desc.getValue()));
            }
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"RSSLINK", (Object)item.getLink());
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"URI", (Object)item.getUri());
            Source source = item.getSource();
            if (source != null) {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"SOURCE", (Object)RSSParser.checkNotNullAndZeroLengthGetNull(source.getValue()));
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"SOURCEURL", (Object)RSSParser.checkNotNullAndZeroLengthGetNull(source.getUrl()));
            } else {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"SOURCE", null);
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"SOURCEURL", null);
            }
            Guid guid = item.getGuid();
            if (guid != null) {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ID", (Object)guid.getValue());
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"IDPERMALINK", (Object)Boolean.toString(guid.isPermaLink()));
            } else {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ID", null);
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"IDPERMALINK", null);
            }
            List enclosures = item.getEnclosures();
            if (enclosures != null && enclosures.size() > 0) {
                Iterator it1 = enclosures.iterator();
                StringBuffer url = new StringBuffer();
                StringBuffer length = new StringBuffer();
                StringBuffer type = new StringBuffer();
                while (it1.hasNext()) {
                    Enclosure rssEnclosure = (Enclosure)it1.next();
                    url.append(RSSParser.checkNotNullAndZeroLengthGetBlank(rssEnclosure.getUrl()));
                    url.append(",");
                    if (rssEnclosure.getLength() == null) {
                        length.append(" ");
                    } else {
                        length.append(rssEnclosure.getLength());
                    }
                    length.append(",");
                    type.append(RSSParser.checkNotNullAndZeroLengthGetBlank(rssEnclosure.getType()));
                    type.append(",");
                }
                url.deleteCharAt(url.length() - separator_length);
                length.deleteCharAt(length.length() - separator_length);
                type.deleteCharAt(type.length() - separator_length);
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"LINKHREF", (Object)RSSParser.checkZeroLengthGetNull(url));
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"LINKLENGTH", (Object)RSSParser.checkZeroLengthGetNull(length));
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"LINKTYPE", (Object)RSSParser.checkZeroLengthGetNull(type));
            } else {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"LINKHREF", null);
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"LINKLENGTH", null);
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"LINKTYPE", null);
            }
            List categories = item.getCategories();
            if (categories != null && categories.size() > 0) {
                Iterator it2 = categories.iterator();
                StringBuffer value = new StringBuffer();
                StringBuffer domain = new StringBuffer();
                while (it2.hasNext()) {
                    Category rssCategory = (Category)it2.next();
                    domain.append(RSSParser.checkNotNullAndZeroLengthGetBlank(rssCategory.getDomain()));
                    domain.append(",");
                    value.append(RSSParser.checkNotNullAndZeroLengthGetBlank(rssCategory.getValue()));
                    value.append(",");
                }
                value.deleteCharAt(value.length() - separator_length);
                domain.deleteCharAt(domain.length() - separator_length);
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"CATEGORYLABEL", (Object)RSSParser.checkZeroLengthGetNull(value));
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"CATEGORYSCHEME", (Object)RSSParser.checkZeroLengthGetNull(domain));
            } else {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"CATEGORYLABEL", null);
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"CATEGORYSCHEME", null);
            }
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"COMMENTS", (Object)item.getComments());
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"AUTHOREMAIL", (Object)item.getAuthor());
            if (item.getPubDate() != null) {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"PUBLISHEDDATE", (Object)DateParser.formatRFC822((Date)item.getPubDate()));
            } else {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"PUBLISHEDDATE", null);
            }
            if (item.getExpirationDate() != null) {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"EXPIRATIONDATE", (Object)DateParser.formatRFC822((Date)item.getExpirationDate()));
            } else {
                QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"EXPIRATIONDATE", null);
            }
            DCModule dcMod = (DCModule)item.getModule("http://purl.org/dc/elements/1.1/");
            if (dcMod != null) {
                RSSParser.addDCElementsInQuery(dcMod, rssItemsTable);
            }
            if ((itunesMod = item.getModule("http://www.itunes.com/dtds/podcast-1.0.dtd")) == null) continue;
            RSSParser.addItunesElementsInQuery(itunesMod, rssItemsTable);
        }
        return rssItemsTable;
    }

    private static void addItunesElementsInQuery(Module itunesMod, QueryTable rssItemsTable) {
        EntryInformation entryInfo = (EntryInformation)itunesMod;
        QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_AUTHOR", (Object)entryInfo.getAuthor());
        if (entryInfo.getBlock()) {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_BLOCK", (Object)"yes");
        } else {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_BLOCK", (Object)"no");
        }
        if (entryInfo.getExplicit()) {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_EXPLICIT", (Object)"yes");
        } else {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_EXPLICIT", (Object)"no");
        }
        if (entryInfo.getDuration() != null) {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_DURATION", (Object)entryInfo.getDuration().toString());
        }
        String[] keywords = entryInfo.getKeywords();
        StringBuffer keywordsBuffer = null;
        if (keywords != null) {
            keywordsBuffer = new StringBuffer("");
            for (int i = 0; i < keywords.length; ++i) {
                keywordsBuffer.append(keywords[i]).append(",");
            }
            if (keywordsBuffer.toString().endsWith(",")) {
                keywordsBuffer.deleteCharAt(keywordsBuffer.length() - 1);
            }
        }
        if (keywordsBuffer != null) {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_KEYWORDS", (Object)keywordsBuffer.toString());
        }
        QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_SUBTITLE", (Object)entryInfo.getSubtitle());
        QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"ITUNES_SUMMARY", (Object)entryInfo.getSummary());
    }

    private static void addDCElementsInQuery(DCModule dcMod, QueryTable rssItemsTable) {
        RSSParser.insertInQuery(dcMod.getCreators(), rssItemsTable, "DC_CREATOR");
        RSSParser.insertInQuery(dcMod.getContributors(), rssItemsTable, "DC_CONTRIBUTOR");
        RSSParser.insertInQuery(dcMod.getCoverages(), rssItemsTable, "DC_COVERAGE");
        RSSParser.insertInQuery(dcMod.getDescriptions(), rssItemsTable, "DC_DESCRIPTION");
        RSSParser.insertInQuery(dcMod.getFormats(), rssItemsTable, "DC_FORMAT");
        RSSParser.insertInQuery(dcMod.getIdentifiers(), rssItemsTable, "DC_IDENTIFIER");
        RSSParser.insertInQuery(dcMod.getLanguages(), rssItemsTable, "DC_LANGUAGE");
        RSSParser.insertInQuery(dcMod.getPublishers(), rssItemsTable, "DC_PUBLISHER");
        RSSParser.insertInQuery(dcMod.getRelations(), rssItemsTable, "DC_RELATION");
        RSSParser.insertInQuery(dcMod.getRightsList(), rssItemsTable, "DC_RIGHT");
        RSSParser.insertInQuery(dcMod.getSources(), rssItemsTable, "DC_SOURCE");
        RSSParser.insertInQuery(dcMod.getTitles(), rssItemsTable, "DC_TITLE");
        RSSParser.insertInQuery(dcMod.getTypes(), rssItemsTable, "DC_TYPE");
        List dates = dcMod.getDates();
        if (dates != null && dates.size() > 0) {
            StringBuffer dateBuf = new StringBuffer();
            for (Date value : dates) {
                if (value == null) continue;
                dateBuf.append(DateParser.formatRFC822((Date)value));
                dateBuf.append(",");
            }
            if (dateBuf.length() - separator_length > -1) {
                dateBuf.deleteCharAt(dateBuf.length() - separator_length);
            }
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"DC_DATE", (Object)RSSParser.checkZeroLengthGetNull(dateBuf));
        } else {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"DC_DATE", null);
        }
        List subjects = dcMod.getSubjects();
        if (subjects != null && subjects.size() > 0) {
            StringBuffer subUriBuf = new StringBuffer();
            StringBuffer subValueBuf = new StringBuffer();
            for (DCSubject content : subjects) {
                if (content.getTaxonomyUri() != null && content.getTaxonomyUri().length() > 0) {
                    subUriBuf.append(content.getTaxonomyUri());
                    subUriBuf.append(",");
                }
                if (content.getValue() == null || content.getValue().length() <= 0) continue;
                subValueBuf.append(content.getValue());
                subValueBuf.append(",");
            }
            if (subUriBuf.length() - separator_length > -1) {
                subUriBuf.deleteCharAt(subUriBuf.length() - separator_length);
            }
            if (subValueBuf.length() - separator_length > -1) {
                subValueBuf.deleteCharAt(subValueBuf.length() - separator_length);
            }
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"DC_SUBJECT_TAXONOMYURI", (Object)RSSParser.checkZeroLengthGetNull(subUriBuf));
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"DC_SUBJECT_VALUE", (Object)RSSParser.checkZeroLengthGetNull(subValueBuf));
        } else {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"DC_SUBJECT_TAXONOMYURI", null);
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)"DC_SUBJECT_VALUE", null);
        }
    }

    private static void insertInQuery(List inList, QueryTable rssItemsTable, String key) {
        if (inList != null && inList.size() > 0) {
            StringBuffer inBuf = new StringBuffer();
            for (String value : inList) {
                if (value == null || value.length() <= 0) continue;
                inBuf.append(value);
                inBuf.append(",");
            }
            if (inBuf.length() - separator_length > -1) {
                inBuf.deleteCharAt(inBuf.length() - separator_length);
            }
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)key, (Object)RSSParser.checkZeroLengthGetNull(inBuf));
        } else {
            QueryFunction.QuerySetCell((Object)rssItemsTable, (String)key, null);
        }
    }

    public static void saveEnclosures(Channel channel, String enclosureDir, boolean overwrite, boolean ignoreEnclosureError, String userAgent) {
        List items = channel.getItems();
        for (Item item : items) {
            List enclosures = item.getEnclosures();
            if (enclosures == null || enclosures.size() <= 0) continue;
            for (Enclosure rssEnclosure : enclosures) {
                String url = rssEnclosure.getUrl().replace("\\", "/");
                int idx = url.lastIndexOf(47);
                if (idx == -1) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.UnableToDetermineEnclosureFileNameException(url)));
                        continue;
                    }
                    throw new FeedReader.UnableToDetermineEnclosureFileNameException(url);
                }
                String file = url.substring(idx + 1);
                try {
                    if (url.contains("..")) {
                        throw new MalformedURLException();
                    }
                    URL enclosureURL = new URL(url);
                    Long length = rssEnclosure.getLength();
                    if (length == null) {
                        FeedReader.getUrlContents(enclosureURL, enclosureDir, -1L, file, overwrite, ignoreEnclosureError, userAgent);
                        continue;
                    }
                    FeedReader.getUrlContents(enclosureURL, enclosureDir, length, file, overwrite, ignoreEnclosureError, userAgent);
                }
                catch (MalformedURLException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.InvalidURLEnclosureException(url)));
                        continue;
                    }
                    throw new FeedReader.InvalidURLEnclosureException(url);
                }
                catch (FileNotFoundException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.EnclosureFileNotFoundException(url)));
                        continue;
                    }
                    throw new FeedReader.EnclosureFileNotFoundException(url);
                }
                catch (IOException e) {
                    if (ignoreEnclosureError) {
                        CFLogs.APPLICATION_LOG.warn((Throwable)((Object)new FeedReader.UnableToSaveEnclosureException(url, e.getMessage())));
                        continue;
                    }
                    throw new FeedReader.UnableToSaveEnclosureException(url, e.getMessage());
                }
            }
        }
    }

    private static String checkNotNullAndZeroLengthGetBlank(String value) {
        if (value != null && value.length() != 0) {
            return value;
        }
        return " ";
    }

    private static String checkNotNullAndZeroLengthGetNull(String value) {
        if (value != null && value.length() != 0) {
            return value;
        }
        return null;
    }

    private static String checkZeroLengthGetNull(StringBuffer st) {
        if (st != null && st.length() != 0) {
            return st.toString();
        }
        return null;
    }

    private static void insertNotNullAndNonZeroLengthValueInStruct(Struct struct, String key, String value) {
        if (key != null && value != null && value.length() > 0) {
            StructUtils.StructInsert((Map)struct, (String)key, (Object)value, (boolean)false);
        }
    }
}

