/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.monitor.jetty.server;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.CFLogs;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.jetty.server.MonitoringServer;
import coldfusion.server.FlexAssemblerService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitoringServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static HttpServlet brokerServletInstance = null;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestURI;
        ServletContext context;
        boolean attrPresent;
        if (!FeatureRouter.getInstance().isFeatureAllowed(EFRConstants.server_monitoring_and_api.intValue())) {
            String errorMsg = RB.getString((Object)((Object)this), (String)"editionErrorMsg");
            CFLogs.MONITOR_LOG.error((Object)errorMsg);
            this.handleHtmlResp(response, errorMsg);
            return;
        }
        if (!Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled()) {
            CFLogs.MONITOR_LOG.info((Object)RB.getString((Object)((Object)this), (String)"notallowed"));
            return;
        }
        if (brokerServletInstance == null) {
            CFLogs.MONITOR_LOG.info((Object)(RB.getString((Object)((Object)this), (String)"firstReqMsg") + " " + MonitoringServer.getInstance().getPort()));
            FlexAssemblerService flexAssemblerService = ServiceFactory.getFlexAssemblerService();
            if (flexAssemblerService != null) {
                brokerServletInstance = flexAssemblerService.getColdFusionMessageBrokerServletInstance();
            }
        }
        if (!(attrPresent = (context = request.getSession().getServletContext()).getAttributeNames().hasMoreElements())) {
            this.setupContext(context);
        }
        if ((requestURI = request.getRequestURI()) != null && (requestURI.startsWith("/CFIDE/administrator/monitor") || requestURI.startsWith("/CFIDE/administrator/help") || requestURI.startsWith("/crossdomain.xml"))) {
            String servername = request.getServerName();
            this.handleCFIDERequests(response, requestURI, request.getQueryString(), servername);
        } else if (requestURI != null && requestURI.startsWith("/flex2gateway")) {
            this.handleFlashRemotingReq(request, response);
        } else {
            response.setStatus(400);
        }
    }

    private void handleCFIDERequests(HttpServletResponse response, String requestURI, String query, String servername) {
        String filePath;
        String fileName = requestURI;
        if (fileName == null) {
            response.setStatus(400);
            return;
        }
        String fileLowerName = fileName.toLowerCase();
        if (fileLowerName.endsWith("localisedvariables.cfm")) {
            fileName = this.setLocalizationFileName(false, response);
        } else if (fileLowerName.endsWith("localisedvariables-multiserver.cfm")) {
            fileName = this.setLocalizationFileName(true, response);
        } else {
            if (fileName.startsWith("/crossdomain.xml")) {
                this.handleCrossDomainReq(response);
                return;
            }
            if (fileName.startsWith("/CFIDE/administrator/monitor/launch-monitor")) {
                fileName = "/CFIDE/administrator/monitor/launch-monitor.html";
            } else if (fileName.startsWith("/CFIDE/administrator/monitor/launch-multiservermonitor")) {
                fileName = "/CFIDE/administrator/monitor/launch-multiservermonitor.html";
            } else {
                if (fileName.startsWith("/CFIDE/administrator/help") || fileName.equalsIgnoreCase("/CFIDE/administrator/monitor/display_snapshot.cfm")) {
                    this.handleRedirectReq(response, requestURI, query, servername);
                    return;
                }
                if (!(fileLowerName.endsWith("js") || fileLowerName.endsWith("htm") || fileLowerName.endsWith("html") || fileLowerName.endsWith("crossdomain.xml") || fileLowerName.endsWith("swf"))) {
                    response.setStatus(400);
                    return;
                }
            }
        }
        FlexAssemblerService flexAssemblerService = ServiceFactory.getFlexAssemblerService();
        ServletContext tempcontext = null;
        if (flexAssemblerService != null) {
            tempcontext = flexAssemblerService.getColdFusionMessageBrokerServletInstance().getServletContext();
        }
        if (!((filePath = ServiceFactory.getRuntimeService().getRealPath(tempcontext, fileName)).endsWith("js") || filePath.endsWith("htm") || filePath.endsWith("html") || filePath.endsWith("crossdomain.xml") || filePath.endsWith("swf") || filePath.endsWith("xml"))) {
            response.setStatus(400);
            return;
        }
        String mimeType = tempcontext.getMimeType(filePath);
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        this.sendResponse(response, filePath);
    }

    private void handleRedirectReq(HttpServletResponse response, String requestURI, String query, String servername) {
        String serverurl = "";
        if (serverurl.length() > 0) {
            serverurl = this.checkServerName(servername, serverurl);
            query = query == null ? "" : "?" + query;
            String reqURL = serverurl + requestURI + query;
            try {
                response.sendRedirect(reqURL);
            }
            catch (IOException e) {
                this.handleError(response, e);
            }
        } else {
            this.handleHtmlResp(response, RB.getString((Object)((Object)this), (String)"cannotserveMsg"));
        }
    }

    private String checkServerName(String servername, String serverurl) {
        int beginIndex = serverurl.indexOf("//");
        int endIndex = serverurl.lastIndexOf(":");
        if (beginIndex != -1 && endIndex != -1) {
            String host = serverurl.substring(beginIndex + 2, endIndex);
            if (servername != null && host != null && !host.equalsIgnoreCase(servername)) {
                serverurl = serverurl.replace(host, servername);
            }
        }
        return serverurl;
    }

    private void handleCrossDomainReq(HttpServletResponse response) {
        String webroot = ServiceFactory.getRuntimeService().getWebRoot();
        if (!webroot.endsWith(File.separator)) {
            webroot = webroot + File.separator;
        }
        String fileName = webroot + "crossdomain.xml";
        response.setContentType("text/xml");
        this.sendResponse(response, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpServletResponse response, String filePath) {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            File file = new File(filePath);
            response.setContentLength((int)file.length());
            in = new FileInputStream(file);
            out = response.getOutputStream();
            byte[] buf = new byte[1024];
            int count = 0;
            while ((count = in.read(buf)) >= 0) {
                out.write(buf, 0, count);
            }
        }
        catch (FileNotFoundException e) {
            this.handleError(response, e);
        }
        catch (IOException e) {
            this.handleError(response, e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void handleError(HttpServletResponse response, Exception e) {
        try {
            CFLogs.MONITOR_LOG.error((Throwable)e);
            response.getWriter().println(e.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleFlashRemotingReq(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (brokerServletInstance != null) {
            brokerServletInstance.service((ServletRequest)request, (ServletResponse)response);
        } else {
            this.handleHtmlResp(response, RB.getString((Object)((Object)this), (String)"relaunchMsg"));
        }
    }

    private void handleHtmlResp(HttpServletResponse response, String msg) {
        String resp = "<html><body><br/><br/> <b>" + msg + RB.getString((Object)((Object)this), (String)"copyrightMsg") + "</b></body></html>";
        response.setContentType("text/html");
        response.setContentLength(resp.length());
        try {
            response.getWriter().print(resp);
        }
        catch (IOException e) {
            CFLogs.MONITOR_LOG.error((Throwable)e);
        }
    }

    private String setLocalizationFileName(boolean isMultiServer, HttpServletResponse response) {
        String locale = response.getLocale().getDisplayLanguage();
        String fileName = locale.equalsIgnoreCase("english") ? (isMultiServer ? "/CFIDE/administrator/monitor/multiserver_resource_en.xml" : "/CFIDE/administrator/monitor/smresource_en.xml") : (isMultiServer ? "/CFIDE/administrator/monitor/multiserver_resource_jp.xml" : "/CFIDE/administrator/monitor/smresource_jp.xml");
        response.setContentType("text/xml");
        return fileName;
    }

    private void setupContext(ServletContext context) {
        FlexAssemblerService flexAssemblerService = ServiceFactory.getFlexAssemblerService();
        if (flexAssemblerService != null) {
            Map contextAttrs = flexAssemblerService.getContextAttributes();
            Set attrNames = contextAttrs.keySet();
            for (String attrName : attrNames) {
                context.setAttribute(attrName, contextAttrs.get(attrName));
            }
        }
    }
}

