/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm.hibernate;

import coldfusion.orm.hibernate.CFCTuplizer;
import coldfusion.orm.hibernate.ComponentTuplizer;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MappingTransformer {
    private static final String cfcStartIdentifier = "cfc.";
    private Document doc;
    private Map<String, String> cfcNameVsEntityName;
    private String pakkage;
    private Element root;

    public MappingTransformer(Document doc, Map<String, String> cfcNameVsEntityName) {
        this.doc = doc;
        this.cfcNameVsEntityName = cfcNameVsEntityName;
        this.root = doc.getDocumentElement();
    }

    public Document getDocument() {
        return this.doc;
    }

    public void transform() {
        String pakkage = this.root.getAttribute("package");
        if (pakkage.trim().length() > 0) {
            this.pakkage = pakkage.trim();
        }
        this.transformAllClassNodes();
        this.transformComponentNodes();
        this.transformAllRelationNodes();
    }

    private void transformAllClassNodes() {
        this.transformClassNodes("class");
        this.transformClassNodes("subclass");
        this.transformClassNodes("joined-subclass");
        this.transformClassNodes("union-subclass");
    }

    private void transformClassNodes(String classNodeName) {
        NodeList nodes = this.root.getElementsByTagName(classNodeName);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            this.transformClassNode((Element)nodes.item(i), classNodeName);
        }
    }

    private void transformClassNode(Element classNode, String classNodeName) {
        String className = classNode.getAttribute("name");
        if (!className.startsWith(cfcStartIdentifier)) {
            return;
        }
        this.setEntityName(classNode, "name");
        this.addTuplizerNode(classNode, classNodeName);
        if (classNodeName.equals("subclass") || classNodeName.equals("joined-subclass") || classNodeName.equals("union-subclass")) {
            this.transformExends(classNode);
        }
    }

    private void transformExends(Element classNode) {
        String extendedClass = classNode.getAttribute("extends");
        if (!extendedClass.startsWith(cfcStartIdentifier)) {
            return;
        }
        String extendedCfcName = this.getCFCNameForClassName(extendedClass);
        String extendedEntityName = this.cfcNameVsEntityName.get(extendedCfcName);
        classNode.setAttribute("extends", extendedEntityName);
    }

    private void setEntityName(Element node, String classAtrribName) {
        String className = node.getAttribute(classAtrribName);
        if (!className.startsWith(cfcStartIdentifier)) {
            return;
        }
        node.removeAttribute(classAtrribName);
        String cfcName = this.getCFCNameForClassName(className);
        String entityName = node.getAttribute("entity-name");
        if (entityName.length() == 0) {
            entityName = this.cfcNameVsEntityName.get(cfcName);
            node.setAttribute("entity-name", entityName);
        }
    }

    private String getCFCNameForClassName(String className) {
        String cfcName = className.substring(4);
        if (this.pakkage != null && cfcName.indexOf(46) < 0) {
            cfcName = this.pakkage + '.' + cfcName;
        }
        return cfcName;
    }

    private void addTuplizerNode(Element classNode, String classTagName) {
        if (classTagName.equals("class")) {
            this.addClassTuplizerNode(classNode);
        } else if (classTagName.equals("subclass")) {
            this.addSubclassTuplizerNode(classNode);
        } else if (classTagName.equals("joined-subclass")) {
            this.addJoinedSubclassTuplizerNode(classNode);
        } else if (classTagName.equals("union-subclass")) {
            this.addUnionSubclassTuplzierNode(classNode);
        }
    }

    private void addClassTuplizerNode(Element classNode) {
        NodeList idList = classNode.getElementsByTagName("id");
        if (idList.getLength() == 0) {
            idList = classNode.getElementsByTagName("composite-id");
        }
        if (idList.getLength() > 0) {
            if (classNode.getFirstChild().getNodeName().equals("cache")) {
                Element tuplizer = this.createTuplizerNode();
                Node cacheNode = classNode.getFirstChild();
                classNode.insertBefore(tuplizer, cacheNode);
            } else {
                Node idNode = idList.item(0);
                Element tuplizer = this.createTuplizerNode();
                classNode.insertBefore(tuplizer, idNode);
            }
        }
    }

    private void addSubclassTuplizerNode(Element subclassNode) {
        NodeList childNodes = subclassNode.getChildNodes();
        int length = childNodes.getLength();
        Element tuplizer = this.createTuplizerNode();
        if (length == 0) {
            subclassNode.appendChild(tuplizer);
        } else {
            Node subclassChild = childNodes.item(0);
            Node elmtToInsertBefore = null;
            if (subclassChild.getNodeName().equals("meta")) {
                if (length == 1) {
                    subclassNode.appendChild(tuplizer);
                } else {
                    elmtToInsertBefore = childNodes.item(1);
                }
            } else {
                elmtToInsertBefore = subclassChild;
            }
            if (elmtToInsertBefore != null) {
                subclassNode.insertBefore(tuplizer, elmtToInsertBefore);
            }
        }
    }

    private void addJoinedSubclassTuplizerNode(Element joinedSubclassNode) {
        Node keyNode = joinedSubclassNode.getElementsByTagName("key").item(0);
        joinedSubclassNode.insertBefore(this.createTuplizerNode(), keyNode);
    }

    private void addUnionSubclassTuplzierNode(Element unionSubclassNode) {
        NodeList childNodes = unionSubclassNode.getChildNodes();
        int length = childNodes.getLength();
        Element tuplizer = this.createTuplizerNode();
        Node elmtToInsertBefore = null;
        for (int i = 0; i < length; ++i) {
            Node subclassChild = childNodes.item(i);
            String name = subclassChild.getNodeName();
            if (name.equals("meta") || name.equals("subselect") || name.equals("synchronize") || name.equals("comment")) continue;
            elmtToInsertBefore = subclassChild;
            break;
        }
        if (elmtToInsertBefore == null) {
            unionSubclassNode.appendChild(tuplizer);
        } else {
            unionSubclassNode.insertBefore(tuplizer, elmtToInsertBefore);
        }
    }

    private void addComponentTuplizerNode(Element classNode) {
        NodeList childNodes = classNode.getChildNodes();
        int length = childNodes.getLength();
        Element tuplizer = this.createTuplizerNode(ComponentTuplizer.class.getName(), "pojo");
        if (length == 0) {
            classNode.appendChild(tuplizer);
        } else {
            Node subclassChild = childNodes.item(0);
            Node elmtToInsertBefore = null;
            if (subclassChild.getNodeName().equals("meta")) {
                if (length == 1) {
                    classNode.appendChild(tuplizer);
                } else {
                    elmtToInsertBefore = childNodes.item(1);
                }
            } else {
                elmtToInsertBefore = subclassChild;
            }
            if (elmtToInsertBefore != null) {
                classNode.insertBefore(tuplizer, elmtToInsertBefore);
            }
        }
    }

    private Element createTuplizerNode() {
        return this.createTuplizerNode(CFCTuplizer.class.getName(), "dynamic-map");
    }

    private Element createTuplizerNode(String className, String entitymode) {
        Element tuplizer = this.doc.createElement("tuplizer");
        tuplizer.setAttribute("entity-mode", entitymode);
        tuplizer.setAttribute("class", className);
        return tuplizer;
    }

    private void transformComponentNodes() {
        this.transformComponentNodes("component");
        this.transformComponentNodes("composite-element");
        this.transformComponentNodes("nested-composite-element");
    }

    private void transformComponentNodes(String componentNodeName) {
        NodeList nodes = this.root.getElementsByTagName(componentNodeName);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Element componentNode = (Element)nodes.item(i);
            String className = componentNode.getAttribute("class");
            if (!className.startsWith(cfcStartIdentifier)) {
                return;
            }
            String cfcName = this.getCFCNameForClassName(className);
            componentNode.setAttribute("class", cfcName);
            this.addComponentTuplizerNode(componentNode);
        }
    }

    private void transformAllRelationNodes() {
        this.transformAllRelationNodes("one-to-one");
        this.transformAllRelationNodes("one-to-many");
        this.transformAllRelationNodes("many-to-one");
        this.transformAllRelationNodes("many-to-many");
        this.transformAllRelationNodes("key-many-to-one");
        this.transformAllRelationNodes("map-key-many-to-many");
        this.transformAllRelationNodes("index-many-to-many");
    }

    private void transformAllRelationNodes(String relationTagName) {
        NodeList nodes = this.root.getElementsByTagName(relationTagName);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            this.setEntityName((Element)nodes.item(i), "class");
        }
    }
}

