/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm;

import coldfusion.orm.CFCMetadata;
import coldfusion.orm.ORMConfiguration;
import coldfusion.orm.ORMProvider;
import coldfusion.orm.ORMUtils;
import coldfusion.orm.PersistentTemplateProxy;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.imq.rttExpr;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class EntityQueryTable
extends QueryTable {
    public EntityQueryTable(Object obj) {
        this(obj, null);
    }

    public EntityQueryTable(Object obj, String entityName) {
        if (obj instanceof List) {
            List objList = (List)obj;
            int size = objList.size();
            if (size > 0) {
                Object entityObj = objList.get(0);
                this.meta = this.buildQueryMetaData(entityObj, entityName);
                if (this.meta == null) {
                    throw new InvalidEntityException();
                }
                this.col_names = this.meta.getColumnLabels();
                this.col_count = this.col_names.length;
                for (Object entity : objList) {
                    this.addRow(this.getRowdata(this.col_names, entity));
                }
            }
        } else {
            this.meta = this.buildQueryMetaData(obj, entityName);
            if (this.meta == null) {
                throw new InvalidEntityException();
            }
            this.col_names = this.meta.getColumnLabels();
            this.col_count = this.col_names.length;
            this.addRow(this.getRowdata(this.col_names, obj));
        }
    }

    private Object[] getRowdata(String[] properties, Object entity) {
        int size = properties.length;
        Object[] rowdata = new Object[size];
        for (int j = 0; j < size; ++j) {
            String property = properties[j];
            Object value = this.getValue(entity, property);
            if (value instanceof TemplateProxy) {
                value = value.toString();
            }
            rowdata[j] = value == null ? "" : value;
        }
        return rowdata;
    }

    private Object getValue(Object entity, String propertyName) {
        if (entity instanceof PersistentTemplateProxy) {
            return ((PersistentTemplateProxy)((Object)entity)).getProperty(propertyName);
        }
        throw new InvalidEntityException();
    }

    private QueryTableMetaData buildQueryMetaData(Object entity, String entityName) {
        CFCMetadata cfcMetadata;
        String cfcName;
        ORMConfiguration config = ORMProvider.getDefault().getCurrentConfiguration();
        String string = cfcName = entityName == null || entityName.length() == 0 ? ORMUtils.getCFCName(entity) : config.getCFCName(entityName);
        if (cfcName != null && (cfcMetadata = config.getCFCMetadata(cfcName)) != null) {
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.addAll(cfcMetadata.getColumnPropertyNames());
            propertyNames.addAll(cfcMetadata.getPKFieldNames());
            int count = propertyNames.size();
            String[] col_names = new String[count];
            int[] col_types = new int[count];
            String[] type_names = new String[count];
            for (int i = 0; i < count; ++i) {
                String propertyName = (String)propertyNames.get(i);
                Class type = cfcMetadata.getPropertyType(propertyName);
                int sqlType = this.getSQLType(type);
                col_names[i] = propertyName;
                col_types[i] = sqlType;
                type_names[i] = rttExpr.getSqlTypeName((int)sqlType);
            }
            return new QueryTableMetaData(col_names, type_names, col_types);
        }
        return null;
    }

    private int getSQLType(Class clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return 12;
        }
        if (Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (Long.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
            return -5;
        }
        if (Float.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz)) {
            return 7;
        }
        if (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 3;
        }
        if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            return -2;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return 92;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return 93;
        }
        if (java.util.Date.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz)) {
            return 91;
        }
        return 2000;
    }

    public static class InvalidEntityException
    extends ApplicationException {
    }
}

