/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.fms;

import coldfusion.eventgateway.fms.CF2FMSTranslator;
import coldfusion.eventgateway.fms.FMS2CFTranslator;
import coldfusion.eventgateway.fms.SOEventHandler;
import coldfusion.eventgateway.fms.SOEventListener;
import coldfusion.runtime.ApplicationException;
import com.macromedia.fcs.client.NetConnection;
import com.macromedia.fcs.client.SharedObject;
import com.macromedia.fcs.util.Util;

public class FMSManager {
    NetConnection nc;
    SharedObject so;
    SOEventHandler soHandler = null;
    String serverUrl;
    String sharedObjName;

    public FMSManager(String serverUrl, String sharedObjName) {
        this.serverUrl = serverUrl;
        this.sharedObjName = sharedObjName;
    }

    public void connetToFCS() throws Exception {
        this.nc = new NetConnection();
        this.nc.connect(this.serverUrl);
        this.so = SharedObject.getRemote((String)this.sharedObjName, (Util.URI)this.nc.getURI(), (SharedObject.Storage)SharedObject.ON_SERVER_ONLY);
        Thread.sleep(3000L);
        if (!this.nc.isConnected()) {
            throw new FMSGatewayConnectionException(this.serverUrl);
        }
        this.soHandler = new SOEventHandler(this.so);
        this.so.registerSink((Object)this.soHandler);
        this.so.connect(this.nc);
    }

    public void setSharedObjValue(String name, Object value) {
        Object translatedValue = CF2FMSTranslator.translate(value);
        this.so.setProperty(name, translatedValue);
    }

    public Object getSharedObjValue(String name) {
        Object value = this.so.getProperty(name);
        return FMS2CFTranslator.translate(value);
    }

    public void closeConnectionToFCS() throws Exception {
        this.so.close();
        this.nc.close();
        this.nc = null;
        this.so = null;
        this.soHandler = null;
    }

    public void addSOEventListener(SOEventListener listener) {
        if (this.soHandler == null) {
            return;
        }
        this.soHandler.addSOListener(listener);
    }

    public void removeSOEventListener(SOEventListener listener) {
        if (this.soHandler == null) {
            return;
        }
        if (this.so != null) {
            this.so.unregisterSink((Object)this.soHandler);
        }
        this.soHandler.removeSOListener(listener);
    }

    public class FMSGatewayConnectionException
    extends ApplicationException {
        public String rtmpurl = null;

        public FMSGatewayConnectionException(String rtmpurl) {
            this.rtmpurl = rtmpurl;
        }
    }
}

