/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.fms;

import coldfusion.runtime.Array;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class FMS2CFTranslator {
    public static Object translate(Object fmsObject) {
        if (fmsObject instanceof Map) {
            return FMS2CFTranslator.translate((Map)fmsObject);
        }
        if (fmsObject instanceof Date) {
            return FMS2CFTranslator.translate((Date)fmsObject);
        }
        return fmsObject;
    }

    private static Object translate(Map map) {
        Array translatedObj = null;
        if (map == null || map.size() == 0) {
            return translatedObj;
        }
        if (FMS2CFTranslator.isConvertibleToArray(map)) {
            translatedObj = new Array();
            TreeMap tmap = new TreeMap(new Comparator(){

                public int compare(Object o1, Object o2) {
                    int i2;
                    int i1 = Integer.parseInt(String.valueOf(o1));
                    return i1 < (i2 = Integer.parseInt(String.valueOf(o2))) ? -1 : (i1 == i2 ? 0 : 1);
                }
            });
            tmap.putAll(map);
            map = tmap;
        } else {
            translatedObj = new Struct();
        }
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (translatedObj instanceof FastArray) {
                Object obj = FMS2CFTranslator.translate(val);
                ((FastArray)translatedObj).add(obj);
                continue;
            }
            ((Struct)translatedObj).put(key, FMS2CFTranslator.translate(val));
        }
        return translatedObj;
    }

    private static OleDateTime translate(Date date) {
        if (date == null) {
            return null;
        }
        return new OleDateTime(date.getTime());
    }

    private static boolean isConvertibleToArray(Map map) {
        Iterator itr = map.keySet().iterator();
        int minValue = 0;
        int maxValue = -1;
        int current = 0;
        while (itr.hasNext()) {
            Object key = itr.next();
            try {
                current = Integer.parseInt(String.valueOf(key));
                if (current > maxValue) {
                    maxValue = current;
                }
                if (current >= minValue) continue;
                minValue = current;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return minValue == 0 && maxValue - minValue == map.size() - 1;
    }
}

