/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import org.jpedal.fonts.PdfFont;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public final class HTMLFontHandler {
    private HTMLFontHandler() {
    }

    public static void processFont(PdfFont restoredFont, DynamicVectorRenderer current, PdfObject newFont, PdfObjectReader currentPdfFile) {
        if (!restoredFont.isFontEmbedded) {
            LogWriter.writeLog("[HTML/SVG] Font " + restoredFont.getFontName() + " is not embedded and will be replaced with a fallback");
        }
        HTMLFontHandler.handleFontInHTML(newFont, current, restoredFont, currentPdfFile);
    }

    private static void handleFontInHTML(PdfObject newFont, DynamicVectorRenderer current, PdfFont restoredFont, PdfObjectReader currentPdfFile) {
        PdfObject Descendent;
        PdfObject pdfFontDescriptor = newFont.getDictionary(-1044665361);
        int cidType = -1;
        if (pdfFontDescriptor == null && (Descendent = newFont.getDictionary(-1547306032)) != null) {
            pdfFontDescriptor = Descendent.getDictionary(-1044665361);
            cidType = Descendent.getParameterConstant(1147962727);
        }
        if (pdfFontDescriptor != null && current.getBooleanValue(45)) {
            byte[] stream;
            PdfObject FontFile22 = pdfFontDescriptor.getDictionary(2021292334);
            if (FontFile22 == null && cidType == -1684566724) {
                FontFile22 = pdfFontDescriptor.getDictionary(746093177);
            }
            if (FontFile22 != null) {
                stream = currentPdfFile.readStream(FontFile22, true, true, false, false, false, FontFile22.getCacheName(currentPdfFile.getObjectReader()));
                current.writeCustom(10, new Object[]{restoredFont, stream, "ttf"});
            } else {
                PdfObject FontFile3 = pdfFontDescriptor.getDictionary(2021292335);
                if (FontFile3 != null) {
                    restoredFont.getGlyphData().setRenderer(current);
                    stream = currentPdfFile.readStream(FontFile3, true, true, false, false, false, FontFile3.getCacheName(currentPdfFile.getObjectReader()));
                    if (stream != null && stream.length > 4 && stream[0] == 79 && stream[1] == 84 && stream[2] == 84 && stream[3] == 79) {
                        current.writeCustom(10, new Object[]{restoredFont, stream, "otf"});
                    } else {
                        current.writeCustom(10, new Object[]{restoredFont, stream, "cff"});
                    }
                } else {
                    PdfObject FontFile = pdfFontDescriptor.getDictionary(746093177);
                    if (FontFile != null) {
                        restoredFont.getGlyphData().setRenderer(current);
                        stream = currentPdfFile.readStream(FontFile, true, true, false, false, false, FontFile.getCacheName(currentPdfFile.getObjectReader()));
                        current.writeCustom(10, new Object[]{restoredFont, stream, "t1"});
                    }
                }
            }
        }
    }
}

