/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.geom.Area;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.BaseDisplay;

abstract class G2Display
extends BaseDisplay {
    G2Display() {
    }

    final void renderText(float y, int type, Area transformedGlyph2, PdfPaint strokePaint, PdfPaint textFillCol, float strokeOpacity, float fillOpacity) {
        Paint currentCol = this.g2.getPaint();
        Composite comp = this.g2.getComposite();
        if ((type & 2) == 2) {
            if (textFillCol != null) {
                if (this.textColor != null && (this.itemToRender == -1 || this.endItem == -1 || this.itemToRender <= this.endItem) && G2Display.checkColorThreshold(textFillCol.getRGB())) {
                    textFillCol = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                textFillCol.setScaling(this.cropH, this.scaling);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, textFillCol, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, textFillCol, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(textFillCol);
            }
            this.renderComposite(fillOpacity);
            this.g2.fill(transformedGlyph2);
            this.g2.setComposite(comp);
        }
        if ((type & 1) == 1) {
            if (strokePaint != null) {
                if (this.textColor != null && (this.itemToRender == -1 || this.endItem == -1 || this.itemToRender <= this.endItem) && G2Display.checkColorThreshold(strokePaint.getRGB())) {
                    strokePaint = new PdfColor(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue());
                }
                strokePaint.setScaling(this.cropH + (double)y, this.scaling);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, strokePaint, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, strokePaint, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(strokePaint);
            }
            this.renderComposite(strokeOpacity);
            float lineWidth = (float)(1.0 / this.g2.getTransform().getScaleX());
            if (lineWidth < 0.0f) {
                lineWidth = -lineWidth;
            }
            this.g2.setStroke(new BasicStroke(lineWidth));
            if (lineWidth < 0.1f) {
                this.g2.draw(transformedGlyph2);
            } else {
                this.g2.fill(transformedGlyph2);
            }
            this.g2.setComposite(comp);
        }
        this.g2.setPaint(currentCol);
    }
}

