/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.spotbugs.SuppressFBWarnings;

public final class ImageCommands {
    public static final int ID = 0;
    public static final int XOBJECT = 2;
    public static boolean trackImages;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_REFACTORED_TO_BE_FINAL"})
    public static boolean rejectSuperimposedImages;

    private ImageCommands() {
    }

    static byte[] getMaskColor(GraphicsState gs) {
        byte[] maskCol = new byte[4];
        int foreground = gs.nonstrokeColorSpace.getColor().getRGB();
        maskCol[0] = (byte)(foreground >> 16 & 0xFF);
        maskCol[1] = (byte)(foreground >> 8 & 0xFF);
        maskCol[2] = (byte)(foreground & 0xFF);
        return maskCol;
    }

    static boolean isRepeatingLine(byte[] lineData, int height) {
        if (lineData.length % height != 0) {
            return false;
        }
        int step = lineData.length / height;
        for (int x = 0; x < lineData.length / height - 1; ++x) {
            for (int targetIndex = step; targetIndex < lineData.length - 1; targetIndex += step) {
                if (lineData[x] == lineData[targetIndex]) continue;
                return false;
            }
        }
        return true;
    }

    static BufferedImage addBackgroundToMask(BufferedImage image, boolean isMask) {
        if (isMask) {
            int cw = image.getWidth();
            int ch = image.getHeight();
            BufferedImage background = new BufferedImage(cw, ch, 1);
            Graphics2D g2 = background.createGraphics();
            g2.setColor(Color.white);
            g2.fillRect(0, 0, cw, ch);
            g2.drawImage((Image)image, 0, 0, null);
            image = background;
        }
        return image;
    }

    static void applyTR(ImageData imageData, Object[] TR2, PdfObjectReader currentPdfFile) {
        try {
            PDFFunction[] functions = ImageCommands.getFunctions(TR2, currentPdfFile);
            if (functions != null) {
                int w = imageData.getWidth();
                int h = imageData.getHeight();
                byte[] data = imageData.getObjectData();
                int compCount = imageData.getCompCount();
                int ptr = 0;
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        for (int a = 0; a < compCount; ++a) {
                            float[] raw = new float[]{(float)(data[ptr] & 0xFF) / 255.0f};
                            if (functions[a] != null) {
                                float[] processed = functions[a].compute(raw);
                                data[ptr] = (byte)(255.0f * processed[0]);
                            }
                            ++ptr;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private static PDFFunction[] getFunctions(Object[] TRvalues, PdfObjectReader currentPdfFile) {
        PDFFunction[] functions = null;
        int total = 0;
        byte[][] kidList = (byte[][])TRvalues[1];
        if (kidList != null) {
            total = kidList.length;
            functions = new PDFFunction[total];
        }
        for (int count = 0; count < total; ++count) {
            if (kidList[count] == null) continue;
            String ref = new String(kidList[count]);
            FunctionObject Function2 = new FunctionObject(ref);
            byte[] possIdent = kidList[count];
            if (possIdent != null && possIdent.length > 4 && possIdent[0] == 47 && possIdent[1] == 73 && possIdent[2] == 100 && possIdent[3] == 101) {
                Function2 = null;
            } else {
                currentPdfFile.readObject(Function2);
            }
            if (Function2 == null) continue;
            functions[count] = FunctionFactory.getFunction(Function2, currentPdfFile);
        }
        return functions;
    }

    public static void applyDecodeArray(byte[] data, int d, float[] decodeArray, int type, boolean isIndexed) {
        int maxValue = 0;
        int maxCompValue = (int)Math.pow(2.0, d) - 1;
        for (float aDecodeArray : decodeArray) {
            if (!((float)maxValue < aDecodeArray)) continue;
            maxValue = (int)aDecodeArray;
        }
        boolean isIdentify = true;
        boolean isInverse = true;
        int compCount = decodeArray.length;
        for (int comp = 0; comp < compCount && isIdentify; comp += 2) {
            isIdentify = decodeArray[comp] == 0.0f && decodeArray[comp + 1] == (float)maxCompValue;
            isInverse = decodeArray[comp + 1] == 0.0f && decodeArray[comp] == (float)maxCompValue;
        }
        if (isIdentify) {
            return;
        }
        if (isInverse) {
            ImageCommands.invertBitsInByteArray(data, d == 8 && type == 1785221209 && !isIndexed);
            return;
        }
        if (d == 1 && decodeArray[0] > decodeArray[1]) {
            ImageCommands.invertBitsInByteArray(data, false);
        } else if (d == 8 && maxValue == 1 && type == 1498837125) {
            ImageCommands.capCMYKDataToDecodeArrayBounds(data, decodeArray);
        } else if (d == 8 && maxValue > 1) {
            ImageCommands.capByteValuesToDecodeArrayBounds(data, decodeArray, type == 1785221209);
        } else {
            ImageCommands.capBitValuesToDecodeArrayBounds(data, decodeArray, d, type == 1785221209);
        }
    }

    private static void invertBitsInByteArray(byte[] data, boolean isRGB) {
        int byteCount = data.length;
        for (int ii = 0; ii < byteCount; ++ii) {
            if (isRGB && (ii & 3) == 3) continue;
            data[ii] = ~data[ii];
        }
    }

    private static void capBitValuesToDecodeArrayBounds(byte[] data, float[] decodeArray, int d, boolean isRGB) {
        int count = decodeArray.length;
        int maxValue = d << 1;
        int divisor = maxValue - 1;
        for (int ii = 0; ii < data.length; ++ii) {
            if (isRGB && (ii & 3) == 3) continue;
            byte currentByte = data[ii];
            int dd = 0;
            int newByte = 0;
            int min = 0;
            int max = 1;
            for (int bits = 7; bits > -1; --bits) {
                int current = currentByte >> bits & 1;
                if ((current = (int)(decodeArray[min] + (float)current * ((decodeArray[max] - decodeArray[min]) / (float)divisor))) > maxValue) {
                    current = maxValue;
                }
                if (current < 0) {
                    current = 0;
                }
                current = (current & 1) << bits;
                newByte += current;
                if ((dd += 2) == count) {
                    dd = 0;
                    min = 0;
                    max = 1;
                    continue;
                }
                min += 2;
                max += 2;
            }
            data[ii] = (byte)newByte;
        }
    }

    private static void capByteValuesToDecodeArrayBounds(byte[] data, float[] decodeArray, boolean isRGB) {
        int j = 0;
        for (int ii = 0; ii < data.length; ++ii) {
            if (isRGB && (ii & 3) == 3) continue;
            int currentByte = data[ii] & 0xFF;
            if ((float)currentByte < decodeArray[j]) {
                currentByte = (int)decodeArray[j];
            } else if ((float)currentByte > decodeArray[j + 1]) {
                currentByte = (int)decodeArray[j + 1];
            }
            if ((j += 2) == decodeArray.length) {
                j = 0;
            }
            data[ii] = (byte)currentByte;
        }
    }

    private static void capCMYKDataToDecodeArrayBounds(byte[] data, float[] decodeArray) {
        int[] tempDecode = new int[decodeArray.length];
        for (int i = 0; i < decodeArray.length; ++i) {
            tempDecode[i] = (int)(decodeArray[i] * 255.0f);
        }
        int j = 0;
        for (int ii = 0; ii < data.length; ++ii) {
            int pp = data[ii] & 0xFF;
            pp = pp * (tempDecode[j + 1] - tempDecode[j]) / 255 + tempDecode[j];
            if ((j += 2) == decodeArray.length) {
                j = 0;
            }
            data[ii] = (byte)pp;
        }
    }

    static boolean isExtractionAllowed(PdfObjectReader currentPdfFile) {
        PdfFileReader objectReader = currentPdfFile.getObjectReader();
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        return decryption == null || decryption.getBooleanValue(103);
    }

    static {
        String imgSetting;
        rejectSuperimposedImages = true;
        String operlapValue = System.getProperty("org.jpedal.rejectsuperimposedimages");
        if (operlapValue != null) {
            rejectSuperimposedImages = operlapValue.toLowerCase().contains("true");
        }
        if ((imgSetting = System.getProperty("org.jpedal.trackImages")) != null) {
            trackImages = imgSetting.toLowerCase().contains("true");
        }
    }
}

