/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StructuredContentHandler {
    private final Map<Integer, String> markedContentProperties;
    int markedContentLevel;
    private StringBuilder markedContentSequence;
    private static final boolean debug = false;
    private boolean contentExtracted;
    private String currentKey;
    private final Map<Integer, String> keys;
    final Map<String, PdfObject> dictionaries;
    Map<String, String> values;
    private final boolean buildDirectly;
    DynamicVectorRenderer current;
    private Document doc;
    private Element root;
    boolean isHTML;

    public StructuredContentHandler(Object markedContent) {
        if (markedContent instanceof Map) {
            this.buildDirectly = false;
            this.values = (Map)markedContent;
        } else {
            this.buildDirectly = true;
            this.doc = (Document)markedContent;
            this.root = this.doc.createElement("TaggedPDF-doc");
            this.doc.appendChild(this.root);
        }
        this.markedContentProperties = new HashMap<Integer, String>();
        this.markedContentLevel = 0;
        this.markedContentSequence = new StringBuilder();
        this.currentKey = "";
        this.keys = new HashMap<Integer, String>();
        this.dictionaries = new HashMap<String, PdfObject>();
    }

    public void DP(PdfObject BDCobj) {
    }

    public void BDC(PdfObject BDCobj) {
        int MCID;
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuilder();
        }
        ++this.markedContentLevel;
        if (this.buildDirectly) {
            BDCobj.setIntNumber(487790868, -1);
        }
        if ((MCID = BDCobj.getInt(487790868)) != -1) {
            this.keys.put(this.markedContentLevel, String.valueOf(MCID));
        }
        this.dictionaries.put(String.valueOf(this.markedContentLevel), BDCobj);
    }

    public void BMC(String op) {
        op = this.setBMCvalues(op);
        if (this.buildDirectly && op != null) {
            Element newRoot = (Element)this.root.getElementsByTagName(op).item(0);
            if (newRoot == null) {
                newRoot = this.doc.createElement(op);
                this.root.appendChild(newRoot);
            }
            this.root = newRoot;
        }
    }

    String setBMCvalues(String op) {
        if (op.startsWith("/")) {
            op = op.substring(1);
        }
        if (this.markedContentLevel == 0 && !this.isHTML) {
            this.markedContentSequence = new StringBuilder();
        }
        this.markedContentProperties.put(this.markedContentLevel, op);
        ++this.markedContentLevel;
        this.keys.put(this.markedContentLevel, op);
        return op;
    }

    public void EMC() {
        this.setEMCValues();
        if (this.buildDirectly) {
            boolean isBMC;
            PdfObject BDCobj = this.dictionaries.get(this.currentKey);
            boolean bl = isBMC = BDCobj == null;
            if (isBMC) {
                if (this.currentKey != null) {
                    Text child = this.doc.createTextNode(StructuredContentHandler.stripEscapeChars(this.markedContentSequence.toString()));
                    this.root.appendChild(child);
                    Node oldRoot = this.root.getParentNode();
                    if (oldRoot instanceof Element) {
                        this.root = (Element)oldRoot;
                    }
                }
            } else {
                String S2 = "p";
                Element tag = this.doc.createElement("p");
                this.root.appendChild(tag);
                Text child = this.doc.createTextNode(this.markedContentSequence.toString());
                tag.appendChild(child);
            }
            this.markedContentSequence = new StringBuilder();
        } else {
            String ContentSequence = this.markedContentSequence.toString();
            PdfObject BDCobj = this.dictionaries.get(String.valueOf(this.markedContentLevel));
            int MCID = -1;
            if (BDCobj != null) {
                MCID = BDCobj.getInt(487790868);
            }
            if (MCID != -1) {
                this.values.put(String.valueOf(MCID), ContentSequence);
                this.markedContentSequence = new StringBuilder();
            }
            this.dictionaries.remove(String.valueOf(this.markedContentLevel));
        }
        if (this.markedContentLevel > 0) {
            --this.markedContentLevel;
        }
    }

    void setEMCValues() {
        this.contentExtracted = true;
        this.currentKey = this.keys.get(this.markedContentLevel);
        if (this.currentKey == null) {
            this.currentKey = String.valueOf(this.markedContentLevel);
        }
    }

    public void setText(StringBuilder current_value) {
        if (this.markedContentSequence.length() == 0) {
            this.markedContentSequence = current_value;
            if (this.markedContentSequence.length() > 0 && this.markedContentSequence.charAt(0) == ' ') {
                this.markedContentSequence.deleteCharAt(0);
            }
        } else {
            this.markedContentSequence.append((CharSequence)current_value);
        }
    }

    private static String stripEscapeChars(String dict) {
        int lastC = 32;
        StringBuilder str = new StringBuilder(dict);
        int length = str.length();
        for (int ii = 0; ii < length; ++ii) {
            char c = str.charAt(ii);
            if (c == '\\' && lastC != 92) {
                str.deleteCharAt(ii);
                --length;
            }
            lastC = c;
        }
        return str.toString();
    }

    public boolean hasContent() {
        return this.contentExtracted;
    }
}

