/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw.xfa;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jpedal.objects.raw.FormAppearanceObject;

final class SingleLineTextAP {
    private SingleLineTextAP() {
    }

    public static void draw(BufferedImage image, FormAppearanceObject XObject2) {
        int[] mattes;
        Color bgColor = Color.WHITE;
        float[] arr = XObject2.getFloatArray(4631);
        if (arr != null) {
            bgColor = new Color((int)arr[0], (int)arr[1], (int)arr[2]);
        }
        if ((mattes = XObject2.getMatteBorderDetails()) != null) {
            SingleLineTextAP.drawMattedTextField(image, mattes, bgColor);
        } else {
            int strokeType = XObject2.getBorderStroke();
            switch (strokeType) {
                case 0: {
                    break;
                }
                case 6: {
                    SingleLineTextAP.drawSingleLineField(image, bgColor);
                }
            }
        }
    }

    private static void drawMattedTextField(BufferedImage image, int[] mattes, Color color) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        if (color.getRed() != 255 || color.getGreen() != 255 || color.getBlue() != 255) {
            g2.setColor(color);
            g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        }
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(6.0f));
        block6: for (int i = 0; i < mattes.length; ++i) {
            if (mattes[i] == 0) continue;
            switch (i) {
                case 0: {
                    g2.drawLine(0, 0, width, 0);
                    continue block6;
                }
                case 1: {
                    g2.drawLine(width, 0, width, height);
                    continue block6;
                }
                case 2: {
                    g2.drawLine(width, height, 0, height);
                    continue block6;
                }
                case 3: {
                    g2.drawLine(0, height, 0, 0);
                }
            }
        }
    }

    private static void drawSingleLineField(BufferedImage image, Color bgColor) {
        int height = image.getHeight();
        int width = image.getWidth();
        Graphics2D g2 = image.createGraphics();
        Color darkGrey = new Color(128, 128, 128);
        Color lightGrey = new Color(212, 208, 200);
        g2.setColor(Color.BLACK);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.setColor(darkGrey);
        g2.fill(new Rectangle2D.Double(2.0, 2.0, width - 4, height - 4));
        g2.setColor(lightGrey);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 6, height - 6));
        g2.setColor(bgColor);
        g2.fill(new Rectangle2D.Double(4.0, 4.0, width - 8, height - 8));
        g2.setColor(lightGrey);
        int[] x = new int[]{width - 4, width - 2, width - 2};
        int[] y = new int[]{4, 2, 4};
        Polygon p = new Polygon(x, y, 3);
        g2.fillPolygon(p);
        g2.setColor(lightGrey);
        x = new int[]{2, 4, 4};
        y = new int[]{height - 2, height - 2, height - 4};
        p = new Polygon(x, y, 3);
        g2.fillPolygon(p);
    }
}

