/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class ReadOnlyTextIcon
extends CustomImageIcon {
    private boolean currentlyPrinting;
    private int printMultiplier = 1;
    private int alignment = -1;
    private static final long serialVersionUID = 8946195842453749725L;
    private BufferedImage rootImage;
    private BufferedImage finalImage;
    private PdfObject fakeObj;
    private boolean textChanged;
    private String preFontStream = "";
    private String betweenFontAndTextStream = "";
    private String afterTextStream = "";
    private String text = "";
    private String fontName = "";
    private String fontSize = "12";
    private String fontCommand = "";
    private final PdfObjectReader currentpdffile;
    private final PdfObject resources;
    private final PdfObject form;

    public ReadOnlyTextIcon(PdfObject form, int iconRot, PdfObjectReader pdfObjectReader, PdfObject res) {
        super(iconRot);
        this.form = form;
        this.currentpdffile = pdfObjectReader;
        this.resources = res;
    }

    @Override
    public Image getImage() {
        this.checkAndCreateimage();
        BufferedImage image = this.finalImage;
        return image;
    }

    public BufferedImage drawToBufferedImage() {
        BufferedImage bufImg = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics g = bufImg.getGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return bufImg;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = (BufferedImage)this.getImage();
        if (image == null) {
            return;
        }
        if (c != null && c.isEnabled()) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(Color.gray);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int drawWidth = this.iconWidth;
            int drawHeight = this.iconHeight;
            if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                drawWidth = this.iconHeight;
                drawHeight = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float hs;
                float ws = (float)drawWidth / (float)image.getWidth(null);
                if (ws < (hs = (float)drawHeight / (float)image.getHeight(null))) {
                    drawWidth = (int)(ws * (float)image.getWidth(null));
                    drawHeight = (int)(ws * (float)image.getHeight(null));
                } else {
                    drawWidth = (int)(hs * (float)image.getWidth(null));
                    drawHeight = (int)(hs * (float)image.getHeight(null));
                }
            }
            int posX = 0;
            int posY = 0;
            if (this.currentpdffile != null) {
                if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                    posX = (this.iconHeight - drawWidth) / 2;
                    posY = (this.iconWidth - drawHeight) / 2;
                } else {
                    posX = (this.iconWidth - drawWidth) / 2;
                    posY = (this.iconHeight - drawHeight) / 2;
                }
            }
            if (this.alignment == 2) {
                posX = 0;
            }
            int finalRotation = this.displaySingle ? ReadOnlyTextIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate;
            switch (finalRotation) {
                case 270: {
                    g2.rotate(-1.5707963267948966);
                    g2.translate(-drawWidth, 0);
                    g2.drawImage(image, -posX, posY, drawWidth, drawHeight, null);
                    break;
                }
                case 90: {
                    g2.rotate(1.5707963267948966);
                    g2.translate(0, -drawHeight);
                    g2.drawImage(image, posX, -posY, drawWidth, drawHeight, null);
                    break;
                }
                case 180: {
                    g2.rotate(Math.PI);
                    g2.translate(-drawWidth, -drawHeight);
                    g2.drawImage(image, -posX, -posY, drawWidth, drawHeight, null);
                    break;
                }
                default: {
                    g2.drawImage(image, posX, posY, drawWidth, drawHeight, null);
                    break;
                }
            }
        } else {
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.translate(-x, -y);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int newWidth = this.iconWidth;
        int newHeight = this.iconHeight;
        if (this.currentlyPrinting) {
            newWidth = this.iconWidth * this.printMultiplier;
            newHeight = this.iconHeight * this.printMultiplier;
        }
        if (this.textChanged || this.rootImage == null || newWidth > this.rootImage.getWidth(null) || newHeight > this.rootImage.getHeight(null) || (float)newWidth < (float)this.rootImage.getWidth(null) / 1.5f || (float)newHeight < (float)this.rootImage.getHeight(null) / 1.5f) {
            this.rootImage = FormStream.decode(this.form, this.currentpdffile, this.fakeObj, -1, newWidth, newHeight, 0, 1.0f);
            this.finalImage = FormStream.rotate(this.rootImage, this.iconRotation);
            this.textChanged = false;
        }
    }

    public void setText(String str) {
        if (str == null) {
            str = "";
        }
        if (str.equals(this.text)) {
            return;
        }
        this.textChanged = true;
        this.text = str;
        PdfObject xobj = new PdfObject("1 10 X");
        do {
            xobj.setDecodedStream(StringUtils.toBytes(this.afterTextStream));
            String tj = FormStream.decipherTextFromAP(this.currentpdffile, xobj);
            if (tj == null || !this.text.contains(tj)) break;
            int endOfTj = this.afterTextStream.indexOf(" Tj", this.afterTextStream.indexOf(tj)) + 3;
            this.afterTextStream = this.afterTextStream.substring(endOfTj);
        } while (!this.afterTextStream.isEmpty());
        StringBuilder builder = new StringBuilder();
        try {
            PdfObject MK;
            float[] bg;
            if (this.text.contains("\n") || this.text.contains("\r")) {
                builder.append(this.handleMultiLineText());
            } else {
                builder.append(this.handleSingleLineText());
            }
            Color BG = null;
            if (this.form.getDictionary(7451) != null && (bg = (MK = this.form.getDictionary(7451)).getFloatArray(4631)) != null) {
                int i;
                boolean colorOutOfBounds = false;
                for (i = 0; i != bg.length; ++i) {
                    if (!(bg[i] > 1.0f)) continue;
                    colorOutOfBounds = true;
                    break;
                }
                if (colorOutOfBounds) {
                    for (i = 0; i != bg.length; ++i) {
                        if (!(bg[i] > 1.0f)) continue;
                        int n = i;
                        bg[n] = bg[n] / 255.0f;
                    }
                }
                if (bg.length > 0) {
                    switch (bg.length) {
                        case 1: {
                            BG = new Color(bg[0], bg[0], bg[0], 1.0f);
                            break;
                        }
                        case 3: {
                            BG = new Color(bg[0], bg[1], bg[2], 1.0f);
                        }
                    }
                }
            }
            if (BG != null) {
                builder.insert(0, " re f ");
                builder.insert(0, ((FormObject)this.form).getBoundingRectangle().height - 3);
                builder.insert(0, ' ');
                builder.insert(0, ((FormObject)this.form).getBoundingRectangle().width - 3);
                builder.insert(0, " rg 0 0 ");
                builder.insert(0, BG.getBlue());
                builder.insert(0, ' ');
                builder.insert(0, BG.getGreen());
                builder.insert(0, ' ');
                builder.insert(0, BG.getRed());
            }
            this.fakeObj.setDecodedStream(builder.toString().getBytes("Cp1252"));
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }

    private String handleSingleLineText() {
        int alignmentX = 2;
        int alignmentY = (int)((float)((FormObject)this.form).getBoundingRectangle().height - Float.parseFloat(this.fontSize)) + 2;
        if (this.form.getParameterConstant(1147962727) != 980909433) {
            alignmentY = (int)((float)((FormObject)this.form).getBoundingRectangle().height - Float.parseFloat(this.fontSize)) / 2;
            if (alignmentY < 2) {
                alignmentY = 2;
            }
            if (((FormObject)this.form).getAlignment() != 2) {
                FontMetrics fm = new Canvas().getFontMetrics(new Font(this.fontName, 0, (int)Float.parseFloat(this.fontSize)));
                Rectangle2D r = fm.getStringBounds(this.text, null);
                switch (((FormObject)this.form).getAlignment()) {
                    case 0: {
                        alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r.getWidth()) / 2;
                        break;
                    }
                    case 4: {
                        alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r.getWidth()) - 2;
                    }
                }
            }
        }
        return this.preFontStream + this.fontName + this.fontSize + this.fontCommand + this.betweenFontAndTextStream + alignmentX + ' ' + alignmentY + " Td (" + this.text + ")Tj " + this.afterTextStream;
    }

    private String handleMultiLineText() {
        StringTokenizer lines = new StringTokenizer(this.text, "\n\r", false);
        int alignmentX = 2;
        int alignmentY = ((FormObject)this.form).getBoundingRectangle().height;
        StringBuilder builder = new StringBuilder();
        builder.append(this.preFontStream).append(this.fontName).append(this.fontSize).append(this.fontCommand).append(this.betweenFontAndTextStream).append(' ').append(alignmentX).append(' ').append(alignmentY).append(" Td ");
        int xPoint = 0;
        while (lines.hasMoreTokens()) {
            String nextLine = lines.nextToken();
            FontMetrics fm = new Canvas().getFontMetrics(new Font(this.fontName, 0, (int)Float.parseFloat(this.fontSize)));
            Rectangle2D r = fm.getStringBounds(nextLine, null);
            if (((FormObject)this.form).getAlignment() != -1) {
                switch (((FormObject)this.form).getAlignment()) {
                    case 2: {
                        alignmentX = 0;
                        break;
                    }
                    case 0: {
                        alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r.getWidth()) / 2;
                        alignmentX -= xPoint;
                        break;
                    }
                    case 4: {
                        alignmentX = (int)((double)((FormObject)this.form).getBoundingRectangle().width - r.getWidth());
                        alignmentX -= xPoint;
                    }
                }
            }
            alignmentY = (int)(-(r.getHeight() + 2.0));
            builder.append(' ').append(alignmentX).append(' ').append(alignmentY).append(" Td (").append(nextLine).append(")Tj ");
            xPoint += alignmentX;
        }
        builder.append(this.afterTextStream);
        return builder.toString();
    }

    public boolean decipherAppObject(FormObject form) {
        String fontStr = "";
        PdfObject appObj = form.getDictionary(4384).getDictionary(30);
        if (appObj != null) {
            fontStr = this.readApObject(appObj);
        }
        this.fakeObj = ReadOnlyTextIcon.createFakeObject(form, this.resources);
        String DA = form.getTextStreamValue(5137);
        if (DA == null || DA.isEmpty()) {
            if (!fontStr.isEmpty()) {
                form.setTextStreamValue(5137, StringUtils.toBytes(fontStr));
                FormStream.decodeFontCommandObj(fontStr, form);
            }
            return false;
        }
        if (fontStr.isEmpty()) {
            int ptr = DA.indexOf(47);
            if (ptr < 0) {
                ptr = 0;
            }
            fontStr = DA.substring(ptr).trim();
        } else {
            String fontname = DA.substring(0, DA.indexOf(32));
            String fontsize = fontStr.substring(fontStr.indexOf(32));
            fontStr = fontname + fontsize;
            fontStr = fontStr.trim();
        }
        if (this.preFontStream.isEmpty() || !this.preFontStream.contains("BT")) {
            this.preFontStream = "BT 0 0 0 RG 1 TFS ";
            this.betweenFontAndTextStream = " 1 0 0 1 0 0 Tm ";
            this.afterTextStream = "";
        }
        int sizeSt = fontStr.indexOf(32);
        int sizeEn = ReadOnlyTextIcon.getEndOfSizeValueInStream(fontStr, sizeSt);
        this.setFontCommandValues(form, fontStr, sizeSt, sizeEn);
        return true;
    }

    private void setFontCommandValues(FormObject form, String fontStr, int sizeSt, int sizeEn) {
        if (sizeEn != -1) {
            this.fontName = fontStr.substring(0, sizeSt);
            this.fontCommand = fontStr.substring(sizeEn);
            float fontStrSize = Float.parseFloat(fontStr.substring(sizeSt, sizeEn));
            Rectangle BBox = form.getBoundingRectangle();
            this.fontSize = BBox != null && (fontStrSize == 0.0f || fontStrSize == -1.0f) ? " " + GUIData.calculateFontSize(BBox.height, BBox.width, false, this.text) + ' ' : " " + fontStrSize + ' ';
        } else {
            Font textFont = form.getTextFont();
            this.fontName = '/' + textFont.getFontName();
            this.fontCommand = "Tf ";
            this.fontSize = " 12 ";
        }
    }

    private static int getEndOfSizeValueInStream(String fontStr, int sizeSt) {
        int sizeEn = -1;
        boolean strFound = false;
        for (int i = sizeSt; i < fontStr.length(); ++i) {
            char chr = fontStr.charAt(i);
            if (chr == ' ' || chr == '\n' || chr == '\r') {
                if (!strFound) continue;
                sizeEn = i;
                break;
            }
            strFound = true;
        }
        return sizeEn;
    }

    private String readApObject(PdfObject appObj) {
        byte[] bytes = appObj.getDecodedStream();
        String fontStr = "";
        if (bytes != null) {
            int[] tf = new int[]{-1, -1};
            int[] tj = new int[]{-1, -1};
            int end = bytes.length;
            ReadOnlyTextIcon.findTFValues(tf, end, bytes);
            ReadOnlyTextIcon.findTJValues(tj, tf[1], end, bytes);
            if (bytes.length > 0) {
                tf[1] = ReadOnlyTextIcon.findTfEnd(bytes, tf[1], tj[0]);
            }
            fontStr = new String(bytes, tf[0], tf[1] - tf[0]);
            if (tj[1] != tf[1]) {
                if (tf[1] == 0) {
                    this.preFontStream = new String(bytes, 0, tj[0]);
                    this.betweenFontAndTextStream = " ";
                } else {
                    this.preFontStream = new String(bytes, 0, tf[0]);
                    this.betweenFontAndTextStream = new String(bytes, tf[1], tj[0] - tf[1]);
                }
                this.text = new String(bytes, tj[0], tj[1] - 3 - tj[0]);
                this.afterTextStream = new String(bytes, tj[1], bytes.length - tj[1]);
            } else if (tf[1] == 0) {
                this.preFontStream = new String(bytes);
            } else {
                this.preFontStream = new String(bytes, 0, tf[0]);
                this.betweenFontAndTextStream = new String(bytes, tf[1], bytes.length - tf[1]);
            }
        }
        return fontStr;
    }

    private static void findTJValues(int[] tj, int endTF, int end, byte[] bytes) {
        for (int i = endTF; i < end - 1; ++i) {
            if ((char)bytes[i] != 'T' || (char)bytes[i + 1] != 'j' || i + 2 < end && bytes[i + 2] != 10 && bytes[i + 2] != 13 && bytes[i + 2] != 32) continue;
            tj[1] = i + 2;
            break;
        }
        if (tj[1] == -1) {
            tj[0] = endTF;
            tj[1] = endTF;
        } else {
            tj[0] = endTF;
            int brackets = 0;
            boolean strFound = false;
            block6: for (int i = tj[1] - 3; i > tj[0]; --i) {
                switch (bytes[i]) {
                    case 10: 
                    case 13: 
                    case 32: {
                        if (!strFound || brackets != 0) continue block6;
                        tj[0] = i + 1;
                        break block6;
                    }
                    case 41: {
                        ++brackets;
                        continue block6;
                    }
                    case 40: {
                        if (--brackets != 0 || !strFound) continue block6;
                        tj[0] = i;
                        break block6;
                    }
                    default: {
                        strFound = true;
                    }
                }
            }
        }
    }

    private static void findTFValues(int[] tf, int end, byte[] bytes) {
        int i;
        for (i = 0; i < end - 1; ++i) {
            if ((char)bytes[i] != 'T' || (char)bytes[i + 1] != 'f' || i + 2 < end && bytes[i + 2] != 10 && bytes[i + 2] != 13 && bytes[i + 2] != 32) continue;
            tf[1] = i + 2;
            break;
        }
        if (tf[1] == -1) {
            tf[0] = 0;
            tf[1] = 0;
        } else {
            for (i = tf[1] - 3; i > tf[0]; --i) {
                if (bytes[i] != 47) continue;
                tf[0] = i;
                break;
            }
        }
    }

    private static XObject createFakeObject(FormObject form, PdfObject resources) {
        Rectangle BBox;
        XObject fakeObj = new XObject(form.getObjectRefAsString());
        if (resources != null) {
            fakeObj.setDictionary(2004251818, resources);
        }
        if ((BBox = form.getBoundingRectangle()) != null) {
            fakeObj.setFloatArray(303185736, new float[]{BBox.width, 0.0f, 0.0f, BBox.height, 0.0f, 0.0f});
        }
        return fakeObj;
    }

    private static int findTfEnd(byte[] bytes, int endTf, int startTj) {
        int newEndTF = 0;
        while (bytes[newEndTF] != 32 && bytes[newEndTF] != 10 && bytes[newEndTF] != 13 && (bytes[newEndTF] < 48 || bytes[newEndTF] > 57)) {
            ++newEndTF;
        }
        newEndTF = bytes[newEndTF] == 103 && newEndTF + 1 < startTj && (bytes[newEndTF + 1] == 32 || bytes[newEndTF + 1] == 10 || bytes[newEndTF + 1] == 13) ? ++newEndTF : (bytes[newEndTF] == 114 && newEndTF + 2 < startTj && bytes[newEndTF + 1] == 103 && (bytes[newEndTF + 2] == 32 || bytes[newEndTF + 2] == 10 || bytes[newEndTF + 2] == 13) ? (newEndTF += 2) : endTf);
        return newEndTF;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setPrinting(boolean print, int multiplier) {
        this.currentlyPrinting = print;
        this.printMultiplier = multiplier;
        this.checkAndCreateimage();
    }

    public PdfObject getFakeObject() {
        return this.fakeObj;
    }
}

