/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

final class Trailer {
    private static final byte[] EOFpattern = new byte[]{37, 37, 69, 79, 70};
    private static final byte[] trailerpattern = new byte[]{116, 114, 97, 105, 108, 101, 114};

    private Trailer() {
    }

    public static byte[] readTrailer(int bufSize, int pointer, int eof, RandomAccessBuffer pdf_datafile) {
        int charReached = 0;
        int charReached2 = 0;
        int trailerCount = 0;
        int end = 4;
        FastByteArrayOutputStream bis = new FastByteArrayOutputStream();
        do {
            if (pointer + bufSize > eof) {
                bufSize = eof - pointer;
            }
            if (bufSize == 0) break;
            byte[] buffer = new byte[bufSize];
            try {
                pdf_datafile.seek(pointer);
                pdf_datafile.read(buffer);
            }
            catch (IOException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            boolean endFound = false;
            for (int i = 0; i < bufSize; ++i) {
                byte currentByte = buffer[i];
                charReached = currentByte == EOFpattern[charReached] ? ++charReached : 0;
                charReached2 = currentByte == trailerpattern[charReached2] ? ++charReached2 : 0;
                if (charReached2 == 7) {
                    ++trailerCount;
                    charReached2 = 0;
                }
                if (charReached != 4 && trailerCount != 2) continue;
                for (int j = 0; j < i + 1; ++j) {
                    bis.write(buffer[j]);
                }
                i = bufSize;
                endFound = true;
            }
            if (!endFound) {
                bis.write(buffer);
            }
            pointer += bufSize;
        } while (charReached != 4 && trailerCount != 2);
        return bis.toByteArray();
    }
}

