/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ObjectReader {
    public boolean fileIsBroken;
    private static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    public static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private final RandomAccessBuffer pdf_datafile;
    private int newCacheSize = -1;
    private final long eof;
    private final PdfFileReader currentPdfFile;

    public ObjectReader(RandomAccessBuffer pdf_datafile, long eof, PdfFileReader currentPdfFile) {
        this.pdf_datafile = pdf_datafile;
        this.eof = eof;
        this.currentPdfFile = currentPdfFile;
    }

    public byte[] readObjectData(int bufSize, PdfObject pdfObject) {
        if (bufSize < 1 || this.newCacheSize != -1 || this.fileIsBroken) {
            byte[] dataRead;
            int newCacheSize = -1;
            if (pdfObject != null) {
                newCacheSize = this.newCacheSize;
            }
            if (newCacheSize == -1) {
                if (bufSize < 1) {
                    bufSize = 128;
                }
                dataRead = this.readUnsizedObjectData(bufSize);
            } else {
                dataRead = this.readUnsizedObjectData(newCacheSize, bufSize, pdfObject);
            }
            if (dataRead != null) {
                dataRead = ObjectUtils.checkEndObject(dataRead);
            }
            return dataRead;
        }
        byte[] dataRead = new byte[bufSize += 6];
        try {
            this.pdf_datafile.read(dataRead);
        }
        catch (IOException ex) {
            LogWriter.writeLog("Unable to fill buffer " + ex);
        }
        return dataRead;
    }

    private byte[] readUnsizedObjectData(int bufSize) {
        int realPos = 0;
        int charReached = 0;
        byte[] dataRead = null;
        int i = bufSize - 1;
        while (true) {
            if (++i == bufSize) {
                byte[] buffer = this.getNextByteBlock(bufSize);
                if (buffer == null) break;
                bufSize = buffer.length;
                if (dataRead == null) {
                    dataRead = ObjectReader.resizeBytes(buffer);
                    bufSize = dataRead.length;
                } else {
                    dataRead = ObjectReader.appendDataBlock(buffer.length, buffer, dataRead);
                }
                i = 0;
            }
            if (dataRead == null) {
                return null;
            }
            void currentByte = dataRead[realPos];
            if (currentByte == endPattern[charReached]) {
                if (charReached == 5) break;
                ++charReached;
            } else {
                charReached = 0;
            }
            ++realPos;
        }
        return dataRead;
    }

    private byte[] readUnsizedObjectData(int newCacheSize, int bufSize, PdfObject pdfObject) {
        byte[] dataRead;
        if (bufSize < 1) {
            bufSize = 128;
        }
        if (bufSize > newCacheSize) {
            bufSize = newCacheSize;
        }
        if ((dataRead = this.readUnsizedObjectData(bufSize)) != null && dataRead.length > newCacheSize) {
            pdfObject.setCache(this.currentPdfFile);
        }
        return dataRead;
    }

    private byte[] getNextByteBlock(int bufSize) {
        long pointer = this.getPointer();
        int nextBuffer = bufSize;
        if (pointer + (long)bufSize > this.eof) {
            nextBuffer = (int)(this.eof - pointer);
        }
        if (nextBuffer == 0) {
            return null;
        }
        byte[] buffer = new byte[nextBuffer += 6];
        try {
            this.pdf_datafile.read(buffer);
        }
        catch (IOException ex) {
            LogWriter.writeLog("Unable to fill buffer " + ex);
            return null;
        }
        return buffer;
    }

    private static byte[] resizeBytes(byte[] buffer) {
        int j = 0;
        for (int i2 = 0; i2 < 10; ++i2) {
            if (buffer[i2] != 101 || buffer[i2 + 1] != 110 || buffer[i2 + 2] != 100 || buffer[i2 + 3] != 111 || buffer[i2 + 4] != 98 || buffer[i2 + 5] != 106) continue;
            j = i2;
            break;
        }
        while (buffer[j] == 101 || buffer[j] == 110 || buffer[j] == 100 || buffer[j] == 111 || buffer[j] == 98 || buffer[j] == 106) {
            ++j;
        }
        if (j > 0) {
            byte[] oldBuffer = buffer;
            int newLength = buffer.length - j;
            buffer = new byte[newLength];
            System.arraycopy(oldBuffer, j, buffer, 0, newLength);
        }
        return buffer;
    }

    private static byte[] appendDataBlock(int newBytes, byte[] buffer, byte[] dataRead) {
        int bytesRead = dataRead.length;
        byte[] tmp = new byte[bytesRead + newBytes];
        System.arraycopy(dataRead, 0, tmp, 0, bytesRead);
        System.arraycopy(buffer, 0, tmp, bytesRead, newBytes);
        return tmp;
    }

    private long getPointer() {
        long old_pointer = 0L;
        try {
            old_pointer = this.pdf_datafile.getFilePointer();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " getting pointer in file");
        }
        return old_pointer;
    }

    public void setCacheSize(int minimumCacheSize) {
        this.newCacheSize = minimumCacheSize;
    }
}

