/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.ArrayList;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.DirectDictionaryToObject;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;

public final class Dictionary {
    private Dictionary() {
    }

    public static int readDictionary(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        boolean ignoreRecursion = pdfObject.ignoreRecursion();
        if (raw[i] != 60) {
            ++i;
        }
        if (raw[i = StreamReaderUtils.skipSpaces(raw, i)] == 47) {
            i = Dictionary.readKey(pdfObject, i + 1, raw, PDFkeyInt);
        } else if (StreamReaderUtils.isEndObj(raw, i)) {
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Empty object" + new String(raw) + "<<");
            }
        } else {
            i = !ignoreRecursion ? Dictionary.readDictionaryFromRefOrDirect(pdfObject, pdfObject.getObjectRefAsString(), i, raw, PDFkeyInt, objectReader) : Dictionary.readRef(pdfObject, i, raw, PDFkeyInt, objectReader);
        }
        return i;
    }

    private static int readRef(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "1.About to read ref orDirect i=" + i + " char=" + (char)raw[i]);
        }
        i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i, 91);
        i = Dictionary.readDictionaryFromRefOrDirect(pdfObject, pdfObject.getObjectRefAsString(), i, raw, PDFkeyInt, objectReader);
        return i;
    }

    private static int readKey(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt) {
        int keyStart = i;
        i = StreamReaderUtils.skipToEndOfRef(raw, i);
        PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
        valueObj.setID(PDFkeyInt);
        valueObj.setConstant(PDFkeyInt, keyStart, i - keyStart, raw);
        valueObj.setGeneralStringValue(new String(Dictionary.getByteKeyFromStream(i - keyStart, raw, keyStart)));
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + "Set Dictionary as String=" + valueObj.getGeneralStringValue() + "  in " + pdfObject + " to " + valueObj);
        }
        pdfObject.setDictionary(PDFkeyInt, valueObj);
        return i;
    }

    public static int setDictionaryValue(PdfObject pdfObject, int i, byte[] raw, PdfFileReader objectReader, int PDFkeyInt, boolean dictionaryOnly) {
        int endJ;
        int j;
        byte[] data;
        boolean isRef;
        boolean ignoreRecursion = pdfObject.ignoreRecursion();
        if (ObjectDecoder.debugFastCode) {
            System.out.println(ObjectDecoder.padding + ">>>Reading Dictionary Pairs i=" + i + ' ' + (char)raw[i] + (char)raw[i + 1] + (char)raw[i + 2] + (char)raw[i + 3] + (char)raw[i + 4] + (char)raw[i + 5] + (char)raw[i + 6]);
        }
        boolean bl = isRef = (data = raw)[j = (i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i, 47))] != 60;
        if (isRef) {
            int[] values = StreamReaderUtils.readRefFromStream(raw, i);
            int number = values[0];
            int generation = values[1];
            i = values[2];
            if (!ignoreRecursion) {
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(number, generation), number, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    if (ObjectDecoder.debugFastCode) {
                        System.out.println(ObjectDecoder.padding + "Data not yet loaded");
                    }
                    return raw.length;
                }
                if (data[0] == 60 && data[1] == 60) {
                    j = 0;
                } else {
                    j = 3;
                    while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111) {
                        if (data[j] == 47) {
                            j = 0;
                            break;
                        }
                        if (++j != data.length) continue;
                        j = 0;
                        break;
                    }
                    if (data[j = StreamReaderUtils.skipSpaces(data, j)] == 37) {
                        j = StreamReaderUtils.skipComment(data, j);
                    }
                }
            }
        }
        if (data[endJ = StreamReaderUtils.skipSpacesOrOtherCharacter(data, j, 60)] == 62) {
            j = endJ + 1;
        } else {
            PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
            valueObj.setID(PDFkeyInt);
            j = dictionaryOnly ? Dictionary.readKeyPairs(data, j, valueObj) : Dictionary.readMixedKeyPairs(data, j, valueObj);
            pdfObject.setDictionary(PDFkeyInt, valueObj);
            if (ObjectDecoder.debugFastCode) {
                System.out.println(ObjectDecoder.padding + "Set Dictionary pairs type in " + pdfObject + " to " + valueObj);
            }
        }
        if (!isRef) {
            i = j;
            if (ObjectDecoder.debugFastCode) {
                System.out.println(i + ">>>>" + data[i - 2] + ' ' + data[i - 1] + " >" + data[i] + "< " + data[i + 1] + ' ' + data[i + 2]);
            }
        }
        return i;
    }

    private static int readMixedKeyPairs(byte[] data, int start, PdfObject pdfObject) {
        ArrayList<byte[]> keys = new ArrayList<byte[]>(100);
        ArrayList<byte[]> values = new ArrayList<byte[]>(100);
        while (true) {
            start = StreamReaderUtils.skipSpacesOrOtherCharacter(data, start, 60);
            if (data[start = StreamReaderUtils.skipSpacesOrOtherCharacter(data, start, 41)] == 37) {
                start = StreamReaderUtils.skipComment(data, start);
            }
            if (data[start] == 62 || StreamReaderUtils.isEndObj(data, start)) break;
            int tokenStart = start + 1;
            start = StreamReaderUtils.skipToEndOfKey(data, tokenStart);
            keys.add(Dictionary.getByteKeyFromStream(start - tokenStart, data, tokenStart));
            int refStart = start = StreamReaderUtils.skipSpaces(data, start);
            if (StreamReaderUtils.isNull(data, start)) {
                start += 4;
                values.add(null);
                continue;
            }
            if (data[start] == 60 || data[start] == 91 || data[start] == 47 || data[start] == 40) {
                switch (data[start]) {
                    case 60: {
                        start = ObjectUtils.skipToEndOfObject(start, data);
                        break;
                    }
                    case 91: {
                        start = StreamReaderUtils.skipToEndOfArray(data, start);
                        break;
                    }
                    case 47: {
                        start = StreamReaderUtils.skipToEndOfKey(data, start + 1);
                        break;
                    }
                    case 40: {
                        ++refStart;
                        start = StreamReaderUtils.skipToEndOfStream(data, start);
                        break;
                    }
                }
            } else {
                while (data[start] != 82 && (data[start] != 47 || data[start - 1] == 92 && data[start - 2] == 92) && data[start] != 62 && data[start - 1] != 62) {
                    ++start;
                }
                if (data[start] == 82) {
                    ++start;
                }
            }
            values.add(Dictionary.getByteKeyFromStream(start - refStart, data, refStart));
        }
        int size = keys.size();
        byte[][] returnKeys = new byte[size][];
        byte[][] returnValues = new byte[size][];
        for (int a = 0; a < size; ++a) {
            returnKeys[a] = (byte[])keys.get(a);
            returnValues[a] = (byte[])values.get(a);
        }
        pdfObject.setDictionaryPairs(returnKeys, returnValues);
        return start;
    }

    private static int readKeyPairs(byte[] data, int start, PdfObject pdfObject) {
        ArrayList<byte[]> keys = new ArrayList<byte[]>(100);
        ArrayList<byte[]> values = new ArrayList<byte[]>(100);
        while (true) {
            if (data[start = StreamReaderUtils.skipSpacesOrOtherCharacter(data, start, 60)] == 37) {
                start = StreamReaderUtils.skipComment(data, start);
            }
            if (data[start] == 62 || StreamReaderUtils.isEndObj(data, start)) break;
            int tokenStart = start + 1;
            start = StreamReaderUtils.skipToEndOfKey(data, tokenStart);
            keys.add(Dictionary.getByteKeyFromStream(start - tokenStart, data, tokenStart));
            int refStart = start = StreamReaderUtils.skipSpaces(data, start);
            if (StreamReaderUtils.isNull(data, start)) {
                start += 4;
                values.add(null);
                continue;
            }
            if (data[start] == 60 || data[start] == 91 || data[start] == 47) {
                switch (data[start]) {
                    case 60: {
                        start = ObjectUtils.skipToEndOfObject(start, data);
                        break;
                    }
                    case 91: {
                        start = StreamReaderUtils.skipToEndOfArray(data, start);
                        break;
                    }
                    case 47: {
                        start = StreamReaderUtils.skipToEndOfKey(data, start + 1);
                        break;
                    }
                }
            } else {
                while (data[start] != 82) {
                    ++start;
                }
                ++start;
            }
            values.add(Dictionary.getByteKeyFromStream(start - refStart, data, refStart));
        }
        int size = keys.size();
        byte[][] returnKeys = new byte[size][];
        byte[][] returnValues = new byte[size][];
        for (int a = 0; a < size; ++a) {
            returnKeys[a] = (byte[])keys.get(a);
            returnValues[a] = (byte[])values.get(a);
        }
        pdfObject.setDictionaryPairs(returnKeys, returnValues);
        return start;
    }

    private static byte[] getByteKeyFromStream(int tokenLength, byte[] data, int tokenStart) {
        byte[] tokenKey = new byte[tokenLength];
        System.arraycopy(data, tokenStart, tokenKey, 0, tokenLength);
        return tokenKey;
    }

    public static int setUnreadDictionaryValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, boolean isInlineImage) {
        if (raw[i] != 60) {
            ++i;
        }
        int start = i = StreamReaderUtils.skipSpaces(raw, i);
        PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
        valueObj.setID(PDFkeyInt);
        if (!StreamReaderUtils.isNull(raw, i)) {
            pdfObject.setDictionary(PDFkeyInt, valueObj);
        }
        int status = 2;
        if (raw[i] == 47) {
            i = Dictionary.getDirectValue(i, raw, PDFkeyInt, isInlineImage, valueObj);
            status = 0;
        } else if (raw[i] != 101 || raw[i + 1] != 110 || raw[i + 2] != 100 || raw[i + 3] != 111 || raw[i + 4] != 98) {
            if (raw[i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i, 91)] == 60 && raw[i + 1] == 60) {
                i = Dictionary.handleDirectDictionary(i, raw);
            } else if (raw[i] == 91) {
                ++i;
                i = Dictionary.handleLevels(i, raw);
            } else if (StreamReaderUtils.isNull(raw, i)) {
                i += 4;
            } else {
                status = 1;
                while ((raw[i] != 82 || raw[i - 1] == 101) && ++i != raw.length) {
                }
                if (++i >= raw.length) {
                    i = raw.length - 1;
                }
            }
        }
        valueObj.setStatus(status);
        if (status != 0) {
            Dictionary.decodeObject(i, raw, PDFkeyInt, start, valueObj);
        }
        if (raw[i] == 47 || raw[i] == 62) {
            --i;
        }
        return i;
    }

    private static void decodeObject(int i, byte[] raw, int PDFkeyInt, int start, PdfObject valueObj) {
        int StrLength = i - start;
        byte[] unresolvedData = new byte[StrLength];
        System.arraycopy(raw, start, unresolvedData, 0, StrLength);
        if (unresolvedData[StrLength - 1] == 82) {
            for (int jj = 0; jj < StrLength; ++jj) {
                if (unresolvedData[jj] != 10 && unresolvedData[jj] != 13) continue;
                unresolvedData[jj] = 32;
            }
        }
        valueObj.setUnresolvedData(unresolvedData, PDFkeyInt);
    }

    static int handleDirectDictionary(int i, byte[] raw) {
        i += 2;
        int reflevel = 1;
        while (reflevel > 0) {
            if (raw[i] == 60 && raw[i + 1] == 60) {
                i += 2;
                ++reflevel;
                continue;
            }
            if (raw[i] == 40) {
                ++i;
                while (raw[i] != 41 || ObjectUtils.isEscaped(raw, i)) {
                    ++i;
                }
                continue;
            }
            if (raw[i] == 62 && i + 1 == raw.length) {
                reflevel = 0;
                continue;
            }
            if (raw[i] == 62 && raw[i + 1] == 62) {
                i += 2;
                --reflevel;
                continue;
            }
            ++i;
        }
        return i;
    }

    private static int handleLevels(int i, byte[] raw) {
        int reflevel = 1;
        while (reflevel > 0) {
            switch (raw[i]) {
                case 40: {
                    ++i;
                    while (raw[i] != 41 || ObjectUtils.isEscaped(raw, i)) {
                        ++i;
                    }
                    break;
                }
                case 91: {
                    ++reflevel;
                    break;
                }
                case 93: {
                    --reflevel;
                    break;
                }
            }
            ++i;
        }
        return --i;
    }

    private static int getDirectValue(int i, byte[] raw, int PDFkeyInt, boolean isInlineImage, PdfObject valueObj) {
        while (raw[i] == 10 || raw[i] == 13 || raw[i] == 32 || raw[i] == 47 || raw[i] == 60) {
            ++i;
        }
        int keyStart = i;
        int keyLength = 0;
        while (raw[i] != 10 && raw[i] != 13 && raw[i] != 32 && raw[i] != 47 && raw[i] != 60 && raw[i] != 62) {
            ++i;
            ++keyLength;
        }
        --i;
        int constant = valueObj.setConstant(PDFkeyInt, keyStart, keyLength, raw);
        if (constant == -1 || isInlineImage) {
            byte[] newStr = new byte[keyLength];
            System.arraycopy(raw, keyStart, newStr, 0, keyLength);
            String s = new String(newStr);
            valueObj.setGeneralStringValue(s);
        }
        return i;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int readDictionaryFromRefOrDirect(PdfObject pdfObject, String objectRef, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        int generation;
        int ref;
        byte[] data;
        int j;
        block4: while (true) {
            if (raw[i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i, 91)] == 37) {
                i = StreamReaderUtils.skipComment(raw, i);
                i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i, 91);
            }
            switch (raw[i]) {
                case 60: {
                    return Dictionary.handleBrackets(pdfObject, objectRef, i, raw, PDFkeyInt, objectReader);
                }
                case 47: {
                    return ObjectUtils.setDirectValue(pdfObject, i, raw, PDFkeyInt);
                }
            }
            j = i;
            data = raw;
            while (true) {
                int[] values;
                block18: {
                    if (data[j = StreamReaderUtils.skipSpacesOrOtherCharacter(data, j, 91)] == 93) {
                        return j;
                    }
                    boolean hasNull = false;
                    do {
                        if (hasNull && data[j] == 93) {
                            return j;
                        }
                        values = StreamReaderUtils.readRefFromStream(data, j);
                        ref = values[0];
                        int keyStart = j;
                        j = StreamReaderUtils.skipToEndOfRef(data, j);
                        j = StreamReaderUtils.skipSpaces(data, j);
                        if (ref != 69560 || data[keyStart] != 110) break block18;
                        hasNull = true;
                    } while (data[j] != 60);
                    i = j;
                    continue block4;
                }
                generation = values[1];
                j = values[2];
                data = objectReader.readObjectAsByteArray(pdfObject, objectReader.isCompressed(ref, generation), ref, generation);
                if (data == null) {
                    pdfObject.setFullyResolved(false);
                    return raw.length;
                }
                if (data.length > 4 && data[0] == 37 && data[1] == 80 && data[2] == 68 && data[3] == 70) {
                    data = null;
                } else if (StreamReaderUtils.isNull(data, 0)) {
                    data = null;
                }
                if (data == null) break block4;
                int j2 = 0;
                if (data[j2] == 37) {
                    j2 = StreamReaderUtils.skipComment(data, j2);
                }
                if (data[j2] != 91 && data[0] != 60 && data[1] != 60 && (j2 = Dictionary.handleOddRef(data, j2)) >= data.length) {
                    return i;
                }
                if (data[j2] != 91) {
                    j = 0;
                    break block4;
                }
                if (data[j2] == 91 && data[j2 + 1] == 60) {
                    j = ++j2;
                    break block4;
                }
                j = j2;
            }
            break;
        }
        if (data == null) return i;
        if ((i = Dictionary.handlePairs(pdfObject, objectRef, i, raw, PDFkeyInt)) >= 0) return Dictionary.readObj(j, data, raw, ref, generation, i, pdfObject, PDFkeyInt, objectReader);
        return -i;
    }

    private static int handleBrackets(PdfObject pdfObject, String objectRef, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        i = (i = Dictionary.handlePairs(pdfObject, objectRef, i, raw, PDFkeyInt)) < 0 ? -i : DirectDictionaryToObject.convert(pdfObject, objectRef, i, raw, PDFkeyInt, objectReader);
        return i;
    }

    private static int handleOddRef(byte[] data, int j2) {
        while ((j2 < 3 || data[j2 - 1] != 106 && data[j2 - 2] != 98 && data[j2 - 3] != 111) && data[j2] != 47) {
            ++j2;
        }
        j2 = StreamReaderUtils.skipSpaces(data, j2);
        return j2;
    }

    private static int handlePairs(PdfObject pdfObject, String objectRef, int i, byte[] raw, int PDFkeyInt) {
        boolean isPairs = false;
        int parentType = pdfObject.getPDFkeyInt();
        if (parentType != 4369 && parentType != -1567847737 && (PDFkeyInt == 30 || PDFkeyInt == 34 || PDFkeyInt == 20 || PDFkeyInt == 893600855)) {
            isPairs = Dictionary.isDictionaryPairs(i, raw, PDFkeyInt, pdfObject.getObjectType());
        }
        if (isPairs) {
            FormObject APobj = new FormObject(objectRef);
            pdfObject.setDictionary(PDFkeyInt, APobj);
            i = -Dictionary.readKeyPairs(raw, i, APobj);
        }
        return i;
    }

    private static int readObj(int j, byte[] data, byte[] raw, int ref, int generation, int i, PdfObject pdfObject, int PDFkeyInt, PdfFileReader objectReader) {
        boolean isMissingValue;
        boolean bl = isMissingValue = (j = StreamReaderUtils.skipSpaces(data, j)) < raw.length && raw[j] == 60 && raw[StreamReaderUtils.skipSpacesOrOtherCharacter(raw, j, 60)] != 47;
        if (isMissingValue) {
            int keyStart = j;
            j = StreamReaderUtils.skipToEndOfRef(data, j);
            ref = NumberUtils.parseInt(keyStart, j, data);
            keyStart = j = StreamReaderUtils.skipSpaces(data, j);
            j = StreamReaderUtils.skipToEndOfRef(data, j);
            generation = NumberUtils.parseInt(keyStart, j, data);
            while (data[j - 1] != 106 && data[j - 2] != 98 && data[j - 3] != 111 && data[j] != 60) {
                ++j;
            }
        }
        j = StreamReaderUtils.skipSpaces(data, j);
        boolean streamIsNull = false;
        while (data[j] != 60 && data[j + 1] != 60 && data[j] != 47 && !(streamIsNull = StreamReaderUtils.isNull(data, j))) {
            ++j;
        }
        i = streamIsNull ? j + 4 : Dictionary.handleValue(pdfObject, i, PDFkeyInt, j, ref, generation, data, objectReader);
        return i;
    }

    public static int setDictionaryValue(PdfObject pdfObject, int i, byte[] raw, int PDFkeyInt, PdfFileReader objectReader) {
        int end = i;
        int nextC = i;
        if (StreamReaderUtils.isNull(raw, nextC = StreamReaderUtils.skipSpaces(raw, nextC))) {
            i = nextC + 4;
            return i;
        }
        if (raw[nextC] == 91 && raw[nextC + 1] == 93) {
            i = nextC;
            return i;
        }
        if (raw[i] != 60 && raw[i + 1] != 60) {
            end += 2;
        }
        boolean inDictionary = true;
        boolean isKey = raw[end - 1] == 47;
        int strLen = raw.length;
        while (inDictionary && end < strLen) {
            if (raw[end] == 60 && raw[end + 1] == 60) {
                int level2 = 1;
                ++end;
                while (level2 > 0) {
                    if (raw[end] == 60 && raw[end + 1] == 60) {
                        ++level2;
                        end += 2;
                        continue;
                    }
                    if (raw[end - 1] == 62 && raw[end] == 62) {
                        if (--level2 <= 0) continue;
                        end += 2;
                        continue;
                    }
                    if (raw[end] == 40) {
                        ++end;
                        while (raw[end] != 41 || ObjectUtils.isEscaped(raw, end)) {
                            ++end;
                        }
                        continue;
                    }
                    ++end;
                }
                inDictionary = false;
                continue;
            }
            if (raw[end] == 82) {
                inDictionary = false;
                continue;
            }
            if (isKey && (raw[end] == 32 || raw[end] == 13 || raw[end] == 10 || raw[end] == 9)) {
                inDictionary = false;
                continue;
            }
            if (raw[end] == 47) {
                inDictionary = false;
                --end;
                continue;
            }
            if (raw[end] == 62 && raw[end + 1] == 62) {
                inDictionary = false;
                --end;
                continue;
            }
            ++end;
        }
        Dictionary.readDictionary(pdfObject, i, raw, PDFkeyInt, objectReader);
        return end;
    }

    private static int handleValue(PdfObject pdfObject, int i, int PDFkeyInt, int j, int ref, int generation, byte[] data, PdfFileReader objectReader) {
        int dataLen = data.length;
        if (data[j] == 47) {
            int keyStart = ++j;
            int keyLength = 0;
            while (j < dataLen && data[j] != 10 && data[j] != 13 && data[j] != 32 && data[j] != 47 && data[j] != 60 && data[j] != 62) {
                ++j;
                ++keyLength;
            }
            --i;
            if (PDFkeyInt == -1) {
                pdfObject.setConstant(-1, keyStart, keyLength, data);
                if (ObjectDecoder.debugFastCode) {
                    System.out.println(ObjectDecoder.padding + "Set object Constant directly to " + pdfObject.setConstant(-1, keyStart, keyLength, data));
                }
            } else {
                PdfObject valueObj = ObjectFactory.createObject(PDFkeyInt, null, pdfObject.getObjectType(), pdfObject.getID());
                valueObj.setID(PDFkeyInt);
                valueObj.setConstant(PDFkeyInt, keyStart, keyLength, data);
                pdfObject.setDictionary(PDFkeyInt, valueObj);
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(valueObj, objectReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else {
            PdfObject valueObj;
            if (PDFkeyInt == -1) {
                valueObj = pdfObject;
            } else {
                valueObj = ObjectFactory.createObject(PDFkeyInt, ref, generation, pdfObject.getObjectType());
                valueObj.setID(PDFkeyInt);
                valueObj.setInCompressedStream(pdfObject.isInCompressedStream());
                if (pdfObject.isDataExternal()) {
                    valueObj.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(valueObj, objectReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
                if (PDFkeyInt != 2004251818) {
                    valueObj.ignoreRecursion(pdfObject.ignoreRecursion());
                }
            }
            ObjectDecoder objDecoder = new ObjectDecoder(objectReader);
            objDecoder.readDictionaryAsObject(valueObj, j, data);
            if (PDFkeyInt != -1) {
                pdfObject.setDictionary(PDFkeyInt, valueObj);
            }
        }
        return i;
    }

    private static boolean isDictionaryPairs(int i, byte[] raw, int PDFkeyInt, int objectType) {
        int length = raw.length;
        while (i < length) {
            if (raw[i = StreamReaderUtils.skipSpacesOrOtherCharacter(raw, i, 60)] == 62 && raw[i + 1] == 62) {
                return true;
            }
            if (raw[i] != 47) {
                return false;
            }
            int keyStart = ++i;
            int keyLength = StreamReaderUtils.findDictionaryEnd(i, raw, length);
            i += keyLength;
            int possibleKey = PdfDictionary.getIntKey(keyStart, keyLength, raw);
            if (possibleKey != -1 && keyLength > 3 && PdfDictionary.getKeyType(possibleKey, -1) != -1) {
                return false;
            }
            ++i;
            if (StreamReaderUtils.isRef(raw, i = StreamReaderUtils.skipSpaces(raw, i))) {
                while (raw[i] != 82) {
                    ++i;
                }
                ++i;
                continue;
            }
            if (StreamReaderUtils.isNull(raw, i)) {
                i += 4;
                continue;
            }
            if (raw[i] == 60 && raw[i + 1] == 60) {
                i = ObjectUtils.skipToEndOfObject(i, raw) + 1;
                continue;
            }
            if (raw[i] == 91) {
                i = StreamReaderUtils.skipToEndOfArray(raw, i);
                continue;
            }
            return false;
        }
        return true;
    }
}

