/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.ArrayList;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.ArrayDecoder;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.io.types.TextStream;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class Array
extends ObjectDecoder
implements ArrayDecoder {
    final ArrayList<byte[]> valuesRead = new ArrayList();
    private int i;
    int j2;
    final int type;
    private final byte[] raw;
    byte[] arrayData;
    int PDFkeyInt;
    private int rawLength;
    private String indirectRef;
    private boolean isSingle;

    public Array(PdfFileReader pdfFileReader, int i, int type, byte[] raw) {
        super(pdfFileReader);
        this.i = i;
        this.type = type;
        this.raw = raw;
        if (raw != null) {
            this.rawLength = raw.length;
        }
    }

    private boolean findStart() {
        if (debugFastCode) {
            System.out.println(padding + "Reading array type=" + PdfDictionary.showArrayType(this.type) + ' ' + (char)this.raw[this.i] + ' ' + (char)this.raw[this.i + 1] + ' ' + (char)this.raw[this.i + 2] + ' ' + (char)this.raw[this.i + 3] + ' ' + (char)this.raw[this.i + 4]);
        }
        if (this.raw[this.i] != 91 && this.raw[this.i] != 60) {
            ++this.i;
        }
        if (this.raw[this.i] == 91 && this.raw[this.i + 1] == 93) {
            return true;
        }
        while (this.raw[this.i] == 10 || this.raw[this.i] == 13 || this.raw[this.i] == 32) {
            ++this.i;
        }
        if (this.raw[this.i] == 37) {
            this.i = StreamReaderUtils.skipComment(this.raw, this.i);
        }
        return false;
    }

    private void readIndirect(PdfObject pdfObject) throws RuntimeException {
        this.isSingle = false;
        int startI = this.i;
        int[] values = StreamReaderUtils.readRefFromStream(this.raw, this.i);
        int ref = values[0];
        int generation = values[1];
        this.i = values[2];
        this.arrayData = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(ref, generation), ref, generation);
        if (this.decryption != null) {
            this.indirectRef = ref + " " + generation + " R";
        }
        if (this.arrayData == null) {
            pdfObject.setFullyResolved(false);
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (14)");
            this.i = this.rawLength;
        } else {
            this.skipToEndOfArray(pdfObject, startI);
        }
    }

    private void skipToEndOfArray(PdfObject pdfObject, int startI) {
        this.j2 = 0;
        while (this.arrayData[this.j2] != 91) {
            if (this.arrayData[this.j2] == 37) {
                this.j2 = StreamReaderUtils.skipComment(this.arrayData, this.j2);
                --this.j2;
            }
            if (StreamReaderUtils.isNull(this.arrayData, this.j2) || this.arrayData[this.j2] == 101 && this.arrayData[this.j2 + 1] == 110 && this.arrayData[this.j2 + 2] == 100 && this.arrayData[this.j2 + 3] == 111 || this.arrayData[this.j2] == 47) break;
            if (this.arrayData[this.j2] == 60 && this.arrayData[this.j2 + 1] == 60) {
                this.j2 = startI;
                this.arrayData = this.raw;
                if (debugFastCode) {
                    System.out.println(padding + "Single value, not indirect " + pdfObject.getObjectRefAsString());
                }
                this.isSingle = true;
                break;
            }
            ++this.j2;
        }
    }

    @Override
    public int readArray(PdfObject pdfObject, int PDFkeyInt) {
        if (this.raw[this.i] != 47 && this.findStart()) {
            return this.i + 1;
        }
        this.PDFkeyInt = PDFkeyInt;
        this.j2 = this.i;
        this.arrayData = this.raw;
        if (debugFastCode) {
            System.out.println(padding + "Reading array type=" + PdfDictionary.showArrayType(this.type) + " into " + pdfObject + ' ' + (char)this.raw[this.i] + ' ' + (char)this.raw[this.i + 1] + ' ' + (char)this.raw[this.i + 2] + ' ' + (char)this.raw[this.i + 3] + ' ' + (char)this.raw[this.i + 4]);
        }
        boolean isIndirect = this.raw[this.i] != 91 && this.raw[this.i] != 40 && this.raw[0] != 0 && !StreamReaderUtils.isNull(this.raw, this.i) && StreamReaderUtils.handleIndirect(this.raw, this.i);
        boolean singleKey = this.isFirstKeySingle();
        if (singleKey && this.raw[this.i] == 47 && this.raw[this.i + 1] == 47) {
            return this.i + 1;
        }
        if ((this.type == 22 || !singleKey) && isIndirect) {
            this.readIndirect(pdfObject);
            if (this.arrayData == null) {
                return this.i;
            }
            singleKey = this.isFirstKeySingle();
        }
        this.scanElements(singleKey, pdfObject);
        if (!isIndirect) {
            this.i = this.j2;
        }
        if (debugFastCode) {
            this.showValues();
        }
        if (this.i < this.rawLength && (this.raw[this.i] == 47 || this.raw[this.i] == 62 || this.raw[this.i] >= 48 && this.raw[this.i] <= 57)) {
            --this.i;
        }
        return this.i;
    }

    void scanElements(boolean singleKey, PdfObject pdfObject) {
        singleKey = this.isSingleKey();
        this.findArrayStart();
        int arrayEnd = this.arrayData.length;
        int keyStart = this.moveToStartOfNextValue();
        int currentElement = 0;
        while (!(this.j2 >= arrayEnd || this.arrayData[this.j2] == 93 || StreamReaderUtils.isEndObj(this.arrayData, this.j2) || this.arrayData[this.j2] == 62 && this.arrayData[this.j2 + 1] == 62)) {
            byte[] newValues;
            if (this.arrayData[this.j2 - 1] == 47) {
                if (this.type == 10 || this.type == 9) {
                    --this.j2;
                    break;
                }
                newValues = this.writeKey();
            } else if (StreamReaderUtils.isRef(this.arrayData, this.j2) || this.arrayData[this.j2] == 60 && this.arrayData[this.j2 + 1] == 60) {
                newValues = this.writeObject(keyStart);
            } else if (StreamReaderUtils.isNumber(this.arrayData, this.j2)) {
                newValues = this.writeNumber();
                if (this.type == 14) {
                    this.isSingle = true;
                }
            } else {
                newValues = StreamReaderUtils.isNull(this.arrayData, this.j2) ? this.writeNull() : (this.arrayData[this.j2] == 40 ? this.writeString(pdfObject) : (StreamReaderUtils.isArray(this.arrayData, this.j2) ? this.writeArray() : (this.arrayData[this.j2 + 1] == 60 && this.arrayData[this.j2 + 2] == 60 ? this.writeDirectDictionary(keyStart) : (this.arrayData[this.j2] == 60 ? this.writeHexString(pdfObject) : this.writeGeneral(keyStart)))));
            }
            if (debugFastCode) {
                System.out.println(padding + "<Element -----" + currentElement + "( j2=" + this.j2 + " ) value=" + new String(newValues) + '<' + ' ' + singleKey);
            }
            this.valuesRead.add(newValues);
            ++currentElement;
            if (singleKey || this.isSingle) break;
            keyStart = this.moveToStartOfNextValue();
        }
        this.fillArray(currentElement, pdfObject);
    }

    int moveToStartOfNextValue() {
        int size = this.arrayData.length;
        this.j2 = StreamReaderUtils.skipSpacesOrOtherCharacter(this.arrayData, this.j2, 47);
        while (this.j2 < size && this.arrayData[this.j2] == 37) {
            while (this.j2 < size && this.arrayData[this.j2] != 10) {
                ++this.j2;
            }
            this.j2 = StreamReaderUtils.skipSpaces(this.arrayData, this.j2);
        }
        this.j2 = StreamReaderUtils.skipSpacesOrOtherCharacter(this.arrayData, this.j2, 47);
        return this.j2;
    }

    byte[] writeGeneral(int keyStart) {
        while (!(this.arrayData[this.j2] == 10 || this.arrayData[this.j2] == 13 || this.arrayData[this.j2] == 32 || this.arrayData[this.j2] == 93 || this.arrayData[this.j2] == 47 || this.arrayData[this.j2] == 91 || this.arrayData[this.j2] == 62 && this.arrayData[this.j2 + 1] == 62 || this.arrayData[this.j2] == 60 && this.arrayData[this.j2 + 1] == 60)) {
            ++this.j2;
            if (this.j2 != this.arrayData.length) continue;
        }
        byte[] newValues = ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, false);
        if (this.arrayData[this.j2] == 62 && this.arrayData[this.j2 + 1] != 62) {
            ++this.j2;
        }
        return newValues;
    }

    byte[] writeDirectDictionary(int keyStart) {
        ++this.j2;
        if (debugFastCode) {
            System.out.println(padding + "----double <<");
        }
        return ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, false);
    }

    private byte[] writeArray() {
        int depth = 0;
        if (debugFastCode) {
            System.out.println(padding + "----array");
        }
        int keyStart = this.j2;
        while (this.arrayData[this.j2] != 93 || depth > 0) {
            if (this.arrayData[this.j2] == 91) {
                ++depth;
            }
            ++this.j2;
            if (this.arrayData[this.j2] != 93) continue;
            --depth;
        }
        ++this.j2;
        return ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, false);
    }

    byte[] writeString(PdfObject pdfObject) {
        if (debugFastCode) {
            System.out.println(padding + "----string");
        }
        int keyStart = this.j2 + 1;
        while (this.arrayData[this.j2] != 41 || ObjectUtils.isEscaped(this.arrayData, this.j2)) {
            ++this.j2;
        }
        byte[] newValues = ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, false);
        ++this.j2;
        try {
            if (!pdfObject.isInCompressedStream() && this.decryption != null) {
                String ref = pdfObject.getObjectRefAsString();
                if (this.indirectRef != null) {
                    ref = this.indirectRef;
                }
                newValues = this.decryption.decrypt(newValues, ref, false, null, false, false);
            }
        }
        catch (PdfSecurityException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return newValues;
    }

    byte[] writeObject(int keyStart) {
        if (debugFastCode) {
            System.out.println(padding + "----ref or direct obj");
        }
        while (this.arrayData[this.j2] != 82 && this.arrayData[this.j2] != 93) {
            if (this.arrayData[this.j2] == 40 && !ObjectUtils.isEscaped(this.arrayData, this.j2)) {
                this.j2 = TextStream.skipToEnd(this.arrayData, this.j2);
            } else if (this.arrayData[this.j2] == 60 && this.arrayData[this.j2 + 1] == 60) {
                int levels = 1;
                if (debugFastCode) {
                    System.out.println(padding + "Reading Direct value");
                }
                while (levels > 0) {
                    ++this.j2;
                    if (this.arrayData[this.j2] == 40 && !ObjectUtils.isEscaped(this.arrayData, this.j2)) {
                        this.j2 = TextStream.skipToEnd(this.arrayData, this.j2);
                        continue;
                    }
                    if (this.arrayData[this.j2] == 60 && this.arrayData[this.j2 + 1] == 60) {
                        ++this.j2;
                        ++levels;
                        continue;
                    }
                    if (this.arrayData[this.j2] != 62 || this.arrayData[this.j2 + 1] != 62) continue;
                    ++this.j2;
                    --levels;
                }
                break;
            }
            ++this.j2;
        }
        ++this.j2;
        byte[] newValues = ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, true);
        if (StreamReaderUtils.isRef(newValues, 0) && (this.type == 10 || this.type == 9)) {
            newValues = this.extractNumberFromRef(newValues);
        }
        return newValues;
    }

    byte[] extractNumberFromRef(byte[] newValues) {
        int[] values = StreamReaderUtils.readRefFromStream(newValues, 0);
        int ref = values[0];
        int generation = values[1];
        byte[] numData = this.objectReader.readObjectAsByteArray(new PdfObject(new String(newValues)), this.objectReader.isCompressed(ref, generation), ref, generation);
        int[] pos = NumberValue.extractDataFromIndirectRef(numData);
        int start = pos[0];
        int length = pos[1] - pos[0];
        byte[] extractedValue = new byte[length];
        System.arraycopy(numData, start, extractedValue, 0, length);
        return extractedValue;
    }

    byte[] writeNumber() {
        if (debugFastCode) {
            System.out.println(padding + "----number");
        }
        int keyStart = this.j2 = StreamReaderUtils.skipSpaces(this.arrayData, this.j2);
        while (this.arrayData[this.j2] >= 48 && this.arrayData[this.j2] <= 57) {
            ++this.j2;
        }
        return ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, false);
    }

    static byte[] writeNumber(byte[] arrayData) {
        int j2;
        if (debugFastCode) {
            System.out.println(padding + "----number");
        }
        int keyStart = j2 = StreamReaderUtils.skipSpaces(arrayData, 0);
        while (arrayData[j2] >= 48 && arrayData[j2] <= 57) {
            ++j2;
        }
        return ObjectUtils.readEscapedValue(j2, arrayData, keyStart, false);
    }

    byte[] writeKey() {
        if (debugFastCode) {
            System.out.println(padding + "----key");
        }
        int keyStart = this.j2;
        this.j2 = StreamReaderUtils.skipToEndOfKey(this.arrayData, this.j2 + 1);
        if (keyStart > 0 && this.arrayData[keyStart - 1] == 47) {
            --keyStart;
        }
        return ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, false);
    }

    void findArrayStart() {
        if (this.j2 < 0) {
            this.j2 = 0;
        }
        boolean startFound = false;
        while (this.arrayData[this.j2] == 10 || this.arrayData[this.j2] == 13 || this.arrayData[this.j2] == 32 || this.arrayData[this.j2] == 91 && !startFound) {
            if (this.arrayData[this.j2] == 91) {
                startFound = true;
            }
            ++this.j2;
        }
        if (debugFastCode) {
            if (this.j2 > 0) {
                System.out.println(padding + "----scanElements j2=" + this.j2 + " chars=" + this.arrayData[this.j2 - 1] + ' ' + this.arrayData[this.j2] + ' ' + this.arrayData[this.j2 + 1]);
            } else {
                System.out.println(padding + "----scanElements j2=" + this.j2 + " chars=" + this.arrayData[this.j2] + ' ' + this.arrayData[this.j2 + 1]);
            }
        }
    }

    byte[] writeNull() {
        if (debugFastCode) {
            System.out.println(padding + "----null");
        }
        int keyStart = this.j2;
        this.j2 += 4;
        return ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, false);
    }

    byte[] writeHexString(PdfObject pdfObject) {
        if (debugFastCode) {
            System.out.println(padding + "----hex string");
        }
        boolean hexString = true;
        int keyStart = this.j2 + 1;
        while (this.arrayData[this.j2] != 62) {
            if (this.arrayData[this.j2] == 47) {
                hexString = false;
            }
            ++this.j2;
        }
        byte[] newValues = ObjectUtils.readEscapedValue(this.j2, this.arrayData, keyStart, false);
        if (hexString) {
            newValues = this.indirectRef == null ? StreamReaderUtils.handleHexString(newValues, this.decryption, pdfObject.getObjectRefAsString()) : StreamReaderUtils.handleHexString(newValues, this.decryption, this.indirectRef);
        }
        ++this.j2;
        return newValues;
    }

    void fillArray(int elementCount, PdfObject pdfObject) {
        byte[][] finalByteValues = new byte[elementCount][];
        for (int a = 0; a < elementCount; ++a) {
            finalByteValues[a] = this.valuesRead.get(a);
        }
        pdfObject.setMixedArray(this.PDFkeyInt, finalByteValues);
        if (this.indirectRef != null) {
            pdfObject.setArrayRef(this.PDFkeyInt, this.indirectRef);
        }
    }

    void showValues() {
        StringBuilder values = new StringBuilder("[");
        for (byte[] value : this.valuesRead) {
            if (value == null) {
                values.append("null ");
                continue;
            }
            values.append(new String(value)).append(' ');
        }
        values.append(" ]");
        System.out.println(padding + "values=" + values);
    }

    boolean isSingleKey() {
        return this.raw[this.i] == 47 || this.raw[this.i] == 40 || this.raw[this.i] == 60;
    }

    boolean isFirstKeySingle() {
        return this.raw[this.i] == 47 || this.raw[this.i] == 40 || this.raw[this.i] == 60;
    }
}

