/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;

class TiffLZWBuffer {
    private byte[][] codes;
    private BufferedOutputStream output;
    private BufferedInputStream input;
    private int bitsToGet = 9;
    private int tp;
    private int putBuffer;
    private int putBits;

    TiffLZWBuffer() {
    }

    public void decompress(BufferedOutputStream output, BufferedInputStream input) throws IOException {
        int code;
        this.init();
        this.input = input;
        this.output = output;
        this.putBuffer = 0;
        this.putBits = 0;
        int oldCode = 0;
        while ((code = this.findNext()) != 257) {
            byte[] chars;
            if (code == 256) {
                this.init();
                code = this.findNext();
                if (code == 257) break;
                this.addCodes(this.codes[code]);
            } else if (code < this.tp) {
                chars = this.codes[code];
                this.addCodes(chars);
                this.addCodeToCodes(this.codes[oldCode], chars[0]);
            } else {
                chars = this.codes[oldCode];
                chars = TiffLZWBuffer.generateCodeArray(chars, chars[0]);
                this.addCodes(chars);
                this.addCodeArrToCodes(chars);
            }
            oldCode = code;
        }
    }

    private void init() {
        this.codes = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.codes[i] = new byte[1];
            this.codes[i][0] = (byte)i;
        }
        this.tp = 258;
        this.bitsToGet = 9;
    }

    private void addCodes(byte[] codes) throws IOException {
        this.output.write(codes);
    }

    private void addCodeToCodes(byte[] oldCodes, byte code) {
        int length = oldCodes.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldCodes, 0, string, 0, length);
        string[length] = code;
        this.codes[this.tp++] = string;
        switch (this.tp) {
            case 511: {
                this.bitsToGet = 10;
                break;
            }
            case 1023: {
                this.bitsToGet = 11;
                break;
            }
            case 2047: {
                this.bitsToGet = 12;
                break;
            }
        }
    }

    private void addCodeArrToCodes(byte[] codeArr) {
        this.codes[this.tp++] = codeArr;
        switch (this.tp) {
            case 511: {
                this.bitsToGet = 10;
                break;
            }
            case 1023: {
                this.bitsToGet = 11;
                break;
            }
            case 2047: {
                this.bitsToGet = 12;
                break;
            }
        }
    }

    private static byte[] generateCodeArray(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        return string;
    }

    private int findNext() {
        int[] combinator = new int[]{511, 1023, 2047, 4095};
        try {
            this.putBuffer = this.putBuffer << 8 | this.input.read();
            this.putBits += 8;
            if (this.putBits < this.bitsToGet) {
                this.putBuffer = this.putBuffer << 8 | this.input.read();
                this.putBits += 8;
            }
            int code = this.putBuffer >> this.putBits - this.bitsToGet & combinator[this.bitsToGet - 9];
            this.putBits -= this.bitsToGet;
            return code;
        }
        catch (Exception e) {
            System.err.println("Exception in findNext " + e);
            return 257;
        }
    }
}

