/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import com.idrsolutions.image.jpeg2000.data.Info;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;

public class JPX
extends BaseFilter
implements PdfFilter {
    private final PdfObject pdfObject;

    public JPX(PdfObject decodeParms, PdfObject pdfObject) {
        super(decodeParms);
        this.pdfObject = pdfObject;
    }

    @Override
    public byte[] decode(byte[] data) throws Exception {
        Jpeg2000Decoder jpxDecoder = new Jpeg2000Decoder();
        data = jpxDecoder.readComponentsAsUnConvertedBytes(data);
        if (this.pdfObject != null) {
            Info info = jpxDecoder.getInfo();
            this.rawColorSpace = JPX.convertJPXValueToColorSpace(info.enumerateCS);
            this.pdfObject.setIntNumber(-789460276, this.rawColorSpace);
        }
        return data;
    }

    private static int convertJPXValueToColorSpace(int colorspace) {
        int value = -1;
        switch (colorspace) {
            case 17: {
                value = 1785221209;
                break;
            }
            case 16: {
                value = 1568372915;
                break;
            }
            case 12: {
                value = 1498837125;
                break;
            }
            case 18: {
                value = 689115931;
            }
        }
        return value;
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) throws Exception {
        int size = bis.available();
        byte[] data = new byte[size];
        bis.read(data);
        data = this.decode(data);
        streamCache.write(data);
    }
}

