/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.utils.LogWriter;

class EarlyLZW {
    private byte[][] tableBytes;
    private byte[] data;
    private ByteArrayOutputStream bos;
    private int tp;
    private int bitsToRead = 9;
    private int bp;
    private int nextValue;
    private int nextBits;
    private boolean earlyChange;
    private static final int[] ANDS = new int[]{511, 1023, 2047, 4095};

    EarlyLZW() {
    }

    public byte[] decode(byte[] data, boolean earlyChange) throws IOException {
        int code;
        if (data[0] == 0 && data[1] == 1) {
            throw new IOException("LZW decoder Start index not Found");
        }
        this.init();
        this.data = data;
        this.bos = new ByteArrayOutputStream();
        this.earlyChange = earlyChange;
        this.bp = 0;
        this.nextValue = 0;
        this.nextBits = 0;
        int oldCode = 0;
        while ((code = this.next()) != 257) {
            byte[] str;
            if (code == 256) {
                this.init();
                code = this.next();
                if (code == 257) break;
                this.write(this.tableBytes[code]);
            } else if (code < this.tp) {
                str = this.tableBytes[code];
                this.write(str);
                this.toTable(this.tableBytes[oldCode], str[0]);
            } else {
                str = this.tableBytes[oldCode];
                str = EarlyLZW.append(str, str[0]);
                this.write(str);
                this.toTable(str);
            }
            oldCode = code;
        }
        this.bos.close();
        return this.bos.toByteArray();
    }

    private void init() {
        this.tableBytes = new byte[8192][];
        for (int i = 0; i < 256; ++i) {
            this.tableBytes[i] = new byte[1];
            this.tableBytes[i][0] = (byte)i;
        }
        this.tp = 258;
        this.bitsToRead = 9;
    }

    private void write(byte[] bb) throws IOException {
        this.bos.write(bb);
    }

    private void toTable(byte[] oldBytes, byte newBytes) {
        int length = oldBytes.length;
        byte[] temp = new byte[length + 1];
        System.arraycopy(oldBytes, 0, temp, 0, length);
        temp[length] = newBytes;
        this.toTable(temp);
    }

    private void toTable(byte[] bytes) {
        if (this.earlyChange) {
            this.tableBytes[this.tp++] = bytes;
        }
        switch (this.tp) {
            case 511: {
                this.bitsToRead = 10;
                break;
            }
            case 1023: {
                this.bitsToRead = 11;
                break;
            }
            case 2047: {
                this.bitsToRead = 12;
            }
        }
        if (!this.earlyChange) {
            this.tableBytes[this.tp++] = bytes;
        }
    }

    private static byte[] append(byte[] oldData, byte newData) {
        int length = oldData.length;
        byte[] data = new byte[length + 1];
        System.arraycopy(oldData, 0, data, 0, length);
        data[length] = newData;
        return data;
    }

    private int next() {
        try {
            this.nextValue = this.nextValue << 8 | this.data[this.bp++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToRead) {
                this.nextValue = this.nextValue << 8 | this.data[this.bp++] & 0xFF;
                this.nextBits += 8;
            }
            int code = this.nextValue >> this.nextBits - this.bitsToRead & ANDS[this.bitsToRead - 9];
            this.nextBits -= this.bitsToRead;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LogWriter.writeLog("invalid LZW value found");
            return 257;
        }
    }
}

