/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.filter.Predictor;
import org.jpedal.objects.raw.PdfObject;

class BaseFilter {
    int rawColorSpace = -1;
    final PdfObject decodeParms;
    BufferedInputStream bis;
    BufferedOutputStream streamCache;
    Map<String, String> cachedObjects;

    BaseFilter(PdfObject decodeParms) {
        this.decodeParms = decodeParms;
    }

    public int getRawColorSpace() {
        return this.rawColorSpace;
    }

    public boolean hasError() {
        return false;
    }

    void setupCachedObjectForDecoding(String cacheName) throws IOException {
        File tempFile2 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
        this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
        ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
        File rawFile = new File(cacheName);
        rawFile.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(cacheName));
        this.bis = new BufferedInputStream(new FileInputStream(tempFile2));
    }

    byte[] applyPredictor(int predictor, byte[] data, int colors, int bitsPerComponent, int columns) throws Exception {
        boolean isCached;
        if (predictor == 1) {
            return data;
        }
        boolean bl = isCached = data == null;
        if (isCached) {
            Predictor.applyPredictor(predictor, this.bis, this.streamCache, colors, bitsPerComponent, columns);
            return null;
        }
        ByteArrayInputStream byis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Predictor.applyPredictor(predictor, byis, bos, colors, bitsPerComponent, columns);
        byis.close();
        return bos.toByteArray();
    }
}

