/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.utils.LogWriter;

public class RandomAccessFileBuffer
implements RandomAccessBuffer {
    private RandomAccessFile ra;
    private boolean isBig;
    private int bp;
    private int bl;
    private byte[] temp;
    private int tSize = 4096;
    private int ts;
    private int te;
    private File file;
    private byte[] password;
    private String tempFileName;
    private CryptoIDR crypt;
    private int paddingAtStartOfFile;

    public RandomAccessFileBuffer(byte[] bytes, byte[] password) throws Exception {
        this.password = password;
        if (password != null) {
            this.crypt = new CryptoIDR(password);
        }
        this.bp = -1;
        this.bl = 0;
        this.file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
        this.tempFileName = this.file.getAbsolutePath();
        RandomAccessFileBuffer.writeToFile(this.tempFileName, bytes, password);
        this.bl = (int)this.file.length();
        this.isBig = false;
        this.ra = new RandomAccessFile(this.file, "r");
        this.init();
    }

    public RandomAccessFileBuffer(String fileName, byte[] password) throws Exception {
        this.password = password;
        if (password != null) {
            this.crypt = new CryptoIDR(password);
        }
        this.bp = -1;
        File file = new File(fileName);
        this.bl = (int)file.length();
        this.isBig = false;
        this.ra = new RandomAccessFile(fileName, "r");
        this.init();
    }

    public RandomAccessFileBuffer(InputStream in, byte[] password) throws Exception {
        this.password = password;
        if (password != null) {
            this.crypt = new CryptoIDR(password);
        }
        this.bp = -1;
        this.bl = 0;
        this.file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
        this.tempFileName = this.file.getPath();
        FileOutputStream to = new FileOutputStream(this.file);
        BufferedInputStream from = new BufferedInputStream(in);
        this.bl = password == null ? ObjectStore.copy(from, to) : ObjectStore.copyAndEncrypt(from, to, password);
        this.isBig = false;
        this.ra = new RandomAccessFile(this.file, "r");
        this.init();
    }

    public RandomAccessFileBuffer(InputStream in) throws Exception {
        this(in, null);
    }

    public RandomAccessFileBuffer(String fileName, String mode) throws IOException {
        this.setupOptimumCase(fileName, mode);
    }

    private void setupOptimumCase(String fileName, String mode) throws IOException {
        File file = new File(fileName);
        this.ra = new RandomAccessFile(file, mode);
        this.isBig = file.length() > Integer.MAX_VALUE;
        this.bl = (int)file.length();
        this.init();
    }

    @Override
    public void setPaddingAtStartOfFile(int paddingAtStartOfFile) {
        this.paddingAtStartOfFile = paddingAtStartOfFile;
    }

    private void init() throws IOException {
        if (!this.isBig) {
            this.tSize = Math.min(this.tSize, this.bl);
            this.bp = this.bl - this.tSize;
            this.temp = new byte[this.tSize];
            this.ts = this.bp;
            this.te = this.ts + this.tSize;
            this.ra.seek(this.bp);
            this.ra.read(this.temp);
            if (this.password != null) {
                this.temp = this.crypt.decrypt(this.temp, this.bp);
            }
        }
    }

    @Override
    public byte[] getPdfBuffer() {
        byte[] bytes = new byte[this.bl];
        try {
            this.ra.seek(0L);
            this.ra.read(bytes);
            if (this.password != null) {
                bytes = this.crypt.decrypt(bytes, 0);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        return bytes;
    }

    @Override
    public long getFilePointer() throws IOException {
        if (this.isBig) {
            return this.ra.getFilePointer();
        }
        return this.bp;
    }

    private boolean checkPos(long pos) throws IOException {
        return pos >= 0L && pos < this.length();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.isBig) {
            this.ra.seek(pos + (long)this.paddingAtStartOfFile);
        } else if (this.checkPos(pos)) {
            this.bp = (int)pos;
        } else {
            throw new IOException("Position out of bounds");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.isBig) {
            return this.ra.read();
        }
        if (this.bp < this.bl) {
            return this.readByte() & 0xFF;
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder input = new StringBuilder();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public long length() throws IOException {
        if (this.isBig) {
            return this.ra.length();
        }
        return this.bl;
    }

    @Override
    public void close() throws IOException {
        if (this.ra != null) {
            this.ra.close();
        }
        this.bp = -1;
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.isBig) {
            return this.ra.read(b);
        }
        this.ra.seek(this.bp + this.paddingAtStartOfFile);
        int maxRead = this.ra.read(b);
        if (this.password != null) {
            byte[] decryptedCopy = this.crypt.decrypt(b, this.bp);
            System.arraycopy(decryptedCopy, 0, b, 0, b.length);
        }
        this.bp += maxRead;
        return maxRead;
    }

    private byte readByte() throws IOException {
        if (this.bp >= this.ts && this.bp < this.te) {
            byte v = this.temp[this.bp - this.ts];
            ++this.bp;
            return v;
        }
        if (this.checkPos(this.bp)) {
            this.ts = this.bp;
            this.te = this.ts + this.tSize;
            this.ra.seek(this.bp + this.paddingAtStartOfFile);
            int max = Math.min(this.bl - this.bp, this.tSize);
            this.temp = new byte[this.temp.length];
            this.ra.read(this.temp, 0, max);
            if (this.password != null) {
                this.temp = this.crypt.decrypt(this.temp, this.bp);
            }
            ++this.bp;
            return this.temp[0];
        }
        return -1;
    }

    private static void writeToFile(String fileName, byte[] data, byte[] password) throws IOException {
        if (password != null) {
            CryptoIDR crypt = new CryptoIDR(password);
            try {
                data = crypt.encrypt(data, 0);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(new File(fileName)));){
            fos.write(data);
        }
    }

    @Override
    public String getTempFileName() {
        return this.tempFileName;
    }
}

