/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class LinearizedHintTable {
    private final Map<Integer, Integer> startRefs = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> endRefs = new HashMap<Integer, Integer>();
    private static final int[] mask = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    private static final int[] shift = new int[]{0, 8, 16, 24};
    private int[] obj;
    private final FileChannel fos;
    private boolean finishedReading;
    private final byte[] password;
    private CryptoIDR crypt;

    public LinearizedHintTable(FileChannel fos, byte[] password) {
        this.fos = fos;
        this.password = password;
        if (password != null) {
            this.crypt = new CryptoIDR(password);
        }
    }

    public void readTable(PdfObject hintObj, PdfObject linearObj, int O, long Ooffset) {
        byte[] hintTableData = hintObj.getDecodedStream();
        int N2 = linearObj.getInt(30);
        if (hintTableData != null && hintTableData.length > 0) {
            this.parseHintTable(N2, O, Ooffset, hintTableData);
        }
    }

    private void parseHintTable(int N2, int O, long Ooffset, byte[] hintTableData) {
        int pageReached;
        int startByte = 0;
        int[] pageObjectCount = new int[N2 + 1];
        this.obj = new int[N2 + 1];
        long[] pageStart = new long[N2 + 1];
        int[] pageLength = new int[N2 + 1];
        int leastNumberOfObjects = ((hintTableData[startByte] & 0xFF) << 24) + ((hintTableData[startByte + 1] & 0xFF) << 16) + ((hintTableData[startByte + 2] & 0xFF) << 8) + (hintTableData[startByte + 3] & 0xFF);
        startByte += 4;
        int bitsNeededforObjectCount = ((hintTableData[startByte += 4] & 0xFF) << 8) + (hintTableData[startByte + 1] & 0xFF);
        int smallestPageSize = ((hintTableData[startByte += 2] & 0xFF) << 24) + ((hintTableData[startByte + 1] & 0xFF) << 16) + ((hintTableData[startByte + 2] & 0xFF) << 8) + (hintTableData[startByte + 3] & 0xFF);
        int bitsNeededforPageSize = ((hintTableData[startByte += 4] & 0xFF) << 8) + (hintTableData[startByte + 1] & 0xFF);
        startByte += 2;
        startByte += 4;
        startByte += 2;
        startByte += 4;
        startByte += 2;
        startByte += 2;
        startByte += 2;
        startByte += 2;
        int bitReached = (startByte += 2) << 3;
        for (pageReached = 0; pageReached < N2; ++pageReached) {
            pageObjectCount[pageReached + 1] = leastNumberOfObjects + LinearizedHintTable.getBitsFromByteStream(bitReached, bitsNeededforObjectCount, hintTableData);
            bitReached += bitsNeededforObjectCount;
        }
        this.obj[1] = O;
        if (N2 > 1) {
            this.obj[2] = 1;
        }
        for (pageReached = 3; pageReached < N2; ++pageReached) {
            this.obj[pageReached] = this.obj[pageReached - 1] + pageObjectCount[pageReached - 1];
        }
        bitReached = bitReached + 7 >> 3 << 3;
        for (pageReached = 0; pageReached < N2; ++pageReached) {
            pageLength[pageReached + 1] = smallestPageSize + LinearizedHintTable.getBitsFromByteStream(bitReached, bitsNeededforPageSize, hintTableData);
            bitReached += bitsNeededforPageSize;
        }
        for (pageReached = 0; pageReached < N2; ++pageReached) {
            if (pageReached == 0) {
                pageStart[1] = Ooffset;
                continue;
            }
            pageStart[pageReached + 1] = pageStart[pageReached] + (long)pageLength[pageReached];
        }
    }

    private static int getBitsFromByteStream(int bitReached, int bitsNeededforObjectCount, byte[] hintTableData) {
        int value = 0;
        int startByte = bitReached >> 3;
        int startOffset = bitReached & 7;
        int bytesNeeded = (bitsNeededforObjectCount + startOffset >> 3) + 1;
        int endShift = (bytesNeeded << 3) - startOffset - bitsNeededforObjectCount;
        if (startOffset == 0) {
            endShift = (bytesNeeded << 3) - bitsNeededforObjectCount & 7;
        }
        if (bytesNeeded > 4) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Example of bits over 32 in Linearized table");
            }
            return 0;
        }
        for (int ii = 0; ii < bytesNeeded; ++ii) {
            int nextValue = hintTableData[startByte + ii] & 0xFF;
            if (ii == 0) {
                nextValue &= mask[startOffset];
            }
            value += nextValue << shift[bytesNeeded - (ii + 1)];
        }
        return value >>= endShift;
    }

    public int getPageObjectRef(int rawPage) {
        if (this.obj == null || this.obj.length <= rawPage) {
            return -1;
        }
        return this.obj[rawPage];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getObjData(int objID) {
        byte[] data;
        if (this.finishedReading) {
            return null;
        }
        Integer key = objID;
        if (!this.startRefs.containsKey(key) || !this.endRefs.containsKey(key)) {
            return null;
        }
        int start = this.startRefs.get(key);
        int end = this.endRefs.get(key);
        int bufSize = end - start + 1;
        long size = 0L;
        try {
            if (this.fos.isOpen()) {
                size = this.fos.size() - 200L;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            size = 0L;
        }
        if (size < (long)end || end - start < 1) {
            return null;
        }
        try {
            FileChannel fileChannel = this.fos;
            synchronized (fileChannel) {
                ByteBuffer buf = ByteBuffer.allocateDirect(bufSize);
                this.fos.read(buf, start);
                ((Buffer)buf).clear();
                data = new byte[buf.capacity()];
                buf.get(data, 0, data.length);
                if (this.password != null) {
                    data = this.crypt.decrypt(data, start);
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
            data = null;
        }
        return data;
    }

    public void storeOffset(int ref, int startObjPtr, int endObjPtr) {
        this.startRefs.put(ref, startObjPtr);
        this.endRefs.put(ref, endObjPtr);
    }

    public void setFinishedReading() {
        this.finishedReading = true;
    }
}

