/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display.swing;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.RepaintManager;
import javax.swing.border.Border;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.display.GUIDisplay;
import org.jpedal.display.PageOffsets;
import org.jpedal.display.swing.SwingHelper;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.LogWriter;

public class SingleDisplay
extends GUIDisplay {
    private AffineTransform displayScaling;
    private int[] cursorBoxOnScreen;
    private int[] lastCursorBoxOnScreen;
    private AffineTransform viewScaling;
    AffineTransform rawAf;
    private int volatileWidth;
    private int volatileHeight;
    boolean screenNeedsRedrawing;
    final PdfDecoder pdf;
    private float oldVolatileWidth = -1.0f;
    private float oldVolatileHeight = -1.0f;
    Map<Integer, String> accleratedPagesAlreadyDrawn = new HashMap<Integer, String>();
    Graphics2D g2;
    Map<Integer, int[][]> areas;
    int lastAreasPainted = -1;
    AffineTransform current2;
    Shape currentClip;
    VolatileImage backBuffer;

    public SingleDisplay(int pageNumber, DynamicVectorRenderer currentDisplay, PdfDecoder pdf, DecoderOptions options) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.pageNumber = pageNumber;
        this.currentDisplay = currentDisplay;
        this.pdf = pdf;
        this.options = options;
        this.displayOffsets = pdf.getDisplayOffsets();
        this.setBorderPresent(pdf.getPages().isBorderPresent());
        this.pageData = pdf.getPdfPageData();
        String val = System.getProperty("org.jpedal.AlwaysAccelerate");
        if (val != null) {
            this.ignoreScalingForAcceleration = "true".equalsIgnoreCase(val);
        }
    }

    public SingleDisplay(PdfDecoderInt pdf, DecoderOptions options) {
        String val;
        this.pdf = (PdfDecoder)pdf;
        this.options = options;
        this.displayOffsets = pdf.getDisplayOffsets();
        this.pageData = pdf.getPdfPageData();
        if (this.currentOffset == null) {
            this.currentOffset = new PageOffsets(pdf.getPageCount(), this.pageData);
        }
        if ((val = System.getProperty("org.jpedal.AlwaysAccelerate")) != null) {
            this.ignoreScalingForAcceleration = "true".equalsIgnoreCase(val);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.areas = null;
        this.backBuffer = null;
        this.accleratedPagesAlreadyDrawn = null;
    }

    private void createBackBuffer() {
        if (this.backBuffer != null) {
            this.backBuffer.flush();
            this.backBuffer = null;
        }
        int width = 0;
        int height = 0;
        if (this.displayView == 1) {
            if (this.displayRotation == 90 || this.displayRotation == 270) {
                width = this.volatileHeight;
                height = this.volatileWidth;
            } else {
                width = this.volatileWidth;
                height = this.volatileHeight;
            }
        } else if (this.currentOffset != null) {
            this.currentOffset.calculateCombinedPageSizes(this.displayView, this.pageNumber, this.displayRotation, this.multiDisplayOptions, this.pageData, this.scaling, this.insetW, this.insetH);
            width = this.currentOffset.getPageWidth();
            height = this.currentOffset.getPageHeight();
        }
        try {
            if (height > 15000) {
                this.volatileHeight = 0;
                height = 0;
                this.overRideAcceleration = true;
            }
            if (width > 0 && height > 0) {
                this.backBuffer = this.pdf.createVolatileImage(width, height);
                this.oldVolatileWidth = this.volatileWidth;
                this.oldVolatileHeight = this.volatileHeight;
                Graphics2D gg = (Graphics2D)this.backBuffer.getGraphics();
                gg.setPaint(this.pdf.getBackground());
                gg.fillRect(0, 0, width, height);
            }
        }
        catch (Error e) {
            this.overRideAcceleration = true;
            this.backBuffer = null;
            LogWriter.writeLog("Switched to unaccelerated draw " + e);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " is display mode");
        }
    }

    boolean isAccelerated() {
        return this.useAcceleration && !this.overRideAcceleration;
    }

    boolean testAcceleratedRendering() {
        boolean canDrawAccelerated = false;
        if (this.oldScaling != this.scaling || this.oldRotation != (float)this.displayRotation || this.oldVolatileWidth != (float)this.volatileWidth || this.oldVolatileHeight != (float)this.volatileHeight) {
            this.backBuffer = null;
            this.overRideAcceleration = false;
        }
        if (!this.overRideAcceleration && this.backBuffer == null) {
            this.createBackBuffer();
            this.accleratedPagesAlreadyDrawn.clear();
        }
        if (this.backBuffer != null) {
            do {
                int valCode = 2;
                if (this.backBuffer != null) {
                    valCode = this.backBuffer.validate(this.pdf.getGraphicsConfiguration());
                }
                if (valCode != 1 && valCode == 2 && !this.overRideAcceleration) {
                    this.createBackBuffer();
                }
                if (this.backBuffer == null) continue;
                canDrawAccelerated = true;
            } while (this.backBuffer == null || this.backBuffer.contentsLost());
        }
        return canDrawAccelerated;
    }

    public void getDisplayedRectangle() {
        this.getDisplayedRectangle(this.pdf.isShowing(), this.pdf.getVisibleRect());
    }

    @Override
    public void drawBorder() {
        if (this.pdf.getPages().isBorderPresent()) {
            Border myBorder = this.pdf.getPDFBorder();
            if (this.crw > 0 && this.crh > 0 && myBorder != null) {
                Insets insets = myBorder.getBorderInsets(this.pdf);
                myBorder.paintBorder(this.pdf, this.g2, this.crx - insets.left, this.cry - insets.bottom, this.crw + insets.left + insets.right, this.crh + insets.bottom + insets.top);
            }
        }
    }

    void setDisplacementOnG2(Graphics2D gBB) {
        float cX = (float)this.crx / this.scaling;
        float cY = (float)this.cry / this.scaling;
        if (this.displayRotation == 0 || this.displayView != 1) {
            gBB.translate(-cX, cY);
        } else if (this.displayRotation == 90) {
            gBB.translate(-cY, -cX);
        } else if (this.displayRotation == 180) {
            gBB.translate(cX, -cY);
        } else if (this.displayRotation == 270) {
            gBB.translate(cY, cX);
        }
    }

    @Override
    public void refreshDisplay() {
        this.screenNeedsRedrawing = true;
        this.accleratedPagesAlreadyDrawn.clear();
        this.overRideAcceleration = false;
    }

    @Override
    public void init(float scaling, int displayRotation, int pageNumber, DynamicVectorRenderer currentDisplay, boolean isInit) {
        this.pageData = this.pdf.getPdfPageData();
        super.init(scaling, displayRotation, pageNumber, currentDisplay, isInit);
        this.volatileWidth = this.pageData.getScaledCropBoxWidth(pageNumber);
        this.volatileHeight = this.pageData.getScaledCropBoxHeight(pageNumber);
    }

    @Override
    public void setPageOffsets() {
        AcroRenderer acro = this.pdf.getFormRenderer();
        if (this.displayView == 1) {
            this.multiDisplayOptions.setReachedToNull();
            if (acro != null) {
                acro.getCompData().setPageDisplacements(null, null);
            }
            return;
        }
        super.setPageOffsets();
        if (acro != null) {
            acro.getCompData().setPageDisplacements(this.multiDisplayOptions.getxReached(), this.multiDisplayOptions.getyReached());
        }
    }

    private void resetToDefaultClip() {
        if (this.current2 != null) {
            this.g2.setTransform(this.current2);
        }
        if (this.currentClip != null) {
            this.g2.setClip(this.currentClip);
        }
    }

    void initRenderer(TextLines lines, Graphics2D g2) {
        this.rawAf = g2.getTransform();
        if (lines.hasHighlightAreasUpdated()) {
            this.lastAreasPainted = -2;
        }
        this.areas = lines.getAllHighlights();
        this.g2 = g2;
        this.setPageSize(this.pageNumber, this.scaling);
        g2.translate(this.insetW - this.crx, this.insetH - this.cry);
        this.current2 = g2.getTransform();
        this.currentClip = g2.getClip();
        g2.clip(new Rectangle(this.crx, this.cry, this.crw, this.crh));
    }

    Rectangle calcVisibleArea(int topY, int topX) {
        Rectangle userAnnot;
        int x = 0;
        int y = 0;
        this.getDisplayedRectangle();
        if (this.displayRotation != 270 && this.displayRotation != 180 && this.rx > this.insetW) {
            x = (int)((float)(this.rx - this.insetW) / this.scaling);
        }
        int w = (int)((float)(this.rw + this.insetW) / this.scaling);
        int h = topY;
        if (this.displayRotation == 0 || this.displayView != 1) {
            x = 0;
            if (this.rx >= this.insetW) {
                x = (int)((float)this.rx / this.scaling) - (int)((float)this.insetW / this.scaling);
            }
            h = (int)((float)(this.rh + this.insetH) / this.scaling);
            w = (int)((float)(this.rw - this.insetW) / this.scaling) + (int)((float)this.insetW / this.scaling);
            y = (int)((float)topY - (float)(this.ry + this.rh) / this.scaling);
        } else if (this.displayRotation == 90) {
            y = (int)((float)(this.rx - this.insetW) / this.scaling);
            h = (int)((float)(this.rw + this.insetW) / this.scaling);
            x = this.ry > this.insetW ? (int)((float)(this.ry - this.insetW) / this.scaling) : 0;
            w = (int)((float)this.rh / this.scaling);
        } else if (this.displayRotation == 270) {
            w = (int)((float)(this.rh + this.insetW) / this.scaling);
            x = topX - (int)((float)(this.ry + this.rh) / this.scaling);
            h = (int)((float)(this.rw + this.insetH) / this.scaling);
            y = topY - (int)((float)(this.rx + this.rw) / this.scaling);
            if (x < this.insetH) {
                x = 0;
                w += this.insetH;
            }
            if (y < this.insetW) {
                y = 0;
                h += this.insetW;
            }
        } else if (this.displayRotation == 180) {
            h = (int)((float)(this.rh + this.insetH) / this.scaling) + this.insetH;
            y = (int)((float)(this.ry - this.insetH) / this.scaling);
            w = (int)((float)(this.rw + this.insetW) / this.scaling);
            x = topX - (int)((float)(this.rx - this.insetW) / this.scaling);
            if ((x -= w) < 0 || x < this.insetH) {
                x = 0;
                w += this.insetH;
            }
            if (y < this.insetW) {
                y = 0;
                h += this.insetW;
            }
        }
        if (this.isAccelerated() || this.scaling >= 2.0f) {
            int dx1 = this.pageData.getScaledCropBoxX(this.pageNumber);
            int dy1 = this.pageData.getScaledCropBoxY(this.pageNumber);
            int gap = 2;
            userAnnot = dx1 != 0 || dy1 != 0 ? new Rectangle(x + (int)((float)dx1 / this.scaling), y + (int)((float)dy1 / this.scaling), w, h) : new Rectangle(x, y, w + (gap + gap), h + (gap + gap));
        } else {
            userAnnot = null;
        }
        return userAnnot;
    }

    void drawPage(AffineTransform viewScaling, AffineTransform displayScaling) {
        if (displayScaling != null && this.currentDisplay != null) {
            if (this.scaling < 2.0f && this.oldScaling > 2.0f) {
                this.useAcceleration = true;
            }
            if (this.useAcceleration || this.areas != null) {
                int areasPainted = -1;
                if (this.areas != null) {
                    areasPainted = this.areas.size();
                }
                if ((this.lastAreasPainted != -2 || areasPainted != -1) && areasPainted != this.lastAreasPainted) {
                    this.screenNeedsRedrawing = true;
                    this.lastAreasPainted = areasPainted;
                }
            }
            boolean canDrawAccelerated = false;
            if (this.useAcceleration && !this.overRideAcceleration && (this.ignoreScalingForAcceleration || this.scaling < 2.0f)) {
                canDrawAccelerated = this.testAcceleratedRendering();
            } else {
                this.useAcceleration = false;
            }
            Rectangle userAnnot = null;
            if (!this.isAccelerated() && (userAnnot = this.calcVisibleArea((int)((float)this.topH / this.scaling), (int)((float)this.topW / this.scaling))) != null) {
                userAnnot.setRect(userAnnot.x + 1, userAnnot.y + 1, userAnnot.width - 2, userAnnot.height - 2);
            }
            this.currentDisplay.setScalingValues(this.cropH + this.cropY, this.scaling);
            this.g2.transform(displayScaling);
            if (canDrawAccelerated) {
                Graphics2D gBB = (Graphics2D)this.backBuffer.getGraphics();
                AffineTransform originalTransform = gBB.getTransform();
                do {
                    GraphicsEnvironment environment;
                    GraphicsConfiguration graphicsConfig;
                    int valCode;
                    if ((valCode = this.backBuffer.validate(graphicsConfig = (environment = GraphicsEnvironment.getLocalGraphicsEnvironment()).getDefaultScreenDevice().getDefaultConfiguration())) == 2 || valCode == 1) {
                        this.screenNeedsRedrawing = true;
                    }
                    if (this.screenNeedsRedrawing) {
                        this.currentDisplay.setG2(gBB);
                        gBB.transform(displayScaling);
                        this.setDisplacementOnG2(gBB);
                        this.currentDisplay.writeCustom(41, new Rectangle(this.pageData.getCropBoxX(this.pageNumber), this.pageData.getCropBoxY(this.pageNumber), this.pageData.getCropBoxWidth(this.pageNumber), this.pageData.getCropBoxHeight(this.pageNumber)));
                        this.currentDisplay.paint(null, viewScaling, userAnnot);
                    }
                    gBB.setTransform(originalTransform);
                } while (this.backBuffer.contentsLost());
                if (this.backBuffer != null) {
                    AffineTransform affBefore = this.g2.getTransform();
                    this.g2.setTransform(this.rawAf);
                    this.g2.drawImage(this.backBuffer, this.insetW, this.insetH, this.pdf);
                    this.g2.setTransform(affBefore);
                }
                gBB.dispose();
            } else {
                this.currentDisplay.setG2(this.g2);
                this.currentDisplay.paint(null, viewScaling, userAnnot);
            }
            this.oldScaling = this.scaling;
            this.oldRotation = this.displayRotation;
        }
    }

    @Override
    public void paintPage(Graphics2D g2, AcroRenderer formRenderer, TextLines textLines) {
        if (this.displayScaling == null) {
            return;
        }
        int insetW = this.options.getInsetW();
        int pageCount = this.pageData.getPageCount();
        g2.translate(this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY());
        int start = this.pageNumber;
        int end = this.pageNumber;
        if (this.displayView != 1) {
            start = this.getStartPage();
            end = this.getEndPage();
            if (start == 0 || end == 0 || this.lastEnd != end || this.lastStart != start) {
                this.lastFormPage = -1;
            }
            this.lastEnd = end;
            this.lastStart = start;
        }
        if (this.lastFormPage != this.pageNumber && formRenderer != null) {
            formRenderer.displayComponentsOnscreen(start, end);
            if (formRenderer.getCompData().hasformsOnPageDecoded(this.pageNumber)) {
                this.lastFormPage = this.pageNumber;
            }
        }
        if (this.pdf.getPageAlignment() == 2) {
            this.handleCenteredPage(g2, formRenderer, insetW, pageCount);
        } else if (formRenderer != null && this.currentOffset != null) {
            this.lastIndent = -1;
            formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.indent, this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), this.displayView, this.currentOffset.getWidestPageNR(), this.currentOffset.getWidestPageR());
            formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.indent);
        }
        this.initRenderer(textLines, g2);
        this.drawPage(this.viewScaling, this.displayScaling);
        if (this.pdf.getDisplayView() == 2 && this.pdf.getDisplayView() == 3 || this.displayView == 1) {
            if (this.viewScaling != null) {
                g2.transform(this.viewScaling);
            }
            this.resetToDefaultClip();
        }
        if (this.pdf.isOpen() && this.displayView == 1) {
            SwingHelper.scaleDisplay(g2, this.crx, this.cry, this.crw, this.crh);
        }
    }

    private void handleCenteredPage(Graphics2D g2, AcroRenderer formRenderer, int insetW, int pageCount) {
        double width = this.pdf.getBounds().getWidth();
        int pdfWidth = this.pdf.getPDFWidth();
        if (this.displayView != 1) {
            pdfWidth = this.getPageSize(this.displayView)[0];
        }
        if (this.displayView == 4) {
            int page = this.pageNumber;
            if (this.getBoolean(Display.BoolValue.SEPARATE_COVER) && (page & 1) == 1) {
                --page;
            } else if (!this.getBoolean(Display.BoolValue.SEPARATE_COVER) && (page & 1) == 0) {
                --page;
            }
            int firstW = 0;
            if (page != 0) {
                firstW = (this.displayRotation + this.pageData.getRotation(page)) % 180 == 90 ? this.pageData.getCropBoxHeight(page) : this.pageData.getCropBoxWidth(page);
            }
            int secondW = page + 1 > pageCount ? firstW : ((this.displayRotation + this.pageData.getRotation(page + 1)) % 180 == 90 ? this.pageData.getCropBoxHeight(page + 1) : this.pageData.getCropBoxWidth(page + 1));
            if (page == 0) {
                firstW = secondW;
            }
            int pageGap = 0;
            if (!this.getBoolean(Display.BoolValue.TURNOVER_ON) || this.pageData.hasMultipleSizes() || pageCount == 2) {
                pageGap = 5;
            }
            this.indent = (width - (double)((float)(firstW + secondW) * this.scaling)) / 2.0 - (double)pageGap - (double)insetW;
        } else {
            this.indent = (width - (double)pdfWidth) / 2.0;
        }
        if (this.displayView == 1) {
            this.lastIndent = (int)this.indent;
        } else if (this.displayView == 2 && this.lastIndent != -1) {
            this.indent = this.lastIndent;
            this.lastIndent = -1;
        } else {
            this.lastIndent = -1;
        }
        g2.translate(this.indent, 0.0);
        if (formRenderer != null && this.currentOffset != null) {
            formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.indent, this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), this.displayView, this.currentOffset.getWidestPageNR(), this.currentOffset.getWidestPageR());
            formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.indent);
        }
    }

    public void setCursorBoxOnScreen(int[] cursorBoxOnScreen, boolean isSamePage) {
        this.cursorBoxOnScreen = cursorBoxOnScreen;
        AcroRenderer formRenderer = this.pdf.getFormRenderer();
        if (!isSamePage && formRenderer != null) {
            formRenderer.removeDisplayComponentsFromScreen();
            this.lastFormPage = -1;
        }
    }

    @Override
    public int[] getCursorBoxOnScreenAsArray() {
        return this.cursorBoxOnScreen;
    }

    @Override
    public void updateCursorBoxOnScreen(int[] newOutlineRectangle, int outlineColor, int pageNumber, int x_size, int y_size) {
        if (this.displayView != 1 && this.getPageSize(this.displayView)[0] == 0 && this.getPageSize(this.displayView)[1] == 0) {
            return;
        }
        if (newOutlineRectangle != null) {
            int diff;
            int x = newOutlineRectangle[0];
            int y = newOutlineRectangle[1];
            int w = newOutlineRectangle[2];
            int h = newOutlineRectangle[3];
            int cropX = this.pageData.getCropBoxX(pageNumber);
            int cropY = this.pageData.getCropBoxY(pageNumber);
            int cropW = this.pageData.getCropBoxWidth(pageNumber);
            int cropH = this.pageData.getCropBoxHeight(pageNumber);
            if (y > 0 && y < cropY) {
                y += cropY;
            }
            if (x < cropX) {
                diff = cropX - x;
                w -= diff;
                x = cropX;
            }
            if (y < cropY) {
                diff = cropY - y;
                h -= diff;
                y += diff;
            }
            if (x + w > cropW + cropX) {
                w = cropX + cropW - x;
            }
            if (y + h > cropY + cropH) {
                h = cropY + cropH - y;
            }
            this.cursorBoxOnScreen = new int[]{x, y, w, h};
        } else {
            this.cursorBoxOnScreen = null;
        }
        int strip = 30;
        int dx = 0;
        if (this.pdf.getPageAlignment() == 2) {
            int width = this.pdf.getBounds().width;
            int pdfWidth = this.pdf.getPDFWidth();
            if (this.displayView != 1) {
                pdfWidth = this.getPageSize(this.displayView)[0];
            }
            dx = (width - pdfWidth) / 2;
        }
        RepaintManager currentManager = RepaintManager.currentManager(this.pdf);
        if (this.lastCursorBoxOnScreen != null) {
            if (this.pdf.getDisplayRotation() == 0 || this.pdf.getDisplayRotation() == 180) {
                currentManager.addDirtyRegion(this.pdf, this.insetW + dx, this.insetH, x_size + 5, y_size);
            } else {
                currentManager.addDirtyRegion(this.pdf, this.insetH + dx, this.insetW, y_size + 5, x_size);
            }
            this.lastCursorBoxOnScreen = null;
        }
        if (this.cursorBoxOnScreen != null) {
            currentManager.addDirtyRegion(this.pdf, (int)((float)this.cursorBoxOnScreen[0] * this.scaling) - 30, (int)((float)(this.pageData.getMediaBoxHeight(pageNumber) - this.cursorBoxOnScreen[1] - this.cursorBoxOnScreen[3]) * this.scaling) - 30, (int)((float)this.cursorBoxOnScreen[2] * this.scaling) + 30 + 30, (int)((float)this.cursorBoxOnScreen[3] * this.scaling) + 30 + 30);
        }
        if (this.viewScaling != null) {
            currentManager.markCompletelyDirty(this.pdf);
        }
        this.pdf.repaint();
    }

    @Override
    public void setPageRotation(int newRotation) {
        super.setPageRotation(newRotation);
        this.displayScaling = new AffineTransform(this.displayScalingDbl);
        this.viewScaling = null;
    }

    @Override
    public void drawFacing(Rectangle visibleRect) {
    }

    @Override
    public void disableScreen() {
        super.disableScreen();
        this.lastFormPage = -1;
    }
}

