/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    GenericColorSpace altCS;
    ColorMapping colorMapper;
    float[] domain;

    SeparationColorSpace() {
    }

    SeparationColorSpace(ColorMapping colorMapper, float[] domain, GenericColorSpace altCS) {
        this.colorMapper = colorMapper;
        this.domain = domain;
        this.altCS = altCS;
        this.componentCount = 1;
        this.setType(-2073385820);
    }

    private void setColor(float value) {
        int elements = 1;
        if (this.domain != null) {
            elements = this.domain.length / 2;
        }
        float[] values = new float[elements];
        for (int j = 0; j < elements; ++j) {
            values[j] = value;
        }
        float[] operand = this.colorMapper.getOperandFloat(values);
        this.altCS.setColor(operand);
    }

    @Override
    public void setColor(float[] operand) {
        if (this.getIndexedMap() != null) {
            operand = this.flattenIndexedValue(operand);
        }
        this.setColor(operand[0]);
    }

    @Override
    public void invalidateCaching(int color) {
        super.invalidateCaching(color);
        this.altCS.invalidateCaching(color);
        this.altCS.setColor(new PdfColor(color));
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image;
        try {
            image = this.createImage(w, h, data);
        }
        catch (Exception ee) {
            image = null;
            LogWriter.writeLog("Couldn't convert Separation colorspace data: " + ee);
        }
        return image;
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] rgb, int w, int h) {
        int pixelCount = 3 * w * h;
        byte[] imageData = new byte[pixelCount];
        int inpLen = this.domain.length / 2;
        if (inpLen == 1) {
            float last = -1.0f;
            int p = 0;
            int pp = 0;
            int ii = w * h;
            for (int i = 0; i < ii; ++i) {
                float cur;
                if (last != (cur = (float)(rgb[p++] & 0xFF) / 255.0f)) {
                    float[] operand = this.colorMapper.getOperandFloat(new float[]{cur});
                    this.altCS.setColor(operand);
                }
                int tt = this.altCS.getColor().getRGB();
                imageData[pp++] = (byte)(tt >> 16 & 0xFF);
                imageData[pp++] = (byte)(tt >> 8 & 0xFF);
                imageData[pp++] = (byte)(tt & 0xFF);
                last = cur;
            }
        } else {
            float[] inputs = new float[inpLen];
            int p = 0;
            int pp = 0;
            int ii = w * h;
            for (int i = 0; i < ii; ++i) {
                for (int j = 0; j < inpLen; ++j) {
                    inputs[j] = (float)(rgb[p++] & 0xFF) / 255.0f;
                }
                float[] operand = this.colorMapper.getOperandFloat(inputs);
                this.altCS.setColor(operand);
                int tt = this.altCS.getColor().getRGB();
                imageData[pp++] = (byte)(tt >> 16 & 0xFF);
                imageData[pp++] = (byte)(tt >> 8 & 0xFF);
                imageData[pp++] = (byte)(tt & 0xFF);
            }
        }
        return imageData;
    }

    BufferedImage createImage(int w, int h, byte[] rgb) {
        byte[] imageData = this.dataToRGBByteArray(rgb, w, h);
        BufferedImage image = new BufferedImage(w, h, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(imageData, w, h);
        image.setData(raster);
        return image;
    }

    @Override
    public byte[] convertIndexToRGB(byte[] data) {
        byte[] newdata = new byte[768];
        int inpLen = this.domain.length / 2;
        int palLen = data.length / inpLen;
        float[] inputs = new float[inpLen];
        int p = 0;
        int pp = 0;
        int ii = Math.min(256, palLen);
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < inpLen; ++j) {
                inputs[j] = (float)(data[p++] & 0xFF) / 255.0f;
            }
            float[] operand = this.colorMapper.getOperandFloat(inputs);
            this.altCS.setColor(operand);
            int tt = this.altCS.getColor().getRGB();
            newdata[pp++] = (byte)(tt >> 16 & 0xFF);
            newdata[pp++] = (byte)(tt >> 8 & 0xFF);
            newdata[pp++] = (byte)(tt & 0xFF);
        }
        return newdata;
    }

    @Override
    public PdfPaint getColor() {
        return this.altCS.getColor();
    }
}

