/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.webp.data;

import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import com.idrsolutions.image.utility.WriterByteLittle;
import com.idrsolutions.image.webp.data.BitEncoder;
import com.idrsolutions.image.webp.data.EBool;
import com.idrsolutions.image.webp.data.EQuantizer;
import com.idrsolutions.image.webp.data.LBuffer;
import com.idrsolutions.image.webp.data.LookUp;
import com.idrsolutions.image.webp.data.Picture;
import com.idrsolutions.image.webp.data.Transform;
import com.idrsolutions.image.webp.data.Util;
import com.idrsolutions.image.webp.data.WebpYUV;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class EVP8 {
    private BitEncoder bitstream;
    private byte[][] leftRow;
    private byte[][] topLine;
    private final int[] tmp = new int[16];

    public static void encode(BufferedImage bImg, OutputStream out, int qp) throws IOException {
        int len;
        LBuffer buf;
        EVP8 enc = new EVP8();
        Picture pic = EVP8.getPictureFromBuffer(bImg);
        int frameSize = enc.encodeFrame(pic, buf = new LBuffer(new byte[len = Math.max(512, bImg.getWidth() * bImg.getHeight() * 3)]), qp);
        int frameAdd = frameSize % 2 != 0 ? frameSize + 1 : frameSize;
        byte[] temp = new byte[frameAdd];
        System.arraycopy(buf.data, 0, temp, 0, frameAdd);
        byte[] data = new byte[20 + frameAdd];
        WriterByteLittle endian = new WriterByteLittle(data);
        endian.write("RIFF".getBytes());
        endian.putU32(data.length - 8);
        endian.write("WEBP".getBytes());
        endian.write("VP8 ".getBytes());
        endian.putU32(frameAdd);
        endian.write(temp);
        out.write(data);
    }

    private static Picture getPictureFromBuffer(BufferedImage img) {
        int b;
        int g;
        int r;
        int p;
        int x;
        int y;
        int w = img.getWidth() % 2 == 0 ? img.getWidth() : img.getWidth() - 1;
        int h = img.getHeight() % 2 == 0 ? img.getHeight() : img.getHeight() - 1;
        int dim = w * h;
        int strideC = (w + 1) / 2;
        int ch = (h + 1) / 2;
        byte[][] data = new byte[][]{new byte[dim], new byte[ch * strideC], new byte[ch * strideC]};
        PixGet pg = Access.getPixGet(img);
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                p = pg.getRGB(x, y);
                r = p >> 16 & 0xFF;
                g = p >> 8 & 0xFF;
                b = p & 0xFF;
                data[0][y * w + x] = (byte)((128 + 66 * r + 129 * g + 25 * b >> 8) - 112);
            }
        }
        for (y = 0; y < h; y += 2) {
            for (x = 0; x < w; x += 2) {
                p = pg.getRGB(x, y);
                r = p >> 16 & 0xFF;
                g = p >> 8 & 0xFF;
                b = p & 0xFF;
                p = y / 2 * strideC + x / 2;
                data[1][p] = (byte)(128 - 38 * r - 74 * g + 112 * b >> 8);
                data[2][p] = (byte)(128 + 112 * r - 94 * g - 18 * b >> 8);
            }
        }
        return new Picture(w, h, data, WebpYUV.YUV420, new Rectangle(w, h));
    }

    private EVP8() {
    }

    private int encodeFrame(Picture pic, LBuffer out, int qp) {
        int mbWidth = pic.width + 15 >> 4;
        int mbHeight = pic.height + 15 >> 4;
        this.bitstream = new BitEncoder(mbWidth);
        this.leftRow = new byte[][]{new byte[16], new byte[8], new byte[8]};
        this.topLine = new byte[][]{new byte[mbWidth << 4], new byte[mbWidth << 3], new byte[mbWidth << 3]};
        EVP8.initValue(this.leftRow, (byte)-127);
        EVP8.initValue(this.topLine, (byte)127);
        Picture outMB = Picture.create();
        EVP8.writeHeader1(out, pic.width, pic.height);
        int start = out.position();
        EBool boolEnc = new EBool(out);
        EVP8.writeHeader2(boolEnc, qp);
        for (int mbY = 0; mbY < mbHeight; ++mbY) {
            for (int mbX = 0; mbX < mbWidth; ++mbX) {
                boolEnc.writeBit(145, 1);
                boolEnc.writeBit(156, 0);
                boolEnc.writeBit(163, 0);
                boolEnc.writeBit(142, 0);
            }
        }
        boolEnc.stop();
        int firstPart = out.position() - start;
        boolEnc = new EBool(out);
        for (int mbY = 0; mbY < mbHeight; ++mbY) {
            EVP8.initValue(this.leftRow, (byte)-127);
            for (int mbX = 0; mbX < mbWidth; ++mbX) {
                this.luma(pic, mbX, mbY, boolEnc, qp, outMB);
                this.chroma(pic, mbX, mbY, boolEnc, qp, outMB);
                this.collectPredictors(outMB, mbX);
            }
        }
        boolEnc.stop();
        int length = out.position();
        out.position(0);
        EVP8.writeHeader(out, firstPart);
        out.position(length);
        return length;
    }

    private static void writeHeader(LBuffer duplicate, int firstPart) {
        boolean showFrame = true;
        int header = firstPart << 5 | 0x10;
        duplicate.put((byte)(header & 0xFF));
        duplicate.put((byte)(header >> 8 & 0xFF));
        duplicate.put((byte)(header >> 16 & 0xFF));
    }

    private static void writeHeader1(LBuffer out, int width, int height) {
        out.put(new byte[]{0, 0, 0});
        out.put((byte)-99);
        out.put((byte)1);
        out.put((byte)42);
        out.putShort((short)width);
        out.putShort((short)height);
    }

    private static void initValue(byte[][] leftRow2, byte val) {
        Arrays.fill(leftRow2[0], val);
        Arrays.fill(leftRow2[1], val);
        Arrays.fill(leftRow2[2], val);
    }

    private static void writeHeader2(EBool boolEnc, int qp) {
        int[][][][] probFlags;
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        EVP8.writeInt(boolEnc, 1, 6);
        EVP8.writeInt(boolEnc, 0, 3);
        boolEnc.writeBit(128, 0);
        EVP8.writeInt(boolEnc, 0, 2);
        EVP8.writeInt(boolEnc, qp, 7);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        boolEnc.writeBit(128, 0);
        int[][][][] nArray = probFlags = LookUp.tokenProbUpdateFlagProbs;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[][][] probFlag;
            int[][][] nArray2 = probFlag = nArray[i];
            int n2 = nArray2.length;
            for (int j = 0; j < n2; ++j) {
                int[][] ints;
                int[][] nArray3 = ints = nArray2[j];
                int n3 = nArray3.length;
                for (int k = 0; k < n3; ++k) {
                    int[] anInt;
                    for (int i2 : anInt = nArray3[k]) {
                        boolEnc.writeBit(i2, 0);
                    }
                }
            }
        }
        boolEnc.writeBit(128, 0);
    }

    private static void writeInt(EBool boolEnc, int data, int bits) {
        for (int bit = bits - 1; bit >= 0; --bit) {
            boolEnc.writeBit(128, 1 & data >> bit);
        }
    }

    private void collectPredictors(Picture outMB, int mbX) {
        System.arraycopy(outMB.getPlaneData(0), 240, this.topLine[0], mbX << 4, 16);
        System.arraycopy(outMB.getPlaneData(1), 56, this.topLine[1], mbX << 3, 8);
        System.arraycopy(outMB.getPlaneData(2), 56, this.topLine[2], mbX << 3, 8);
        EVP8.copyCol(outMB.getPlaneData(0), 15, 16, this.leftRow[0]);
        EVP8.copyCol(outMB.getPlaneData(1), 7, 8, this.leftRow[1]);
        EVP8.copyCol(outMB.getPlaneData(2), 7, 8, this.leftRow[2]);
    }

    private static void copyCol(byte[] planeData, int off, int stride, byte[] out) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = planeData[off];
            off += stride;
        }
    }

    private void luma(Picture pic, int mbX, int mbY, EBool out, int qp, Picture outMB) {
        int x = mbX << 4;
        int y = mbY << 4;
        int[][] ac = this.transform(pic, qp, x, y);
        int[] dc = EVP8.extractDC(ac);
        this.writeLumaDC(mbX, out, qp, dc);
        this.writeLumaAC(mbX, out, ac, qp);
        EVP8.restorePlaneLuma(dc, ac, qp);
        EVP8.putLuma(outMB.getPlaneData(0), this.lumaDCPred(x, y), ac);
    }

    private void writeLumaAC(int mbX, EBool out, int[][] ac, int qp) {
        for (int i = 0; i < 16; ++i) {
            EQuantizer.quantizeY(ac[i], qp);
            this.bitstream.encodeCoeffsDCT15(out, EVP8.zigzag(ac[i], this.tmp), mbX, i & 3, i >> 2);
        }
    }

    private void writeLumaDC(int mbX, EBool out, int qp, int[] dc) {
        Transform.walsh4x4(dc);
        EQuantizer.quantizeY2(dc, qp);
        this.bitstream.encodeCoeffsWHT(out, EVP8.zigzag(dc, this.tmp), mbX);
    }

    private void writeChroma(int comp, int mbX, EBool boolEnc, int[][] ac, int qp) {
        for (int i = 0; i < 4; ++i) {
            EQuantizer.quantizeUV(ac[i], qp);
            this.bitstream.encodeCoeffsDCTUV(boolEnc, EVP8.zigzag(ac[i], this.tmp), comp, mbX, i & 1, i >> 1);
        }
    }

    private static int[] zigzag(int[] zz, int[] tmp2) {
        for (int i = 0; i < 16; ++i) {
            tmp2[i] = zz[LookUp.ZIGZAGS[i]];
        }
        return tmp2;
    }

    private void chroma(Picture pic, int mbX, int mbY, EBool boolEnc, int qp, Picture outMB) {
        int x = mbX << 3;
        int y = mbY << 3;
        byte chromaPred1 = this.chromaPredBlk(1, x, y);
        byte chromaPred2 = this.chromaPredBlk(2, x, y);
        int[][] ac1 = EVP8.transformChroma(pic, 1, qp, x, y, outMB, chromaPred1);
        int[][] ac2 = EVP8.transformChroma(pic, 2, qp, x, y, outMB, chromaPred2);
        this.writeChroma(1, mbX, boolEnc, ac1, qp);
        this.writeChroma(2, mbX, boolEnc, ac2, qp);
        EVP8.restorePlaneChroma(ac1, qp);
        EVP8.putChroma(outMB.data[1], x, y, ac1, chromaPred1);
        EVP8.restorePlaneChroma(ac2, qp);
        EVP8.putChroma(outMB.data[2], x, y, ac2, chromaPred2);
    }

    private static int[][] transformChroma(Picture pic, int comp, int qp, int x, int y, Picture outMB, int chromaPred) {
        int[][] ac = new int[4][16];
        for (int blk = 0; blk < ac.length; ++blk) {
            int blkOffX = (blk & 1) << 2;
            int blkOffY = blk >> 1 << 2;
            EVP8.takeSubtract(pic.getPlaneData(comp), pic.getPlaneWidth(comp), pic.getPlaneHeight(comp), x + blkOffX, y + blkOffY, ac[blk], chromaPred);
            Transform.fdct4x4(ac[blk]);
        }
        return ac;
    }

    private static void putChroma(byte[] mb, int x, int y, int[][] ac, int chromaPred) {
        for (int blk = 0; blk < 4; ++blk) {
            EVP8.putBlk(mb, chromaPred, ac[blk], 3, (blk & 1) << 2, blk >> 1 << 2);
        }
    }

    private static byte chromaPredOne(byte[] pix, int x) {
        return (byte)(pix[x] + pix[x + 1] + pix[x + 2] + pix[x + 3] + pix[x + 4] + pix[x + 5] + pix[x + 6] + pix[x + 7] + 4 >> 3);
    }

    private static byte chromaPredTwo(byte[] pix1, byte[] pix2, int x, int y) {
        return (byte)(pix1[x] + pix1[x + 1] + pix1[x + 2] + pix1[x + 3] + pix1[x + 4] + pix1[x + 5] + pix1[x + 6] + pix1[x + 7] + pix2[y] + pix2[y + 1] + pix2[y + 2] + pix2[y + 3] + pix2[y + 4] + pix2[y + 5] + pix2[y + 6] + pix2[y + 7] + 8 >> 4);
    }

    private byte chromaPredBlk(int comp, int x, int y) {
        int predY = y & 7;
        if (x != 0 && y != 0) {
            return EVP8.chromaPredTwo(this.leftRow[comp], this.topLine[comp], predY, x);
        }
        if (x != 0) {
            return EVP8.chromaPredOne(this.leftRow[comp], predY);
        }
        if (y != 0) {
            return EVP8.chromaPredOne(this.topLine[comp], x);
        }
        return 0;
    }

    private static void putLuma(byte[] planeData, int pred, int[][] ac) {
        for (int blk = 0; blk < ac.length; ++blk) {
            int blkOffX = (blk & 3) << 2;
            int blkOffY = blk & 0xFFFFFFFC;
            EVP8.putBlk(planeData, pred, ac[blk], 4, blkOffX, blkOffY);
        }
    }

    private static void putBlk(byte[] planeData, int pred, int[] block, int log2stride, int blkX, int blkY) {
        int stride = 1 << log2stride;
        int[] lastVal = new int[4];
        for (int pos = 0; pos < 4; ++pos) {
            lastVal[pos] = block[pos] - 1;
        }
        byte[] vals = new byte[4];
        int srcOff = 0;
        int dstOff = (blkY << log2stride) + blkX;
        for (int line = 0; line < 4; ++line) {
            for (int pos = 0; pos < 4; ++pos) {
                if (lastVal[pos] != block[srcOff + pos]) {
                    lastVal[pos] = block[srcOff + pos];
                    vals[pos] = (byte)Util.clip(block[srcOff + pos] + pred);
                }
                planeData[dstOff + pos] = vals[pos];
            }
            srcOff += 4;
            dstOff += stride;
        }
    }

    private static void restorePlaneChroma(int[][] ac, int qp) {
        for (int i = 0; i < 4; ++i) {
            EQuantizer.dequantUV(ac[i], qp);
            Transform.idct4x4(ac[i]);
        }
    }

    private static void restorePlaneLuma(int[] dc, int[][] ac, int qp) {
        EQuantizer.dequantY2(dc, qp);
        Transform.iwalsh4x4(dc);
        for (int i = 0; i < 16; ++i) {
            EQuantizer.dequantY(ac[i], qp);
            ac[i][0] = dc[i];
            Transform.idct4x4(ac[i]);
        }
    }

    private static int[] extractDC(int[][] ac) {
        int[] dc = new int[ac.length];
        for (int i = 0; i < ac.length; ++i) {
            dc[i] = ac[i][0];
        }
        return dc;
    }

    private byte lumaDCPred(int x, int y) {
        if (x == 0 && y == 0) {
            return 0;
        }
        if (y == 0) {
            return (byte)(Util.sumByte(this.leftRow[0]) + 8 >> 4);
        }
        if (x == 0) {
            return (byte)(Util.sumByte3(this.topLine[0], 0) + 8 >> 4);
        }
        return (byte)(Util.sumByte(this.leftRow[0]) + Util.sumByte3(this.topLine[0], x) + 16 >> 5);
    }

    private int[][] transform(Picture pic, int qp, int x, int y) {
        byte dcc = this.lumaDCPred(x, y);
        int[][] ac = new int[16][16];
        for (int i = 0; i < ac.length; ++i) {
            int[] coeff = ac[i];
            int blkOffX = (i & 3) << 2;
            int blkOffY = i & 0xFFFFFFFC;
            EVP8.takeSubtract(pic.getPlaneData(0), pic.getPlaneWidth(0), pic.getPlaneHeight(0), x + blkOffX, y + blkOffY, coeff, dcc);
            Transform.fdct4x4(coeff);
        }
        return ac;
    }

    private static void takeSubtract(byte[] planeData, int planeWidth, int planeHeight, int x, int y, int[] coeff, int dc) {
        if (x + 4 < planeWidth && y + 4 < planeHeight) {
            EVP8.takeSubtractSafe(planeData, planeWidth, x, y, coeff, dc);
        } else {
            EVP8.takeSubtractUnsafe(planeData, planeWidth, planeHeight, x, y, coeff, dc);
        }
    }

    private static void takeSubtractSafe(byte[] planeData, int planeWidth, int x, int y, int[] coeff, int dc) {
        int i = 0;
        int srcOff = y * planeWidth + x;
        int dstOff = 0;
        while (i < 4) {
            coeff[dstOff] = planeData[srcOff] - dc;
            coeff[dstOff + 1] = planeData[srcOff + 1] - dc;
            coeff[dstOff + 2] = planeData[srcOff + 2] - dc;
            coeff[dstOff + 3] = planeData[srcOff + 3] - dc;
            ++i;
            srcOff += planeWidth;
            dstOff += 4;
        }
    }

    private static void takeSubtractUnsafe(byte[] planeData, int planeWidth, int planeHeight, int x, int y, int[] coeff, int dc) {
        int j;
        int off;
        int i;
        int outOff = 0;
        for (i = y; i < Math.min(y + 4, planeHeight); ++i) {
            off = i * planeWidth + Math.min(x, planeWidth);
            for (j = x; j < Math.min(x + 4, planeWidth); ++j) {
                coeff[outOff++] = planeData[off++] - dc;
            }
            --off;
            while (j < x + 4) {
                coeff[outOff++] = planeData[off] - dc;
                ++j;
            }
        }
        while (i < y + 4) {
            off = planeHeight * planeWidth - planeWidth + Math.min(x, planeWidth);
            for (j = x; j < Math.min(x + 4, planeWidth); ++j) {
                coeff[outOff++] = planeData[off++] - dc;
            }
            --off;
            while (j < x + 4) {
                coeff[outOff++] = planeData[off] - dc;
                ++j;
            }
            ++i;
        }
    }
}

