/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.util.HashMap;

public enum IFDCompression {
    Uncompressed(1),
    CCITT_ID(2),
    Group_3_Fax(3),
    Group_4_Fax(4),
    LZW(5),
    JPEG(6),
    JPEG_TechNote(7),
    ADOBEDEFLATE(8),
    PackBits(32773),
    Deflate(32946),
    Thunderscan(32809),
    JDELI_UNSUPPORTED(-1);

    final int value;
    private static final HashMap<Integer, IFDCompression> lookup;

    private IFDCompression(int val) {
        this.value = val;
    }

    public static IFDCompression getIFD(int val) {
        IFDCompression key = lookup.get(val);
        if (key == null) {
            return JDELI_UNSUPPORTED;
        }
        return key;
    }

    static {
        lookup = new HashMap();
        for (IFDCompression value : IFDCompression.values()) {
            lookup.put(value.value, value);
        }
    }
}

