/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class Deflate {
    private Deflate() {
    }

    public static byte[] decompress(byte[] compressedData) throws Exception {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedData);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4 * compressedData.length);){
            byte[] buffer = new byte[1024];
            int count = 1024;
            while (!inflater.finished() && count != 0) {
                count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            inflater.end();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] compress(byte[] pixels, int compressionLevel) throws IOException {
        Deflater deflater = new Deflater(compressionLevel);
        deflater.setInput(pixels);
        int min = Math.min(pixels.length / 2, 4096);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(min);){
            deflater.finish();
            byte[] buffer = new byte[min];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            deflater.end();
            outputStream.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

