/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.png.data.BitWriter;
import com.idrsolutions.image.png.data.D3;
import com.idrsolutions.image.png.data.D4;
import com.idrsolutions.image.png.data.PngBitReader;
import com.idrsolutions.image.png.data.PngChunk;
import com.idrsolutions.image.png.data.Quant24;
import com.idrsolutions.image.png.data.Quant32;
import com.idrsolutions.image.png.options.PngCompressionFormat;
import com.idrsolutions.image.png.options.PngEncoderOptions;
import com.idrsolutions.image.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.zip.Deflater;

public class PngEncoder
extends JDeliImage
implements Encoder {
    private PngEncoderOptions pngEncoderOptions = new PngEncoderOptions();

    public PngEncoder(EncoderOptions format) {
        if (format != null) {
            this.pngEncoderOptions = (PngEncoderOptions)format;
        }
    }

    public PngEncoder() {
    }

    @Override
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        PngEncoder.optimiseImage(image);
        BufferedImage img = ImageUtils.fixSubBufferedImage(image);
        if (this.pngEncoderOptions.isOptimizeBasedOnColors()) {
            img = PngEncoder.getColorCountIndexed(img);
        }
        if (this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.QUANTISED8BIT) {
            this.compress8Bit(img, outputStream);
        } else {
            this.compressNormal(img, outputStream);
        }
    }

    public void write(BufferedImage image, File file) throws IOException {
        PngEncoder.optimiseImage(image);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        this.write(image, bos);
        bos.flush();
        bos.close();
    }

    private static BufferedImage getColorCountIndexed(BufferedImage image) {
        int zeroCount;
        int nColors;
        byte[] pixBytes = null;
        int[] pixInts = null;
        int iw = image.getWidth();
        int ih = image.getHeight();
        int count = 0;
        int dim = image.getWidth() * image.getHeight();
        int p = 0;
        int a = 0;
        int[] countMap = new int[255];
        boolean hasBlack = false;
        int nComp = image.getColorModel().getNumComponents();
        switch (image.getType()) {
            case 5: 
            case 6: 
            case 7: {
                int i;
                pixBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (i = 0; i < dim; ++i) {
                    int g;
                    int r;
                    int v;
                    if (nComp == 4) {
                        a = pixBytes[p++] & 0xFF;
                    }
                    int b = pixBytes[p++] & 0xFF;
                    if ((v = a << 24 | (r = pixBytes[p++] & 0xFF) << 16 | (g = pixBytes[p++] & 0xFF) << 8 | b) == 0) {
                        hasBlack = true;
                        continue;
                    }
                    if (count < 255) {
                        if (PngEncoder.checkColorInArray(countMap, count + 1, v)) continue;
                        countMap[count++] = v;
                        continue;
                    }
                    return image;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int i;
                pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (i = 0; i < dim; ++i) {
                    int v = pixInts[i];
                    if (v == 0) {
                        hasBlack = true;
                        continue;
                    }
                    if (count < 255) {
                        if (PngEncoder.checkColorInArray(countMap, count + 1, v)) continue;
                        countMap[count++] = v;
                        continue;
                    }
                    return image;
                }
                break;
            }
            default: {
                return image;
            }
        }
        if ((nColors = count + (zeroCount = hasBlack ? 1 : 0)) <= 256) {
            return PngEncoder.getOptimizedImage(iw, ih, nColors, nComp, pixBytes, pixInts, countMap);
        }
        return image;
    }

    private static boolean checkColorInArray(int[] arr, int max, int color) {
        int temp = arr[0];
        for (int i = 0; i < max; ++i) {
            if (arr[i] != color) continue;
            arr[0] = arr[i];
            arr[i] = temp;
            return true;
        }
        return false;
    }

    private static BufferedImage getOptimizedImage(int iw, int ih, int nColors, int nComp, byte[] pixBytes, int[] pixInts, int[] countMap) {
        int v;
        int a = 0;
        int[] palette = new int[nColors];
        System.arraycopy(countMap, 0, palette, 0, nColors);
        int p = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BitWriter bw = new BitWriter(bos);
        int bps = PngEncoder.getBps(nColors);
        int paletteLen = 1 << bps;
        int gap = 8 - iw * bps % 8;
        for (int y = 0; y < ih; ++y) {
            for (int x = 0; x < iw; ++x) {
                if (pixBytes != null) {
                    if (nComp == 4) {
                        a = pixBytes[p++] & 0xFF;
                    }
                    int b = pixBytes[p++] & 0xFF;
                    int g = pixBytes[p++] & 0xFF;
                    int r = pixBytes[p++] & 0xFF;
                    v = a << 24 | r << 16 | g << 8 | b;
                } else {
                    v = pixInts[p++];
                }
                int f = 0;
                for (int i = 0; i < nColors; ++i) {
                    if (v != palette[i]) continue;
                    f = i;
                    break;
                }
                bw.writeBits(f, bps);
            }
            if (gap == 8) continue;
            bw.writeBits(0, gap);
        }
        bw.end();
        byte[] aa = new byte[paletteLen];
        byte[] rr = new byte[paletteLen];
        byte[] gg = new byte[paletteLen];
        byte[] bb = new byte[paletteLen];
        for (int i = 0; i < nColors; ++i) {
            v = palette[i];
            aa[i] = (byte)(v >> 24 & 0xFF);
            rr[i] = (byte)(v >> 16 & 0xFF);
            gg[i] = (byte)(v >> 8 & 0xFF);
            bb[i] = (byte)(v & 0xFF);
        }
        IndexColorModel cm = nComp == 4 ? new IndexColorModel(bps, paletteLen, rr, gg, bb, aa) : new IndexColorModel(bps, paletteLen, rr, gg, bb);
        BufferedImage img = bps <= 4 ? new BufferedImage(iw, ih, 12, cm) : new BufferedImage(iw, ih, 13, cm);
        byte[] dd = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        System.arraycopy(bos.toByteArray(), 0, dd, 0, dd.length);
        return img;
    }

    private static int getBps(int nColors) {
        int bps;
        switch (nColors) {
            case 1: 
            case 2: {
                bps = 1;
                break;
            }
            case 3: 
            case 4: {
                bps = 2;
                break;
            }
            default: {
                bps = 8;
            }
        }
        return bps;
    }

    @Deprecated
    public boolean isCompressed() {
        return this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.QUANTISED8BIT;
    }

    public PngEncoderOptions getEncoderOptions() {
        return this.pngEncoderOptions;
    }

    public void setEncoderOptions(PngEncoderOptions pngEncoderOptions) {
        this.pngEncoderOptions = pngEncoderOptions;
    }

    @Deprecated
    public void setCompressed(boolean compress) {
        if (compress) {
            this.pngEncoderOptions.setCompressionFormat(PngCompressionFormat.QUANTISED8BIT);
        } else {
            this.pngEncoderOptions.setCompressionFormat(PngCompressionFormat.NONE);
        }
    }

    @Deprecated
    public boolean isOptimizeBasedOnColors() {
        return this.pngEncoderOptions.isOptimizeBasedOnColors();
    }

    @Deprecated
    public void setOptimizeBasedOnColors(boolean optimizeBasedOnColors) {
        this.pngEncoderOptions.setOptimizeBasedOnColors(optimizeBasedOnColors);
    }

    private static BufferedImage fixIndex567(BufferedImage image) {
        if (image.getType() == 13) {
            int pixLen = image.getColorModel().getPixelSize();
            switch (pixLen) {
                case 5: 
                case 6: 
                case 7: {
                    BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 13);
                    result.getGraphics().drawImage(image, 0, 0, null);
                    return result;
                }
            }
        }
        return image;
    }

    private void compressNormal(BufferedImage imageInput, OutputStream outputStream) throws IOException {
        int colType;
        BufferedImage image = PngEncoder.fixIndex567(imageInput);
        int bh = image.getHeight();
        int bw = image.getWidth();
        ColorModel colorModel = image.getColorModel();
        boolean hasAlpha = colorModel.hasAlpha();
        int pLen = colorModel.getPixelSize();
        int nComp = colorModel.getNumComponents();
        boolean isIndexed = colorModel instanceof IndexColorModel;
        int bitDepth = PngEncoder.calculateBitDepth(pLen, nComp);
        if (isIndexed) {
            colType = 3;
            nComp = 1;
        } else {
            colType = nComp < 3 ? (hasAlpha ? 4 : 0) : (bitDepth < 8 ? (hasAlpha ? 4 : 0) : (hasAlpha ? 6 : 2));
        }
        outputStream.write(PngChunk.SIGNATURE);
        PngChunk chunk = PngChunk.createHeaderChunk(bw, bh, (byte)bitDepth, (byte)colType, (byte)0, (byte)0, (byte)0);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        byte[] pixels = isIndexed && bitDepth != 8 ? PngEncoder.getIndexedPaletteData(image) : PngEncoder.getPixelData(image, bitDepth, nComp, bw, bh);
        if (isIndexed) {
            PngEncoder.handleindexed(outputStream, (IndexColorModel)colorModel, bitDepth, pixels);
        }
        if (this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.ZLIB_BETTER_COMPRESSION && bitDepth == 8 && !isIndexed) {
            PngEncoder.adjustFilters(pixels, bw, bh, nComp);
        }
        pixels = this.getDeflatedData(pixels);
        chunk = PngChunk.createDataChunk(pixels);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        chunk = PngChunk.createEndChunk();
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
    }

    private static void adjustFilters(byte[] pixels, int iw, int ih, int nComp) {
        int stripLen = iw * nComp;
        int stripFiltLen = stripLen + 1;
        int matchLoc = 1;
        for (int y = 1; y < ih; ++y) {
            int dataLoc = y * stripFiltLen + 1;
            boolean same = true;
            for (int x = 0; x < stripLen; ++x) {
                if (pixels[dataLoc + x] == pixels[matchLoc + x]) continue;
                same = false;
                break;
            }
            if (same) {
                pixels[dataLoc - 1] = 2;
                Arrays.fill(pixels, dataLoc, dataLoc + stripLen, (byte)0);
                continue;
            }
            matchLoc = dataLoc;
        }
    }

    private static void handleindexed(OutputStream outputStream, IndexColorModel colorModel, int bitDepth, byte[] pixels) throws IOException {
        int indexModelMapSize = colorModel.getMapSize();
        int[] rgbs = new int[indexModelMapSize];
        colorModel.getRGBs(rgbs);
        if (bitDepth == 8) {
            indexModelMapSize = PngEncoder.reduceIndexMap(indexModelMapSize, rgbs, pixels);
        }
        ByteBuffer bb = ByteBuffer.allocate(indexModelMapSize * 3);
        for (int i = 0; i < indexModelMapSize; ++i) {
            int color = rgbs[i];
            bb.put(new byte[]{(byte)(color >> 16), (byte)(color >> 8), (byte)color});
        }
        PngChunk chunk = PngChunk.createPaleteChunk(bb.array());
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        if (colorModel.getNumComponents() == 4) {
            byte[] trnsBytes = new byte[indexModelMapSize];
            for (int i = 0; i < indexModelMapSize; ++i) {
                trnsBytes[i] = (byte)(rgbs[i] >> 24);
            }
            chunk = PngChunk.createTrnsChunk(trnsBytes);
            outputStream.write(chunk.getLength());
            outputStream.write(chunk.getName());
            outputStream.write(chunk.getData());
            outputStream.write(chunk.getCRCValue());
        }
    }

    private static int reduceIndexMap(int indexModelMapSize, int[] rgbs, byte[] pixels) {
        int i;
        int numColors = 0;
        byte[] indexMap = new byte[indexModelMapSize];
        LinkedHashMap<Integer, Integer> colors = new LinkedHashMap<Integer, Integer>();
        for (i = 0; i < indexModelMapSize; ++i) {
            int color = rgbs[i];
            if (!colors.containsKey(color)) {
                indexMap[i] = (byte)numColors;
                colors.put(color, numColors);
                ++numColors;
                continue;
            }
            indexMap[i] = (byte)((Integer)colors.get(color)).intValue();
        }
        if (numColors < indexModelMapSize) {
            for (i = 0; i < pixels.length; ++i) {
                pixels[i] = indexMap[pixels[i] & 0xFF];
            }
            Set colorSet = colors.keySet();
            int temp = 0;
            Iterator iterator = colorSet.iterator();
            while (iterator.hasNext()) {
                int c = (Integer)iterator.next();
                rgbs[temp++] = c;
            }
        }
        return numColors;
    }

    private static boolean isAlphaUsed(byte[] trnsBytes) {
        for (byte trn : trnsBytes) {
            if (trn == -1) continue;
            return true;
        }
        return false;
    }

    private void compress8Bit(BufferedImage image, OutputStream outputStream) throws IOException {
        int type = image.getType();
        int bh = image.getHeight();
        int bw = image.getWidth();
        int dim = bh * bw;
        int[] argb = null;
        int[] rgb = null;
        switch (type) {
            case 5: {
                rgb = PngEncoder.handleType3ByteBGR(image);
                break;
            }
            case 6: 
            case 7: {
                argb = PngEncoder.handleType4ByteABGR(image);
                break;
            }
            case 4: {
                rgb = PngEncoder.handleTypeIntBGR(image);
                break;
            }
            case 2: 
            case 3: {
                argb = PngEncoder.handleTypeIntRGBorARGB(image);
                break;
            }
            case 1: {
                rgb = PngEncoder.handleTypeIntRGBorARGB(image);
                break;
            }
            default: {
                this.compressNormal(image, outputStream);
                return;
            }
        }
        if (argb != null) {
            this.compressARGB(outputStream, bh, bw, dim, argb);
        } else {
            this.compressRGB(outputStream, bh, bw, dim, rgb);
        }
    }

    private void compressRGB(OutputStream outputStream, int bh, int bw, int dim, int[] rgb) throws IOException {
        byte[] colorPalette;
        byte[] qBytes;
        byte[] indexedPixels = new byte[dim + bh];
        Object[] objs = PngEncoder.getIndexedMap(rgb, bw, bh);
        if (objs != null) {
            qBytes = (byte[])objs[0];
            colorPalette = (byte[])objs[1];
        } else {
            Quant24 wu = new Quant24();
            colorPalette = wu.getPalette(rgb, bw, bh);
            qBytes = D3.process(colorPalette, rgb, bh, bw);
        }
        int k = 0;
        int z = 0;
        for (int i = 0; i < bh; ++i) {
            indexedPixels[z++] = 0;
            for (int j = 0; j < bw; ++j) {
                indexedPixels[z++] = qBytes[k++];
            }
        }
        this.writePNGToStream(outputStream, null, colorPalette, indexedPixels, bw, bh);
    }

    private void compressARGB(OutputStream outputStream, int bh, int bw, int dim, int[] argb) throws IOException {
        byte[] trnsBytes;
        byte[] colorPalette;
        byte[] qBytes;
        byte[] indexedPixels = new byte[dim + bh];
        Object[] objs = PngEncoder.getIndexedMap(argb, bw, bh);
        if (objs != null) {
            qBytes = (byte[])objs[0];
            colorPalette = (byte[])objs[1];
            trnsBytes = (byte[])objs[2];
        } else {
            Quant32 wu = new Quant32();
            Object[] obj = wu.getPalette(argb, bw, bh);
            colorPalette = (byte[])obj[0];
            trnsBytes = (byte[])obj[1];
            qBytes = D4.process(colorPalette, trnsBytes, argb, bh, bw);
        }
        if (!PngEncoder.isAlphaUsed(trnsBytes)) {
            trnsBytes = null;
        }
        int k = 0;
        int z = 0;
        for (int i = 0; i < bh; ++i) {
            indexedPixels[z++] = 0;
            for (int j = 0; j < bw; ++j) {
                indexedPixels[z++] = qBytes[k++];
            }
        }
        this.writePNGToStream(outputStream, trnsBytes, colorPalette, indexedPixels, bw, bh);
    }

    private static int[] handleTypeIntRGBorARGB(BufferedImage image) {
        int bh = image.getHeight();
        int bw = image.getWidth();
        int p = 0;
        int pp = 0;
        int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] rgb = new int[bh * bw];
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                rgb[pp++] = intPixels[p++];
            }
        }
        return rgb;
    }

    private static int[] handleTypeIntBGR(BufferedImage image) {
        int bh = image.getHeight();
        int bw = image.getWidth();
        int p = 0;
        int pp = 0;
        int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] rgb = new int[bh * bw];
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                int val = intPixels[p++];
                int b = val >> 16 & 0xFF;
                int g = val >> 8 & 0xFF;
                int r = val & 0xFF;
                rgb[pp++] = r << 16 | g << 8 | b;
            }
        }
        return rgb;
    }

    private static int[] handleType4ByteABGR(BufferedImage image) {
        int bh = image.getHeight();
        int bw = image.getWidth();
        int p = 0;
        int pp = 0;
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int[] argb = new int[bh * bw];
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                int a = pixels[p++] & 0xFF;
                int b = pixels[p++] & 0xFF;
                int g = pixels[p++] & 0xFF;
                int r = pixels[p++] & 0xFF;
                argb[pp++] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return argb;
    }

    private static int[] handleType3ByteBGR(BufferedImage image) {
        int bh = image.getHeight();
        int bw = image.getWidth();
        int p = 0;
        int pp = 0;
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int[] rgb = new int[bh * bw];
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                int b = pixels[p++] & 0xFF;
                int g = pixels[p++] & 0xFF;
                int r = pixels[p++] & 0xFF;
                rgb[pp++] = r << 16 | g << 8 | b;
            }
        }
        return rgb;
    }

    private void writePNGToStream(OutputStream outputStream, byte[] trnsBytes, byte[] colorPalette, byte[] indexedPixels, int bw, int bh) throws IOException {
        outputStream.write(PngChunk.SIGNATURE);
        PngChunk chunk = PngChunk.createHeaderChunk(bw, bh, (byte)8, (byte)3, (byte)0, (byte)0, (byte)0);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        byte[] pixels = this.getDeflatedData(indexedPixels);
        chunk = PngChunk.createPaleteChunk(colorPalette);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        if (trnsBytes != null) {
            chunk = PngChunk.createTrnsChunk(trnsBytes);
            outputStream.write(chunk.getLength());
            outputStream.write(chunk.getName());
            outputStream.write(chunk.getData());
            outputStream.write(chunk.getCRCValue());
        }
        chunk = PngChunk.createDataChunk(pixels);
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
        chunk = PngChunk.createEndChunk();
        outputStream.write(chunk.getLength());
        outputStream.write(chunk.getName());
        outputStream.write(chunk.getData());
        outputStream.write(chunk.getCRCValue());
    }

    private static Object[] getIndexedMap(int[] pixel, int bw, int bh) {
        int[] colors = new int[256];
        int c = 0;
        int p = 0;
        int t = 0;
        byte[] indexedBytes = new byte[bh * bw];
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int pp = 0;
        for (int y = 0; y < bh; ++y) {
            for (int x = 0; x < bw; ++x) {
                int key;
                Integer val;
                if ((val = (Integer)map.get(key = pixel[pp++])) == null) {
                    if (c > 255) {
                        return null;
                    }
                    map.put(key, c);
                    colors[c] = key;
                    indexedBytes[p++] = (byte)c;
                    ++c;
                    continue;
                }
                indexedBytes[p++] = (byte)val.intValue();
            }
        }
        byte[] palette = new byte[c * 3];
        byte[] trns = new byte[c];
        p = 0;
        for (int i = 0; i < c; ++i) {
            int val = colors[i];
            trns[t++] = (byte)(val >> 24 & 0xFF);
            palette[p++] = (byte)(val >> 16 & 0xFF);
            palette[p++] = (byte)(val >> 8 & 0xFF);
            palette[p++] = (byte)(val & 0xFF);
        }
        return new Object[]{indexedBytes, palette, trns};
    }

    private static byte[] getIndexedPaletteData(BufferedImage buff) throws IOException {
        byte[] pixels = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        int ih = buff.getHeight();
        int len = pixels.length / ih;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int k = 0;
            for (int i = 0; i < ih; ++i) {
                bos.write(0);
                byte[] temp = new byte[len];
                System.arraycopy(pixels, k, temp, 0, len);
                bos.write(temp);
                k += len;
            }
            bos.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    private static byte[] getBIPixelData(BufferedImage buff, int bitDepth, int bw) throws IOException {
        byte[] pixels = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        int multi = bitDepth == 1 ? 8 : (bitDepth == 2 ? 4 : 2);
        PngBitReader reader = new PngBitReader(pixels, true);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BitWriter writer = new BitWriter(bos);
        int cc2 = 0;
        int iter = pixels.length * multi;
        for (int i = 0; i < iter; ++i) {
            if (cc2 == 0) {
                writer.writeByte();
            }
            writer.writeBits(reader.getPositive(bitDepth), bitDepth);
            if (++cc2 != bw) continue;
            cc2 = 0;
        }
        writer.end();
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    private static byte[] getUnknowPixelData(BufferedImage buff, int bw, int bh, int nComp) {
        ByteBuffer out = ByteBuffer.allocate(bw * bh * nComp + bh);
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        int clm = 0;
        for (int i : pixInt) {
            if (clm == 0) {
                out.put((byte)0);
            }
            byte[] t = PngChunk.intToBytes(i);
            switch (nComp) {
                case 4: {
                    out.put(new byte[]{t[1], t[2], t[3], t[0]});
                    break;
                }
                case 3: {
                    out.put(new byte[]{t[1], t[2], t[3]});
                    break;
                }
                case 2: {
                    out.put(new byte[]{t[2], t[3]});
                    break;
                }
                case 1: {
                    out.put(t[3]);
                }
            }
            if (++clm != bw) continue;
            clm = 0;
        }
        return out.array();
    }

    private static byte[] getShortPixelData(BufferedImage buff, int bw, int bh, int nComp) {
        short[] shortPixels = ((DataBufferUShort)buff.getRaster().getDataBuffer()).getData();
        ByteBuffer bos16 = ByteBuffer.allocate(shortPixels.length * 2 + bh);
        int scol = 0;
        for (int p = 0; p < shortPixels.length; p += nComp) {
            if (scol == 0) {
                bos16.put((byte)0);
            }
            for (int i = 0; i < nComp; ++i) {
                bos16.putShort(shortPixels[p + i]);
            }
            if (++scol != bw) continue;
            scol = 0;
        }
        return bos16.array();
    }

    private static byte[] getPixelData(BufferedImage buff, int bitDepth, int nComp, int bw, int bh) throws IOException {
        ColorModel model = buff.getColorModel();
        switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                return PngEncoder.getBIPixelData(buff, bitDepth, bw);
            }
            case 8: {
                return PngEncoder.get8BitData(buff, nComp, bw, bh, model);
            }
            case 16: {
                return PngEncoder.getShortPixelData(buff, bw, bh, nComp);
            }
        }
        return null;
    }

    private static byte[] get8BitData(BufferedImage buff, int nComp, int bw, int bh, ColorModel model) {
        DataBuffer dataBuff = buff.getRaster().getDataBuffer();
        switch (dataBuff.getDataType()) {
            case 0: {
                switch (buff.getType()) {
                    case 5: {
                        return PngEncoder.handleBGR(nComp, buff, bh, bw);
                    }
                    case 6: 
                    case 7: {
                        return PngEncoder.handleABGR(nComp, buff, bh, bw);
                    }
                }
                return PngEncoder.handleDefaultTypeByte(nComp, buff, bh, bw);
            }
            case 3: {
                if (buff.getType() == 2 || buff.getType() == 3) {
                    return PngEncoder.handleTypeIntARGB(bw, bh, buff);
                }
                if (buff.getType() == 1) {
                    return PngEncoder.handleTypeIntRGB(bw, bh, buff);
                }
                if (buff.getType() == 4) {
                    return PngEncoder.handleTypeIntBGR(bw, bh, buff);
                }
                if (model instanceof DirectColorModel) {
                    return PngEncoder.handleDirectColorModel(model, bw, bh, buff);
                }
                return PngEncoder.getUnknowPixelData(buff, bw, bh, nComp);
            }
        }
        return null;
    }

    private static byte[] handleDirectColorModel(ColorModel model, int bw, int bh, BufferedImage buff) {
        int k = 0;
        int p = 0;
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        DirectColorModel dm = (DirectColorModel)model;
        long rMask = PngEncoder.getMaskValue(dm.getRedMask());
        long gMask = PngEncoder.getMaskValue(dm.getGreenMask());
        long bMask = PngEncoder.getMaskValue(dm.getBlueMask());
        long aMask = PngEncoder.getMaskValue(dm.getAlphaMask());
        byte[] output = new byte[bw * bh * 4 + bh];
        for (int i = 0; i < bh; ++i) {
            output[k++] = 0;
            for (int j = 0; j < bw; ++j) {
                int val = pixInt[p++];
                output[k++] = (byte)(val >> (int)rMask);
                output[k++] = (byte)(val >> (int)gMask);
                output[k++] = (byte)(val >> (int)bMask);
                output[k++] = (byte)(val >> (int)aMask);
            }
        }
        return output;
    }

    private static byte[] handleTypeIntBGR(int bw, int bh, BufferedImage buff) {
        int k = 0;
        int p = 0;
        byte[] output = new byte[bw * bh * 3 + bh];
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < bh; ++i) {
            output[k++] = 0;
            for (int j = 0; j < bw; ++j) {
                int val = pixInt[p++];
                output[k++] = (byte)val;
                output[k++] = (byte)(val >> 8);
                output[k++] = (byte)(val >> 16);
            }
        }
        return output;
    }

    private static byte[] handleTypeIntRGB(int bw, int bh, BufferedImage buff) {
        int p = 0;
        int k = 0;
        byte[] output = new byte[bw * bh * 3 + bh];
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < bh; ++i) {
            output[k++] = 0;
            for (int j = 0; j < bw; ++j) {
                int val = pixInt[p++];
                output[k++] = (byte)(val >> 16);
                output[k++] = (byte)(val >> 8);
                output[k++] = (byte)val;
            }
        }
        return output;
    }

    private static byte[] handleTypeIntARGB(int bw, int bh, BufferedImage buff) {
        int k = 0;
        int p = 0;
        byte[] output = new byte[bw * bh * 4 + bh];
        int[] pixInt = ((DataBufferInt)buff.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < bh; ++i) {
            output[k++] = 0;
            for (int j = 0; j < bw; ++j) {
                int val = pixInt[p++];
                output[k++] = (byte)(val >> 16);
                output[k++] = (byte)(val >> 8);
                output[k++] = (byte)val;
                output[k++] = (byte)(val >> 24);
            }
        }
        return output;
    }

    private static byte[] handleDefaultTypeByte(int nComp, BufferedImage buff, int bh, int bw) {
        byte[] pixels8 = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        byte[] res = new byte[bw * bh * nComp + bh];
        int pLen = pixels8.length;
        int col = 0;
        int bp = 0;
        for (int p = 0; p < pLen; p += nComp) {
            if (col == 0) {
                res[bp++] = 0;
            }
            for (int i = 0; i < nComp; ++i) {
                res[bp++] = pixels8[p + i];
            }
            if (++col != bw) continue;
            col = 0;
        }
        return res;
    }

    private static byte[] handleABGR(int nComp, BufferedImage buff, int bh, int bw) {
        byte[] pixels8 = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        byte[] res = new byte[bw * bh * nComp + bh];
        int pLen = pixels8.length;
        int bp = 0;
        int col = 0;
        for (int p = 0; p < pLen; p += nComp) {
            if (col == 0) {
                res[bp++] = 0;
            }
            res[bp++] = pixels8[p + 3];
            res[bp++] = pixels8[p + 2];
            res[bp++] = pixels8[p + 1];
            res[bp++] = pixels8[p];
            if (++col != bw) continue;
            col = 0;
        }
        return res;
    }

    private static byte[] handleBGR(int nComp, BufferedImage buff, int bh, int bw) {
        byte[] pixels8 = ((DataBufferByte)buff.getRaster().getDataBuffer()).getData();
        int pLen = pixels8.length;
        int col = 0;
        byte[] res = new byte[bw * bh * nComp + bh];
        int bp = 0;
        for (int p = 0; p < pLen; p += nComp) {
            if (col == 0) {
                res[bp++] = 0;
            }
            res[bp++] = pixels8[p + 2];
            res[bp++] = pixels8[p + 1];
            res[bp++] = pixels8[p];
            if (++col != bw) continue;
            col = 0;
        }
        return res;
    }

    private static int getMaskValue(int mask) {
        switch (mask) {
            case 255: {
                return 0;
            }
            case 65280: {
                return 8;
            }
            case 0xFF0000: {
                return 16;
            }
        }
        return 24;
    }

    private static int calculateBitDepth(int pixelBits, int nComp) {
        if (pixelBits < 8) {
            return pixelBits;
        }
        int c = pixelBits / nComp;
        if (c == 8 || c == 16) {
            return c;
        }
        return 8;
    }

    private byte[] getDeflatedData(byte[] pixels) throws IOException {
        Deflater deflater = this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.QUANTISED8BIT || this.pngEncoderOptions.getCompressionFormat() == PngCompressionFormat.ZLIB_BETTER_COMPRESSION || this.pngEncoderOptions.isOptimizeBasedOnColors() ? new Deflater(9) : new Deflater(1);
        deflater.setInput(pixels);
        int min = Math.min(pixels.length / 2, 4096);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(min);){
            deflater.finish();
            byte[] buffer = new byte[min];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            deflater.end();
            outputStream.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

