/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.LUT;
import java.util.Arrays;

public final class EntropyEncoder {
    private int a;
    private int b;
    private int c;
    private int ct;
    private final byte[] i = new byte[19];
    private final int[] mps = new int[19];
    public static final byte UNIFORM = 18;
    public static final byte RUNLENGTH = 17;
    private static final int BLEN = 4096;
    private final byte[] data = new byte[4096];
    private int bp;

    public void init() {
        this.a = 32768;
        this.c = 0;
        this.ct = 12;
        this.b = 0;
        Arrays.fill(this.data, (byte)0);
        this.bp = 0;
        Arrays.fill(this.i, (byte)0);
        Arrays.fill(this.mps, 0);
        this.i[0] = 4;
        this.i[18] = 46;
        this.i[17] = 3;
    }

    public void encode(int cx, int d) {
        byte icx = this.i[cx];
        int qeicx = LUT.QE[icx];
        if (d == this.mps[cx]) {
            this.a -= qeicx;
            if (this.a < 32768) {
                if (this.a < qeicx) {
                    this.a = qeicx;
                } else {
                    this.c += qeicx;
                }
                this.i[cx] = LUT.NMPS[icx];
                this.renorme();
            } else {
                this.c += qeicx;
            }
        } else {
            this.a -= qeicx;
            if (this.a >= qeicx) {
                this.a = qeicx;
            } else {
                this.c += qeicx;
            }
            if (LUT.SWITCHML[icx] == 1) {
                this.mps[cx] = 1 - this.mps[cx];
            }
            this.i[cx] = LUT.NLPS[icx];
            this.renorme();
        }
    }

    private void renorme() {
        do {
            this.a <<= 1;
            this.c <<= 1;
            --this.ct;
            if (this.ct != 0) continue;
            this.byteOut();
        } while (this.a < 32768);
    }

    private void byteOut() {
        if (this.b == 255) {
            this.put(this.b);
            this.b = this.c >> 20 & 0xFF;
            this.c &= 0xFFFFF;
            this.ct = 7;
        } else if (this.c < 0x8000000) {
            this.put(this.b);
            this.b = this.c >> 19 & 0xFF;
            this.c &= 0x7FFFF;
            this.ct = 8;
        } else {
            ++this.b;
            if (this.b == 255) {
                this.c &= 0x7FFFFFF;
                this.put(this.b);
                this.b = this.c >> 20 & 0xFF;
                this.c &= 0xFFFFF;
                this.ct = 7;
            } else {
                this.put(this.b);
                this.b = this.c >> 19 & 0xFF;
                this.c &= 0x7FFFF;
                this.ct = 8;
            }
        }
    }

    private void flush() {
        int temp = this.c + this.a;
        this.c |= 0xFFFF;
        if (this.c >= temp) {
            this.c -= 32768;
        }
        this.c <<= this.ct;
        this.byteOut();
        this.c <<= this.ct;
        this.byteOut();
        if (this.b != 255) {
            this.put(this.b);
        }
    }

    private void put(int b) {
        this.data[this.bp++] = (byte)b;
    }

    public byte[] getEncodedData() {
        this.flush();
        byte[] result = new byte[this.bp - 1];
        System.arraycopy(this.data, 1, result, 0, result.length);
        return result;
    }
}

