/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import com.idrsolutions.image.jpeg2000.data.COD;
import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.Info;
import com.idrsolutions.image.jpeg2000.data.JpxBitWriter;
import com.idrsolutions.image.jpeg2000.data.QCD;
import com.idrsolutions.image.jpeg2000.data.SIZ;
import com.idrsolutions.image.jpeg2000.data.Subband;
import com.idrsolutions.image.jpeg2000.data.TagTree;
import com.idrsolutions.image.jpeg2000.data.Tier1Encoder;
import com.idrsolutions.image.jpeg2000.data.Tile;
import com.idrsolutions.image.jpeg2000.data.TileBand;
import com.idrsolutions.image.jpeg2000.data.TileComponent;
import com.idrsolutions.image.jpeg2000.data.TileResolution;
import com.idrsolutions.image.jpeg2000.data.Trns;
import com.idrsolutions.image.jpeg2000.options.Jpeg2000EncoderOptions;
import com.idrsolutions.image.jpeg2000.options.Jpeg2000OutputSubtype;
import com.idrsolutions.image.utility.ByteWriter;
import com.idrsolutions.image.utility.WriterByteBig;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class Jpeg2000Encoder
extends JDeliImage
implements Encoder {
    private Jpeg2000EncoderOptions jpeg2000EncoderOptions = new Jpeg2000EncoderOptions();

    public Jpeg2000Encoder(EncoderOptions format) {
        if (format != null) {
            this.jpeg2000EncoderOptions = (Jpeg2000EncoderOptions)format;
        }
    }

    public Jpeg2000Encoder() {
    }

    public Jpeg2000EncoderOptions getEncoderOptions() {
        return this.jpeg2000EncoderOptions;
    }

    public void write(BufferedImage image, File file) throws IOException {
        boolean isJp2;
        Jpeg2000Encoder.optimiseImage(image);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        boolean bl = isJp2 = this.jpeg2000EncoderOptions.getOutputSubtype() == Jpeg2000OutputSubtype.JP2;
        if (isJp2 != file.getName().toUpperCase().endsWith(".JP2")) {
            throw new RuntimeException("file ending and Jpeg2000OutputSubtype subtype mismatch");
        }
        this.write(image, bos);
        bos.flush();
        bos.close();
    }

    @Override
    public void write(BufferedImage inputImage, OutputStream os) throws IOException {
        boolean isJp2;
        Jpeg2000Encoder.optimiseImage(inputImage);
        BufferedImage image = Jpeg2000Encoder.fixToSupported(inputImage);
        Info info = Jpeg2000Encoder.generateInfo(image, this.jpeg2000EncoderOptions.getQuality());
        boolean bl = isJp2 = this.jpeg2000EncoderOptions.getOutputSubtype() == Jpeg2000OutputSubtype.JP2;
        if (isJp2) {
            Jpeg2000Encoder.writeJp2(info, os);
        }
        int v = 65359;
        os.write(255);
        os.write(79);
        os.write(Jpeg2000Encoder.initSIZ(info.siz));
        os.write(Jpeg2000Encoder.initCOD(info.cod));
        os.write(Jpeg2000Encoder.initQCD(info.qcd, info.cod));
        os.write(Jpeg2000Encoder.initSOT());
        os.write(Jpeg2000Encoder.initSOD());
        Jpeg2000Encoder.writeTile(image, info, os);
        info.tilesMap.clear();
        os.write(Jpeg2000Encoder.initEOC());
    }

    private static BufferedImage fixToSupported(BufferedImage image) {
        if (image.getType() == 0) {
            BufferedImage res = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            res.getGraphics().drawImage(image, 0, 0, null);
            return res;
        }
        return image;
    }

    private static void writeJp2(Info info, OutputStream os) throws IOException {
        os.write(Jpeg2000Encoder.intToBytes(12));
        os.write(Jpeg2000Encoder.intToBytes(1783636000));
        os.write(Jpeg2000Encoder.intToBytes(218793738));
        os.write(Jpeg2000Encoder.intToBytes(20));
        os.write(Jpeg2000Encoder.intToBytes(1718909296));
        os.write(Jpeg2000Encoder.intToBytes(1785737760));
        os.write(Jpeg2000Encoder.intToBytes(0));
        os.write(Jpeg2000Encoder.intToBytes(0));
        os.write(Jpeg2000Encoder.intToBytes(30));
        os.write(Jpeg2000Encoder.intToBytes(1785737832));
        os.write(Jpeg2000Encoder.intToBytes(22));
        os.write(Jpeg2000Encoder.intToBytes(1768449138));
        os.write(Jpeg2000Encoder.intToBytes(info.siz.Xsiz));
        os.write(Jpeg2000Encoder.intToBytes(info.siz.Ysiz));
        os.write(0);
        os.write(info.siz.Csiz);
        os.write(7);
        os.write(7);
        os.write(0);
        os.write(0);
        os.write(Jpeg2000Encoder.intToBytes(0));
        os.write(Jpeg2000Encoder.intToBytes(1785737827));
    }

    private static byte[] intToBytes(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    @Deprecated
    public void setQuality(int percentage) {
        this.jpeg2000EncoderOptions.setQuality(percentage);
    }

    @Deprecated
    public int getQuality() {
        return this.jpeg2000EncoderOptions.getQuality();
    }

    private static Info generateInfo(BufferedImage image, int quality) {
        Info info = new Info();
        SIZ siz = new SIZ();
        int nComp = image.getColorModel().getNumComponents();
        siz.Csiz = nComp >= 3 ? 3 : 1;
        siz.Xsiz = image.getWidth();
        siz.Ysiz = image.getHeight();
        siz.XTsiz = image.getWidth();
        siz.YTsiz = image.getHeight();
        siz.precisionInfo = new int[siz.Csiz][3];
        for (int i = 0; i < siz.Csiz; ++i) {
            siz.precisionInfo[i][0] = 7;
            siz.precisionInfo[i][1] = 1;
            siz.precisionInfo[i][2] = 1;
        }
        info.siz = siz;
        COD cod = new COD();
        cod.nLayers = 1;
        cod.multiCompTransform = siz.Csiz == 3 ? 1 : 0;
        cod.nDecompLevel = image.getWidth() < 2 || image.getHeight() < 2 ? 0 : 1;
        int iw = image.getWidth();
        int ih = image.getHeight();
        while (iw > 8 && ih > 8 && cod.nDecompLevel < 30) {
            iw >>= 1;
            ih >>= 1;
            ++cod.nDecompLevel;
        }
        cod.xcb = 6;
        cod.ycb = 6;
        cod.transformation = quality == 100 ? 1 : 0;
        info.cod = cod;
        info.qcd = Jpeg2000Encoder.getQCD(cod, quality);
        return info;
    }

    private static QCD getQCD(COD cod, int quality) {
        QCD qcd = new QCD();
        qcd.hasScalar = true;
        qcd.guardBits = 2;
        qcd.quantBits = 0;
        qcd.exponentB = new int[cod.nDecompLevel * 3 + 1];
        qcd.mantissaB = new int[cod.nDecompLevel * 3 + 1];
        int NL = cod.nDecompLevel;
        int start = 8;
        int p = 0;
        if (cod.transformation == 0) {
            for (int r = 0; r <= NL; ++r) {
                if (r == 0) {
                    qcd.exponentB[p++] = start++;
                    continue;
                }
                qcd.exponentB[p++] = start;
                qcd.exponentB[p++] = start;
                qcd.exponentB[p++] = start;
            }
            p = 0;
            qcd.mantissaB[0] = start = (100 - quality) * 20;
            int i = 0;
            while (i < NL) {
                qcd.mantissaB[p + 1] = start;
                qcd.mantissaB[p + 2] = start;
                qcd.mantissaB[p + 3] = start;
                ++i;
                p += 3;
            }
        } else {
            for (int r = 0; r <= NL; ++r) {
                if (r == 0) {
                    qcd.exponentB[p++] = start;
                    continue;
                }
                qcd.exponentB[p++] = start + 1;
                qcd.exponentB[p++] = start + 1;
                qcd.exponentB[p++] = start + 2;
            }
        }
        return qcd;
    }

    private static byte[] initSIZ(SIZ siz) {
        int Lsiz = 38 + 3 * siz.Csiz;
        byte[] temp = new byte[Lsiz + 2];
        WriterByteBig buffer = new WriterByteBig(temp);
        buffer.putU16(65361);
        buffer.putU16(Lsiz);
        buffer.putU16(0);
        buffer.putU32(siz.Xsiz);
        buffer.putU32(siz.Ysiz);
        buffer.putU32(0);
        buffer.putU32(0);
        buffer.putU32(siz.XTsiz);
        buffer.putU32(siz.YTsiz);
        buffer.putU32(0);
        buffer.putU32(0);
        buffer.putU16(siz.Csiz);
        for (int i = 0; i < siz.Csiz; ++i) {
            buffer.putU8(siz.precisionInfo[i][0]);
            buffer.putU8(1);
            buffer.putU8(1);
        }
        return temp;
    }

    private static byte[] initCOD(COD cod) {
        int Lcod = 12;
        byte[] temp = new byte[14];
        WriterByteBig buffer = new WriterByteBig(temp);
        buffer.putU16(65362);
        buffer.putU16(12);
        buffer.putU8(0);
        buffer.putU8(4);
        buffer.putU16(cod.nLayers);
        buffer.putU8(cod.multiCompTransform);
        buffer.putU8(cod.nDecompLevel);
        buffer.putU8(cod.xcb - 2);
        buffer.putU8(cod.ycb - 2);
        buffer.putU8(0);
        buffer.putU8(cod.transformation);
        return temp;
    }

    private static byte[] initQCD(QCD qcd, COD cod) {
        if (cod.transformation == 0) {
            int Lqcd = 5 + 6 * cod.nDecompLevel;
            byte[] temp = new byte[Lqcd + 2];
            WriterByteBig buffer = new WriterByteBig(temp);
            buffer.putU16(65372);
            buffer.putU16(Lqcd);
            buffer.putU8(qcd.guardBits << 5 | 2);
            for (int i = 0; i < qcd.exponentB.length; ++i) {
                buffer.putU16(qcd.exponentB[i] << 11 | qcd.mantissaB[i]);
            }
            return temp;
        }
        int Lqcd = 4 + 3 * cod.nDecompLevel;
        byte[] temp = new byte[Lqcd + 2];
        WriterByteBig buffer = new WriterByteBig(temp);
        buffer.putU16(65372);
        buffer.putU16(Lqcd);
        buffer.putU8(qcd.guardBits << 5);
        for (int i = 0; i < qcd.exponentB.length; ++i) {
            buffer.putU8(qcd.exponentB[i] << 3);
        }
        return temp;
    }

    private static byte[] initSOT() {
        int Lsot = 10;
        byte[] temp = new byte[12];
        WriterByteBig buffer = new WriterByteBig(temp);
        buffer.putU16(65424);
        buffer.putU16(10);
        buffer.putU16(0);
        buffer.putU32(0);
        buffer.putU8(0);
        buffer.putU8(1);
        return temp;
    }

    private static byte[] initSOD() {
        byte[] temp = new byte[2];
        WriterByteBig buffer = new WriterByteBig(temp);
        buffer.putU16(65427);
        return temp;
    }

    private static byte[] initEOC() {
        byte[] temp = new byte[2];
        WriterByteBig buffer = new WriterByteBig(temp);
        buffer.putU16(65497);
        return temp;
    }

    private static void writeTile(BufferedImage image, Info info, OutputStream os) throws IOException {
        int NL = info.cod.nDecompLevel;
        int nComp = info.siz.Csiz;
        info.generateTileMap();
        Jpeg2000Encoder.updateTcTrTbCb(info);
        Tile tile = info.tilesMap.get(0);
        int dim = image.getWidth() * image.getHeight();
        int[] pixels = new int[dim];
        Info.getComponentAsABGR(image, pixels);
        Jpeg2000Encoder.packetOrdering(pixels, info, tile, NL, nComp, os);
    }

    private static void componentTransform(int[] pixels, float[] floats, boolean reversible, int sizBps, int nComp, int c) {
        if (nComp == 3) {
            if (reversible) {
                Jpeg2000Encoder.forwardShiftRCT(pixels, floats, sizBps, c);
            } else {
                Jpeg2000Encoder.forwardShiftICT(pixels, floats, sizBps, c);
            }
        } else {
            int multi = 1 << sizBps;
            int dim = pixels.length;
            for (int i = 0; i < dim; ++i) {
                floats[i] = pixels[i] - multi;
            }
        }
    }

    private static void packetOrdering(int[] pixels, Info info, Tile tile, int NL, int nComp, OutputStream stream) throws IOException {
        int r = 0;
        int iw = info.siz.Xsiz;
        int ih = info.siz.Ysiz;
        boolean reversible = info.cod.transformation == 1;
        float[] floats = new float[iw * ih];
        int sizBps = info.siz.precisionInfo[0][0];
        for (int c = 0; c < nComp; ++c) {
            TileComponent tc = tile.components.get(c);
            tc.floats = floats;
            Jpeg2000Encoder.componentTransform(pixels, floats, reversible, sizBps, nComp, c);
            List<Subband> coefs = Trns.getForward(tc.floats, iw, ih, NL, reversible);
            Jpeg2000Encoder.quantize(coefs, info.qcd, reversible);
            int cc = 0;
            for (TileResolution tcr : tc.resolutions) {
                for (TileBand tb : tcr.tileBands) {
                    Subband sb = coefs.get(cc);
                    tb.floats = sb.floats;
                    tb.eb = sb.eb;
                    tb.ub = sb.ub;
                    ++cc;
                }
            }
            coefs.clear();
            tc.floats = null;
            while (r <= NL) {
                TileResolution tr = tc.resolutions.get(r);
                JpxBitWriter bw = new JpxBitWriter();
                bw.putBit(1);
                ByteWriter byteWriter = new ByteWriter();
                for (TileBand tb : tr.tileBands) {
                    for (CodeBlock cb : tb.codeBlocks) {
                        Tier1Encoder tier1 = new Tier1Encoder(info, tb, cb);
                        tier1.encode();
                    }
                    Jpeg2000Encoder.encodeTier2(tb, bw, byteWriter);
                    tb.codeBlocks.clear();
                    tb.floats = null;
                }
                bw.end();
                stream.write(bw.data, 0, bw.bp);
                stream.write(byteWriter.data, 0, byteWriter.bp);
                tr.tileBands.clear();
                ++r;
            }
            tc.resolutions.clear();
            r = 0;
        }
        info.tilesMap.clear();
    }

    private static void updateTcTrTbCb(Info info) {
        Tile tile = info.tilesMap.get(0);
        tile.qcd = info.qcd;
        tile.cod = info.cod;
        int NL = tile.cod.nDecompLevel;
        int xcb = tile.cod.xcb;
        int ycb = tile.cod.ycb;
        for (TileComponent tc : tile.components) {
            for (int r = 0; r <= NL; ++r) {
                int powN;
                int ppx = 15;
                int ppy = 15;
                int xcb_ = r == 0 ? Math.min(xcb, 15) : Math.min(xcb, 14);
                int ycb_ = r == 0 ? Math.min(ycb, 15) : Math.min(ycb, 14);
                TileResolution tr = new TileResolution();
                int NL_R2 = 1 << NL - r;
                tr.x0 = (int)Math.ceil(1.0 * (double)tc.x0 / (double)NL_R2);
                tr.x1 = (int)Math.ceil(1.0 * (double)tc.x1 / (double)NL_R2);
                tr.y0 = (int)Math.ceil(1.0 * (double)tc.y0 / (double)NL_R2);
                tr.y1 = (int)Math.ceil(1.0 * (double)tc.y1 / (double)NL_R2);
                Jpeg2000Decoder.updatePrecinctInfo(tr, r, 15, 15);
                if (r == 0) {
                    powN = 1 << NL;
                    TileBand tb = new TileBand(0);
                    tb.x1 = (int)Math.abs(Math.ceil(1.0 * (double)tc.x1 / (double)powN));
                    tb.y1 = (int)Math.abs(Math.ceil(1.0 * (double)tc.y1 / (double)powN));
                    tr.tileBands.add(tb);
                    Info.updateCodeBlocks(tr, tb, xcb_, ycb_);
                } else {
                    int n = NL + 1 - r;
                    powN = 1 << n;
                    int powM = 1 << n - 1;
                    TileBand tb = new TileBand(2);
                    tb.x1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.x1 - (double)powM) / (double)powN));
                    tb.y1 = (int)Math.abs(Math.ceil(1.0 * (double)tc.y1 / (double)powN));
                    tr.tileBands.add(tb);
                    Info.updateCodeBlocks(tr, tb, xcb_, ycb_);
                    tb = new TileBand(1);
                    tb.x1 = (int)Math.abs(Math.ceil(1.0 * (double)tc.x1 / (double)powN));
                    tb.y1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.y1 - (double)powM) / (double)powN));
                    tr.tileBands.add(tb);
                    Info.updateCodeBlocks(tr, tb, xcb_, ycb_);
                    tb = new TileBand(3);
                    tb.x1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.x1 - (double)powM) / (double)powN));
                    tb.y1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.y1 - (double)powM) / (double)powN));
                    tr.tileBands.add(tb);
                    Info.updateCodeBlocks(tr, tb, xcb_, ycb_);
                }
                tc.resolutions.add(tr);
            }
        }
    }

    private static void forwardShiftICT(int[] pixels, float[] floats, int bps, int c) {
        int len = pixels.length;
        int multi = 1 << bps;
        block4: for (int i = 0; i < len; ++i) {
            int v = pixels[i];
            int r = v & 0xFF;
            int g = v >> 8 & 0xFF;
            int b = v >> 16 & 0xFF;
            int i0 = r - multi;
            int i1 = g - multi;
            int i2 = b - multi;
            switch (c) {
                case 0: {
                    floats[i] = 0.299f * (float)i0 + 0.587f * (float)i1 + 0.114f * (float)i2;
                    continue block4;
                }
                case 1: {
                    floats[i] = -0.16875f * (float)i0 - 0.33126f * (float)i1 + 0.5f * (float)i2;
                    continue block4;
                }
                default: {
                    floats[i] = 0.5f * (float)i0 - 0.41869f * (float)i1 - 0.08131f * (float)i2;
                }
            }
        }
    }

    private static void forwardShiftRCT(int[] pixels, float[] floats, int bps, int c) {
        int len = pixels.length;
        int multi = 1 << bps;
        block4: for (int i = 0; i < len; ++i) {
            int v = pixels[i];
            int r = v & 0xFF;
            int g = v >> 8 & 0xFF;
            int b = v >> 16 & 0xFF;
            int i0 = r - multi;
            int i1 = g - multi;
            int i2 = b - multi;
            switch (c) {
                case 0: {
                    floats[i] = (i0 + 2 * i1 + i2) / 4;
                    continue block4;
                }
                case 1: {
                    floats[i] = i2 - i1;
                    continue block4;
                }
                default: {
                    floats[i] = i0 - i1;
                }
            }
        }
    }

    private static void quantize(List<Subband> coefs, QCD qcd, boolean reversible) {
        if (reversible) {
            int a = 0;
            for (Subband coef : coefs) {
                coef.eb = qcd.exponentB[a];
                coef.ub = qcd.mantissaB[a];
                ++a;
            }
        } else {
            int a = 0;
            for (Subband coef : coefs) {
                coef.eb = qcd.exponentB[a];
                coef.ub = qcd.mantissaB[a];
                int rb = 8 + Jpeg2000Encoder.getBandMultiplier(coef.type) - coef.eb;
                float deltaB = (float)(Math.pow(2.0, rb) * (double)(1.0f + (float)coef.ub / 2048.0f));
                for (float v : coef.floats) {
                    int sign = v < 0.0f ? -1 : 1;
                    v = v < 0.0f ? -v : v;
                    coef.floats[i] = sign * (int)(v / deltaB);
                }
                ++a;
            }
        }
    }

    private static int getBandMultiplier(int type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 3: {
                return 2;
            }
        }
        return 1;
    }

    private static void encodeTier2(TileBand tb, JpxBitWriter bw, ByteWriter packetData) {
        CodeBlock cb;
        int tbw = tb.x1 - tb.x0;
        int tbh = tb.y1 - tb.y0;
        int numX = (int)Math.ceil(1.0 * (double)tbw / 64.0);
        int numY = (int)Math.ceil(1.0 * (double)tbh / 64.0);
        int cbDim = numX * numY;
        int[] layers = new int[cbDim];
        int[] zeros = new int[cbDim];
        int pos = 0;
        for (int m = 0; m < numY; ++m) {
            for (int n = 0; n < numX; ++n) {
                cb = tb.codeBlocks.get(pos);
                zeros[pos] = cb.zeroBitPlanes;
                ++pos;
            }
        }
        pos = 0;
        TagTree layerTree = new TagTree(numY, numX, layers);
        TagTree zeroTree = new TagTree(numY, numX, zeros);
        for (int m = 0; m < numY; ++m) {
            for (int n = 0; n < numX; ++n) {
                int i;
                int cPassLog2;
                int lenBits;
                int dataLen;
                cb = tb.codeBlocks.get(pos);
                layerTree.encode(m, n, bw);
                zeroTree.encode(m, n, bw);
                byte nPasses = cb.block.nCodingPass;
                Jpeg2000Encoder.writeCodingPasses(bw, nPasses);
                int nBP = 0;
                for (int t = dataLen = cb.block.data.length; t > 0; t >>= 1) {
                    ++nBP;
                }
                int lblock = 3;
                while ((lenBits = (nPasses < 1 << (cPassLog2 = Jpeg2000Encoder.log2(nPasses)) ? cPassLog2 - 1 : cPassLog2) + lblock) < nBP) {
                    ++lblock;
                }
                int indication = lblock - 3;
                for (i = 0; i < indication; ++i) {
                    bw.putBit(1);
                }
                bw.putBit(0);
                int bal = lenBits - nBP;
                for (i = 0; i < bal; ++i) {
                    bw.putBit(0);
                }
                bw.putNBit(dataLen, nBP);
                packetData.write(cb.block.data);
                ++pos;
            }
        }
    }

    private static void writeCodingPasses(JpxBitWriter bw, int nPasses) {
        switch (nPasses) {
            case 1: {
                bw.putBit(0);
                break;
            }
            case 2: {
                bw.putBit(1);
                bw.putBit(0);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                bw.putNBit(9 + nPasses, 4);
                break;
            }
            default: {
                if (nPasses < 37) {
                    bw.putNBit(0x1E0 | nPasses - 6, 9);
                    break;
                }
                bw.putNBit(0xFF80 | nPasses - 37, 9);
            }
        }
    }

    private static int log2(int x) {
        int n = 1;
        int i = 0;
        while (x > n) {
            n <<= 1;
            ++i;
        }
        return i;
    }
}

